/*
 * Decompiled with CFR 0.152.
 */
package js7.common.auth;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import js7.base.auth.DistinguishedName;
import js7.base.auth.DistinguishedName$;
import js7.base.auth.HashedPassword;
import js7.base.auth.HashedPassword$;
import js7.base.auth.Permission;
import js7.base.auth.User;
import js7.base.auth.UserId;
import js7.base.auth.UserId$;
import js7.base.configutils.Configs$;
import js7.base.configutils.Configs$RichConfig$;
import js7.base.convert.As;
import js7.base.generic.SecretString;
import js7.base.generic.SecretString$;
import js7.base.log.Logger$package$Logger$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.common.auth.Hasher$;
import js7.common.auth.IdToUser;
import js7.common.auth.IdToUser$RawUserAccount$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.View;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class IdToUser$
implements Serializable {
    public static final Logger js7$common$auth$IdToUser$$$logger;
    private static final String UsersConfigPath;
    private static final Regex PasswordRegex;
    private static final Function1<String, String> identityHasher;
    public static final IdToUser$RawUserAccount$ RawUserAccount;
    public static final IdToUser$ MODULE$;

    private IdToUser$() {
    }

    static {
        MODULE$ = new IdToUser$();
        js7$common$auth$IdToUser$$$logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(IdToUser$.class));
        UsersConfigPath = "js7.auth.users";
        PasswordRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^:]+):(.*)"));
        identityHasher = ScalaUtils$syntax$.MODULE$.ToStringFunction1((Function1 & Serializable)o -> (String)Predef$.MODULE$.identity(o)).withToString("identity");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IdToUser$.class);
    }

    public <U extends User> IdToUser<U> fromConfig(Config config, Function4<UserId, HashedPassword, Set<Permission>, Seq<DistinguishedName>, U> toUser, PartialFunction<String, Permission> toPermission) {
        Config cfg = config.getConfig(UsersConfigPath);
        ConfigObject cfgObject = (ConfigObject)config.getValue(UsersConfigPath);
        scala.collection.immutable.Map distinguishedNameToUserIds = (scala.collection.immutable.Map)CollectionConverters$.MODULE$.MapHasAsScala((Map)cfgObject).asScala().view().flatMap((Function1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            ConfigValue configValue = (ConfigValue)x$1._2();
            return (View)Option$.MODULE$.option2Iterable(UserId$.MODULE$.checked(string).toOption()).view().flatMap((Function1 & Serializable)userId -> {
                Object object;
                ConfigValue configValue = configValue;
                if (configValue instanceof ConfigObject) {
                    ConfigObject configObject;
                    ConfigObject value = configObject = (ConfigObject)configValue;
                    object = (Serializable)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)value.get((Object)"distinguished-names"))).view().flatMap((Function1 & Serializable)_$2 -> {
                        Object object = _$2.unwrapped();
                        if (object instanceof java.util.List) {
                            java.util.List list;
                            java.util.List list2 = list = (java.util.List)object;
                            return (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(list2).asScala().flatMap((Function1 & Serializable)x$1 -> {
                                Nil$ nil$;
                                Object object = x$1;
                                if (object instanceof String) {
                                    String string;
                                    String o = string = (String)object;
                                    nil$ = DistinguishedName$.MODULE$.checked(o).toOption().map((Function1 & Serializable)_$3 -> {
                                        DistinguishedName distinguishedName = (DistinguishedName)Predef$.MODULE$.ArrowAssoc(_$3);
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)distinguishedName, userId);
                                    });
                                } else {
                                    nil$ = package$.MODULE$.Nil();
                                }
                                return (IterableOnce)nil$;
                            });
                        }
                        throw new MatchError(object);
                    });
                } else {
                    object = package$.MODULE$.Nil();
                }
                return (IterableOnce)object;
            });
        }).groupMap((Function1 & Serializable)_$4 -> (DistinguishedName)_$4._1(), (Function1 & Serializable)_$5 -> (UserId)_$5._2()).map((Function1 & Serializable)x$1 -> {
            DistinguishedName distinguishedName = (DistinguishedName)x$1._1();
            View view = (View)x$1._2();
            DistinguishedName distinguishedName2 = (DistinguishedName)Predef$.MODULE$.ArrowAssoc((Object)distinguishedName);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)distinguishedName2, (Object)view.toSet());
        });
        Logger LoggerImpl_this = js7$common$auth$IdToUser$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("distinguishedNameToUserIds=\u23ce{}", (Object)((IterableOnceOps)distinguishedNameToUserIds.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                DistinguishedName k = (DistinguishedName)tuple2._1();
                Set v = (Set)tuple2._2();
                return "\n  " + k + " --> " + v.mkString(" ");
            })).mkString());
        }
        if (!distinguishedNameToUserIds.values().forall((Function1 & Serializable)_$6 -> _$6.nonEmpty())) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return new IdToUser<U>((Function1<UserId, Option<IdToUser.RawUserAccount>>)(Function1 & Serializable)userId -> this.userIdToRaw$2(cfg, (UserId)userId), (Function1<DistinguishedName, Set<UserId>>)(Function1 & Serializable)dn -> (Set)distinguishedNameToUserIds.getOrElse(dn, IdToUser$::fromConfig$$anonfun$4$$anonfun$1), toUser, toPermission);
    }

    public <U extends User> PartialFunction<String, Permission> fromConfig$default$3() {
        return PartialFunction$.MODULE$.empty();
    }

    public Option<HashedPassword> js7$common$auth$IdToUser$$$toHashedPassword(UserId userId, SecretString encodedPassword) {
        block6: {
            List list;
            List list2;
            String string = encodedPassword.string();
            Option option = PasswordRegex.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list2 = (List)option.get()).lengthCompare(2) == 0) {
                String string2 = (String)list2.apply(0);
                String string3 = (String)list2.apply(1);
                if ("plain".equals(string2)) {
                    String pw = string3;
                    return Some$.MODULE$.apply((Object)HashedPassword$.MODULE$.apply(SecretString$.MODULE$.apply(pw), identityHasher));
                }
                if ("sha512".equals(string2)) {
                    String pw = string3;
                    return Some$.MODULE$.apply((Object)HashedPassword$.MODULE$.apply(SecretString$.MODULE$.apply(pw.toLowerCase(Locale.ROOT)), Hasher$.MODULE$.sha512()));
                }
            }
            if ("".equals(string)) {
                return Some$.MODULE$.apply((Object)HashedPassword$.MODULE$.apply(SecretString$.MODULE$.empty(), identityHasher));
            }
            Option option2 = PasswordRegex.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && (list = (List)option2.get()).lengthCompare(2) == 0) {
                String string4 = (String)list.apply(0);
                String string5 = (String)list.apply(1);
                Logger LoggerImpl_this = js7$common$auth$IdToUser$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("Unknown password encoding scheme for User '{}'", (Object)userId);
                }
                return None$.MODULE$;
            }
            Logger LoggerImpl_this = js7$common$auth$IdToUser$$$logger;
            if (!LoggerImpl_this.underlying().isErrorEnabled()) break block6;
            LoggerImpl_this.underlying().error("Missing password encoding scheme for User '{}'. Try to prefix the configured password with 'plain:' or 'sha512:'", (Object)userId);
        }
        return None$.MODULE$;
    }

    private final Option userIdToRaw$2(Config cfg$1, UserId userId) {
        block1: {
            if (cfg$1.hasPath(userId.string())) {
                return this.existentUserIdToRaw$1(cfg$1, userId);
            }
            Logger LoggerImpl_this = js7$common$auth$IdToUser$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block1;
            LoggerImpl_this.underlying().debug("Configuration files (\"private.conf\") does not have an entry '{}.{}'", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{UsersConfigPath, userId.string()}), Object.class));
        }
        return None$.MODULE$;
    }

    private static final Config existentUserIdToRaw$1$$anonfun$1(Config cfg$3, UserId userId$2) {
        return cfg$3.getConfig(userId$2.string());
    }

    private static final Iterable $anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final Iterable $anonfun$3() {
        return package$.MODULE$.Nil();
    }

    private final Option existentUserIdToRaw$1(Config cfg$2, UserId userId) {
        Try try_ = Try$.MODULE$.apply(() -> IdToUser$.existentUserIdToRaw$1$$anonfun$1(cfg$2, userId));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable throwable = failure.exception();
            if (throwable instanceof ConfigException.WrongType) {
                ConfigException.WrongType wrongType = (ConfigException.WrongType)throwable;
                return Configs$.MODULE$.ConvertibleConfig(cfg$2).optionAs(userId.string(), (As)SecretString$.MODULE$.StringAsSecretString()).map((Function1 & Serializable)o -> IdToUser$RawUserAccount$.MODULE$.apply(userId, (Option<SecretString>)Some$.MODULE$.apply(o), IdToUser$RawUserAccount$.MODULE$.$lessinit$greater$default$3(), IdToUser$RawUserAccount$.MODULE$.$lessinit$greater$default$4()));
            }
            Throwable t = throwable;
            throw t;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Config c = (Config)success.value();
            Option encodedPassword = Configs$.MODULE$.ConvertibleConfig(c).optionAs("password", (As)SecretString$.MODULE$.StringAsSecretString());
            Set permissions = Configs$RichConfig$.MODULE$.stringSeq$extension(Configs$.MODULE$.RichConfig(c), "permissions", (Function0<Iterable<String>>)((Function0 & Serializable)IdToUser$::$anonfun$2)).toSet();
            IndexedSeq<DistinguishedName> distinguishedNames = Configs$RichConfig$.MODULE$.seqAs$extension(Configs$.MODULE$.RichConfig(c), "distinguished-names", IdToUser$::$anonfun$3, DistinguishedName$.MODULE$.GenericStringAsString());
            return Some$.MODULE$.apply((Object)IdToUser$RawUserAccount$.MODULE$.apply(userId, (Option<SecretString>)encodedPassword, (Set<String>)permissions, (Seq<DistinguishedName>)distinguishedNames));
        }
        throw new MatchError((Object)try_);
    }

    private static final Set fromConfig$$anonfun$4$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }
}

