/*
 * Decompiled with CFR 0.152.
 */
package js7.common.auth;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.base.auth.DistinguishedName;
import js7.base.auth.HashedPassword;
import js7.base.auth.HashedPassword$;
import js7.base.auth.HashedPassword$MatchesNothing$;
import js7.base.auth.Permission;
import js7.base.auth.User;
import js7.base.auth.UserId;
import js7.base.auth.UserId$;
import js7.base.generic.SecretString;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Memoizer$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.common.auth.IdToUser$;
import js7.common.auth.IdToUser$RawUserAccount$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.ChainingOps$;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;
import scala.util.package;

public final class IdToUser<U extends User>
implements Function1<UserId, Option<U>> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(IdToUser.class.getDeclaredField("someAnonymous$lzy1"));
    private final Function1<UserId, Option<RawUserAccount>> userIdToRaw;
    private final Function1<DistinguishedName, Set<UserId>> distinguishedNameToUserIds;
    private final Function4<UserId, HashedPassword, Set<Permission>, Seq<DistinguishedName>, U> toUser;
    private final PartialFunction<String, Permission> toPermission;
    private volatile Object someAnonymous$lzy1;
    private final Function1<UserId, Option<U>> memoizedToUser;

    public static <U extends User> IdToUser<U> fromConfig(Config config, Function4<UserId, HashedPassword, Set<Permission>, Seq<DistinguishedName>, U> function4, PartialFunction<String, Permission> partialFunction) {
        return IdToUser$.MODULE$.fromConfig(config, function4, partialFunction);
    }

    public static <U extends User> PartialFunction<String, Permission> fromConfig$default$3() {
        return IdToUser$.MODULE$.fromConfig$default$3();
    }

    public IdToUser(Function1<UserId, Option<RawUserAccount>> userIdToRaw, Function1<DistinguishedName, Set<UserId>> distinguishedNameToUserIds, Function4<UserId, HashedPassword, Set<Permission>, Seq<DistinguishedName>, U> toUser, PartialFunction<String, Permission> toPermission) {
        this.userIdToRaw = userIdToRaw;
        this.distinguishedNameToUserIds = distinguishedNameToUserIds;
        this.toUser = toUser;
        this.toPermission = toPermission;
        Function1 & Serializable intersect = (Function1 & Serializable)userId -> {
            if (userId.isAnonymous()) {
                return this.someAnonymous();
            }
            return ((Option)userIdToRaw.apply(userId)).flatMap((Function1 & Serializable)raw -> this.rawToUser((RawUserAccount)raw));
        };
        this.memoizedToUser = Memoizer$.MODULE$.strict1(intersect, Memoizer$.MODULE$.strict1$default$2(intersect));
    }

    private Some<U> someAnonymous() {
        Object object = this.someAnonymous$lzy1;
        if (object instanceof Some) {
            return (Some)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Some)this.someAnonymous$lzyINIT1();
    }

    private Object someAnonymous$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.someAnonymous$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Some some = null;
                    try {
                        some = Some$.MODULE$.apply(this.toUser.apply((Object)UserId$.MODULE$.Anonymous(), (Object)HashedPassword$.MODULE$.newEmpty(), (Object)Predef$.MODULE$.Set().empty(), (Object)package$.MODULE$.Nil()));
                        object2 = some == null ? LazyVals.NullValue$.MODULE$ : some;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.someAnonymous$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return some;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<U> apply(UserId userId) {
        return (Option)this.memoizedToUser.apply((Object)userId);
    }

    public Either<Problem, Either<Set<UserId>, U>> distinguishedNameToIdsOrUser(DistinguishedName distinguishedName) {
        Set userIds = (Set)this.distinguishedNameToUserIds.apply((Object)distinguishedName);
        if (userIds.isEmpty()) {
            return package$.MODULE$.Left().apply((Object)IdToUser.unknownDN$1(distinguishedName));
        }
        if (IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(userIds.sizeIs(), 1)) {
            Option<U> option = this.apply((UserId)userIds.head());
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)IdToUser.unknownDN$1(distinguishedName));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                User user = (User)some.value();
                return package$.MODULE$.Right().apply((Object)package$.MODULE$.Right().apply((Object)user));
            }
            throw new MatchError(option);
        }
        if (!IterableOps.SizeCompareOps$.MODULE$.$greater$extension(userIds.sizeIs(), 1)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Left().apply((Object)userIds));
    }

    private Option<U> rawToUser(RawUserAccount raw) {
        Some some;
        Option<SecretString> option = raw.encodedPassword();
        if (None$.MODULE$.equals(option)) {
            some = Some$.MODULE$.apply((Object)HashedPassword$MatchesNothing$.MODULE$);
        } else if (option instanceof Some) {
            Some some2 = (Some)option;
            SecretString pw = (SecretString)some2.value();
            some = IdToUser$.MODULE$.js7$common$auth$IdToUser$$$toHashedPassword(raw.userId(), pw).map((Function1 & Serializable)_$1 -> _$1.hashAgainRandom());
        } else {
            throw new MatchError(option);
        }
        return some.map((Function1 & Serializable)hashedPassword -> (User)this.toUser.apply((Object)raw.userId(), hashedPassword, raw.permissions().flatMap((Function1 & Serializable)p -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.toPermission);
            Option option = (Option)package.chaining$.MODULE$.scalaUtilChainingOps(ScalaUtils$syntax$RichPartialFunction$.MODULE$.get$extension(partialFunction, p));
            return (IterableOnce)ChainingOps$.MODULE$.tap$extension((Object)option, (Function1)(JProcedure1 & Serializable)maybe -> {
                if (maybe.isEmpty()) {
                    Logger LoggerImpl_this = IdToUser$.js7$common$auth$IdToUser$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn("{} has unknown '{}' permission", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{raw.userId(), p}), Object.class));
                        return;
                    }
                    return;
                }
            });
        }), raw.distinguishedNames()));
    }

    private static final String unknownDN$1$$anonfun$1(DistinguishedName distinguishedName$2) {
        return "Unknown distinguished name (not defined as an user): " + distinguishedName$2;
    }

    private static final Problem unknownDN$1(DistinguishedName distinguishedName$1) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> IdToUser.unknownDN$1$$anonfun$1(distinguishedName$1)), Problem$.MODULE$.apply$default$2());
    }

    public static final class RawUserAccount
    implements Product,
    Serializable {
        private final UserId userId;
        private final Option<SecretString> encodedPassword;
        private final Set<String> permissions;
        private final Seq<DistinguishedName> distinguishedNames;

        public static RawUserAccount apply(UserId userId, Option<SecretString> option, Set<String> set, Seq<DistinguishedName> seq) {
            return IdToUser$RawUserAccount$.MODULE$.apply(userId, option, set, seq);
        }

        public static RawUserAccount fromProduct(Product product) {
            return IdToUser$RawUserAccount$.MODULE$.fromProduct(product);
        }

        public static RawUserAccount unapply(RawUserAccount rawUserAccount) {
            return IdToUser$RawUserAccount$.MODULE$.unapply(rawUserAccount);
        }

        public static Set<String> $lessinit$greater$default$3() {
            return IdToUser$RawUserAccount$.MODULE$.$lessinit$greater$default$3();
        }

        public static Seq<DistinguishedName> $lessinit$greater$default$4() {
            return IdToUser$RawUserAccount$.MODULE$.$lessinit$greater$default$4();
        }

        public RawUserAccount(UserId userId, Option<SecretString> encodedPassword, Set<String> permissions, Seq<DistinguishedName> distinguishedNames) {
            this.userId = userId;
            this.encodedPassword = encodedPassword;
            this.permissions = permissions;
            this.distinguishedNames = distinguishedNames;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 460549664, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            RawUserAccount rawUserAccount;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RawUserAccount)) return false;
            RawUserAccount rawUserAccount2 = rawUserAccount = (RawUserAccount)object;
            UserId userId = this.userId();
            UserId userId2 = rawUserAccount2.userId();
            if (userId == null) {
                if (userId2 != null) {
                    return false;
                }
            } else if (!((Object)userId).equals(userId2)) return false;
            Option<SecretString> option = this.encodedPassword();
            Option<SecretString> option2 = rawUserAccount2.encodedPassword();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Set<String> set = this.permissions();
            Set<String> set2 = rawUserAccount2.permissions();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Seq<DistinguishedName> seq = this.distinguishedNames();
            Seq<DistinguishedName> seq2 = rawUserAccount2.distinguishedNames();
            if (seq == null) {
                if (seq2 == null) return true;
                return false;
            } else {
                if (!seq.equals(seq2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RawUserAccount;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "RawUserAccount";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "userId";
                }
                case 1: {
                    return "encodedPassword";
                }
                case 2: {
                    return "permissions";
                }
                case 3: {
                    return "distinguishedNames";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UserId userId() {
            return this.userId;
        }

        public Option<SecretString> encodedPassword() {
            return this.encodedPassword;
        }

        public Set<String> permissions() {
            return this.permissions;
        }

        public Seq<DistinguishedName> distinguishedNames() {
            return this.distinguishedNames;
        }

        public RawUserAccount copy(UserId userId, Option<SecretString> encodedPassword, Set<String> permissions, Seq<DistinguishedName> distinguishedNames) {
            return new RawUserAccount(userId, encodedPassword, permissions, distinguishedNames);
        }

        public UserId copy$default$1() {
            return this.userId();
        }

        public Option<SecretString> copy$default$2() {
            return this.encodedPassword();
        }

        public Set<String> copy$default$3() {
            return this.permissions();
        }

        public Seq<DistinguishedName> copy$default$4() {
            return this.distinguishedNames();
        }

        public UserId _1() {
            return this.userId();
        }

        public Option<SecretString> _2() {
            return this.encodedPassword();
        }

        public Set<String> _3() {
            return this.permissions();
        }

        public Seq<DistinguishedName> _4() {
            return this.distinguishedNames();
        }
    }
}

