/*
 * Decompiled with CFR 0.152.
 */
package js7.common.pekkohttp.web.auth;

import cats.effect.IO$;
import cats.effect.unsafe.IORuntime;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import js7.base.auth.DistinguishedName;
import js7.base.auth.DistinguishedName$;
import js7.base.auth.GetPermission$;
import js7.base.auth.HashedPassword;
import js7.base.auth.Permission;
import js7.base.auth.SimpleUser;
import js7.base.auth.SuperPermission$;
import js7.base.auth.User;
import js7.base.auth.UserAndPassword;
import js7.base.auth.UserId;
import js7.base.auth.UserId$;
import js7.base.auth.ValidUserPermission$;
import js7.base.log.Logger$package$Logger$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.common.pekkohttp.PekkoHttpServerUtils$;
import js7.common.pekkohttp.StandardMarshallers$;
import js7.common.pekkohttp.web.auth.GateKeeper$;
import js7.common.pekkohttp.web.auth.GateKeeper$Configuration$;
import js7.common.pekkohttp.web.auth.GateKeeper$GetIsPublic$;
import js7.common.pekkohttp.web.auth.GateKeeper$IsPublic$;
import js7.common.pekkohttp.web.auth.GateKeeper$LoopbackIsPublic$;
import js7.common.pekkohttp.web.auth.OurMemoizingAuthenticator;
import js7.common.pekkohttp.web.data.WebServerBinding;
import js7.common.pekkohttp.web.data.WebServerBinding$Https$;
import org.apache.pekko.http.scaladsl.marshalling.Marshaller$;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable;
import org.apache.pekko.http.scaladsl.marshalling.ToResponseMarshallable$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.headers.HttpChallenge;
import org.apache.pekko.http.scaladsl.model.headers.HttpChallenges$;
import org.apache.pekko.http.scaladsl.model.headers.ModeledCompanion;
import org.apache.pekko.http.scaladsl.model.headers.Tls;
import org.apache.pekko.http.scaladsl.model.headers.Tls$minusSession$minusInfo$;
import org.apache.pekko.http.scaladsl.model.headers.WWW;
import org.apache.pekko.http.scaladsl.model.headers.WWW$minusAuthenticate$;
import org.apache.pekko.http.scaladsl.server.AuthenticationFailedRejection;
import org.apache.pekko.http.scaladsl.server.AuthenticationFailedRejection$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.ExceptionHandler;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.RejectionHandler;
import org.apache.pekko.http.scaladsl.server.RejectionHandler$;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.Route$;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.directives.HeaderMagnet$;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple1;
import scala.Tuple1$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class GateKeeper<U extends User> {
    private final WebServerBinding binding;
    private final Configuration<U> configuration;
    private final boolean isLoopback;
    private final User.Companion<U> U;
    private final ExceptionHandler exceptionHandler;
    private final IORuntime IORuntime;
    public final Logger js7$common$pekkohttp$web$auth$GateKeeper$$logger;
    private final boolean httpsClientAuthRequired;
    private final OurMemoizingAuthenticator<U> authenticator;
    private final AuthenticationFailedRejection credentialsMissing;
    private final WWW.minusAuthenticate wwwAuthenticateHeader;
    private final U anonymous;
    private final RejectionHandler credentialRejectionHandler;
    private final Directive<Tuple1<Either<Set<UserId>, U>>> preAuthenticate;
    private final Directive<Tuple1<U>> httpAuthenticate;

    public static <U extends User> GateKeeper<U> apply(WebServerBinding webServerBinding, Configuration<U> configuration, User.Companion<U> companion, IORuntime iORuntime, ExceptionHandler exceptionHandler) {
        return GateKeeper$.MODULE$.apply(webServerBinding, configuration, companion, iORuntime, exceptionHandler);
    }

    public static GateKeeper<SimpleUser> forTest(WebServerBinding webServerBinding, boolean bl, Config config, ExceptionHandler exceptionHandler, IORuntime iORuntime) {
        return GateKeeper$.MODULE$.forTest(webServerBinding, bl, config, exceptionHandler, iORuntime);
    }

    public static StatusCodes.ClientError unauthorized() {
        return GateKeeper$.MODULE$.unauthorized();
    }

    public static boolean forTest$default$2() {
        return GateKeeper$.MODULE$.forTest$default$2();
    }

    public static <U extends User> boolean $lessinit$greater$default$3() {
        return GateKeeper$.MODULE$.$lessinit$greater$default$3();
    }

    public static Config forTest$default$3() {
        return GateKeeper$.MODULE$.forTest$default$3();
    }

    public GateKeeper(WebServerBinding binding, Configuration<U> configuration, boolean isLoopback, User.Companion<U> U, ExceptionHandler exceptionHandler, IORuntime IORuntime2) {
        this.binding = binding;
        this.configuration = configuration;
        this.isLoopback = isLoopback;
        this.U = U;
        this.exceptionHandler = exceptionHandler;
        this.IORuntime = IORuntime2;
        this.js7$common$pekkohttp$web$auth$GateKeeper$$logger = Logger$package$Logger$.MODULE$.withPrefix(binding.toString(), ClassTag$.MODULE$.apply(GateKeeper.class));
        WebServerBinding.Scheme scheme = binding.scheme();
        WebServerBinding$Https$ webServerBinding$Https$ = WebServerBinding$Https$.MODULE$;
        this.httpsClientAuthRequired = !(scheme != null ? !scheme.equals(webServerBinding$Https$) : webServerBinding$Https$ != null) && configuration.httpsClientAuthRequired();
        this.authenticator = new OurMemoizingAuthenticator<U>(configuration.idToUser());
        HttpChallenge basicChallenge = HttpChallenges$.MODULE$.basic(configuration.realm());
        this.credentialsMissing = AuthenticationFailedRejection$.MODULE$.apply((AuthenticationFailedRejection.Cause)AuthenticationFailedRejection.CredentialsMissing$.MODULE$, basicChallenge);
        this.wwwAuthenticateHeader = WWW$minusAuthenticate$.MODULE$.apply(basicChallenge, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpChallenge[0]));
        this.anonymous = configuration.anonymous();
        this.credentialRejectionHandler = RejectionHandler$.MODULE$.newBuilder().handle((PartialFunction)new Serializable(this){
            private final /* synthetic */ GateKeeper $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Rejection x2) {
                Rejection rejection = x2;
                if (rejection instanceof AuthenticationFailedRejection) {
                    AuthenticationFailedRejection authenticationFailedRejection = (AuthenticationFailedRejection)rejection;
                    AuthenticationFailedRejection.Cause cause = authenticationFailedRejection.cause();
                    HttpChallenge httpChallenge = authenticationFailedRejection.challenge();
                    if (AuthenticationFailedRejection.CredentialsRejected$.MODULE$.equals(cause)) {
                        HttpChallenge challenge = httpChallenge;
                        return true;
                    }
                    if (AuthenticationFailedRejection.CredentialsMissing$.MODULE$.equals(cause)) {
                        HttpChallenge challenge = httpChallenge;
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Rejection x2, Function1 function1) {
                Rejection rejection = x2;
                if (rejection instanceof AuthenticationFailedRejection) {
                    AuthenticationFailedRejection authenticationFailedRejection = (AuthenticationFailedRejection)rejection;
                    AuthenticationFailedRejection.Cause cause = authenticationFailedRejection.cause();
                    HttpChallenge httpChallenge = authenticationFailedRejection.challenge();
                    if (AuthenticationFailedRejection.CredentialsRejected$.MODULE$.equals(cause)) {
                        HttpChallenge challenge = httpChallenge;
                        Logger LoggerImpl_this = this.$outer.js7$common$pekkohttp$web$auth$GateKeeper$$logger;
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            LoggerImpl_this.underlying().warn("HTTP request with invalid authentication rejected - delaying response for {}", (Object)ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.$outer.invalidAuthenticationDelay())));
                        }
                        return Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.respondWithHeader((HttpHeader)WWW$minusAuthenticate$.MODULE$.apply(challenge, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpChallenge[0])))).apply(this::applyOrElse$$anonfun$1);
                    }
                    if (AuthenticationFailedRejection.CredentialsMissing$.MODULE$.equals(cause)) {
                        HttpChallenge challenge = httpChallenge;
                        return Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.respondWithHeader((HttpHeader)WWW$minusAuthenticate$.MODULE$.apply(challenge, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpChallenge[0])))).apply(GateKeeper::js7$common$pekkohttp$web$auth$GateKeeper$$anon$1$$_$applyOrElse$$anonfun$2);
                    }
                }
                return function1.apply((Object)x2);
            }

            private final Function1 applyOrElse$$anonfun$1() {
                return this.$outer.js7$common$pekkohttp$web$auth$GateKeeper$$completeDelayed((Function0<ToResponseMarshallable>)((Function0 & Serializable)GateKeeper::js7$common$pekkohttp$web$auth$GateKeeper$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(), js7$common$pekkohttp$web$auth$GateKeeper$$anon$1$$_$applyOrElse$$anonfun$2(), js7$common$pekkohttp$web$auth$GateKeeper$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1()}, serializedLambda);
            }
        }).result();
        this.preAuthenticate = Directive$.MODULE$.apply((Function1 & Serializable)inner -> {
            Function1 function1 = (Function1)Directive$.MODULE$.addDirectiveApply(this.httpAuthenticate, ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)httpUser -> {
                if (!this.httpsClientAuthRequired) {
                    return (Function1)inner.apply((Object)Tuple1$.MODULE$.apply((Object)package$.MODULE$.Right().apply(httpUser)));
                }
                return (Function1)Directive$.MODULE$.addDirectiveApply(this.clientHttpsAuthenticate(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)x$1 -> {
                    Left left;
                    Set allowedHttpsUserIds;
                    Either either;
                    block5: {
                        Either idsOrUser;
                        block4: {
                            idsOrUser = either = x$1;
                            if (httpUser.isAnonymous()) break block4;
                            Either either2 = idsOrUser;
                            Right right = package$.MODULE$.Right().apply(httpUser);
                            if (either2 != null ? !either2.equals(right) : right != null) break block5;
                        }
                        return (Function1)inner.apply((Object)Tuple1$.MODULE$.apply((Object)idsOrUser));
                    }
                    if (either instanceof Left && (allowedHttpsUserIds = (Set)(left = (Left)either).value()).contains((Object)httpUser.id())) {
                        return (Function1)inner.apply((Object)Tuple1$.MODULE$.apply((Object)package$.MODULE$.Right().apply(httpUser)));
                    }
                    return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.respondWithHeader((HttpHeader)this.wwwAuthenticateHeader())).apply(this::$anonfun$1$$anonfun$1$$anonfun$1);
                });
            });
            return Route$.MODULE$.seal(function1, Route$.MODULE$.seal$default$2(function1), Route$.MODULE$.seal$default$3(function1), Route$.MODULE$.seal$default$4(function1), exceptionHandler);
        }, Tuple$.MODULE$.forTuple1());
        this.httpAuthenticate = Directive$.MODULE$.apply((Function1 & Serializable)inner -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.handleRejections(this.credentialRejectionHandler)).apply(() -> this.$init$$$anonfun$2$$anonfun$1(configuration, inner)), Tuple$.MODULE$.forTuple1());
    }

    public AuthenticationFailedRejection credentialsMissing() {
        return this.credentialsMissing;
    }

    public WWW.minusAuthenticate wwwAuthenticateHeader() {
        return this.wwwAuthenticateHeader;
    }

    public U anonymous() {
        return this.anonymous;
    }

    public Option<U> authenticateUser(UserAndPassword userAndPassword) {
        if (!userAndPassword.userId().isAnonymous()) {
            this.ifPublic().foreach((Function1)(JProcedure1 & Serializable)reason -> {
                Logger LoggerImpl_this = this.js7$common$pekkohttp$web$auth$GateKeeper$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("User '{}' logs in with credentials despite {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{userAndPassword.userId().string(), reason}), Object.class));
                    return;
                }
            });
        }
        return this.authenticator.authenticate(userAndPassword);
    }

    public Directive<Tuple1<Either<Set<UserId>, U>>> preAuthenticate() {
        return this.preAuthenticate;
    }

    private Directive<Tuple1<Either<Set<UserId>, U>>> clientHttpsAuthenticate() {
        return Directive$.MODULE$.apply((Function1 & Serializable)inner -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.optionalHeaderValueByType(HeaderMagnet$.MODULE$.fromCompanionNormalHeader((ModeledCompanion)Tls$minusSession$minusInfo$.MODULE$, ClassTag$.MODULE$.apply(Tls.minusSession.minusInfo.class))), ApplyConverter$.MODULE$.hac1()).apply(arg_0 -> this.clientHttpsAuthenticate$$anonfun$1$$anonfun$1(inner, arg_0)), Tuple$.MODULE$.forTuple1());
    }

    private Either<Problem, Either<Set<UserId>, U>> certToUsers(X509Certificate cert) {
        return DistinguishedName$.MODULE$.checked(cert.getSubjectX500Principal().getName()).flatMap(this.configuration.distinguishedNameToIdsOrUser());
    }

    public Directive<Tuple1<U>> authorize(U user, Set<Permission> requiredPermissions) {
        return Directive$.MODULE$.apply((Function1 & Serializable)inner -> {
            Function1 function1 = (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.extractRequest(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)request -> {
                Either<Problem, User> either = this.allowedUser(user, (HttpRequest)request, requiredPermissions);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    User authorizedUser = (User)right.value();
                    return (Function1)inner.apply((Object)Tuple1$.MODULE$.apply((Object)authorizedUser));
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Problem problem = (Problem)left.value();
                    if (user.isAnonymous()) {
                        return Directives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{this.credentialsMissing()}));
                    }
                    return Directives$.MODULE$.complete(() -> GateKeeper.$anonfun$2$$anonfun$1(problem));
                }
                throw new MatchError(either);
            });
            return Route$.MODULE$.seal(function1, Route$.MODULE$.seal$default$2(function1), Route$.MODULE$.seal$default$3(function1), Route$.MODULE$.seal$default$4(function1), this.exceptionHandler);
        }, Tuple$.MODULE$.forTuple1());
    }

    public Either<Problem, U> allowedUser(U user, HttpRequest request, Set<Permission> requiredPermissions) {
        Option<AuthorizationReason> option = this.ifPublic(request.method());
        if (option instanceof Some) {
            Logger LoggerImpl_this;
            Set<Permission> set;
            Some some = (Some)option;
            AuthorizationReason reason = (AuthorizationReason)some.value();
            AuthorizationReason authorizationReason = reason;
            if (GateKeeper$IsPublic$.MODULE$.equals(authorizationReason) || GateKeeper$LoopbackIsPublic$.MODULE$.equals(authorizationReason)) {
                set = this.configuration.publicPermissions();
            } else if (GateKeeper$GetIsPublic$.MODULE$.equals(authorizationReason)) {
                set = this.configuration.publicGetPermissions();
            } else {
                throw new MatchError((Object)authorizationReason);
            }
            U empoweredUser = this.U.addPermissions(user, set);
            Set<Permission> set2 = empoweredUser.grantedPermissions();
            Set<Permission> set3 = user.grantedPermissions();
            if ((set2 == null ? set3 != null : !set2.equals(set3)) && (LoggerImpl_this = this.js7$common$pekkohttp$web$auth$GateKeeper$$logger).underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Due to " + reason + ", user '" + empoweredUser.id().string() + "' has all permissions for " + (request.method().value() + " " + request.uri().path()));
            }
            return package$.MODULE$.Right().apply(empoweredUser);
        }
        if (None$.MODULE$.equals(option)) {
            return this.ifPermitted(user, requiredPermissions, request.method());
        }
        throw new MatchError(option);
    }

    public Option<AuthorizationReason> ifPublic(HttpMethod method) {
        return this.ifPublic().orElse(() -> this.ifPublic$$anonfun$1(method));
    }

    public Option<AuthorizationReason> ifPublic() {
        if (this.configuration.isPublic()) {
            return Some$.MODULE$.apply((Object)GateKeeper$IsPublic$.MODULE$);
        }
        if (this.isLoopback && this.configuration.loopbackIsPublic()) {
            return Some$.MODULE$.apply((Object)GateKeeper$LoopbackIsPublic$.MODULE$);
        }
        return None$.MODULE$;
    }

    private Either<Problem, U> ifPermitted(U user, Set<Permission> requiredPermissions, HttpMethod method) {
        return user.checkPermissions(requiredPermissions).flatMap((Function1 & Serializable)_$2 -> {
            if (requiredPermissions.contains((Object)ValidUserPermission$.MODULE$) || user.hasPermission(ValidUserPermission$.MODULE$) || GateKeeper$.MODULE$.js7$common$pekkohttp$web$auth$GateKeeper$$$isGet(method)) {
                return package$.MODULE$.Right().apply(user);
            }
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Anonymous is permitted HTTP GET only"));
        });
    }

    public Function1<RequestContext, Future<RouteResult>> js7$common$pekkohttp$web$auth$GateKeeper$$completeDelayed(Function0<ToResponseMarshallable> body) {
        return PekkoHttpServerUtils$.MODULE$.completeIO(IO$.MODULE$.apply(body).delayBy((Duration)this.invalidAuthenticationDelay()), ToResponseMarshallable$.MODULE$.marshaller(), this.IORuntime);
    }

    public FiniteDuration invalidAuthenticationDelay() {
        return this.configuration.invalidAuthenticationDelay();
    }

    public String secureStateString() {
        return this.configuration.secureStateString(this.binding.scheme());
    }

    public static final ToResponseMarshallable js7$common$pekkohttp$web$auth$GateKeeper$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1() {
        return ToResponseMarshallable$.MODULE$.apply((Object)GateKeeper$.MODULE$.unauthorized(), Marshaller$.MODULE$.fromStatusCode());
    }

    private static final ToResponseMarshallable applyOrElse$$anonfun$2$$anonfun$1() {
        return ToResponseMarshallable$.MODULE$.apply((Object)GateKeeper$.MODULE$.unauthorized(), Marshaller$.MODULE$.fromStatusCode());
    }

    public static final Function1 js7$common$pekkohttp$web$auth$GateKeeper$$anon$1$$_$applyOrElse$$anonfun$2() {
        return Directives$.MODULE$.complete(GateKeeper::applyOrElse$$anonfun$2$$anonfun$1);
    }

    private static final ToResponseMarshallable $anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        StatusCodes.ClientError clientError = (StatusCodes.ClientError)Predef$.MODULE$.ArrowAssoc((Object)StatusCodes$.MODULE$.Forbidden());
        return ToResponseMarshallable$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clientError, (Object)Problem$.MODULE$.pure("HTTP user does not match UserIds allowed by HTTPS client distinguished name")), Marshaller$.MODULE$.fromStatusCodeAndValue(Predef$.MODULE$.$conforms(), StandardMarshallers$.MODULE$.problemToEntityMarshaller()));
    }

    private final Function1 $anonfun$1$$anonfun$1$$anonfun$1() {
        return this.js7$common$pekkohttp$web$auth$GateKeeper$$completeDelayed((Function0<ToResponseMarshallable>)((Function0 & Serializable)GateKeeper::$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1));
    }

    private final Function1 $init$$$anonfun$2$$anonfun$1(Configuration configuration$2, Function1 inner$3) {
        return (Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.authenticateBasic(configuration$2.realm(), this.authenticator), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)user -> (Function1)inner$3.apply((Object)Tuple1$.MODULE$.apply(user)));
    }

    private static final ToResponseMarshallable clientHttpsAuthenticate$$anonfun$1$$anonfun$1$$anonfun$1() {
        StatusCodes.ClientError clientError = (StatusCodes.ClientError)Predef$.MODULE$.ArrowAssoc((Object)StatusCodes$.MODULE$.Forbidden());
        return ToResponseMarshallable$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clientError, (Object)Problem$.MODULE$.pure("A client HTTPS certificate is required")), Marshaller$.MODULE$.fromStatusCodeAndValue(Predef$.MODULE$.$conforms(), StandardMarshallers$.MODULE$.problemToEntityMarshaller()));
    }

    public static final /* synthetic */ boolean js7$common$pekkohttp$web$auth$GateKeeper$$anon$2$$_$isDefinedAt$$anonfun$1(int _$1) {
        return _$1 == -1;
    }

    public static final /* synthetic */ boolean js7$common$pekkohttp$web$auth$GateKeeper$$anon$2$$_$applyOrElse$$anonfun$3(int _$1) {
        return _$1 == -1;
    }

    private final /* synthetic */ Either clientHttpsAuthenticate$$anonfun$1$$anonfun$1$$anonfun$2(X509Certificate cert) {
        return this.certToUsers(cert);
    }

    private static final ToResponseMarshallable clientHttpsAuthenticate$$anonfun$1$$anonfun$1$$anonfun$3(Problem problem$1) {
        StatusCodes.ClientError clientError = (StatusCodes.ClientError)Predef$.MODULE$.ArrowAssoc((Object)GateKeeper$.MODULE$.unauthorized());
        return ToResponseMarshallable$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clientError, (Object)problem$1), Marshaller$.MODULE$.fromStatusCodeAndValue(Predef$.MODULE$.$conforms(), StandardMarshallers$.MODULE$.problemToEntityMarshaller()));
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ Function1 clientHttpsAuthenticate$$anonfun$1$$anonfun$1(Function1 inner$5, Option x$1) {
        block7: {
            block9: {
                block8: {
                    var3_3 = x$1;
                    if (None$.MODULE$.equals(var3_3)) {
                        return Directives$.MODULE$.complete((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, clientHttpsAuthenticate$$anonfun$1$$anonfun$1$$anonfun$1(), ()Lorg/apache/pekko/http/scaladsl/marshalling/ToResponseMarshallable;)());
                    }
                    if (!(var3_3 instanceof Some)) break block7;
                    var4_4 = (Some)var3_3;
                    tlsSessionInfo = (Tls.minusSession.minusInfo)var4_4.value();
                    var7_6 = tlsSessionInfo.peerCertificates();
                    if (!(var7_6 instanceof .colon.colon)) break block8;
                    var8_7 = (.colon.colon)var7_6;
                    var9_8 = (Certificate)var8_7.head();
                    var10_9 = var8_7.next();
                    if (!(var9_8 instanceof X509Certificate)) break block8;
                    cert = var11_10 = (X509Certificate)var9_8;
                    v0 = package$.MODULE$.Nil();
                    var13_12 = var10_9;
                    if (v0 != null ? v0.equals(var13_12) == false : var13_12 != null) break block8;
                    v1 = package$.MODULE$.Right().apply((Object)cert);
                    break block9;
                }
                if (!((var15_14 = (certs = var7_6).collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Certificate x2) {
                        X509Certificate x509Certificate;
                        X509Certificate o;
                        Certificate certificate = x2;
                        return certificate instanceof X509Certificate && Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(o = (x509Certificate = (X509Certificate)certificate)).getBasicConstraints())).forall((Function1)((JFunction1.mcZI.sp & Serializable)GateKeeper::js7$common$pekkohttp$web$auth$GateKeeper$$anon$2$$_$isDefinedAt$$anonfun$1));
                    }

                    public final Object applyOrElse(Certificate x2, Function1 function1) {
                        X509Certificate x509Certificate;
                        X509Certificate o;
                        Certificate certificate = x2;
                        if (certificate instanceof X509Certificate && Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(o = (x509Certificate = (X509Certificate)certificate)).getBasicConstraints())).forall((Function1)((JFunction1.mcZI.sp & Serializable)GateKeeper::js7$common$pekkohttp$web$auth$GateKeeper$$anon$2$$_$applyOrElse$$anonfun$3))) {
                            return o;
                        }
                        return function1.apply((Object)x2);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$common$pekkohttp$web$auth$GateKeeper$$anon$2$$_$isDefinedAt$$anonfun$1(int ), js7$common$pekkohttp$web$auth$GateKeeper$$anon$2$$_$applyOrElse$$anonfun$3(int )}, serializedLambda);
                    }
                })) instanceof .colon.colon)) ** GOTO lbl-1000
                var16_15 = (.colon.colon)var15_14;
                var17_16 = var16_15.next();
                cert = (X509Certificate)var16_15.head();
                v2 = package$.MODULE$.Nil();
                var19_18 = var17_16;
                if (!(v2 != null ? v2.equals(var19_18) == false : var19_18 != null)) {
                    LoggerImpl_this = this.js7$common$pekkohttp$web$auth$GateKeeper$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("HTTPS client has sent the client certificate and some CA certificate. We ignore the latter");
                    }
                    v1 = package$.MODULE$.Right().apply((Object)cert);
                } else lbl-1000:
                // 2 sources

                {
                    if (certs.nonEmpty() && (LoggerImpl_this = this.js7$common$pekkohttp$web$auth$GateKeeper$$logger).underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("HTTPS client certificates rejected: {}", (Object)certs.mkString(", "));
                    }
                    v1 = package$.MODULE$.Left().apply((Object)((n = (var22_21 = certs.length())) > 1 ? Problem$.MODULE$.pure("One and only one peer certificate is required (not " + n + ")") : Problem$.MODULE$.pure("A client X.509 certificate is required")));
                }
            }
            var6_23 = v1.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, clientHttpsAuthenticate$$anonfun$1$$anonfun$1$$anonfun$2(java.security.cert.X509Certificate ), (Ljava/security/cert/X509Certificate;)Lscala/util/Either;)((GateKeeper)this));
            if (var6_23 instanceof Left) {
                var24_24 = (Left)var6_23;
                problem = (Problem)var24_24.value();
                return this.js7$common$pekkohttp$web$auth$GateKeeper$$completeDelayed((Function0<ToResponseMarshallable>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, clientHttpsAuthenticate$$anonfun$1$$anonfun$1$$anonfun$3(js7.base.problem.Problem ), ()Lorg/apache/pekko/http/scaladsl/marshalling/ToResponseMarshallable;)((Problem)problem));
            }
            if (var6_23 instanceof Right) {
                var26_26 = (Right)var6_23;
                o = (Either)var26_26.value();
                return (Function1)inner$5.apply((Object)Tuple1$.MODULE$.apply((Object)o));
            }
            throw new MatchError((Object)var6_23);
        }
        throw new MatchError((Object)var3_3);
    }

    private static final ToResponseMarshallable $anonfun$2$$anonfun$1(Problem problem$2) {
        StatusCodes.ClientError clientError = (StatusCodes.ClientError)Predef$.MODULE$.ArrowAssoc((Object)StatusCodes$.MODULE$.Forbidden());
        return ToResponseMarshallable$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clientError, (Object)problem$2), Marshaller$.MODULE$.fromStatusCodeAndValue(Predef$.MODULE$.$conforms(), StandardMarshallers$.MODULE$.problemToEntityMarshaller()));
    }

    private static final GateKeeper$GetIsPublic$ ifPublic$$anonfun$1$$anonfun$1() {
        return GateKeeper$GetIsPublic$.MODULE$;
    }

    private final Option ifPublic$$anonfun$1(HttpMethod method$1) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.configuration.getIsPublic() && GateKeeper$.MODULE$.js7$common$pekkohttp$web$auth$GateKeeper$$$isGet(method$1));
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, GateKeeper::ifPublic$$anonfun$1$$anonfun$1);
    }

    public static interface AuthorizationReason {
    }

    public static final class Configuration<U extends User>
    implements Product,
    Serializable {
        private final String realm;
        private final FiniteDuration invalidAuthenticationDelay;
        private final boolean isPublic;
        private final boolean loopbackIsPublic;
        private final boolean getIsPublic;
        private final boolean httpsClientAuthRequired;
        private final Function1<UserId, Option<U>> idToUser;
        private final Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> distinguishedNameToIdsOrUser;
        private final Set<Permission> publicPermissions;
        private final Set<Permission> publicGetPermissions;
        private final U anonymous;

        public static <U extends User> Configuration<U> apply(String string, FiniteDuration finiteDuration, boolean bl, boolean bl2, boolean bl3, boolean bl4, Function1<UserId, Option<U>> function1, Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> function12) {
            return GateKeeper$Configuration$.MODULE$.apply(string, finiteDuration, bl, bl2, bl3, bl4, function1, function12);
        }

        public static <U extends User> Configuration<U> fromConfig(Config config, Function4<UserId, HashedPassword, Set<Permission>, Seq<DistinguishedName>, U> function4, Iterable<Permission> iterable) {
            return GateKeeper$Configuration$.MODULE$.fromConfig(config, function4, iterable);
        }

        public static Configuration<?> fromProduct(Product product) {
            return GateKeeper$Configuration$.MODULE$.fromProduct(product);
        }

        public static <U extends User> Configuration<U> unapply(Configuration<U> configuration) {
            return GateKeeper$Configuration$.MODULE$.unapply(configuration);
        }

        public static <U extends User> Function4<UserId, HashedPassword, Set<Permission>, Seq<DistinguishedName>, SimpleUser> fromConfig$default$2() {
            return GateKeeper$Configuration$.MODULE$.fromConfig$default$2();
        }

        public static <U extends User> boolean $lessinit$greater$default$3() {
            return GateKeeper$Configuration$.MODULE$.$lessinit$greater$default$3();
        }

        public static <U extends User> Iterable<Permission> fromConfig$default$3() {
            return GateKeeper$Configuration$.MODULE$.fromConfig$default$3();
        }

        public static <U extends User> boolean $lessinit$greater$default$4() {
            return GateKeeper$Configuration$.MODULE$.$lessinit$greater$default$4();
        }

        public static <U extends User> boolean $lessinit$greater$default$5() {
            return GateKeeper$Configuration$.MODULE$.$lessinit$greater$default$5();
        }

        public static <U extends User> boolean $lessinit$greater$default$6() {
            return GateKeeper$Configuration$.MODULE$.$lessinit$greater$default$6();
        }

        public Configuration(String realm, FiniteDuration invalidAuthenticationDelay, boolean isPublic, boolean loopbackIsPublic, boolean getIsPublic, boolean httpsClientAuthRequired, Function1<UserId, Option<U>> idToUser, Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> distinguishedNameToIdsOrUser) {
            this.realm = realm;
            this.invalidAuthenticationDelay = invalidAuthenticationDelay;
            this.isPublic = isPublic;
            this.loopbackIsPublic = loopbackIsPublic;
            this.getIsPublic = getIsPublic;
            this.httpsClientAuthRequired = httpsClientAuthRequired;
            this.idToUser = idToUser;
            this.distinguishedNameToIdsOrUser = distinguishedNameToIdsOrUser;
            this.publicPermissions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{SuperPermission$.MODULE$}));
            this.publicGetPermissions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{GetPermission$.MODULE$}));
            this.anonymous = (User)((Option)idToUser.apply((Object)UserId$.MODULE$.Anonymous())).getOrElse(this::$init$$$anonfun$3);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)-1563253546);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.realm()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.invalidAuthenticationDelay()));
            n = Statics.mix((int)n, (int)(this.isPublic() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.loopbackIsPublic() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.getIsPublic() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.httpsClientAuthRequired() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.idToUser()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.distinguishedNameToIdsOrUser()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            Configuration configuration;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Configuration)) return false;
            Configuration configuration2 = configuration = (Configuration)object;
            if (this.isPublic() != configuration2.isPublic()) return false;
            if (this.loopbackIsPublic() != configuration2.loopbackIsPublic()) return false;
            if (this.getIsPublic() != configuration2.getIsPublic()) return false;
            if (this.httpsClientAuthRequired() != configuration2.httpsClientAuthRequired()) return false;
            String string = this.realm();
            String string2 = configuration2.realm();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            FiniteDuration finiteDuration = this.invalidAuthenticationDelay();
            FiniteDuration finiteDuration2 = configuration2.invalidAuthenticationDelay();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            Function1<UserId, Option<U>> function1 = this.idToUser();
            Function1<UserId, Option<U>> function12 = configuration2.idToUser();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> function13 = this.distinguishedNameToIdsOrUser();
            Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> function14 = configuration2.distinguishedNameToIdsOrUser();
            if (function13 == null) {
                if (function14 == null) return true;
                return false;
            } else {
                if (!function13.equals(function14)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Configuration;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "Configuration";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean((boolean)this._6());
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "realm";
                }
                case 1: {
                    return "invalidAuthenticationDelay";
                }
                case 2: {
                    return "isPublic";
                }
                case 3: {
                    return "loopbackIsPublic";
                }
                case 4: {
                    return "getIsPublic";
                }
                case 5: {
                    return "httpsClientAuthRequired";
                }
                case 6: {
                    return "idToUser";
                }
                case 7: {
                    return "distinguishedNameToIdsOrUser";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String realm() {
            return this.realm;
        }

        public FiniteDuration invalidAuthenticationDelay() {
            return this.invalidAuthenticationDelay;
        }

        public boolean isPublic() {
            return this.isPublic;
        }

        public boolean loopbackIsPublic() {
            return this.loopbackIsPublic;
        }

        public boolean getIsPublic() {
            return this.getIsPublic;
        }

        public boolean httpsClientAuthRequired() {
            return this.httpsClientAuthRequired;
        }

        public Function1<UserId, Option<U>> idToUser() {
            return this.idToUser;
        }

        public Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> distinguishedNameToIdsOrUser() {
            return this.distinguishedNameToIdsOrUser;
        }

        public Set<Permission> publicPermissions() {
            return this.publicPermissions;
        }

        public Set<Permission> publicGetPermissions() {
            return this.publicGetPermissions;
        }

        public U anonymous() {
            return this.anonymous;
        }

        public String secureStateString(WebServerBinding.Scheme scheme) {
            if (this.isPublic()) {
                return " - ACCESS IS PUBLIC - EVERYONE HAS ACCESS (public = true)";
            }
            if (this.loopbackIsPublic() && this.getIsPublic()) {
                return " - ACCESS VIA LOOPBACK (127.*.*.*) INTERFACE OR VIA HTTP METHODS GET OR HEAD IS PUBLIC (loopback-is-public = true, get-is-public = true) ";
            }
            if (this.loopbackIsPublic()) {
                return " - ACCESS VIA LOOPBACK (127.*.*.*) INTERFACE IS PUBLIC (loopback-is-public = true)";
            }
            if (this.getIsPublic()) {
                return " - ACCESS VIA HTTP METHODS GET OR HEAD IS PUBLIC (get-is-public = true)";
            }
            WebServerBinding.Scheme scheme2 = scheme;
            WebServerBinding$Https$ webServerBinding$Https$ = WebServerBinding$Https$.MODULE$;
            if (!(scheme2 != null ? !scheme2.equals(webServerBinding$Https$) : webServerBinding$Https$ != null) && this.httpsClientAuthRequired()) {
                return " - HTTPS client authentication (mutual TLS) required";
            }
            return "";
        }

        public <U extends User> Configuration<U> copy(String realm, FiniteDuration invalidAuthenticationDelay, boolean isPublic, boolean loopbackIsPublic, boolean getIsPublic, boolean httpsClientAuthRequired, Function1<UserId, Option<U>> idToUser, Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> distinguishedNameToIdsOrUser) {
            return new Configuration<U>(realm, invalidAuthenticationDelay, isPublic, loopbackIsPublic, getIsPublic, httpsClientAuthRequired, idToUser, distinguishedNameToIdsOrUser);
        }

        public <U extends User> String copy$default$1() {
            return this.realm();
        }

        public <U extends User> FiniteDuration copy$default$2() {
            return this.invalidAuthenticationDelay();
        }

        public boolean copy$default$3() {
            return this.isPublic();
        }

        public boolean copy$default$4() {
            return this.loopbackIsPublic();
        }

        public boolean copy$default$5() {
            return this.getIsPublic();
        }

        public boolean copy$default$6() {
            return this.httpsClientAuthRequired();
        }

        public <U extends User> Function1<UserId, Option<U>> copy$default$7() {
            return this.idToUser();
        }

        public <U extends User> Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> copy$default$8() {
            return this.distinguishedNameToIdsOrUser();
        }

        public String _1() {
            return this.realm();
        }

        public FiniteDuration _2() {
            return this.invalidAuthenticationDelay();
        }

        public boolean _3() {
            return this.isPublic();
        }

        public boolean _4() {
            return this.loopbackIsPublic();
        }

        public boolean _5() {
            return this.getIsPublic();
        }

        public boolean _6() {
            return this.httpsClientAuthRequired();
        }

        public Function1<UserId, Option<U>> _7() {
            return this.idToUser();
        }

        public Function1<DistinguishedName, Either<Problem, Either<Set<UserId>, U>>> _8() {
            return this.distinguishedNameToIdsOrUser();
        }

        private final User $init$$$anonfun$3() {
            throw scala.sys.package$.MODULE$.error("Anonymous user has not been defined");
        }
    }
}

