/*
 * Decompiled with CFR 0.152.
 */
package js7.common.pekkoutils;

import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.log.Logger$package$Logger$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.thread.Futures$implicits$;
import js7.base.thread.Futures$implicits$SuccessFuture$;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$AsScalaDuration$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.common.configuration.Js7Configuration$;
import js7.common.pekkoutils.Pekkos$RichActorPath$;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.util.ByteString;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.Line$;

public final class Pekkos$
implements Serializable {
    private static final Logger logger;
    private static final String ValidSymbols;
    private static final String toHex;
    public static final Pekkos$RichActorPath$ RichActorPath;
    public static final Pekkos$ MODULE$;

    private Pekkos$() {
    }

    static {
        MODULE$ = new Pekkos$();
        logger = Logger$package$Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Pekkos$.class));
        ValidSymbols = "%-_.*$+:@&=,!~';";
        toHex = "0123456789ABCDEF";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Pekkos$.class);
    }

    public ActorSystem newActorSystem(String name, Config config, ExecutionContext executionContext) {
        return (ActorSystem)Logger$package$Logger$syntax$.MODULE$.debugCall(logger, "newActorSystem", (Function0<Object>)((Function0 & Serializable)() -> Pekkos$.newActorSystem$$anonfun$1(name)), () -> Pekkos$.newActorSystem$$anonfun$2(config, name, executionContext));
    }

    public Config newActorSystem$default$2() {
        return ConfigFactory.empty();
    }

    public void terminateAndWait(ActorSystem actorSystem) {
        this.terminateAndWait(actorSystem, JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(actorSystem.settings().config().getDuration("js7.pekko.shutdown-timeout"))));
    }

    public void terminateAndWait(ActorSystem actorSystem, FiniteDuration timeout) {
        Logger$package$Logger$syntax$.MODULE$.debugCall(logger, "ActorSystem:" + actorSystem.name() + " terminateAndWait", (Function0<Object>)((Function0 & Serializable)Pekkos$::terminateAndWait$$anonfun$1), () -> Pekkos$.terminateAndWait$$anonfun$2(actorSystem, timeout));
    }

    public IO<BoxedUnit> terminate(ActorSystem actorSystem) {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(logger, "ActorSystem:" + actorSystem.name() + " terminate", (Function0<Object>)((Function0 & Serializable)Pekkos$::terminate$$anonfun$1), CatsEffectExtensions$.MODULE$.fromFutureDummyCancelable(IO$.MODULE$, IO$.MODULE$.apply(() -> Pekkos$.terminate$$anonfun$2(actorSystem))).void());
    }

    private Future<Terminated> terminateFuture(ActorSystem actorSystem) {
        FiniteDuration finiteDuration;
        if (actorSystem.whenTerminated().isCompleted()) {
            return actorSystem.whenTerminated();
        }
        try {
            finiteDuration = JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(actorSystem.settings().config().getDuration("js7.pekko.http.connection-pool-shutdown-timeout")));
        }
        catch (ConfigException.Missing missing) {
            finiteDuration = ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(100));
        }
        FiniteDuration poolShutdownTimeout = finiteDuration;
        Promise timeoutPromise = Promise$.MODULE$.apply();
        Cancellable timer = actorSystem.scheduler().scheduleOnce(poolShutdownTimeout, (Function0 & Serializable)() -> {
            Pekkos$.$anonfun$1(timeoutPromise);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)actorSystem.dispatcher());
        return Future$.MODULE$.firstCompletedOf((IterableOnce)((SeqOps)new .colon.colon(this.shutDownHttpConnectionPools(actorSystem), (List)new .colon.colon((Object)timeoutPromise.future(), (List)Nil$.MODULE$))), (ExecutionContext)actorSystem.dispatcher()).flatMap((Function1 & Serializable)_$1 -> {
            Logger LoggerImpl_this;
            if (timeoutPromise.isCompleted() && (LoggerImpl_this = logger).underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("ActorSystem:{} shutdownAllConnectionPools() \u23f0 timed out after {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{actorSystem.name(), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(poolShutdownTimeout))}), Object.class));
            }
            timer.cancel();
            return actorSystem.terminate();
        }, (ExecutionContext)actorSystem.dispatcher());
    }

    public Future<BoxedUnit> shutDownHttpConnectionPools(ActorSystem actorSystem) {
        if (actorSystem.hasExtension((ExtensionId)Http$.MODULE$)) {
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("ActorSystem:{} shutdownAllConnectionPools()", (Object)actorSystem.name());
            }
            return Http$.MODULE$.apply(actorSystem).shutdownAllConnectionPools();
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    public String byteStringToTruncatedString(ByteString byteString, int size) {
        return byteString.size() + " bytes " + ((IterableOnceOps)byteString.take(size).map((Function1 & Serializable)c -> StringOps$.MODULE$.format$extension("%02x", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)c))})))).mkString(" ") + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(IterableOps.SizeCompareOps$.MODULE$.$greater$extension(byteString.sizeIs(), size)), (Function0<String>)((Function0 & Serializable)Pekkos$::byteStringToTruncatedString$$anonfun$2));
    }

    public int byteStringToTruncatedString$default$2() {
        return 100;
    }

    public String encodeAsActorName(String o) {
        String a = Uri.Path$.Segment$.MODULE$.apply(o, (Uri.Path$.SlashOrEmpty)Uri.Path$.Empty$.MODULE$).toString();
        return this.encodeAsActorName2((String)(a.startsWith("$") ? "%24" + StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(a)) : a));
    }

    private boolean isValidChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || ValidSymbols.indexOf(Char$.MODULE$.char2int(c)) != -1;
    }

    private String encodeAsActorName2(String string) {
        StringBuilder sb = new StringBuilder(string.length() + 30);
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(string), (Function1 & Serializable)c -> Pekkos$.encodeAsActorName2$$anonfun$1(sb, BoxesRunTime.unboxToChar((Object)c)));
        return sb.toString();
    }

    public String uniqueActorName(String name, ActorContext context) {
        String _name;
        block1: {
            _name = name;
            if (!context.child(name).isDefined()) break block1;
            _name = (String)package$.MODULE$.Iterator().from(2).map((Function1 & Serializable)i -> Pekkos$.uniqueActorName$$anonfun$1(name, BoxesRunTime.unboxToInt((Object)i))).find((Function1 & Serializable)nam -> context.child(nam).isEmpty()).get();
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Duplicate actor name. Replacement actor name is {}/{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Pekkos$RichActorPath$.MODULE$.pretty$extension(this.RichActorPath(context.self().path())), name}), Object.class));
            }
        }
        return _name;
    }

    public String decodeActorName(String o) {
        return Uri.Path$.MODULE$.apply(o, Uri.Path$.MODULE$.apply$default$2()).head().toString();
    }

    public final ActorPath RichActorPath(ActorPath underlying) {
        return underlying;
    }

    public Resource<IO, ActorSystem> actorSystemResource(String name, Config config) {
        return cats.effect.package$.MODULE$.Resource().eval((Object)IO$.MODULE$.executionContext()).flatMap((Function1 & Serializable)ec -> MODULE$.actorSystemResource1(name, config, (ExecutionContext)ec));
    }

    public Config actorSystemResource$default$2() {
        return ConfigFactory.empty();
    }

    private Resource<IO, ActorSystem> actorSystemResource1(String name, Config config, ExecutionContext ec) {
        return cats.effect.package$.MODULE$.Resource().make((Object)IO$.MODULE$.apply(() -> Pekkos$.actorSystemResource1$$anonfun$1(name, config, ec)), (Function1 & Serializable)actorSystem -> MODULE$.terminate((ActorSystem)actorSystem), (Functor)IO$.MODULE$.asyncForIO());
    }

    public <F> Resource<F, ActorRef> actorResource(Props props, String name, ActorRefFactory arf, Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.delay(() -> Pekkos$.actorResource$$anonfun$1(arf, props, name)), (Function1 & Serializable)a -> F.delay((Function0 & Serializable)() -> {
            Pekkos$.actorResource$$anonfun$2$$anonfun$1(arf, a);
            return BoxedUnit.UNIT;
        }), F);
    }

    private static final Object newActorSystem$$anonfun$1(String name$1) {
        return name$1;
    }

    private static final ExecutionContext newActorSystem$$anonfun$2$$anonfun$1(ExecutionContext executionContext$2) {
        return executionContext$2;
    }

    private static final ActorSystem newActorSystem$$anonfun$2(Config config$1, String name$2, ExecutionContext executionContext$1) {
        Config myConfig = ConfigFactory.systemProperties().withFallback((ConfigMergeable)config$1).withFallback((ConfigMergeable)Js7Configuration$.MODULE$.defaultConfig()).resolve();
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(myConfig.getBoolean("js7.pekko.use-js7-thread-pool"));
        return ActorSystem$.MODULE$.apply("pekko-" + name$2, (Option)Some$.MODULE$.apply((Object)myConfig), (Option)Some$.MODULE$.apply((Object)MODULE$.getClass().getClassLoader()), ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> Pekkos$.newActorSystem$$anonfun$2$$anonfun$1(executionContext$1)));
    }

    private static final Object terminateAndWait$$anonfun$1() {
        return Logger$package$Logger$syntax$.MODULE$.debugCall$default$3(logger);
    }

    private static final Object terminateAndWait$$anonfun$2(ActorSystem actorSystem$1, FiniteDuration timeout$1) {
        Object object;
        try {
            Future future = Futures$implicits$.MODULE$.SuccessFuture(MODULE$.terminateFuture(actorSystem$1));
            object = Futures$implicits$SuccessFuture$.MODULE$.await$extension(future, timeout$1, Tag$.MODULE$.apply(Terminated.class, LightTypeTag$.MODULE$.parse(-1807721664, "\u0004\u0000\u0001!org.apache.pekko.actor.Terminated\u0001\u0001", "\u0000\u0003\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001*org.apache.pekko.actor.AutoReceivedMessage\u0001\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001!org.apache.pekko.actor.Terminated\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001,org.apache.pekko.actor.DeadLetterSuppression\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u00018org.apache.pekko.actor.NoSerializationVerificationNeeded\u0001\u0001\u0004\u0000\u0001&org.apache.pekko.actor.PossiblyHarmful\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)), Enclosing$.MODULE$.apply("js7.common.pekkoutils.Pekkos.terminateAndWait"), FileName$.MODULE$.apply("Pekkos.scala"), Line$.MODULE$.apply(50));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Logger LoggerImpl_this = logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = actorSystem$1.name();
                    Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                    objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4);
                    LoggerImpl_this.underlying().warn("ActorSystem:{} .terminate(): {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                }
            } else {
                throw throwable;
            }
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private static final Object terminate$$anonfun$1() {
        return Logger$package$Logger$syntax$.MODULE$.debugIO$default$3(logger);
    }

    private static final Future terminate$$anonfun$2(ActorSystem actorSystem$2) {
        return MODULE$.terminateFuture(actorSystem$2);
    }

    private static final void $anonfun$1(Promise timeoutPromise$1) {
        timeoutPromise$1.success((Object)BoxedUnit.UNIT);
    }

    private static final String byteStringToTruncatedString$$anonfun$2() {
        return " ...";
    }

    private static final /* synthetic */ StringBuilder encodeAsActorName2$$anonfun$1(StringBuilder sb$1, char c) {
        if (MODULE$.isValidChar(c)) {
            return (StringBuilder)sb$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)c));
        }
        if (c >= '\u0080') {
            sb$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'%'));
            sb$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(toHex), c >> 12)));
            sb$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(toHex), c >> 8 & 0xF)));
        }
        sb$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'%'));
        sb$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(toHex), c >> 4 & 0xF)));
        return (StringBuilder)sb$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(toHex), c & 0xF)));
    }

    private static final /* synthetic */ String uniqueActorName$$anonfun$1(String name$3, int i) {
        return name$3 + "~" + i;
    }

    private static final ActorSystem actorSystemResource1$$anonfun$1(String name$5, Config config$3, ExecutionContext ec$1) {
        return MODULE$.newActorSystem(name$5, config$3, ec$1);
    }

    private static final ActorRef actorResource$$anonfun$1(ActorRefFactory arf$1, Props props$1, String name$6) {
        return arf$1.actorOf(props$1, name$6);
    }

    private static final void actorResource$$anonfun$2$$anonfun$1(ActorRefFactory arf$3, ActorRef a$1) {
        arf$3.stop(a$1);
    }
}

