/*
 * Decompiled with CFR 0.152.
 */
package js7.common.system.startup;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import js7.base.convert.As;
import js7.base.convert.As$;
import js7.base.io.file.FileUtils$;
import js7.base.system.startup.StartUp$;
import js7.base.utils.ProgramTermination;
import js7.base.utils.ProgramTermination$Failure$;
import js7.common.commandline.CommandLineArguments;
import js7.common.commandline.CommandLineArguments$;
import js7.common.configuration.BasicConfiguration$;
import js7.common.system.startup.JavaMain$;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JavaMainLockfileSupport$
implements Serializable {
    public static final JavaMainLockfileSupport$ MODULE$ = new JavaMainLockfileSupport$();

    private JavaMainLockfileSupport$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JavaMainLockfileSupport$.class);
    }

    public IO<ProgramTermination> runMain(Seq<String> args, boolean useLockFile, Function1<CommandLineArguments, IO<ProgramTermination>> body) {
        if (useLockFile) {
            return this.lockAndRunMain(args, body);
        }
        return JavaMain$.MODULE$.runMain(args, body);
    }

    public boolean runMain$default$2() {
        return false;
    }

    private IO<ProgramTermination> lockAndRunMain(Seq<String> args, Function1<CommandLineArguments, IO<ProgramTermination>> body) {
        return IO$.MODULE$.defer(() -> JavaMainLockfileSupport$.lockAndRunMain$$anonfun$1(args, body));
    }

    private void cleanWorkDirectory(Path workDirectory) {
        if (Files.exists(workDirectory, new LinkOption[0])) {
            FileUtils$.MODULE$.tryDeleteDirectoryContentRecursively(workDirectory);
            return;
        }
        Files.createDirectory(workDirectory, new FileAttribute[0]);
    }

    public <A> IO<A> lock(Path lockFile, A lockedValue, IO<A> body) {
        return (IO)package$.MODULE$.Resource().fromAutoCloseable((Object)IO$.MODULE$.apply(() -> JavaMainLockfileSupport$.lock$$anonfun$1(lockFile)), (Sync)IO$.MODULE$.asyncForIO()).use((Function1 & Serializable)lockFileChannel -> {
            Try try_ = Try$.MODULE$.apply(() -> JavaMainLockfileSupport$.lock$$anonfun$2$$anonfun$1(lockFileChannel));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable throwable = failure.exception();
                return IO$.MODULE$.blocking(() -> JavaMainLockfileSupport$.lock$$anonfun$2$$anonfun$2(throwable, lockedValue));
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                if (success.value() == null) {
                    return IO$.MODULE$.blocking(() -> JavaMainLockfileSupport$.lock$$anonfun$2$$anonfun$3(lockedValue));
                }
                return IO$.MODULE$.blocking(() -> JavaMainLockfileSupport$.lock$$anonfun$2$$anonfun$4(lockFileChannel)).$times$greater(body);
            }
            throw new MatchError((Object)try_);
        }, (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    private static final IO lockAndRunMain$$anonfun$1$$anonfun$1(Path data$1, Function1 body$2, CommandLineArguments arguments$1) {
        MODULE$.cleanWorkDirectory(data$1.resolve("work"));
        return (IO)body$2.apply((Object)arguments$1);
    }

    private static final IO lockAndRunMain$$anonfun$1(Seq args$1, Function1 body$1) {
        CommandLineArguments arguments = CommandLineArguments$.MODULE$.apply((Seq<String>)args$1);
        Path data = Paths.get((String)arguments.as("--data-directory=", (As)As$.MODULE$.StringAsString()), new String[0]);
        Path state = data.resolve("state");
        if (!Files.exists(state, new LinkOption[0])) {
            Files.createDirectory(state, new FileAttribute[0]);
        }
        Path lockFile = BasicConfiguration$.MODULE$.dataToLockFile(data);
        return MODULE$.lock(lockFile, ProgramTermination$Failure$.MODULE$, JavaMain$.MODULE$.runMain(() -> JavaMainLockfileSupport$.lockAndRunMain$$anonfun$1$$anonfun$1(data, body$1, arguments)));
    }

    private static final FileChannel lock$$anonfun$1(Path lockFile$1) {
        return FileChannel.open(lockFile$1, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    private static final FileLock lock$$anonfun$2$$anonfun$1(FileChannel lockFileChannel$1) {
        return lockFileChannel$1.tryLock();
    }

    private static final Object lock$$anonfun$2$$anonfun$2(Throwable throwable$1, Object lockedValue$1) {
        StartUp$.MODULE$.printlnWithClock("tryLock: " + throwable$1);
        return lockedValue$1;
    }

    private static final Object lock$$anonfun$2$$anonfun$3(Object lockedValue$3) {
        StartUp$.MODULE$.printlnWithClock("Duplicate start of JS7");
        return lockedValue$3;
    }

    private static final int lock$$anonfun$2$$anonfun$4(FileChannel lockFileChannel$2) {
        return lockFileChannel$2.write(ByteBuffer.wrap(BoxesRunTime.boxToLong((long)ProcessHandle.current().pid()).toString().getBytes(StandardCharsets.UTF_8)));
    }
}

