/*
 * Decompiled with CFR 0.152.
 */
package js7.controller.agent;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.package$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.agent.data.commands.AgentCommand;
import js7.agent.data.commands.AgentCommand$AttachItem$;
import js7.agent.data.commands.AgentCommand$AttachOrder$;
import js7.agent.data.commands.AgentCommand$AttachSignedItem$;
import js7.agent.data.commands.AgentCommand$Batch$;
import js7.agent.data.commands.AgentCommand$DetachItem$;
import js7.agent.data.commands.AgentCommand$DetachOrder$;
import js7.agent.data.commands.AgentCommand$MarkOrder$;
import js7.agent.data.commands.AgentCommand$ReleaseEvents$;
import js7.agent.data.commands.AgentCommand$ResetSubagent$;
import js7.agent.data.commands.AgentCommand$Response$Accepted$;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.CatsExtensions$;
import js7.base.crypt.Signed;
import js7.base.log.CorrelId$;
import js7.base.log.CorrelIdWrapped;
import js7.base.log.CorrelIdWrapped$;
import js7.base.log.Logger$package$Logger$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.problem.Problems$ShuttingDownProblem$;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.service.Problems$ServiceStoppedProblem$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Assertions$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.ScalaUtils;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.controller.agent.AgentDriver;
import js7.controller.agent.AgentDriver$Queueable$AttachOrder$;
import js7.controller.agent.AgentDriver$Queueable$AttachSignedItem$;
import js7.controller.agent.AgentDriver$Queueable$AttachUnsignedItem$;
import js7.controller.agent.AgentDriver$Queueable$DetachItem$;
import js7.controller.agent.AgentDriver$Queueable$DetachOrder$;
import js7.controller.agent.AgentDriver$Queueable$MarkOrder$;
import js7.controller.agent.AgentDriver$Queueable$ReleaseEventsQueueable$;
import js7.controller.agent.AgentDriver$Queueable$ResetSubagent$;
import js7.controller.agent.CommandQueue$QueueableResponse$;
import js7.controller.agent.CommandQueue$queue$;
import js7.controller.agent.DirectorDriver$DirectorDriverStoppedProblem$;
import js7.data.Problems$ClusterNodeHasBeenSwitchedOverProblem$;
import js7.data.agent.AgentPath;
import js7.data.agent.Problems$AgentIsShuttingDown$;
import js7.data.item.InventoryItemKey;
import js7.data.item.SignableItem;
import js7.data.item.UnsignedItem;
import js7.data.order.Order;
import js7.data.order.OrderId;
import js7.data.order.OrderMark;
import js7.data.subagent.Problems$NoDirectorProblem$;
import js7.data.subagent.SubagentId;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeqView;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.View;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.ChainingOps$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.hashing.MurmurHash3$;
import scala.util.package;
import sourcecode.Enclosing$;
import sourcecode.FullName$;
import sourcecode.Text;
import sourcecode.Text$;

public abstract class CommandQueue {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CommandQueue.class.getDeclaredField("queue$lzy1"));
    private final int batchSize;
    private final FiniteDuration commandErrorDelay;
    public final Logger js7$controller$agent$CommandQueue$$logger;
    private final FiniteDuration shortErrorDelay;
    private final AsyncLock lock;
    public final Set<OrderId> js7$controller$agent$CommandQueue$$attachedOrderIds;
    private final Set<AgentDriver.Queueable> isExecuting;
    private Deadline delayCommandExecutionAfterErrorUntil;
    private boolean isCoupled;
    private boolean freshlyCoupled;
    private int openRequestCount;
    private final boolean isTerminating;
    private final Deferred<IO, BoxedUnit> terminated;
    private volatile Object queue$lzy1;

    public CommandQueue(AgentPath agentPath, int batchSize, FiniteDuration commandErrorDelay) {
        this.batchSize = batchSize;
        this.commandErrorDelay = commandErrorDelay;
        this.js7$controller$agent$CommandQueue$$logger = Logger$package$Logger$.MODULE$.withPrefix(agentPath.string(), ClassTag$.MODULE$.apply(CommandQueue.class));
        this.shortErrorDelay = ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1)).min(commandErrorDelay);
        this.lock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#lock"));
        this.js7$controller$agent$CommandQueue$$attachedOrderIds = (Set)Set$.MODULE$.empty();
        this.isExecuting = (Set)Set$.MODULE$.empty();
        this.delayCommandExecutionAfterErrorUntil = Deadline$.MODULE$.now();
        this.isCoupled = false;
        this.freshlyCoupled = false;
        this.openRequestCount = 0;
        this.isTerminating = false;
        this.terminated = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
    }

    public abstract int commandParallelism();

    public abstract IO<Either<Problem, AgentCommand.Batch.Response>> executeCommand(AgentCommand.Batch var1);

    public abstract IO<BoxedUnit> asyncOnBatchSucceeded(Seq<QueueableResponse> var1);

    public abstract IO<BoxedUnit> asyncOnBatchFailed(Vector<AgentDriver.Queueable> var1, Problem var2);

    private final CommandQueue$queue$ queue() {
        Object object = this.queue$lzy1;
        if (object instanceof CommandQueue$queue$) {
            return (CommandQueue$queue$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CommandQueue$queue$)this.queue$lzyINIT1();
    }

    private Object queue$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.queue$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CommandQueue$queue$ commandQueue$queue$ = null;
                    try {
                        commandQueue$queue$ = new CommandQueue$queue$(this);
                        object2 = commandQueue$queue$ == null ? LazyVals.NullValue$.MODULE$ : commandQueue$queue$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.queue$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return commandQueue$queue$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final IO<BoxedUnit> onCoupled(scala.collection.immutable.Set<OrderId> attachedOrderIds) {
        return this.lock.lock(IO$.MODULE$.defer(() -> this.onCoupled$$anonfun$1(attachedOrderIds)), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#onCoupled"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 135));
    }

    public final IO<BoxedUnit> onDecoupled() {
        return this.lock.lock(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.onDecoupled$$anonfun$1();
            return BoxedUnit.UNIT;
        }), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#onDecoupled"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 140));
    }

    public final IO<Object> enqueue(AgentDriver.Queueable queueable) {
        return this.lock.lock(IO$.MODULE$.defer(() -> this.enqueue$$anonfun$1(queueable)), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#enqueue"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 160));
    }

    public final IO<BoxedUnit> untilTerminated() {
        return (IO)this.terminated.get();
    }

    public final IO<BoxedUnit> maybeStartSending() {
        return this.lock.lock(this.maybeStartSendingLocked(), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#maybeStartSending"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 166));
    }

    private IO<BoxedUnit> maybeStartSendingLocked() {
        return (IO)CatsExtensions$.MODULE$.ifTrue(IO$.MODULE$.apply(this::maybeStartSendingLocked$$anonfun$1), (Function0<Object>)((Function0 & Serializable)this::maybeStartSendingLocked$$anonfun$2), IO$.MODULE$.asyncForIO());
    }

    private IO<BoxedUnit> delayNextCommand() {
        return IO$.MODULE$.defer(this::delayNextCommand$$anonfun$1);
    }

    private IO<BoxedUnit> sendNow(Vector<AgentDriver.Queueable> queuable) {
        return IO$.MODULE$.defer(() -> this.sendNow$$anonfun$1(queuable));
    }

    private AgentCommand queuableToAgentCommand(AgentDriver.Queueable queuable) {
        AgentCommand agentCommand;
        AgentDriver.Queueable queueable = queuable;
        if (queueable instanceof AgentDriver.Queueable.AttachOrder) {
            AgentDriver.Queueable.AttachOrder attachOrder = (AgentDriver.Queueable.AttachOrder)queueable;
            AgentDriver.Queueable.AttachOrder attachOrder2 = AgentDriver$Queueable$AttachOrder$.MODULE$.unapply(attachOrder);
            Order<Order.IsFreshOrReady> order = attachOrder2._1();
            AgentPath agentPath = attachOrder2._2();
            Order<Order.IsFreshOrReady> order2 = order;
            AgentPath agentPath2 = agentPath;
            agentCommand = AgentCommand$AttachOrder$.MODULE$.apply(order2, agentPath2);
        } else if (queueable instanceof AgentDriver.Queueable.DetachOrder) {
            OrderId orderId;
            AgentDriver.Queueable.DetachOrder detachOrder = (AgentDriver.Queueable.DetachOrder)queueable;
            AgentDriver.Queueable.DetachOrder detachOrder2 = AgentDriver$Queueable$DetachOrder$.MODULE$.unapply(detachOrder);
            OrderId orderId2 = orderId = detachOrder2._1();
            agentCommand = AgentCommand$DetachOrder$.MODULE$.apply(orderId2);
        } else if (queueable instanceof AgentDriver.Queueable.MarkOrder) {
            AgentDriver.Queueable.MarkOrder markOrder = (AgentDriver.Queueable.MarkOrder)queueable;
            AgentDriver.Queueable.MarkOrder markOrder2 = AgentDriver$Queueable$MarkOrder$.MODULE$.unapply(markOrder);
            OrderId orderId = markOrder2._1();
            OrderMark orderMark = markOrder2._2();
            OrderId orderId3 = orderId;
            OrderMark mark = orderMark;
            agentCommand = AgentCommand$MarkOrder$.MODULE$.apply(orderId3, mark);
        } else if (queueable instanceof AgentDriver.Queueable.AttachUnsignedItem) {
            UnsignedItem unsignedItem;
            AgentDriver.Queueable.AttachUnsignedItem attachUnsignedItem = (AgentDriver.Queueable.AttachUnsignedItem)queueable;
            AgentDriver.Queueable.AttachUnsignedItem attachUnsignedItem2 = AgentDriver$Queueable$AttachUnsignedItem$.MODULE$.unapply(attachUnsignedItem);
            UnsignedItem item = unsignedItem = attachUnsignedItem2._1();
            agentCommand = AgentCommand$AttachItem$.MODULE$.apply(item);
        } else if (queueable instanceof AgentDriver.Queueable.AttachSignedItem) {
            Signed<SignableItem> signed;
            AgentDriver.Queueable.AttachSignedItem attachSignedItem = (AgentDriver.Queueable.AttachSignedItem)queueable;
            AgentDriver.Queueable.AttachSignedItem attachSignedItem2 = AgentDriver$Queueable$AttachSignedItem$.MODULE$.unapply(attachSignedItem);
            Signed<SignableItem> signed2 = signed = attachSignedItem2._1();
            agentCommand = AgentCommand$AttachSignedItem$.MODULE$.apply(signed2);
        } else if (queueable instanceof AgentDriver.Queueable.DetachItem) {
            InventoryItemKey inventoryItemKey;
            AgentDriver.Queueable.DetachItem detachItem = (AgentDriver.Queueable.DetachItem)queueable;
            AgentDriver.Queueable.DetachItem detachItem2 = AgentDriver$Queueable$DetachItem$.MODULE$.unapply(detachItem);
            InventoryItemKey id = inventoryItemKey = detachItem2._1();
            agentCommand = AgentCommand$DetachItem$.MODULE$.apply(id);
        } else if (queueable instanceof AgentDriver.Queueable.ReleaseEventsQueueable) {
            long l;
            AgentDriver.Queueable.ReleaseEventsQueueable releaseEventsQueueable = (AgentDriver.Queueable.ReleaseEventsQueueable)queueable;
            AgentDriver.Queueable.ReleaseEventsQueueable releaseEventsQueueable2 = AgentDriver$Queueable$ReleaseEventsQueueable$.MODULE$.unapply(releaseEventsQueueable);
            long untilEventId = l = releaseEventsQueueable2._1();
            agentCommand = AgentCommand$ReleaseEvents$.MODULE$.apply(untilEventId);
        } else if (queueable instanceof AgentDriver.Queueable.ResetSubagent) {
            AgentDriver.Queueable.ResetSubagent resetSubagent = (AgentDriver.Queueable.ResetSubagent)queueable;
            AgentDriver.Queueable.ResetSubagent resetSubagent2 = AgentDriver$Queueable$ResetSubagent$.MODULE$.unapply(resetSubagent);
            SubagentId subagentId = resetSubagent2._1();
            boolean bl = resetSubagent2._2();
            SubagentId subagentId2 = subagentId;
            boolean force = bl;
            agentCommand = AgentCommand$ResetSubagent$.MODULE$.apply(subagentId2, force);
        } else {
            throw new MatchError((Object)queueable);
        }
        return agentCommand;
    }

    public final IO<BoxedUnit> onOrdersDetached(View<OrderId> orderIds) {
        return IO$.MODULE$.whenA(orderIds.nonEmpty(), () -> this.onOrdersDetached$$anonfun$1(orderIds));
    }

    public final IO<BoxedUnit> onOrdersAttached(Seq<OrderId> orderIds) {
        return IO$.MODULE$.whenA(orderIds.nonEmpty(), () -> this.onOrdersAttached$$anonfun$1(orderIds));
    }

    public final IO<Seq<AgentDriver.Queueable>> handleBatchSucceeded(Seq<QueueableResponse> responses) {
        return this.lock.lock(IO$.MODULE$.defer(() -> this.handleBatchSucceeded$$anonfun$1(responses)), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#handleBatchSucceeded"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 305));
    }

    public final IO<BoxedUnit> handleBatchFailed(Seq<AgentDriver.Queueable> queuables, boolean delay) {
        return this.lock.lock(IO$.MODULE$.defer(() -> this.handleBatchFailed$$anonfun$1(delay, queuables)), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#handleBatchFailed"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 315));
    }

    private IO<BoxedUnit> onQueueableResponded(scala.collection.immutable.Set<AgentDriver.Queueable> queueables) {
        return IO$.MODULE$.defer(() -> this.onQueueableResponded$$anonfun$1(queueables));
    }

    private static final boolean isCorrespondingCommand$1(AgentDriver.Queueable.DetachOrder detachOrder$1, AgentDriver.Queueable queueable) {
        AgentDriver.Queueable queueable2 = queueable;
        if (queueable2 instanceof AgentDriver.Queueable.AttachOrder) {
            AgentDriver.Queueable.AttachOrder attachOrder = (AgentDriver.Queueable.AttachOrder)queueable2;
            AgentDriver.Queueable.AttachOrder attachOrder2 = AgentDriver$Queueable$AttachOrder$.MODULE$.unapply(attachOrder);
            Order<Order.IsFreshOrReady> order = attachOrder2._1();
            AgentPath agentPath = attachOrder2._2();
            Order<Order.IsFreshOrReady> order2 = order;
            OrderId orderId = order2.id();
            OrderId orderId2 = detachOrder$1.orderId();
            return !(orderId != null ? !((Object)orderId).equals(orderId2) : orderId2 != null);
        }
        if (queueable2 instanceof AgentDriver.Queueable.MarkOrder) {
            OrderId orderId;
            AgentDriver.Queueable.MarkOrder markOrder = (AgentDriver.Queueable.MarkOrder)queueable2;
            AgentDriver.Queueable.MarkOrder markOrder2 = AgentDriver$Queueable$MarkOrder$.MODULE$.unapply(markOrder);
            OrderId orderId3 = markOrder2._1();
            OrderMark orderMark = markOrder2._2();
            OrderId orderId4 = orderId = orderId3;
            OrderId orderId5 = detachOrder$1.orderId();
            return !(orderId4 != null ? !((Object)orderId4).equals(orderId5) : orderId5 != null);
        }
        return false;
    }

    public static final /* synthetic */ boolean js7$controller$agent$CommandQueue$queue$$$_$_$$anonfun$1(AgentDriver.Queueable.DetachOrder detachOrder$2, AgentDriver.Queueable queueable) {
        return CommandQueue.isCorrespondingCommand$1(detachOrder$2, queueable);
    }

    public static final /* synthetic */ String js7$controller$agent$CommandQueue$queue$$$_$removeStillQueuedCommandsWhenDetachingTheOrder$$anonfun$1(AgentDriver.Queueable o) {
        ScalaUtils.syntax.RichJavaClass<?> RichJavaClass_this = ScalaUtils$syntax$.MODULE$.RichJavaClass(o.getClass());
        return String.valueOf(RichJavaClass_this.cachedSimpleScalaName());
    }

    public static final /* synthetic */ boolean js7$controller$agent$CommandQueue$queue$$$_$_$$anonfun$2(scala.collection.immutable.Set orderIds$1, AgentDriver.Queueable x$1) {
        AgentDriver.Queueable queueable = x$1;
        if (queueable instanceof AgentDriver.Queueable.AttachOrder) {
            AgentDriver.Queueable.AttachOrder attachOrder = (AgentDriver.Queueable.AttachOrder)queueable;
            AgentDriver.Queueable.AttachOrder attachOrder2 = AgentDriver$Queueable$AttachOrder$.MODULE$.unapply(attachOrder);
            Order<Order.IsFreshOrReady> order = attachOrder2._1();
            AgentPath agentPath = attachOrder2._2();
            Order<Order.IsFreshOrReady> order2 = order;
            return orderIds$1.contains((Object)order2.id());
        }
        return false;
    }

    public static final boolean js7$controller$agent$CommandQueue$queue$$$_$isAlreadyAttached$default$1$1() {
        return false;
    }

    public static final /* synthetic */ String js7$controller$agent$CommandQueue$queue$$$_$toString$$anonfun$1(AgentDriver.Queueable _$1) {
        return _$1.toShortString();
    }

    private final IO onCoupled$$anonfun$1(scala.collection.immutable.Set attachedOrderIds$1) {
        this.js7$controller$agent$CommandQueue$$attachedOrderIds.clear();
        this.js7$controller$agent$CommandQueue$$attachedOrderIds.$plus$plus$eq((IterableOnce)attachedOrderIds$1);
        this.queue().removeAlreadyAttachedOrders();
        this.isCoupled = true;
        this.freshlyCoupled = true;
        return this.maybeStartSendingLocked();
    }

    private final void onDecoupled$$anonfun$1() {
        this.isCoupled = false;
    }

    private final boolean v$proxy1$1() {
        return !this.isTerminating;
    }

    private final IO enqueue$$anonfun$1$$anonfun$1() {
        return this.maybeStartSendingLocked();
    }

    private final IO enqueue$$anonfun$1(AgentDriver.Queueable queueable$2) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1()), "!isTerminating"), FullName$.MODULE$.apply("js7.controller.agent.CommandQueue.enqueue"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 145));
        AgentDriver.Queueable queueable = queueable$2;
        if (queueable instanceof AgentDriver.Queueable.AttachOrder) {
            AgentDriver.Queueable.AttachOrder attachOrder = (AgentDriver.Queueable.AttachOrder)queueable;
            AgentDriver.Queueable.AttachOrder attachOrder2 = AgentDriver$Queueable$AttachOrder$.MODULE$.unapply(attachOrder);
            Order<Order.IsFreshOrReady> order = attachOrder2._1();
            AgentPath agentPath = attachOrder2._2();
            Order<Order.IsFreshOrReady> order2 = order;
            if (this.js7$controller$agent$CommandQueue$$attachedOrderIds.contains((Object)order2.id())) {
                Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("\ud83e\udeb1 AttachOrder({} ignored because Order is already attached to Agent", (Object)order2.id());
                }
                return IO$.MODULE$.pure((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        if (this.queue().contains(queueable$2)) {
            Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("\ud83e\udeb1 Ignore duplicate {}", (Object)queueable$2);
            }
            return IO$.MODULE$.pure((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("enqueue {}", (Object)queueable$2);
        }
        this.queue().enqueue(queueable$2);
        return IO$.MODULE$.whenA(this.queue().size() == this.batchSize || this.freshlyCoupled, this::enqueue$$anonfun$1$$anonfun$1).as((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    private final boolean maybeStartSendingLocked$$anonfun$1() {
        return this.isCoupled && !this.isTerminating;
    }

    private final Vector queueables$lzyINIT1$1(LazyRef queueables$lzy1$1) {
        Vector vector;
        LazyRef lazyRef = queueables$lzy1$1;
        synchronized (lazyRef) {
            vector = (Vector)(queueables$lzy1$1.initialized() ? queueables$lzy1$1.value() : queueables$lzy1$1.initialize((Object)((IterableOnceOps)((IterableOps)this.queue().view().filterNot(this.isExecuting)).take(this.freshlyCoupled ? 1 : this.batchSize)).toVector()));
        }
        return vector;
    }

    private final Vector queueables$2(LazyRef queueables$lzy1$2) {
        return (Vector)(queueables$lzy1$2.initialized() ? queueables$lzy1$2.value() : this.queueables$lzyINIT1$1(queueables$lzy1$2));
    }

    private final IO maybeStartSendingLocked$$anonfun$2$$anonfun$1(LazyRef queueables$lzy1$3) {
        this.isExecuting.$plus$plus$eq((IterableOnce)this.queueables$2(queueables$lzy1$3));
        ++this.openRequestCount;
        return CatsEffectExtensions$.MODULE$.startAndForget(this.delayNextCommand().$times$greater(this.sendNow((Vector<AgentDriver.Queueable>)this.queueables$2(queueables$lzy1$3))).handleError((Function1)(JProcedure1 & Serializable)t -> {
            Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                LoggerImpl_this.underlying().error(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), t);
                return;
            }
        }), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#maybeStartSendingLocked")).void();
    }

    private final IO maybeStartSendingLocked$$anonfun$2() {
        LazyRef lazyRef = new LazyRef();
        boolean canSend = this.openRequestCount < this.commandParallelism() && (!this.freshlyCoupled || this.openRequestCount == 0) && this.queueables$2(lazyRef).nonEmpty();
        return IO$.MODULE$.whenA(canSend, () -> this.maybeStartSendingLocked$$anonfun$2$$anonfun$1(lazyRef));
    }

    private final IO delayNextCommand$$anonfun$1$$anonfun$1(FiniteDuration delay$1) {
        block0: {
            Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("Delay command after error for {}", (Object)ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(delay$1)));
        }
        return IO$.MODULE$.sleep(delay$1);
    }

    private final IO delayNextCommand$$anonfun$1() {
        FiniteDuration delay = this.delayCommandExecutionAfterErrorUntil.timeLeft();
        return IO$.MODULE$.whenA(ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(delay)), () -> this.delayNextCommand$$anonfun$1$$anonfun$1(delay));
    }

    private final IO sendNow$$anonfun$1(Vector queuable$1) {
        Vector subcmds = (Vector)queuable$1.map((Function1 & Serializable)o -> CorrelIdWrapped$.MODULE$.apply(CorrelId$.MODULE$.current(), this.queuableToAgentCommand((AgentDriver.Queueable)o)));
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.executeCommand(AgentCommand$Batch$.MODULE$.apply((Seq<CorrelIdWrapped<AgentCommand>>)subcmds)));
        return ((IO)CatsExtensions$.MODULE$.tryIt(ScalaUtils$syntax$RichEitherF$.MODULE$.mapmap$extension(iO, (Function1 & Serializable)response -> (Vector)((StrictOptimizedIterableOps)queuable$1.zip(response.responses())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            AgentDriver.Queueable i = (AgentDriver.Queueable)tuple2._1();
            Either r = (Either)tuple2._2();
            return CommandQueue$QueueableResponse$.MODULE$.apply(i, (Either<Problem, AgentCommand.Response>)r);
        }), IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Either either = (Either)success.value();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Vector queueableResponses = (Vector)right.value();
                    Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        IndexedSeqView indexedSeqView = queuable$1.view().map((Function1 & Serializable)_$2 -> _$2.toShortString());
                        LoggerImpl_this.underlying().debug("\u2714\ufe0e sendNow queueables={}", (Object)ScalaUtils$syntax$.MODULE$.mkStringLimited(indexedSeqView, 3, ScalaUtils$syntax$.MODULE$.mkStringLimited$default$3(indexedSeqView)));
                    }
                    return this.asyncOnBatchSucceeded((Seq<QueueableResponse>)queueableResponses);
                }
                if (either instanceof Left) {
                    Logger LoggerImpl_this;
                    Left left = (Left)either;
                    Problem problem = (Problem)left.value();
                    Logger LoggerImpl_this2 = this.js7$controller$agent$CommandQueue$$logger;
                    if (LoggerImpl_this2.underlying().isDebugEnabled()) {
                        LoggerImpl_this2.underlying().debug("\ud83d\udca5 sendNow: " + problem, problem.throwableOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    if ((LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger).underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("\ud83d\udca5 sendNow: queueables={}", queuable$1.map((Function1 & Serializable)_$3 -> _$3.toShortString()));
                    }
                    return this.asyncOnBatchFailed((Vector<AgentDriver.Queueable>)queuable$1, problem);
                }
            }
            if (try_ instanceof Failure) {
                Logger LoggerImpl_this;
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                Logger LoggerImpl_this3 = this.js7$controller$agent$CommandQueue$$logger;
                if (LoggerImpl_this3.underlying().isDebugEnabled()) {
                    LoggerImpl_this3.underlying().debug("\ud83d\udca5 sendNow: " + t, t);
                }
                if ((LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger).underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("\ud83d\udca5 sendNow: queueables={}", queuable$1.map((Function1 & Serializable)_$4 -> _$4.toShortString()));
                }
                return this.asyncOnBatchFailed((Vector<AgentDriver.Queueable>)queuable$1, Problem$.MODULE$.fromThrowable(t));
            }
            throw new MatchError((Object)try_);
        });
    }

    private final void onOrdersDetached$$anonfun$1$$anonfun$1(View orderIds$3) {
        this.js7$controller$agent$CommandQueue$$attachedOrderIds.$minus$minus$eq((IterableOnce)orderIds$3);
    }

    private final IO onOrdersDetached$$anonfun$1(View orderIds$2) {
        return this.lock.lock(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.onOrdersDetached$$anonfun$1$$anonfun$1(orderIds$2);
            return BoxedUnit.UNIT;
        }), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#onOrdersDetached"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 244));
    }

    private final void onOrdersAttached$$anonfun$1$$anonfun$1(Seq orderIds$5) {
        this.js7$controller$agent$CommandQueue$$attachedOrderIds.$plus$plus$eq((IterableOnce)orderIds$5);
        this.queue().removeAttachedOrderCommands((scala.collection.immutable.Set<OrderId>)orderIds$5.toSet());
    }

    private final IO onOrdersAttached$$anonfun$1(Seq orderIds$4) {
        return this.lock.lock(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.onOrdersAttached$$anonfun$1$$anonfun$1(orderIds$4);
            return BoxedUnit.UNIT;
        }), Enclosing$.MODULE$.apply("js7.controller.agent.CommandQueue#onOrdersAttached"), ScalaSourceLocation$.MODULE$.apply("CommandQueue.scala", 251));
    }

    private static final boolean isRepeatableProblem$1(Problem problem) {
        return problem.httpStatusCode() == 503 || problem.is(DirectorDriver$DirectorDriverStoppedProblem$.MODULE$) || problem.is(Problems$ClusterNodeHasBeenSwitchedOverProblem$.MODULE$) || problem.is(Problems$NoDirectorProblem$.MODULE$) || problem.is(Problems$AgentIsShuttingDown$.MODULE$) || problem.is(Problems$ShuttingDownProblem$.MODULE$) || problem.is(Problems$ServiceStoppedProblem$.MODULE$);
    }

    private final Seq handleBatchSucceeded$$anonfun$1$$anonfun$2(Seq responses$2, scala.collection.immutable.Set repeatables$1) {
        return (Seq)responses$2.flatMap((Function1 & Serializable)x$1 -> {
            QueueableResponse queueableResponse = x$1;
            QueueableResponse queueableResponse2 = CommandQueue$QueueableResponse$.MODULE$.unapply(queueableResponse);
            AgentDriver.Queueable queueable = queueableResponse2._1();
            Either<Problem, AgentCommand.Response> either = queueableResponse2._2();
            AgentDriver.Queueable queueable2 = queueable;
            if (either instanceof Right) {
                Right right = (Right)either;
                AgentCommand.Response response = (AgentCommand.Response)right.value();
                if (AgentCommand$Response$Accepted$.MODULE$.equals(response)) {
                    return Some$.MODULE$.apply((Object)queueable2);
                }
                AgentCommand.Response o = response;
                throw scala.sys.package$.MODULE$.error("Unexpected response from Agent: " + o);
            }
            AgentDriver.Queueable queueable3 = queueable;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                if (repeatables$1.apply((Object)queueable3)) {
                    Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("\u27f2 Agent rejected {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{queueable3.toShortString(), problem}), Object.class));
                    }
                } else {
                    Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                        LoggerImpl_this.underlying().error("Agent rejected {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{queueable3.toShortString(), problem}), Object.class));
                    }
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)queueableResponse);
        });
    }

    private final IO handleBatchSucceeded$$anonfun$1(Seq responses$1) {
        Tuple2 tuple2;
        Tuple2 $1$;
        this.freshlyCoupled = false;
        Tuple2 tuple22 = (Tuple2)package.chaining$.MODULE$.scalaUtilChainingOps((Object)responses$1.partition((Function1 & Serializable)r -> r.response().left().exists((Function1 & Serializable)problem -> CommandQueue.isRepeatableProblem$1(problem))));
        Tuple2 tuple23 = $1$ = (tuple2 = (Tuple2)ChainingOps$.MODULE$.pipe$extension((Object)tuple22, (Function1 & Serializable)x$1 -> {
            Seq seq = (Seq)x$1._1();
            Seq seq2 = (Seq)x$1._2();
            return Tuple2$.MODULE$.apply((Object)((IterableOnceOps)seq.map((Function1 & Serializable)_$5 -> _$5.queueable())).toSet(), (Object)((IterableOnceOps)seq2.map((Function1 & Serializable)_$6 -> _$6.queueable())).toSet());
        }));
        scala.collection.immutable.Set repeatables = (scala.collection.immutable.Set)tuple23._1();
        scala.collection.immutable.Set toBeDequeued = (scala.collection.immutable.Set)tuple23._2();
        this.queue().dequeueAll((scala.collection.immutable.Set<AgentDriver.Queueable>)toBeDequeued);
        if (repeatables.nonEmpty()) {
            this.delayCommandExecutionAfterErrorUntil = Deadline$.MODULE$.now().$plus(this.commandErrorDelay);
        }
        return this.onQueueableResponded((scala.collection.immutable.Set<AgentDriver.Queueable>)responses$1.view().map((Function1 & Serializable)_$7 -> _$7.queueable()).toSet()).$times$greater(IO$.MODULE$.apply(() -> this.handleBatchSucceeded$$anonfun$1$$anonfun$2(responses$1, repeatables)));
    }

    private final IO handleBatchFailed$$anonfun$1(boolean delay$2, Seq queuables$1) {
        block0: {
            this.delayCommandExecutionAfterErrorUntil = Deadline$.MODULE$.now().$plus(delay$2 ? this.commandErrorDelay : this.shortErrorDelay);
            Logger LoggerImpl_this = this.js7$controller$agent$CommandQueue$$logger;
            if (!LoggerImpl_this.underlying().isTraceEnabled()) break block0;
            LoggerImpl_this.underlying().trace("delayCommandExecutionAfterErrorUntil={}", (Object)ScalaTime$RichDeadline$.MODULE$.toTimestamp$extension(ScalaTime$.MODULE$.RichDeadline(this.delayCommandExecutionAfterErrorUntil)));
        }
        return this.onQueueableResponded((scala.collection.immutable.Set<AgentDriver.Queueable>)queuables$1.toSet());
    }

    private final IO onQueueableResponded$$anonfun$1(scala.collection.immutable.Set queueables$1) {
        this.isExecuting.$minus$minus$eq((IterableOnce)queueables$1);
        --this.openRequestCount;
        if (this.isTerminating && this.isExecuting.isEmpty()) {
            return ((IO)this.terminated.complete((Object)BoxedUnit.UNIT)).void();
        }
        return this.maybeStartSendingLocked();
    }

    public static final class QueueableResponse
    implements Product,
    Serializable {
        private final AgentDriver.Queueable queueable;
        private final Either<Problem, AgentCommand.Response> response;

        public static QueueableResponse apply(AgentDriver.Queueable queueable, Either<Problem, AgentCommand.Response> either) {
            return CommandQueue$QueueableResponse$.MODULE$.apply(queueable, either);
        }

        public static QueueableResponse fromProduct(Product product) {
            return CommandQueue$QueueableResponse$.MODULE$.fromProduct(product);
        }

        public static QueueableResponse unapply(QueueableResponse queueableResponse) {
            return CommandQueue$QueueableResponse$.MODULE$.unapply(queueableResponse);
        }

        public QueueableResponse(AgentDriver.Queueable queueable, Either<Problem, AgentCommand.Response> response) {
            this.queueable = queueable;
            this.response = response;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -1677112222, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            QueueableResponse queueableResponse;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QueueableResponse)) return false;
            QueueableResponse queueableResponse2 = queueableResponse = (QueueableResponse)object;
            AgentDriver.Queueable queueable = this.queueable();
            AgentDriver.Queueable queueable2 = queueableResponse2.queueable();
            if (queueable == null) {
                if (queueable2 != null) {
                    return false;
                }
            } else if (!queueable.equals(queueable2)) return false;
            Either<Problem, AgentCommand.Response> either = this.response();
            Either<Problem, AgentCommand.Response> either2 = queueableResponse2.response();
            if (either == null) {
                if (either2 == null) return true;
                return false;
            } else {
                if (!either.equals(either2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QueueableResponse;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "QueueableResponse";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "queueable";
            }
            if (1 == n2) {
                return "response";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AgentDriver.Queueable queueable() {
            return this.queueable;
        }

        public Either<Problem, AgentCommand.Response> response() {
            return this.response;
        }

        public QueueableResponse copy(AgentDriver.Queueable queueable, Either<Problem, AgentCommand.Response> response) {
            return new QueueableResponse(queueable, response);
        }

        public AgentDriver.Queueable copy$default$1() {
            return this.queueable();
        }

        public Either<Problem, AgentCommand.Response> copy$default$2() {
            return this.response();
        }

        public AgentDriver.Queueable _1() {
            return this.queueable();
        }

        public Either<Problem, AgentCommand.Response> _2() {
            return this.response();
        }
    }
}

