/*
 * Decompiled with CFR 0.152.
 */
package js7.data.board;

import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import fs2.Stream$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.Timestamp;
import js7.base.utils.L3;
import js7.base.utils.L3$;
import js7.base.utils.MultipleLinesBracket$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichOption$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.base.utils.Tests$;
import js7.data.board.BoardPath;
import js7.data.board.Notice;
import js7.data.board.NoticeEvent;
import js7.data.board.NoticeEvent$NoticeDeleted$;
import js7.data.board.NoticeKey;
import js7.data.board.NoticeKey$;
import js7.data.board.NoticePlace;
import js7.data.board.NoticePlace$;
import js7.data.board.NoticeSnapshot;
import js7.data.board.NoticeV2_3;
import js7.data.board.PlannedBoard$;
import js7.data.board.PlannedBoardId;
import js7.data.event.KeyedEvent;
import js7.data.order.OrderId;
import js7.data.plan.PlanId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.View;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.hashing.MurmurHash3$;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Name;
import sourcecode.Name$;

public final class PlannedBoard
implements Product,
Serializable {
    private final PlannedBoardId id;
    private final Map<NoticeKey, NoticePlace> toNoticePlace;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(PlannedBoard$.class.getDeclaredField("given_Ordering_PlannedBoard$lzy1"));

    public static PlannedBoard apply(PlannedBoardId plannedBoardId, Map<NoticeKey, NoticePlace> map) {
        return PlannedBoard$.MODULE$.apply(plannedBoardId, map);
    }

    public static PlannedBoard fromProduct(Product product) {
        return PlannedBoard$.MODULE$.fromProduct(product);
    }

    public static Ordering<PlannedBoard> given_Ordering_PlannedBoard() {
        return PlannedBoard$.MODULE$.given_Ordering_PlannedBoard();
    }

    public static PlannedBoard unapply(PlannedBoard plannedBoard) {
        return PlannedBoard$.MODULE$.unapply(plannedBoard);
    }

    public static Map<NoticeKey, NoticePlace> apply$default$2() {
        return PlannedBoard$.MODULE$.apply$default$2();
    }

    public PlannedBoard(PlannedBoardId id, Map<NoticeKey, NoticePlace> toNoticePlace) {
        this.id = id;
        this.toNoticePlace = toNoticePlace;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1566196657, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        PlannedBoard plannedBoard;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PlannedBoard)) return false;
        PlannedBoard plannedBoard2 = plannedBoard = (PlannedBoard)object;
        PlannedBoardId plannedBoardId = this.id();
        PlannedBoardId plannedBoardId2 = plannedBoard2.id();
        if (plannedBoardId == null) {
            if (plannedBoardId2 != null) {
                return false;
            }
        } else if (!((Object)plannedBoardId).equals(plannedBoardId2)) return false;
        Map<NoticeKey, NoticePlace> map = this.toNoticePlace();
        Map<NoticeKey, NoticePlace> map2 = plannedBoard2.toNoticePlace();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof PlannedBoard;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "PlannedBoard";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "id";
        }
        if (1 == n2) {
            return "toNoticePlace";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public PlannedBoardId id() {
        return this.id;
    }

    public Map<NoticeKey, NoticePlace> toNoticePlace() {
        return this.toNoticePlace;
    }

    public int estimatedSnapshotSize() {
        return this.noticeCount() + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.toNoticePlace().values().view().map((Function1 & Serializable)_$1 -> _$1.estimatedSnapshotSize())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Stream<Nothing$, NoticeSnapshot> toSnapshotStream() {
        return Stream$.MODULE$.iterable(this.toNoticePlace()).flatMap((Function1 & Serializable)x$1 -> {
            NoticeKey noticeKey = (NoticeKey)x$1._1();
            NoticePlace noticePlace = (NoticePlace)x$1._2();
            return noticePlace.toSnapshotStream(this.id().$div(noticeKey));
        }, NotGiven$.MODULE$.value());
    }

    public Stream<Nothing$, String> toStringStream() {
        return Stream$.MODULE$.emit((Object)String.valueOf(this.id())).$plus$plus(this::toStringStream$$anonfun$1);
    }

    public Either<Problem, PlannedBoard> recoverNoticeSnapshot(Serializable snapshot) {
        NoticeKey noticeKey;
        Serializable serializable = snapshot;
        if (serializable instanceof Notice) {
            Notice notice;
            Notice o = notice = (Notice)serializable;
            noticeKey = o.noticeKey();
        } else if (serializable instanceof NoticePlace.Snapshot) {
            NoticePlace.Snapshot snapshot2;
            NoticePlace.Snapshot o = snapshot2 = (NoticePlace.Snapshot)serializable;
            noticeKey = o.noticeId().noticeKey();
        } else {
            throw new MatchError((Object)serializable);
        }
        NoticeKey noticeKey2 = noticeKey;
        Map map = (Map)this.toNoticePlace().updated((Object)noticeKey2, (Object)this.noticePlace(noticeKey2).recoverSnapshot(snapshot));
        PlannedBoardId plannedBoardId = this.copy$default$1();
        return package$.MODULE$.Right().apply((Object)this.copy(plannedBoardId, (Map<NoticeKey, NoticePlace>)map));
    }

    public boolean isAnnounced(NoticeKey noticeKey) {
        return this.toNoticePlace().get((Object)noticeKey).exists((Function1 & Serializable)_$3 -> _$3.isAnnounced());
    }

    public Either<Problem, PlannedBoard> announceNotice(NoticeKey noticeKey) {
        return package$.MODULE$.Right().apply((Object)this.updateNoticePlace(noticeKey, this.noticePlace(noticeKey).announce()));
    }

    public Either<Problem, PlannedBoard> addNoticeV2_3(NoticeV2_3 notice) {
        return this.addNotice(notice.toNotice(this.boardPath()));
    }

    public Either<Problem, PlannedBoard> addNotice(Notice notice) {
        return package$.MODULE$.Right().apply((Object)this.updateNoticePlace(notice.noticeKey(), this.noticePlace(notice.noticeKey()).post(notice)));
    }

    public PlannedBoard addExpectation(NoticeKey noticeKey, OrderId orderId) {
        return this.updateNoticePlace(noticeKey, this.noticePlace(noticeKey).addExpecting(orderId));
    }

    public Either<Problem, PlannedBoard> removeExpectation(NoticeKey noticeKey, OrderId orderId) {
        return package$.MODULE$.Right().apply(this.toNoticePlace().get((Object)noticeKey).fold(this::removeExpectation$$anonfun$1, (Function1 & Serializable)noticePlace -> this.updateNoticePlace(noticeKey, noticePlace.removeExpecting(orderId))));
    }

    public PlannedBoard startConsumption(NoticeKey noticeKey, OrderId orderId) {
        Map map = (Map)this.toNoticePlace().updated((Object)noticeKey, (Object)this.noticePlace(noticeKey).startConsumption(orderId));
        PlannedBoardId plannedBoardId = this.copy$default$1();
        return this.copy(plannedBoardId, (Map<NoticeKey, NoticePlace>)map);
    }

    public Either<Problem, PlannedBoard> finishConsumption(NoticeKey noticeKey, boolean succeeded) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.toNoticePlace());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, noticeKey, Tag$.MODULE$.apply(NoticeKey.class, LightTypeTag$.MODULE$.parse(1605945125, "\u0004\u0000\u0001\u0018js7.data.board.NoticeKey\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.NoticeKey\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("PlannedBoard.scala"), Line$.MODULE$.apply(81)).map((Function1 & Serializable)noticePlace -> this.updateNoticePlace(noticeKey, noticePlace.finishConsumption(succeeded)));
    }

    public L3 isNoticeAvailable(NoticeKey noticeKey) {
        if (this.hasNotice(noticeKey)) {
            return L3$.True;
        }
        if (this.isAnnounced(noticeKey)) {
            return L3$.False;
        }
        return L3$.Unknown;
    }

    public boolean hasNotice(NoticeKey noticeKey) {
        return this.toNoticePlace().get((Object)noticeKey).exists((Function1 & Serializable)_$4 -> _$4.notice().isDefined());
    }

    public boolean containsNoticeKey(NoticeKey noticeKey) {
        return this.toNoticePlace().contains((Object)noticeKey);
    }

    public Set<OrderId> expectingOrders(NoticeKey noticeKey) {
        Option option = ScalaUtils$syntax$.MODULE$.RichOption(this.toNoticePlace().get((Object)noticeKey));
        return (Set)ScalaUtils$syntax$RichOption$.MODULE$.fold_$extension(option, PlannedBoard::expectingOrders$$anonfun$1, (Function1 & Serializable)_$5 -> _$5.expectingOrderIds());
    }

    public View<Notice> notices() {
        return (View)this.toNoticePlace().values().view().flatMap((Function1 & Serializable)_$6 -> _$6.notice());
    }

    public int noticeCount() {
        return this.toNoticePlace().values().count((Function1 & Serializable)_$7 -> _$7.notice().isDefined());
    }

    public Either<Problem, Notice> notice(NoticeKey noticeKey) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.toNoticePlace());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, noticeKey, Tag$.MODULE$.apply(NoticeKey.class, LightTypeTag$.MODULE$.parse(1605945125, "\u0004\u0000\u0001\u0018js7.data.board.NoticeKey\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.NoticeKey\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("PlannedBoard.scala"), Line$.MODULE$.apply(113)).flatMap((Function1 & Serializable)noticePlace -> {
            Left left;
            Option<Notice> option = noticePlace.notice();
            if (None$.MODULE$.equals(option)) {
                left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.notice$$anonfun$1$$anonfun$1(noticeKey)), Problem$.MODULE$.apply$default$2()));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Notice notice2 = (Notice)some.value();
                left = package$.MODULE$.Right().apply((Object)notice2);
            } else {
                throw new MatchError(option);
            }
            return left.map((Function1 & Serializable)notice -> notice);
        });
    }

    public NoticePlace noticePlace(NoticeKey noticeKey) {
        return (NoticePlace)this.toNoticePlace().getOrElse((Object)noticeKey, PlannedBoard::noticePlace$$anonfun$1);
    }

    public Either<Problem, KeyedEvent<NoticeEvent.NoticeDeleted>> deleteNoticeEvent(NoticeKey noticeKey) {
        Either either = ScalaUtils$syntax$.MODULE$.RichEither(this.checkNoticeIsDeletable(noticeKey));
        return ScalaUtils$syntax$RichEither$.MODULE$.rightAs$extension(either, () -> this.deleteNoticeEvent$$anonfun$1(noticeKey));
    }

    public Either<Problem, PlannedBoard> removeNotice(NoticeKey noticeKey) {
        Either either = ScalaUtils$syntax$.MODULE$.RichEither(this.checkNoticeIsDeletable(noticeKey));
        return ScalaUtils$syntax$RichEither$.MODULE$.rightAs$extension(either, () -> this.removeNotice$$anonfun$1(noticeKey));
    }

    private Either<Problem, BoxedUnit> checkNoticeIsDeletable(NoticeKey noticeKey) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.toNoticePlace());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, noticeKey, Tag$.MODULE$.apply(NoticeKey.class, LightTypeTag$.MODULE$.parse(1605945125, "\u0004\u0000\u0001\u0018js7.data.board.NoticeKey\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.NoticeKey\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("PlannedBoard.scala"), Line$.MODULE$.apply(133)).map((Function1)(JProcedure1 & Serializable)_$8 -> {});
    }

    public Either<Problem, PlannedBoard> moveFromNoticePlace(NoticeKey noticeKey) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.toNoticePlace());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, noticeKey, Tag$.MODULE$.apply(NoticeKey.class, LightTypeTag$.MODULE$.parse(1605945125, "\u0004\u0000\u0001\u0018js7.data.board.NoticeKey\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.NoticeKey\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("PlannedBoard.scala"), Line$.MODULE$.apply(137)).flatMap((Function1 & Serializable)noticePlace -> {
            Map map = (Map)this.toNoticePlace().$minus((Object)noticeKey);
            PlannedBoardId plannedBoardId = this.copy$default$1();
            return package$.MODULE$.Right().apply((Object)this.copy(plannedBoardId, (Map<NoticeKey, NoticePlace>)map));
        });
    }

    public Either<Problem, PlannedBoard> moveToNoticePlace(NoticeKey noticeKey, NoticePlace noticePlace, Option<Timestamp> endOfLife) {
        if (this.toNoticePlace().contains((Object)noticeKey)) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure(noticeKey + " exists already"));
        }
        NoticePlace newNoticePlace = noticePlace.copy((Option<Notice>)noticePlace.notice().map((Function1 & Serializable)_$9 -> _$9.copy(this.id().planId().$div(this.boardPath()).$div(noticeKey), endOfLife)), noticePlace.copy$default$2(), noticePlace.copy$default$3(), noticePlace.copy$default$4(), noticePlace.copy$default$5());
        Map map = (Map)this.toNoticePlace().updated((Object)noticeKey, (Object)newNoticePlace);
        PlannedBoardId plannedBoardId = this.copy$default$1();
        return package$.MODULE$.Right().apply((Object)this.copy(plannedBoardId, (Map<NoticeKey, NoticePlace>)map));
    }

    public Option<PlannedBoard> removeNoticeKeys() {
        Name src$proxy1 = Name$.MODULE$.apply("removeNoticeKeys");
        return (Option)Logger$package$Logger$syntax$.MODULE$.traceCall(PlannedBoard$.js7$data$board$PlannedBoard$$$logger, src$proxy1.value(), (Function0<Object>)((Function0 & Serializable)this::removeNoticeKeys$$anonfun$1), this::removeNoticeKeys$$anonfun$2);
    }

    private void requireNoNoticePlaceIsInUse() {
        ObjectRef msg = ObjectRef.create((Object)"");
        ScalaUtils$syntax$.MODULE$.foreachWithBracket(this.toNoticePlace().view().filter((Function1 & Serializable)_$10 -> ((NoticePlace)_$10._2()).isInUse()), MultipleLinesBracket$.MODULE$.Square(), (Function2 & Serializable)(v1, v2) -> {
            PlannedBoard.requireNoNoticePlaceIsInUse$$anonfun$2(msg, (Tuple2)v1, BoxesRunTime.unboxToChar((Object)v2));
            return BoxedUnit.UNIT;
        });
        if (Tests$.MODULE$.isStrict() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((String)msg.elem))) {
            throw new AssertionError((Object)((String)msg.elem));
        }
    }

    private PlannedBoard updateNoticePlace(NoticeKey noticeKey, NoticePlace noticePlace) {
        Map map = noticePlace.isEmpty() ? (Map)this.toNoticePlace().$minus((Object)noticeKey) : (Map)this.toNoticePlace().updated((Object)noticeKey, (Object)noticePlace);
        PlannedBoardId plannedBoardId = this.copy$default$1();
        return this.copy(plannedBoardId, (Map<NoticeKey, NoticePlace>)map);
    }

    public Option<Notice> maybeNotice(NoticeKey noticeKey) {
        return this.toNoticePlace().get((Object)noticeKey).flatMap((Function1 & Serializable)_$11 -> _$11.notice());
    }

    public PlanId planId() {
        return this.id().planId();
    }

    public BoardPath boardPath() {
        return this.id().boardPath();
    }

    public boolean isEmpty() {
        return this.toNoticePlace().isEmpty();
    }

    public String toString() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.toNoticePlace().toArray(ClassTag$.MODULE$.apply(Tuple2.class)));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1 & Serializable)_$12 -> (NoticeKey)_$12._1(), NoticeKey$.MODULE$.given_Ordering_NoticeKey()));
        return "PlannedBoard(" + this.id() + " " + ArrayOps$.MODULE$.view$extension(object2).map((Function1 & Serializable)x$1 -> {
            NoticeKey noticeKey = (NoticeKey)x$1._1();
            NoticePlace noticePlace = (NoticePlace)x$1._2();
            return noticeKey + " -> " + noticePlace;
        }).mkString(", ") + ")";
    }

    public PlannedBoard copy(PlannedBoardId id, Map<NoticeKey, NoticePlace> toNoticePlace) {
        return new PlannedBoard(id, toNoticePlace);
    }

    public PlannedBoardId copy$default$1() {
        return this.id();
    }

    public Map<NoticeKey, NoticePlace> copy$default$2() {
        return this.toNoticePlace();
    }

    public PlannedBoardId _1() {
        return this.id();
    }

    public Map<NoticeKey, NoticePlace> _2() {
        return this.toNoticePlace();
    }

    private final Stream toStringStream$$anonfun$1() {
        return Stream$.MODULE$.iterable((Iterable)this.toNoticePlace().toVector().sortBy((Function1 & Serializable)_$2 -> (NoticeKey)_$2._1(), NoticeKey$.MODULE$.given_Ordering_NoticeKey())).map((Function1 & Serializable)x$1 -> {
            NoticeKey noticeKey = (NoticeKey)x$1._1();
            NoticePlace noticePlace = (NoticePlace)x$1._2();
            return "  " + noticeKey + " -> " + noticePlace;
        });
    }

    private final PlannedBoard removeExpectation$$anonfun$1() {
        return this;
    }

    private static final Set expectingOrders$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private final String notice$$anonfun$1$$anonfun$1(NoticeKey noticeKey$4) {
        return this.id().$div(noticeKey$4) + " does not denote a Notice (but a Notice expectation)";
    }

    private static final NoticePlace noticePlace$$anonfun$1() {
        return NoticePlace$.MODULE$.empty();
    }

    private final KeyedEvent deleteNoticeEvent$$anonfun$1(NoticeKey noticeKey$5) {
        BoardPath boardPath = this.boardPath();
        NoticeEvent.NoticeDeleted Event_this = NoticeEvent$NoticeDeleted$.MODULE$.apply(this.id().planId().$div(noticeKey$5));
        return new KeyedEvent<NoticeEvent.NoticeDeleted>(Event_this, boardPath);
    }

    private final PlannedBoard removeNotice$$anonfun$1$$anonfun$1() {
        return this;
    }

    private final PlannedBoard removeNotice$$anonfun$1(NoticeKey noticeKey$6) {
        return (PlannedBoard)this.toNoticePlace().get((Object)noticeKey$6).fold(this::removeNotice$$anonfun$1$$anonfun$1, (Function1 & Serializable)noticePlace -> this.updateNoticePlace(noticeKey$6, noticePlace.removeNotice()));
    }

    private static final /* synthetic */ void body$proxy1$1$$anonfun$1(Tuple2 x$1, char x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        NoticeKey key = (NoticeKey)tuple22._1();
        NoticePlace noticePlace = (NoticePlace)tuple22._2();
        char br = BoxesRunTime.unboxToChar((Object)tuple2._2());
        Logger LoggerImpl_this = PlannedBoard$.js7$data$board$PlannedBoard$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("{}Remove {} -> {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToCharacter((char)br), key, noticePlace}), Object.class));
            return;
        }
    }

    private final PlannedBoard a$proxy1$1() {
        Map map = Predef$.MODULE$.Map().empty();
        PlannedBoardId plannedBoardId = this.copy$default$1();
        return this.copy(plannedBoardId, (Map<NoticeKey, NoticePlace>)map);
    }

    private final PlannedBoard body$proxy1$1$$anonfun$2() {
        return this.a$proxy1$1();
    }

    private final Option body$proxy1$1() {
        ScalaUtils$syntax$.MODULE$.foreachWithBracket(this.toNoticePlace(), MultipleLinesBracket$.MODULE$.Square(), (Function2 & Serializable)(v1, v2) -> {
            PlannedBoard.body$proxy1$1$$anonfun$1((Tuple2)v1, BoxesRunTime.unboxToChar((Object)v2));
            return BoxedUnit.UNIT;
        });
        this.requireNoNoticePlaceIsInUse();
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.toNoticePlace().nonEmpty());
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, this::body$proxy1$1$$anonfun$2);
    }

    private final Object removeNoticeKeys$$anonfun$1() {
        return Logger$package$Logger$syntax$.MODULE$.traceCall$default$3(PlannedBoard$.js7$data$board$PlannedBoard$$$logger);
    }

    private final Option removeNoticeKeys$$anonfun$2() {
        return this.body$proxy1$1();
    }

    private static final /* synthetic */ void requireNoNoticePlaceIsInUse$$anonfun$2(ObjectRef msg$1, Tuple2 x$1, char x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        NoticeKey noticeKey = (NoticeKey)tuple22._1();
        NoticePlace noticePlace = (NoticePlace)tuple22._2();
        char br = BoxesRunTime.unboxToChar((Object)tuple2._2());
        msg$1.elem = "requireNoNoticePlaceIsInUse: Internal problem: Removing a being expected or consumed " + noticeKey + " -> " + noticePlace;
        Logger LoggerImpl_this = PlannedBoard$.js7$data$board$PlannedBoard$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToCharacter((char)br), (String)msg$1.elem}), Object.class));
            return;
        }
    }
}

