/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow.instructions;

import java.io.Serializable;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.Timestamp;
import js7.data.event.KeyedEvent;
import js7.data.execution.workflow.instructions.EventInstructionExecutor;
import js7.data.execution.workflow.instructions.InstructionExecutor;
import js7.data.execution.workflow.instructions.InstructionExecutorService;
import js7.data.execution.workflow.instructions.RetryExecutor$;
import js7.data.item.VersionedItemId;
import js7.data.order.Order;
import js7.data.order.Order$DelayedAfterError$;
import js7.data.order.Order$DelayingRetry$;
import js7.data.order.OrderEvent;
import js7.data.order.OrderEvent$OrderFailedIntermediate_$;
import js7.data.order.OrderEvent$OrderMoved$;
import js7.data.order.OrderEvent$OrderRetrying$;
import js7.data.order.OrderObstacle;
import js7.data.order.OrderObstacle$WaitingForOtherTime$;
import js7.data.order.OrderObstacleCalculator;
import js7.data.state.StateView;
import js7.data.workflow.Instruction;
import js7.data.workflow.WorkflowPath;
import js7.data.workflow.instructions.Retry;
import js7.data.workflow.instructions.TryInstruction;
import js7.data.workflow.position.BranchId;
import js7.data.workflow.position.BranchPath$package$BranchPath$syntax$;
import js7.data.workflow.position.Position;
import js7.data.workflow.position.TryBranchId$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class RetryExecutor
implements InstructionExecutor,
EventInstructionExecutor {
    private final InstructionExecutorService service;
    private final Class<? extends Retry> instructionClass;

    public RetryExecutor(InstructionExecutorService service) {
        this.service = service;
        this.instructionClass = Retry.class;
    }

    @Override
    public InstructionExecutorService service() {
        return this.service;
    }

    public Class<? extends Retry> instructionClass() {
        return this.instructionClass;
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> toEvents(Retry retry, Order<Order.State> order, StateView state) {
        if (!order.isState(ClassTag$.MODULE$.apply(Order.Ready.class))) {
            return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil());
        }
        return order.workflowPosition().position().nextRetryPosition().flatMap((Function1 & Serializable)nextTryPos -> {
            Option option = Checked$.MODULE$.CheckedOption(BranchPath$package$BranchPath$syntax$.MODULE$.parent(nextTryPos.branchPath()).flatMap((Function1 & Serializable)parent -> {
                VersionedItemId<WorkflowPath> versionedItemId = order.workflowId();
                return Some$.MODULE$.apply((Object)state.instruction(parent.$div$colon(versionedItemId))).collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Instruction x2) {
                        Instruction instruction = x2;
                        if (instruction instanceof TryInstruction) {
                            TryInstruction tryInstruction;
                            TryInstruction o = tryInstruction = (TryInstruction)instruction;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Instruction x2, Function1 function1) {
                        Instruction instruction = x2;
                        if (instruction instanceof TryInstruction) {
                            TryInstruction tryInstruction;
                            TryInstruction o = tryInstruction = (TryInstruction)instruction;
                            return o;
                        }
                        return function1.apply((Object)x2);
                    }
                }).flatMap((Function1 & Serializable)_try -> nextTryPos.branchPath().lastOption().map((Function1 & Serializable)_$1 -> _$1.branchId()).collect((PartialFunction)new Serializable((TryInstruction)_try){
                    private final TryInstruction _try$1;
                    {
                        this._try$1 = _try$2;
                    }

                    public final boolean isDefinedAt(BranchId x2) {
                        BranchId branchId = x2;
                        Option<Object> option = TryBranchId$.MODULE$.unapply(branchId);
                        if (!option.isEmpty()) {
                            int n;
                            int index = n = BoxesRunTime.unboxToInt((Object)option.get());
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(BranchId x2, Function1 function1) {
                        BranchId branchId = x2;
                        Option<Object> option = TryBranchId$.MODULE$.unapply(branchId);
                        if (!option.isEmpty()) {
                            int n;
                            int index = n = BoxesRunTime.unboxToInt((Object)option.get());
                            return Tuple2$.MODULE$.apply(this._try$1.maxTries(), (Object)this._try$1.retryDelay(index));
                        }
                        return function1.apply((Object)x2);
                    }
                }));
            }));
            return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> RetryExecutor.toEvents$$anonfun$1$$anonfun$2(nextTryPos))).map((Function1 & Serializable)x$1 -> {
                FiniteDuration delay;
                Tuple2 tuple2 = x$1;
                Option option = (Option)tuple2._1();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int maxRetries = BoxesRunTime.unboxToInt((Object)some.value());
                    if (order.position().tryCount() >= maxRetries) {
                        OrderEvent.OrderFailedIntermediate_ orderFailedIntermediate_ = OrderEvent$OrderFailedIntermediate_$.MODULE$.apply(OrderEvent$OrderFailedIntermediate_$.MODULE$.$lessinit$greater$default$1());
                        return package$.MODULE$.Nil().$colon$colon((Object)orderFailedIntermediate_);
                    }
                }
                if (ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(delay = (FiniteDuration)tuple2._2()))) {
                    OrderEvent.OrderRetrying orderRetrying = OrderEvent$OrderRetrying$.MODULE$.apply((Option<Timestamp>)Some$.MODULE$.apply((Object)this.nextTimestamp(delay)), OrderEvent$OrderRetrying$.MODULE$.$lessinit$greater$default$2());
                    return package$.MODULE$.Nil().$colon$colon((Object)orderRetrying);
                }
                OrderEvent.OrderRetrying orderRetrying = OrderEvent$OrderRetrying$.MODULE$.apply(OrderEvent$OrderRetrying$.MODULE$.$lessinit$greater$default$1(), OrderEvent$OrderRetrying$.MODULE$.$lessinit$greater$default$2());
                OrderEvent.OrderMoved orderMoved = OrderEvent$OrderMoved$.MODULE$.apply((Position)nextTryPos, OrderEvent$OrderMoved$.MODULE$.$lessinit$greater$default$2());
                return package$.MODULE$.Nil().$colon$colon((Object)orderMoved).$colon$colon((Object)orderRetrying);
            }).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)_$3 -> {
                OrderEvent.OrderActorEvent Event_this = _$3;
                return new KeyedEvent<OrderEvent.OrderActorEvent>(Event_this, order.id());
            }));
        });
    }

    private Timestamp nextTimestamp(FiniteDuration delay) {
        Timestamp timestamp;
        Timestamp at = timestamp = this.clock().now().$plus(delay);
        if (delay.$greater$eq((Object)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(10)))) {
            return at.roundToNextSecond();
        }
        Timestamp at2 = timestamp;
        return at2;
    }

    @Override
    public Either<Problem, Set<OrderObstacle>> toObstacles(Order<Order.State> order, OrderObstacleCalculator calculator) {
        Order.State state = order.state();
        if (state instanceof Order.DelayingRetry) {
            Timestamp timestamp;
            Order.DelayingRetry delayingRetry = (Order.DelayingRetry)state;
            Order.DelayingRetry delayingRetry2 = Order$DelayingRetry$.MODULE$.unapply(delayingRetry);
            Timestamp until = timestamp = delayingRetry2._1();
            return package$.MODULE$.Right().apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OrderObstacle[]{OrderObstacle$WaitingForOtherTime$.MODULE$.apply(until)})));
        }
        if (state instanceof Order.DelayedAfterError) {
            Timestamp timestamp;
            Order.DelayedAfterError delayedAfterError = (Order.DelayedAfterError)state;
            Order.DelayedAfterError delayedAfterError2 = Order$DelayedAfterError$.MODULE$.unapply(delayedAfterError);
            Timestamp until = timestamp = delayedAfterError2._1();
            return package$.MODULE$.Right().apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OrderObstacle[]{OrderObstacle$WaitingForOtherTime$.MODULE$.apply(until)})));
        }
        return InstructionExecutor.toObstacles$(this, order, calculator);
    }

    private static final Problem toEvents$$anonfun$1$$anonfun$2(Position nextTryPos$3) {
        return RetryExecutor$.MODULE$.js7$data$execution$workflow$instructions$RetryExecutor$$$missingTryProblem(nextTryPos$3);
    }
}

