/*
 * Decompiled with CFR 0.152.
 */
package js7.data.lock;

import io.circe.Codec;
import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Big;
import js7.data.item.InventoryItemState;
import js7.data.item.UnsignedSimpleItemState;
import js7.data.lock.Acquired;
import js7.data.lock.Acquired$Available$;
import js7.data.lock.Lock;
import js7.data.lock.LockPath;
import js7.data.lock.LockRefusal;
import js7.data.lock.LockRefusal$AlreadyAcquiredByThisOrder$;
import js7.data.lock.LockRefusal$InvalidCount$;
import js7.data.lock.LockRefusal$IsInUse$;
import js7.data.lock.LockRefusal$LimitReached$;
import js7.data.lock.LockState$;
import js7.data.order.OrderId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Vector;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;

public final class LockState
implements InventoryItemState,
UnsignedSimpleItemState,
Big,
Product,
Serializable {
    private final Lock lock;
    private final Acquired acquired;
    private final Vector<OrderId> queue;
    private final LockState$ companion;
    private final Lock item;

    public static LockState apply(Lock lock, Acquired acquired, Vector<OrderId> vector) {
        return LockState$.MODULE$.apply(lock, acquired, vector);
    }

    public static LockState fromProduct(Product product) {
        return LockState$.MODULE$.fromProduct(product);
    }

    public static Codec.AsObject<LockState> jsonCodec() {
        return LockState$.MODULE$.jsonCodec();
    }

    public static LockState unapply(LockState lockState) {
        return LockState$.MODULE$.unapply(lockState);
    }

    public static Acquired $lessinit$greater$default$2() {
        return LockState$.MODULE$.$lessinit$greater$default$2();
    }

    public static Vector<OrderId> $lessinit$greater$default$3() {
        return LockState$.MODULE$.$lessinit$greater$default$3();
    }

    public LockState(Lock lock, Acquired acquired, Vector<OrderId> queue) {
        this.lock = lock;
        this.acquired = acquired;
        this.queue = queue;
        this.companion = LockState$.MODULE$;
        this.item = lock;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 1253472294, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        LockState lockState;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LockState)) return false;
        LockState lockState2 = lockState = (LockState)object;
        Lock lock = this.lock();
        Lock lock2 = lockState2.lock();
        if (lock == null) {
            if (lock2 != null) {
                return false;
            }
        } else if (!((Object)lock).equals(lock2)) return false;
        Acquired acquired = this.acquired();
        Acquired acquired2 = lockState2.acquired();
        if (acquired == null) {
            if (acquired2 != null) {
                return false;
            }
        } else if (!acquired.equals(acquired2)) return false;
        Vector<OrderId> vector = this.queue();
        Vector<OrderId> vector2 = lockState2.queue();
        if (vector == null) {
            if (vector2 == null) return true;
            return false;
        } else {
            if (!vector.equals(vector2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LockState;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "LockState";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "lock";
            }
            case 1: {
                return "acquired";
            }
            case 2: {
                return "queue";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Lock lock() {
        return this.lock;
    }

    public Acquired acquired() {
        return this.acquired;
    }

    public Vector<OrderId> queue() {
        return this.queue;
    }

    public LockState$ companion() {
        return this.companion;
    }

    @Override
    public Lock item() {
        return this.item;
    }

    @Override
    public LockPath path() {
        return this.item().path();
    }

    public Either<Problem, LockState> updateItem(Lock lock) {
        return scala.package$.MODULE$.Right().apply((Object)this.copy(lock, this.copy$default$2(), this.copy$default$3()));
    }

    public Either<Problem, LockState> enqueue(OrderId orderId2, Option<Object> count) {
        if (!count.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 <= this.lock().limit())) {
            return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.enqueue$$anonfun$2(count)), Problem$.MODULE$.apply$default$2()));
        }
        if (this.acquired().isAcquiredBy(orderId2)) {
            return scala.package$.MODULE$.Left().apply((Object)LockRefusal$AlreadyAcquiredByThisOrder$.MODULE$.toProblem(this.lock().path()));
        }
        if (this.queue().contains((Object)orderId2)) {
            return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.enqueue$$anonfun$3(orderId2)), Problem$.MODULE$.apply$default$2()));
        }
        Option option = orderId2.allParents().find((Function1 & Serializable)orderId -> this.acquired().isAcquiredBy((OrderId)orderId));
        if (option instanceof Some) {
            Some some = (Some)option;
            OrderId parentOrderId = (OrderId)some.value();
            return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.enqueue$$anonfun$5(parentOrderId)), Problem$.MODULE$.apply$default$2()));
        }
        if (None$.MODULE$.equals(option)) {
            Vector vector = (Vector)this.queue().$colon$plus((Object)orderId2);
            Lock lock = this.copy$default$1();
            Acquired acquired = this.copy$default$2();
            return scala.package$.MODULE$.Right().apply((Object)this.copy(lock, acquired, (Vector<OrderId>)vector));
        }
        throw new MatchError((Object)option);
    }

    public Either<Problem, Object> isAvailable(OrderId orderId, Option<Object> count) {
        Either<LockRefusal, BoxedUnit> either = this.checkAcquire(orderId, count);
        if (either instanceof Left) {
            Left left = (Left)either;
            LockRefusal lockRefusal = (LockRefusal)left.value();
            if (lockRefusal instanceof LockRefusal.NotAvailable) {
                LockRefusal.NotAvailable notAvailable = (LockRefusal.NotAvailable)lockRefusal;
                return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            LockRefusal refusal = lockRefusal;
            return scala.package$.MODULE$.Left().apply((Object)refusal.toProblem(this.lockPath()));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = right.value();
            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
        }
        throw new MatchError(either);
    }

    public Option<Object> isAvailable$default$2() {
        return None$.MODULE$;
    }

    private Either<LockRefusal, BoxedUnit> checkAcquire(OrderId orderId, Option<Object> count) {
        return this.tryAcquire(orderId, count).map((Function1)(JProcedure1 & Serializable)_$2 -> {});
    }

    private Option<Object> checkAcquire$default$2() {
        return None$.MODULE$;
    }

    private Either<LockRefusal, Acquired> tryAcquire(OrderId orderId, Option<Object> count) {
        return this.acquired().acquireFor(orderId, count).flatMap((Function1 & Serializable)a -> this.checkLimit(count).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return a;
        }));
    }

    public Either<Problem, LockState> acquire(OrderId orderId, Option<Object> count) {
        return this.toLockState(this.tryAcquire(orderId, count)).map((Function1 & Serializable)lockState -> {
            if (this.queue().contains((Object)orderId)) {
                Vector vector = (Vector)this.queue().filterNot((Function1 & Serializable)_$3 -> {
                    OrderId orderId = _$3;
                    OrderId orderId2 = orderId;
                    return !(orderId != null ? !((Object)orderId).equals(orderId2) : orderId2 != null);
                });
                Lock lock = lockState.copy$default$1();
                Acquired acquired = lockState.copy$default$2();
                return lockState.copy(lock, acquired, (Vector<OrderId>)vector);
            }
            return lockState;
        });
    }

    public LockState dequeue(OrderId orderId) {
        Vector vector = (Vector)this.queue().filterNot((Function1 & Serializable)_$4 -> {
            OrderId orderId = _$4;
            OrderId orderId2 = orderId;
            return !(orderId != null ? !((Object)orderId).equals(orderId2) : orderId2 != null);
        });
        Lock lock = this.copy$default$1();
        Acquired acquired = this.copy$default$2();
        return this.copy(lock, acquired, (Vector<OrderId>)vector);
    }

    public Either<Problem, LockState> release(OrderId orderId) {
        return this.toLockState(this.acquired().release(orderId));
    }

    private Either<LockRefusal, BoxedUnit> checkLimit(Option<Object> count) {
        Option<Object> option = count;
        if (None$.MODULE$.equals(option)) {
            Acquired acquired = this.acquired();
            Acquired$Available$ acquired$Available$ = Acquired$Available$.MODULE$;
            if (!(acquired != null ? !acquired.equals(acquired$Available$) : acquired$Available$ != null)) {
                return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            return scala.package$.MODULE$.Left().apply((Object)LockRefusal$IsInUse$.MODULE$);
        }
        if (option instanceof Some) {
            boolean ok;
            boolean bl;
            Some some = (Some)option;
            int n = BoxesRunTime.unboxToInt((Object)some.value());
            if (n < 1) {
                return scala.package$.MODULE$.Left().apply((Object)LockRefusal$InvalidCount$.MODULE$.apply(n));
            }
            try {
                bl = package$.MODULE$.addExact(this.acquired().lockCount(), n) <= this.lock().limit();
            }
            catch (ArithmeticException arithmeticException) {
                bl = ok = false;
            }
            if (ok) {
                return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            return scala.package$.MODULE$.Left().apply((Object)LockRefusal$LimitReached$.MODULE$.apply(this.lock().limit(), n, this.acquired().lockCount()));
        }
        throw new MatchError(option);
    }

    private Either<Problem, LockState> toLockState(Either<LockRefusal, Acquired> result) {
        return result.left().map((Function1 & Serializable)refusal -> refusal.toProblem(this.lock().path())).map((Function1 & Serializable)acquired -> this.copy(this.copy$default$1(), (Acquired)acquired, this.copy$default$3()));
    }

    private LockPath lockPath() {
        return this.lock().path();
    }

    public LockState copy(Lock lock, Acquired acquired, Vector<OrderId> queue) {
        return new LockState(lock, acquired, queue);
    }

    public Lock copy$default$1() {
        return this.lock();
    }

    public Acquired copy$default$2() {
        return this.acquired();
    }

    public Vector<OrderId> copy$default$3() {
        return this.queue();
    }

    public Lock _1() {
        return this.lock();
    }

    public Acquired _2() {
        return this.acquired();
    }

    public Vector<OrderId> _3() {
        return this.queue();
    }

    private static final Object enqueue$$anonfun$2$$anonfun$1() {
        return "";
    }

    private final String enqueue$$anonfun$2(Option count$1) {
        return "Cannot fulfill lock count=" + count$1.getOrElse(LockState::enqueue$$anonfun$2$$anonfun$1) + " with " + this.lockPath() + " limit=" + this.lock().limit();
    }

    private final String enqueue$$anonfun$3(OrderId orderId$1) {
        return orderId$1 + " already queues for " + this.lockPath();
    }

    private final String enqueue$$anonfun$5(OrderId parentOrderId$1) {
        return this.lockPath() + " has already been acquired by parent " + parentOrderId$1;
    }
}

