/*
 * Decompiled with CFR 0.152.
 */
package js7.data.order;

import cats.Applicative;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.package;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import js7.base.problem.Problem;
import js7.base.time.Timestamp;
import js7.base.time.WallClock$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.data.agent.AgentPath;
import js7.data.agent.AgentRef$;
import js7.data.execution.workflow.instructions.InstructionExecutorService;
import js7.data.item.VersionedItemId;
import js7.data.job.JobKey;
import js7.data.order.Order;
import js7.data.order.Order$Cancelled$;
import js7.data.order.Order$Failed$;
import js7.data.order.Order$FailedWhileFresh$;
import js7.data.order.OrderId;
import js7.data.order.OrderObstacle;
import js7.data.order.OrderObstacle$AgentProcessLimitReached$;
import js7.data.order.OrderObstacle$WaitingForCommand$;
import js7.data.order.OrderObstacle$WaitingForOtherTime$;
import js7.data.order.OrderObstacle$WorkflowSuspended$;
import js7.data.state.StateView;
import js7.data.workflow.WorkflowPath;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.View;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import sourcecode.FileName$;
import sourcecode.Line$;

public final class OrderObstacleCalculator {
    private final StateView stateView;
    private final ConcurrentHashMap<JobKey, Object> _jobToOrderCount;

    public OrderObstacleCalculator(StateView stateView) {
        this.stateView = stateView;
        this._jobToOrderCount = new ConcurrentHashMap();
    }

    public StateView stateView() {
        return this.stateView;
    }

    public int waitingForAdmissionOrderCount(Timestamp now) {
        Either either = ScalaUtils$syntax$.MODULE$.RichEither(this.ordersToObstacles((Iterable<OrderId>)this.stateView().idToOrder().keys().view(), now));
        return ((View)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either)).count((Function1 & Serializable)_$1 -> ((IterableOnceOps)_$1._2()).exists((Function1 & Serializable)x$1 -> {
            OrderObstacle orderObstacle = x$1;
            if (orderObstacle instanceof OrderObstacle.WaitingForAdmission) {
                OrderObstacle.WaitingForAdmission waitingForAdmission = (OrderObstacle.WaitingForAdmission)orderObstacle;
                return true;
            }
            return false;
        }));
    }

    public Either<Problem, View<Tuple2<OrderId, scala.collection.immutable.Set<OrderObstacle>>>> ordersToObstacles(Iterable<OrderId> orderIds, Timestamp now) {
        InstructionExecutorService instructionService = new InstructionExecutorService(WallClock$.MODULE$.fixed(now));
        return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)orderIds.toVector(), UnorderedFoldable$.MODULE$.catsTraverseForVector()).traverse((Function1 & Serializable)orderId -> this.orderToObstacles((OrderId)orderId, instructionService).map((Function1 & Serializable)obstacles -> {
            OrderId orderId = (OrderId)Predef$.MODULE$.ArrowAssoc(orderId);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)orderId, obstacles);
        }), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)_$2 -> (View)_$2.view().filter((Function1 & Serializable)_$3 -> ((IterableOnceOps)_$3._2()).nonEmpty()));
    }

    public Either<Problem, scala.collection.immutable.Set<OrderObstacle>> orderToObstacles(OrderId orderId, InstructionExecutorService instructionExecutorService) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.stateView().idToOrder());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, orderId, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("OrderObstacleCalculator.scala"), Line$.MODULE$.apply(42)).flatMap((Function1 & Serializable)order -> instructionExecutorService.toObstacles((Order<Order.State>)order, this).map((Function1 & Serializable)a -> {
            scala.collection.immutable.Set<OrderObstacle> b = this.orderStateToObstacles((Order<Order.State>)order);
            scala.collection.immutable.Set c = ScalaUtils$syntax$RichBoolean$.MODULE$.thenSet$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(order.isSuspendedOrStopped()), OrderObstacleCalculator::$anonfun$1);
            return (scala.collection.immutable.Set)a.$plus$plus(b).$plus$plus(c).$plus$plus(this.workflowSuspendedObstacle((Order<Order.State>)order));
        }));
    }

    private Option<OrderObstacle$WorkflowSuspended$> workflowSuspendedObstacle(Order<Order.State> order) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.stateView().isWorkflowSuspended(order.workflowPath()));
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, OrderObstacleCalculator::workflowSuspendedObstacle$$anonfun$1);
    }

    private scala.collection.immutable.Set<OrderObstacle> orderStateToObstacles(Order<Order.State> order) {
        Set result = (Set)Set$.MODULE$.empty();
        Order.State state = order.state();
        if (state instanceof Order.Fresh) {
            Order.Fresh fresh = (Order.Fresh)state;
            v0 = result.$plus$plus$eq((IterableOnce)order.scheduledFor().map((Function1 & Serializable)_$4 -> OrderObstacle$WaitingForOtherTime$.MODULE$.apply((Timestamp)_$4)));
        } else {
            v0 = Order$FailedWhileFresh$.MODULE$.equals(state) || Order$Failed$.MODULE$.equals(state) || Order$Cancelled$.MODULE$.equals(state) ? result.$plus$eq((Object)OrderObstacle$WaitingForCommand$.MODULE$) : BoxedUnit.UNIT;
        }
        if (order.isState(ClassTag$.MODULE$.apply(Order.IsFreshOrReady.class))) {
            order.attached().foreach((Function1)(JProcedure1 & Serializable)agentPath -> {
                Option limit = this.stateView().keyToItem(AgentRef$.MODULE$).get(agentPath).flatMap((Function1 & Serializable)_$5 -> _$5.processLimit());
                if (limit.exists((Function1)(JFunction1.mcZI.sp & Serializable)_$6 -> _$6 <= this.stateView().slowProcessingOrderCount((AgentPath)agentPath))) {
                    result.$plus$eq((Object)OrderObstacle$AgentProcessLimitReached$.MODULE$);
                    return;
                }
            });
        }
        return result.toSet();
    }

    public int jobToOrderCount(JobKey jobKey2) {
        return BoxesRunTime.unboxToInt((Object)this._jobToOrderCount.computeIfAbsent(jobKey2, jobKey -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.stateView().idToWorkflow());
            return BoxesRunTime.unboxToInt((Object)ScalaUtils$syntax$RichPartialFunction$.MODULE$.get$extension(partialFunction, jobKey.workflowId()).fold(OrderObstacleCalculator::jobToOrderCount$$anonfun$1$$anonfun$1, (Function1 & Serializable)workflow -> this.stateView().orders().view().count((Function1 & Serializable)order -> {
                if (!(order.state() instanceof Order.Processing)) return false;
                VersionedItemId<WorkflowPath> versionedItemId = order.workflowId();
                VersionedItemId<WorkflowPath> versionedItemId2 = jobKey.workflowId();
                if (versionedItemId == null) {
                    if (versionedItemId2 != null) {
                        return false;
                    }
                } else if (!((Object)versionedItemId).equals(versionedItemId2)) return false;
                if (!workflow.positionToJobKey(order.position()).contains(jobKey)) return false;
                return true;
            })));
        }));
    }

    private static final OrderObstacle $anonfun$1() {
        return OrderObstacle$WaitingForCommand$.MODULE$;
    }

    private static final OrderObstacle$WorkflowSuspended$ workflowSuspendedObstacle$$anonfun$1() {
        return OrderObstacle$WorkflowSuspended$.MODULE$;
    }

    private static final int jobToOrderCount$$anonfun$1$$anonfun$1() {
        return 0;
    }
}

