/*
 * Decompiled with CFR 0.152.
 */
package js7.data.state;

import cats.Applicative;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.package;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.Timestamp;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.base.utils.Tests$;
import js7.data.agent.AgentPath;
import js7.data.board.BoardPath;
import js7.data.board.BoardState;
import js7.data.board.BoardState$;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.controller.ControllerId;
import js7.data.event.ItemContainer;
import js7.data.item.InventoryItem;
import js7.data.item.InventoryItemKey;
import js7.data.item.InventoryItemState;
import js7.data.item.UnsignedItemKey;
import js7.data.item.UnsignedItemState;
import js7.data.item.UnsignedSimpleItem;
import js7.data.item.UnsignedSimpleItemPath;
import js7.data.item.VersionedItemId;
import js7.data.job.JobKey;
import js7.data.job.JobResource;
import js7.data.job.JobResource$;
import js7.data.job.JobResourcePath;
import js7.data.lock.LockPath;
import js7.data.lock.LockState;
import js7.data.lock.LockState$;
import js7.data.order.MinimumOrder;
import js7.data.order.Order;
import js7.data.order.Order$Cancelled$;
import js7.data.order.Order$FailedInFork$;
import js7.data.order.OrderEvent;
import js7.data.order.OrderId;
import js7.data.order.OrderId$;
import js7.data.state.EngineStateFunctions;
import js7.data.state.EngineStateStatistics;
import js7.data.state.StateView$;
import js7.data.state.StateView$DummyStateView$;
import js7.data.value.expression.Scope;
import js7.data.value.expression.Scope$;
import js7.data.value.expression.scopes.JobResourceScope$;
import js7.data.value.expression.scopes.NamedValueScope$;
import js7.data.value.expression.scopes.NowScope$;
import js7.data.value.expression.scopes.OrderScopes;
import js7.data.value.expression.scopes.OrderScopes$;
import js7.data.workflow.Workflow;
import js7.data.workflow.WorkflowControl$;
import js7.data.workflow.WorkflowPath;
import js7.data.workflow.WorkflowPathControl;
import js7.data.workflow.WorkflowPathControl$;
import js7.data.workflow.WorkflowPathControlPath;
import js7.data.workflow.WorkflowPathControlPath$;
import js7.data.workflow.instructions.End;
import js7.data.workflow.instructions.Execute;
import js7.data.workflow.instructions.NoticeInstruction;
import js7.data.workflow.instructions.executable.WorkflowJob;
import js7.data.workflow.package$WorkflowControlId$;
import js7.data.workflow.position.Label;
import js7.data.workflow.position.WorkflowPosition;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.MapOps;
import scala.collection.MapView;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import sourcecode.FileName$;
import sourcecode.Line$;

public interface StateView
extends ItemContainer,
EngineStateFunctions {
    public static StateView empty() {
        return StateView$.MODULE$.empty();
    }

    public boolean isAgent();

    public ClusterState clusterState();

    public static Option maybeAgentPath$(StateView $this) {
        return $this.maybeAgentPath();
    }

    default public Option<AgentPath> maybeAgentPath() {
        return None$.MODULE$;
    }

    public ControllerId controllerId();

    public Map<OrderId, Order<Order.State>> idToOrder();

    public Iterable<Order<Order.State>> orders();

    public EngineStateStatistics statistics();

    public static boolean weHave$(StateView $this, Order order) {
        return $this.weHave(order);
    }

    default public boolean weHave(Order<Order.State> order) {
        return order.isDetached() && !this.isAgent() || order.isAttached() && this.isAgent();
    }

    public static int slowProcessingOrderCount$(StateView $this, AgentPath agentPath) {
        return $this.slowProcessingOrderCount(agentPath);
    }

    default public int slowProcessingOrderCount(AgentPath agentPath) {
        return this.orders().iterator().filter((Function1 & Serializable)_$1 -> _$1.attached().contains((Object)agentPath)).count((Function1 & Serializable)_$2 -> _$2.isState(ClassTag$.MODULE$.apply(Order.Processing.class)));
    }

    public static int jobToOrderCount$(StateView $this, JobKey jobKey) {
        return $this.jobToOrderCount(jobKey);
    }

    default public int jobToOrderCount(JobKey jobKey) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return BoxesRunTime.unboxToInt((Object)ScalaUtils$syntax$RichPartialFunction$.MODULE$.get$extension(partialFunction, jobKey.workflowId()).fold(StateView::jobToOrderCount$$anonfun$1, (Function1 & Serializable)workflow -> this.orders().view().count((Function1 & Serializable)order -> {
            if (!(order.state() instanceof Order.Processing)) return false;
            VersionedItemId<WorkflowPath> versionedItemId = order.workflowId();
            VersionedItemId<WorkflowPath> versionedItemId2 = jobKey.workflowId();
            if (versionedItemId == null) {
                if (versionedItemId2 != null) {
                    return false;
                }
            } else if (!((Object)versionedItemId).equals(versionedItemId2)) return false;
            if (!workflow.positionToJobKey(order.position()).contains((Object)jobKey)) return false;
            return true;
        })));
    }

    @Override
    public PartialFunction<VersionedItemId<WorkflowPath>, Workflow> idToWorkflow();

    public Either<Problem, VersionedItemId<WorkflowPath>> workflowPathToId(WorkflowPath var1);

    public static MapView pathToWorkflowPathControl$(StateView $this) {
        return $this.pathToWorkflowPathControl();
    }

    default public MapView<WorkflowPathControlPath, WorkflowPathControl> pathToWorkflowPathControl() {
        return this.keyTo(WorkflowPathControl$.MODULE$).mapValues((Function1 & Serializable)_$3 -> (WorkflowPathControl)_$3.item());
    }

    public MapView<UnsignedItemKey, UnsignedItemState> keyToUnsignedItemState();

    public static MapView keyTo$(StateView $this, InventoryItemState.Companion A) {
        return $this.keyTo(A);
    }

    default public <A extends InventoryItemState> MapView<InventoryItemKey, A> keyTo(InventoryItemState.Companion<A> A) {
        return this.keyToUnsignedItemState().filter((Function1 & Serializable)x$1 -> {
            UnsignedItemKey unsignedItemKey = (UnsignedItemKey)x$1._1();
            UnsignedItemState unsignedItemState = (UnsignedItemState)x$1._2();
            return unsignedItemState.companion() == A;
        });
    }

    public static MapView pathToUnsignedSimple$(StateView $this, UnsignedSimpleItem.Companion A) {
        return $this.pathToUnsignedSimple(A);
    }

    default public <A extends UnsignedSimpleItem> MapView<UnsignedSimpleItemPath, A> pathToUnsignedSimple(UnsignedSimpleItem.Companion<A> A) {
        return this.keyToUnsignedItemState().filter((Function1 & Serializable)x$1 -> {
            UnsignedItemKey unsignedItemKey = (UnsignedItemKey)x$1._1();
            UnsignedItemState unsignedItemState = (UnsignedItemState)x$1._2();
            return unsignedItemState.item().companion() == A;
        }).mapValues((Function1 & Serializable)_$6 -> _$6.item());
    }

    public static Either checkOrdersDoNotExist$(StateView $this, Iterable orderIds) {
        return $this.checkOrdersDoNotExist((Iterable<OrderId>)orderIds);
    }

    default public Either<Problem, BoxedUnit> checkOrdersDoNotExist(Iterable<OrderId> orderIds) {
        if (Tests$.MODULE$.isStrict()) {
            Map<OrderId, Order<Order.State>> map = this.idToOrder();
            Iterable known = (Iterable)orderIds.filter((Function1 & Serializable)key -> map.isDefinedAt(key));
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(known.isEmpty());
            return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, () -> StateView.checkOrdersDoNotExist$$anonfun$1(known));
        }
        return Checked$.MODULE$.unit();
    }

    public static Either checkOrdersExist$(StateView $this, Iterable orderIds) {
        return $this.checkOrdersExist((Iterable<OrderId>)orderIds);
    }

    default public Either<Problem, BoxedUnit> checkOrdersExist(Iterable<OrderId> orderIds) {
        if (Tests$.MODULE$.isStrict()) {
            Map<OrderId, Order<Order.State>> map = this.idToOrder();
            Iterable unknown = (Iterable)orderIds.filterNot((Function1 & Serializable)key -> map.isDefinedAt(key));
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(unknown.isEmpty());
            return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, () -> StateView.checkOrdersExist$$anonfun$1(unknown));
        }
        return Checked$.MODULE$.unit();
    }

    public static boolean isOrderProcessable$(StateView $this, OrderId orderId) {
        return $this.isOrderProcessable(orderId);
    }

    default public boolean isOrderProcessable(OrderId orderId) {
        return this.idToOrder().get((Object)orderId).exists((Function1 & Serializable)order -> this.isOrderProcessable((Order<Order.State>)order));
    }

    public static boolean isOrderProcessable$(StateView $this, Order order) {
        return $this.isOrderProcessable(order);
    }

    default public boolean isOrderProcessable(Order<Order.State> order) {
        return order.isProcessable() && this.isOrderProcessable2(order);
    }

    public static Option ifOrderProcessable$(StateView $this, Order order) {
        return $this.ifOrderProcessable(order);
    }

    default public Option<Order<Order.IsFreshOrReady>> ifOrderProcessable(Order<Order.State> order2) {
        return order2.ifProcessable().flatMap((Function1 & Serializable)order -> {
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.isOrderProcessable2((Order<Order.State>)order));
            return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> StateView.ifOrderProcessable$$anonfun$1$$anonfun$1(order));
        });
    }

    private boolean isOrderProcessable2(Order<Order.State> order) {
        return this.instruction(order.workflowPosition()) instanceof Execute && order.isAttached() && !this.isOrderAtStopPosition(order) && !this.isOrderAtBreakpoint(order) && !this.isWorkflowSuspended(order.workflowPath());
    }

    public static boolean isOrderAtStopPosition$(StateView $this, Order order) {
        return $this.isOrderAtStopPosition(order);
    }

    default public boolean isOrderAtStopPosition(Order<Order.State> order) {
        return order.stopPositions().nonEmpty() && ((Workflow)this.idToWorkflow().apply(order.workflowId())).isOrderAtStopPosition(order);
    }

    public static boolean isOrderAtBreakpoint$(StateView $this, Order order) {
        return $this.isOrderAtBreakpoint(order);
    }

    default public boolean isOrderAtBreakpoint(Order<Order.State> order) {
        return order.isState(ClassTag$.MODULE$.apply(Order.IsFreshOrReady.class)) && order.isSuspendibleNow() && !order.isResumed() && this.keyTo(WorkflowControl$.MODULE$).get(package$WorkflowControlId$.MODULE$.apply(order.workflowId())).exists((Function1 & Serializable)_$7 -> _$7.breakpoints().contains((Object)order.position().normalized()));
    }

    public static Either workflowJob$(StateView $this, WorkflowPosition workflowPosition) {
        return $this.workflowJob(workflowPosition);
    }

    default public Either<Problem, WorkflowJob> workflowJob(WorkflowPosition workflowPosition) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, workflowPosition.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> workflow.checkedWorkflowJob(workflowPosition.position()));
    }

    private Either<Problem, WorkflowJob> keyToJob(JobKey jobKey) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, jobKey.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)_$8 -> {
            MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(_$8.keyToJob());
            return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, jobKey, Tag$.MODULE$.apply(JobKey.class, LightTypeTag$.MODULE$.parse(-228237535, "\u0004\u0000\u0001\u0013js7.data.job.JobKey\u0001\u0001", "\u0000\u0000\u0000", 30)), FileName$.MODULE$.apply("StateView.scala"), Line$.MODULE$.apply(138));
        });
    }

    public static Either orderIdToBoardState$(StateView $this, OrderId orderId) {
        return $this.orderIdToBoardState(orderId);
    }

    default public Either<Problem, BoardState> orderIdToBoardState(OrderId orderId) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.idToOrder());
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, orderId, Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), FileName$.MODULE$.apply("StateView.scala"), Line$.MODULE$.apply(143)).flatMap((Function1 & Serializable)order -> this.instruction_(order.workflowPosition(), ClassTag$.MODULE$.apply(NoticeInstruction.class)).flatMap((Function1 & Serializable)instr -> {
            Left left;
            Vector vector = instr.referencedBoardPaths().toVector();
            SeqOps seqOps = package$.MODULE$.Vector().unapplySeq((SeqOps)vector);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0) {
                BoardPath boardPath2;
                BoardPath o = boardPath2 = (BoardPath)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                left = package$.MODULE$.Right().apply((Object)o);
            } else {
                left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Legacy orderIdToBoardState, but instruction has multiple BoardPaths"));
            }
            return left.flatMap((Function1 & Serializable)boardPath -> {
                MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.keyTo(BoardState$.MODULE$));
                return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, boardPath, Tag$.MODULE$.apply(BoardPath.class, LightTypeTag$.MODULE$.parse(1326589135, "\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0002\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0006\u0004\u0000\u0001\u0090\f\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001", 30)), FileName$.MODULE$.apply("StateView.scala"), Line$.MODULE$.apply(148));
            });
        }));
    }

    public static Either workflowPositionToLabel$(StateView $this, WorkflowPosition workflowPosition) {
        return $this.workflowPositionToLabel(workflowPosition);
    }

    default public Either<Problem, Option<Label>> workflowPositionToLabel(WorkflowPosition workflowPosition) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, workflowPosition.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> workflow.labeledInstruction(workflowPosition.position()).map((Function1 & Serializable)labeled -> labeled.maybeLabel()));
    }

    public static boolean childOrderIsJoinable$(StateView $this, Order order, Order parent) {
        return $this.childOrderIsJoinable(order, parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean childOrderIsJoinable(Order<Order.State> order, Order<Order.Forked> parent) {
        if (order.isSuspendedOrStopped()) return false;
        if (!order.isDetachedOrAttached()) return false;
        Option<Order.AttachedState> option = order.attachedState();
        Option<Order.AttachedState> option2 = parent.attachedState();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (order.state() == Order$FailedInFork$.MODULE$) return true;
        if (order.state() == Order$Cancelled$.MODULE$) return true;
        if (!order.isState(ClassTag$.MODULE$.apply(Order.Ready.class))) return false;
        if (!order.position().parent().contains((Object)parent.position())) return false;
        if (!(this.instruction(order.workflowPosition()) instanceof End)) return false;
        return true;
    }

    public static boolean isSuspendedOrStopped$(StateView $this, Order order) {
        return $this.isSuspendedOrStopped(order);
    }

    default public boolean isSuspendedOrStopped(Order<Order.State> order) {
        return order.isSuspendedOrStopped() || this.isWorkflowSuspended(order.workflowPath());
    }

    public static boolean isWorkflowSuspended$(StateView $this, WorkflowPath workflowPath) {
        return $this.isWorkflowSuspended(workflowPath);
    }

    default public boolean isWorkflowSuspended(WorkflowPath workflowPath) {
        return this.keyTo(WorkflowPathControl$.MODULE$).get((Object)WorkflowPathControlPath$.MODULE$.apply(workflowPath)).exists((Function1 & Serializable)_$9 -> ((WorkflowPathControl)_$9.item()).suspended());
    }

    public static Scope toPlanOrderScope$(StateView $this, MinimumOrder order) {
        return $this.toPlanOrderScope(order);
    }

    default public Scope toPlanOrderScope(MinimumOrder order) {
        return (Scope)package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)OrderScopes$.MODULE$.minimumOrderScope(order.id(), order, this.controllerId()), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)NamedValueScope$.MODULE$.apply(order.arguments()));
    }

    public static Either toOrderScope$(StateView $this, Order order) {
        return $this.toOrderScope(order);
    }

    default public Either<Problem, Scope> toOrderScope(Order<Order.State> order) {
        return this.toOrderScopes(order).map((Function1 & Serializable)_$10 -> _$10.pureOrderScope());
    }

    public static Either toImpureOrderExecutingScope$(StateView $this, Order order, Timestamp now) {
        return $this.toImpureOrderExecutingScope(order, now);
    }

    default public Either<Problem, Scope> toImpureOrderExecutingScope(Order<Order.State> order, Timestamp now) {
        return this.toOrderScopes(order).map((Function1 & Serializable)orderScopes -> {
            Scope nowScope = NowScope$.MODULE$.apply(now);
            return (Scope)package.semigroup$.MODULE$.catsSyntaxSemigroup(package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)orderScopes.pureOrderScope(), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)nowScope), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)JobResourceScope$.MODULE$.apply((PartialFunction<JobResourcePath, JobResource>)this.keyTo(JobResource$.MODULE$), (Scope)package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)orderScopes.variablelessOrderScope(), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)nowScope)));
        });
    }

    public static Either noticeScope$(StateView $this, Order order) {
        return $this.noticeScope(order);
    }

    default public Either<Problem, Scope> noticeScope(Order<Order.State> order) {
        return this.toOrderScopes(order).map((Function1 & Serializable)_$11 -> _$11.pureOrderScope());
    }

    public static Either toOrderScopes$(StateView $this, Order order) {
        return $this.toOrderScopes(order);
    }

    default public Either<Problem, OrderScopes> toOrderScopes(Order<Order.State> order) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(this.idToWorkflow());
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, order.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).map((Function1 & Serializable)_$12 -> OrderScopes$.MODULE$.apply(order, (Workflow)_$12, this.controllerId()));
    }

    public static Either foreachLockDemand$(StateView $this, Seq demands, Function2 op) {
        return $this.foreachLockDemand((Seq<OrderEvent.LockDemand>)demands, op);
    }

    default public <A> Either<Problem, Seq<A>> foreachLockDemand(Seq<OrderEvent.LockDemand> demands, Function2<LockState, Option<Object>, Either<Problem, A>> op) {
        return (Either)package.traverse$.MODULE$.toTraverseOps(demands, UnorderedFoldable$.MODULE$.catsTraverseForSeq()).traverse((Function1 & Serializable)demand -> {
            MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.keyTo(LockState$.MODULE$));
            return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, demand.lockPath(), Tag$.MODULE$.apply(LockPath.class, LightTypeTag$.MODULE$.parse(876090908, "\u0004\u0000\u0001\u0016js7.data.lock.LockPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0016js7.data.lock.LockPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0002\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 30)), FileName$.MODULE$.apply("StateView.scala"), Line$.MODULE$.apply(207)).flatMap((Function1 & Serializable)_$13 -> (Either)op.apply(_$13, demand.count()));
        }, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither());
    }

    public static Either foreachLock$(StateView $this, Seq lockPaths, Function1 op) {
        return $this.foreachLock((Seq<LockPath>)lockPaths, op);
    }

    default public <A> Either<Problem, Seq<A>> foreachLock(Seq<LockPath> lockPaths, Function1<LockState, Either<Problem, A>> op) {
        return (Either)package.traverse$.MODULE$.toTraverseOps(lockPaths, UnorderedFoldable$.MODULE$.catsTraverseForSeq()).traverse((Function1 & Serializable)lockPath -> {
            MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(this.keyTo(LockState$.MODULE$));
            return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, lockPath, Tag$.MODULE$.apply(LockPath.class, LightTypeTag$.MODULE$.parse(876090908, "\u0004\u0000\u0001\u0016js7.data.lock.LockPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0016js7.data.lock.LockPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0002\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 30)), FileName$.MODULE$.apply("StateView.scala"), Line$.MODULE$.apply(213)).flatMap(op);
        }, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither());
    }

    private static int jobToOrderCount$$anonfun$1() {
        return 0;
    }

    private static String left$proxy1$1$$anonfun$1(Iterable known$2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])known$2.toArray(ClassTag$.MODULE$.apply(OrderId.class)));
        return "Orders already exist: " + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(object, OrderId$.MODULE$.ordering())).mkString(", ");
    }

    private static Problem left$proxy1$1(Iterable known$1) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> StateView.left$proxy1$1$$anonfun$1(known$1)), Problem$.MODULE$.apply$default$2());
    }

    private static Problem checkOrdersDoNotExist$$anonfun$1(Iterable known$3) {
        return StateView.left$proxy1$1(known$3);
    }

    private static String left$proxy2$1$$anonfun$1(Iterable unknown$2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])unknown$2.toArray(ClassTag$.MODULE$.apply(OrderId.class)));
        return "Unknown Orders: " + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(object, OrderId$.MODULE$.ordering())).mkString(", ");
    }

    private static Problem left$proxy2$1(Iterable unknown$1) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> StateView.left$proxy2$1$$anonfun$1(unknown$1)), Problem$.MODULE$.apply$default$2());
    }

    private static Problem checkOrdersExist$$anonfun$1(Iterable unknown$3) {
        return StateView.left$proxy2$1(unknown$3);
    }

    private static Order ifOrderProcessable$$anonfun$1$$anonfun$1(Order order$1) {
        return order$1;
    }

    public static final class DummyStateView
    implements ItemContainer,
    EngineStateFunctions,
    StateView,
    Product,
    Serializable {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DummyStateView.class.getDeclaredField("pathToUnsignedSimpleItem$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DummyStateView.class.getDeclaredField("pathToSimpleItem$lzy1"));
        private volatile Object pathToSimpleItem$lzy1;
        private volatile Object pathToUnsignedSimpleItem$lzy1;
        private final boolean isAgent;
        private final ControllerId controllerId;
        private final Map<OrderId, Order<Order.State>> idToOrder;
        private final Iterable<Order<Order.State>> orders;
        private final EngineStateStatistics statistics;
        private final PartialFunction<VersionedItemId<WorkflowPath>, Workflow> idToWorkflow;
        private final MapView<UnsignedItemKey, UnsignedItemState> keyToUnsignedItemState;
        private final MapView<InventoryItemKey, InventoryItem> keyToItem;

        public static DummyStateView apply(boolean bl, ControllerId controllerId, Map<OrderId, Order<Order.State>> map, Iterable<Order<Order.State>> iterable, EngineStateStatistics engineStateStatistics, PartialFunction<VersionedItemId<WorkflowPath>, Workflow> partialFunction, MapView<UnsignedItemKey, UnsignedItemState> mapView, MapView<InventoryItemKey, InventoryItem> mapView2) {
            return StateView$DummyStateView$.MODULE$.apply(bl, controllerId, map, iterable, engineStateStatistics, partialFunction, mapView, mapView2);
        }

        public static DummyStateView fromProduct(Product product) {
            return StateView$DummyStateView$.MODULE$.fromProduct(product);
        }

        public static DummyStateView unapply(DummyStateView dummyStateView) {
            return StateView$DummyStateView$.MODULE$.unapply(dummyStateView);
        }

        public static boolean $lessinit$greater$default$1() {
            return StateView$DummyStateView$.MODULE$.$lessinit$greater$default$1();
        }

        public static ControllerId $lessinit$greater$default$2() {
            return StateView$DummyStateView$.MODULE$.$lessinit$greater$default$2();
        }

        public static Map<OrderId, Order<Order.State>> $lessinit$greater$default$3() {
            return StateView$DummyStateView$.MODULE$.$lessinit$greater$default$3();
        }

        public static Iterable<Order<Order.State>> $lessinit$greater$default$4() {
            return StateView$DummyStateView$.MODULE$.$lessinit$greater$default$4();
        }

        public static EngineStateStatistics $lessinit$greater$default$5() {
            return StateView$DummyStateView$.MODULE$.$lessinit$greater$default$5();
        }

        public static PartialFunction<VersionedItemId<WorkflowPath>, Workflow> $lessinit$greater$default$6() {
            return StateView$DummyStateView$.MODULE$.$lessinit$greater$default$6();
        }

        public static MapView<UnsignedItemKey, UnsignedItemState> $lessinit$greater$default$7() {
            return StateView$DummyStateView$.MODULE$.$lessinit$greater$default$7();
        }

        public static MapView<InventoryItemKey, InventoryItem> $lessinit$greater$default$8() {
            return StateView$DummyStateView$.MODULE$.$lessinit$greater$default$8();
        }

        public DummyStateView(boolean isAgent, ControllerId controllerId, Map<OrderId, Order<Order.State>> idToOrder, Iterable<Order<Order.State>> orders, EngineStateStatistics statistics, PartialFunction<VersionedItemId<WorkflowPath>, Workflow> idToWorkflow, MapView<UnsignedItemKey, UnsignedItemState> keyToUnsignedItemState, MapView<InventoryItemKey, InventoryItem> keyToItem) {
            this.isAgent = isAgent;
            this.controllerId = controllerId;
            this.idToOrder = idToOrder;
            this.orders = orders;
            this.statistics = statistics;
            this.idToWorkflow = idToWorkflow;
            this.keyToUnsignedItemState = keyToUnsignedItemState;
            this.keyToItem = keyToItem;
            ItemContainer.$init$(this);
        }

        public final MapView pathToSimpleItem() {
            Object object = this.pathToSimpleItem$lzy1;
            if (object instanceof MapView) {
                return (MapView)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (MapView)this.pathToSimpleItem$lzyINIT1();
        }

        private Object pathToSimpleItem$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.pathToSimpleItem$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        MapView mapView = null;
                        try {
                            mapView = ItemContainer.pathToSimpleItem$(this);
                            object2 = mapView == null ? LazyVals.NullValue$.MODULE$ : mapView;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.pathToSimpleItem$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return mapView;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public final MapView pathToUnsignedSimpleItem() {
            Object object = this.pathToUnsignedSimpleItem$lzy1;
            if (object instanceof MapView) {
                return (MapView)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (MapView)this.pathToUnsignedSimpleItem$lzyINIT1();
        }

        private Object pathToUnsignedSimpleItem$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.pathToUnsignedSimpleItem$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        MapView mapView = null;
                        try {
                            mapView = ItemContainer.pathToUnsignedSimpleItem$(this);
                            object2 = mapView == null ? LazyVals.NullValue$.MODULE$ : mapView;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.pathToUnsignedSimpleItem$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return mapView;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)514090798);
            n = Statics.mix((int)n, (int)(this.isAgent() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.controllerId()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.idToOrder()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.orders()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.statistics()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.idToWorkflow()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keyToUnsignedItemState()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keyToItem()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            DummyStateView dummyStateView;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DummyStateView)) return false;
            DummyStateView dummyStateView2 = dummyStateView = (DummyStateView)object;
            if (this.isAgent() != dummyStateView2.isAgent()) return false;
            ControllerId controllerId = this.controllerId();
            ControllerId controllerId2 = dummyStateView2.controllerId();
            if (controllerId == null) {
                if (controllerId2 != null) {
                    return false;
                }
            } else if (!((Object)controllerId).equals(controllerId2)) return false;
            Map<OrderId, Order<Order.State>> map = this.idToOrder();
            Map<OrderId, Order<Order.State>> map2 = dummyStateView2.idToOrder();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Iterable<Order<Order.State>> iterable = this.orders();
            Iterable<Order<Order.State>> iterable2 = dummyStateView2.orders();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            EngineStateStatistics engineStateStatistics = this.statistics();
            EngineStateStatistics engineStateStatistics2 = dummyStateView2.statistics();
            if (engineStateStatistics == null) {
                if (engineStateStatistics2 != null) {
                    return false;
                }
            } else if (!((Object)engineStateStatistics).equals(engineStateStatistics2)) return false;
            PartialFunction<VersionedItemId<WorkflowPath>, Workflow> partialFunction = this.idToWorkflow();
            PartialFunction<VersionedItemId<WorkflowPath>, Workflow> partialFunction2 = dummyStateView2.idToWorkflow();
            if (partialFunction == null) {
                if (partialFunction2 != null) {
                    return false;
                }
            } else if (!partialFunction.equals(partialFunction2)) return false;
            MapView<UnsignedItemKey, UnsignedItemState> mapView = this.keyToUnsignedItemState();
            MapView<UnsignedItemKey, UnsignedItemState> mapView2 = dummyStateView2.keyToUnsignedItemState();
            if (mapView == null) {
                if (mapView2 != null) {
                    return false;
                }
            } else if (!mapView.equals(mapView2)) return false;
            MapView<InventoryItemKey, InventoryItem> mapView3 = this.keyToItem();
            MapView<InventoryItemKey, InventoryItem> mapView4 = dummyStateView2.keyToItem();
            if (mapView3 == null) {
                if (mapView4 == null) return true;
                return false;
            } else {
                if (!mapView3.equals(mapView4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DummyStateView;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "DummyStateView";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "isAgent";
                }
                case 1: {
                    return "controllerId";
                }
                case 2: {
                    return "idToOrder";
                }
                case 3: {
                    return "orders";
                }
                case 4: {
                    return "statistics";
                }
                case 5: {
                    return "idToWorkflow";
                }
                case 6: {
                    return "keyToUnsignedItemState";
                }
                case 7: {
                    return "keyToItem";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public boolean isAgent() {
            return this.isAgent;
        }

        @Override
        public ControllerId controllerId() {
            return this.controllerId;
        }

        @Override
        public Map<OrderId, Order<Order.State>> idToOrder() {
            return this.idToOrder;
        }

        @Override
        public Iterable<Order<Order.State>> orders() {
            return this.orders;
        }

        @Override
        public EngineStateStatistics statistics() {
            return this.statistics;
        }

        @Override
        public PartialFunction<VersionedItemId<WorkflowPath>, Workflow> idToWorkflow() {
            return this.idToWorkflow;
        }

        @Override
        public MapView<UnsignedItemKey, UnsignedItemState> keyToUnsignedItemState() {
            return this.keyToUnsignedItemState;
        }

        @Override
        public MapView<InventoryItemKey, InventoryItem> keyToItem() {
            return this.keyToItem;
        }

        @Override
        public ClusterState clusterState() {
            return ClusterState$Empty$.MODULE$;
        }

        @Override
        public Either<Problem, VersionedItemId<WorkflowPath>> workflowPathToId(WorkflowPath workflowPath) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("DummyStateView"));
        }

        public DummyStateView copy(boolean isAgent, ControllerId controllerId, Map<OrderId, Order<Order.State>> idToOrder, Iterable<Order<Order.State>> orders, EngineStateStatistics statistics, PartialFunction<VersionedItemId<WorkflowPath>, Workflow> idToWorkflow, MapView<UnsignedItemKey, UnsignedItemState> keyToUnsignedItemState, MapView<InventoryItemKey, InventoryItem> keyToItem) {
            return new DummyStateView(isAgent, controllerId, idToOrder, orders, statistics, idToWorkflow, keyToUnsignedItemState, keyToItem);
        }

        public boolean copy$default$1() {
            return this.isAgent();
        }

        public ControllerId copy$default$2() {
            return this.controllerId();
        }

        public Map<OrderId, Order<Order.State>> copy$default$3() {
            return this.idToOrder();
        }

        public Iterable<Order<Order.State>> copy$default$4() {
            return this.orders();
        }

        public EngineStateStatistics copy$default$5() {
            return this.statistics();
        }

        public PartialFunction<VersionedItemId<WorkflowPath>, Workflow> copy$default$6() {
            return this.idToWorkflow();
        }

        public MapView<UnsignedItemKey, UnsignedItemState> copy$default$7() {
            return this.keyToUnsignedItemState();
        }

        public MapView<InventoryItemKey, InventoryItem> copy$default$8() {
            return this.keyToItem();
        }

        public boolean _1() {
            return this.isAgent();
        }

        public ControllerId _2() {
            return this.controllerId();
        }

        public Map<OrderId, Order<Order.State>> _3() {
            return this.idToOrder();
        }

        public Iterable<Order<Order.State>> _4() {
            return this.orders();
        }

        public EngineStateStatistics _5() {
            return this.statistics();
        }

        public PartialFunction<VersionedItemId<WorkflowPath>, Workflow> _6() {
            return this.idToWorkflow();
        }

        public MapView<UnsignedItemKey, UnsignedItemState> _7() {
            return this.keyToUnsignedItemState();
        }

        public MapView<InventoryItemKey, InventoryItem> _8() {
            return this.keyToItem();
        }
    }
}

