/*
 * Decompiled with CFR 0.152.
 */
package js7.data.workflow;

import cats.Show;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.io.process.KeyLogin;
import js7.base.io.process.ReturnCode;
import js7.base.parser.BasicPrinter$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.RangeSet;
import js7.base.utils.RangeSet$Interval$;
import js7.base.utils.RangeSet$Single$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.data.agent.AgentPath;
import js7.data.job.CommandLineExecutable;
import js7.data.job.CommandLineExecutable$;
import js7.data.job.CommandLineExpression;
import js7.data.job.Executable;
import js7.data.job.InternalExecutable;
import js7.data.job.InternalExecutable$;
import js7.data.job.PathExecutable;
import js7.data.job.PathExecutable$;
import js7.data.job.ProcessExecutable;
import js7.data.job.ReturnCodeMeaning;
import js7.data.job.ReturnCodeMeaning$;
import js7.data.job.ReturnCodeMeaning$Failure$;
import js7.data.job.ReturnCodeMeaning$Success$;
import js7.data.job.ShellScriptExecutable;
import js7.data.job.ShellScriptExecutable$;
import js7.data.lock.LockPath;
import js7.data.lock.LockPath$;
import js7.data.order.OrderEvent;
import js7.data.order.OrderEvent$LockDemand$;
import js7.data.order.OrderOutcome;
import js7.data.source.SourcePos;
import js7.data.value.Value;
import js7.data.value.ValuePrinter$;
import js7.data.value.expression.Expression;
import js7.data.workflow.Instruction;
import js7.data.workflow.Workflow;
import js7.data.workflow.WorkflowPrinter$;
import js7.data.workflow.instructions.EmptyInstruction;
import js7.data.workflow.instructions.EmptyInstruction$;
import js7.data.workflow.instructions.Execute;
import js7.data.workflow.instructions.Execute$Anonymous$;
import js7.data.workflow.instructions.Execute$Named$;
import js7.data.workflow.instructions.ExplicitEnd;
import js7.data.workflow.instructions.ExplicitEnd$;
import js7.data.workflow.instructions.Fail;
import js7.data.workflow.instructions.Fail$;
import js7.data.workflow.instructions.Finish;
import js7.data.workflow.instructions.Finish$;
import js7.data.workflow.instructions.Fork;
import js7.data.workflow.instructions.Fork$;
import js7.data.workflow.instructions.Gap;
import js7.data.workflow.instructions.Gap$;
import js7.data.workflow.instructions.If;
import js7.data.workflow.instructions.If$;
import js7.data.workflow.instructions.If$IfThen$;
import js7.data.workflow.instructions.ImplicitEnd;
import js7.data.workflow.instructions.Instructions$;
import js7.data.workflow.instructions.LockInstruction;
import js7.data.workflow.instructions.LockInstruction$;
import js7.data.workflow.instructions.Retry;
import js7.data.workflow.instructions.Retry$;
import js7.data.workflow.instructions.TryInstruction;
import js7.data.workflow.instructions.TryInstruction$;
import js7.data.workflow.instructions.executable.WorkflowJob;
import js7.data.workflow.instructions.executable.WorkflowJob$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public final class WorkflowPrinter {
    private final StringBuilder sb;

    public static Show<Workflow> WorkflowShow() {
        return WorkflowPrinter$.MODULE$.WorkflowShow();
    }

    public static String instructionToString(Instruction instruction) {
        return WorkflowPrinter$.MODULE$.instructionToString(instruction);
    }

    public static String namedValuesToString(Map<String, Value> map) {
        return WorkflowPrinter$.MODULE$.namedValuesToString(map);
    }

    public static String print(Workflow workflow) {
        return WorkflowPrinter$.MODULE$.print(workflow);
    }

    public WorkflowPrinter(StringBuilder sb) {
        this.sb = sb;
    }

    public void appendQuoted(String string) {
        ValuePrinter$.MODULE$.appendQuoted(this.sb, string);
    }

    public Object appendQuotedExpression(String string) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(string), '\n')) {
            if (!StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(string), '\'')) {
                return this.sb.append('\'').append(string).append('\'');
            }
            this.q$1(string, "''");
            return BoxedUnit.UNIT;
        }
        this.appendQuoted(string);
        return BoxedUnit.UNIT;
    }

    public void appendNamedValues(Map<String, Value> namedValues) {
        WorkflowPrinter$.MODULE$.js7$data$workflow$WorkflowPrinter$$$appendNamedValues(this.sb, namedValues);
    }

    public void appendNameToExpression(Map<String, Expression> nameToExpression) {
        ValuePrinter$.MODULE$.appendNameToExpression(this.sb, nameToExpression);
    }

    public void indent(int nesting) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nesting).foreach((Function1 & Serializable)x$1 -> this.indent$$anonfun$1(BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public void appendWorkflowExecutable(WorkflowJob job) {
        this.sb.$plus$plus$eq("agent=");
        this.appendQuoted(job.agentPath().string());
        if (job.processLimit() != WorkflowJob$.MODULE$.DefaultProcessLimit()) {
            this.sb.$plus$plus$eq(", processLimit=");
            this.sb.append(job.processLimit());
        }
        if (job.defaultArguments().nonEmpty()) {
            this.sb.$plus$plus$eq(", defaultArguments=");
            this.appendNameToExpression(job.defaultArguments());
        }
        job.sigkillDelay().foreach((Function1 & Serializable)o -> {
            this.sb.append(", sigkillDelay=");
            return this.sb.append((Object)ScalaTime$RichFiniteDuration$.MODULE$.toBigDecimalSeconds$extension(ScalaTime$.MODULE$.RichFiniteDuration((FiniteDuration)o)));
        });
        Executable executable = job.executable();
        if (executable instanceof ProcessExecutable) {
            PathExecutable pathExecutable;
            Some<Tuple5<String, Map<String, Expression>, ReturnCodeMeaning, Option<KeyLogin>, Object>> some;
            ProcessExecutable processExecutable;
            ProcessExecutable executable2 = processExecutable = (ProcessExecutable)executable;
            ReturnCodeMeaning returnCodeMeaning = executable2.returnCodeMeaning();
            ReturnCodeMeaning returnCodeMeaning2 = ReturnCodeMeaning$.MODULE$.Default();
            ReturnCodeMeaning returnCodeMeaning3 = returnCodeMeaning;
            if (!(returnCodeMeaning2 != null ? !returnCodeMeaning2.equals(returnCodeMeaning3) : returnCodeMeaning3 != null)) {
                v1 = BoxedUnit.UNIT;
            } else if (returnCodeMeaning instanceof ReturnCodeMeaning.Success) {
                RangeSet<ReturnCode> rangeSet;
                ReturnCodeMeaning.Success success = (ReturnCodeMeaning.Success)returnCodeMeaning;
                ReturnCodeMeaning.Success success2 = ReturnCodeMeaning$Success$.MODULE$.unapply(success);
                RangeSet<ReturnCode> returnCodes = rangeSet = success2._1();
                this.sb.$plus$plus$eq(", successReturnCodes=[");
                this.sb.$plus$plus$eq(((IterableOnceOps)returnCodes.ranges().map((Function1 & Serializable)x$1 -> {
                    RangeSet.Range range = x$1;
                    if (range instanceof RangeSet.Single) {
                        ReturnCode returnCode;
                        RangeSet.Single single = (RangeSet.Single)range;
                        RangeSet.Single single2 = RangeSet$Single$.MODULE$.unapply(single);
                        ReturnCode a = returnCode = (ReturnCode)single2._1();
                        return BoxesRunTime.boxToInteger((int)a.number());
                    }
                    if (range instanceof RangeSet.Interval) {
                        RangeSet.Interval interval = (RangeSet.Interval)range;
                        RangeSet.Interval interval2 = RangeSet$Interval$.MODULE$.unapply(interval);
                        ReturnCode returnCode = (ReturnCode)interval2._1();
                        ReturnCode returnCode2 = (ReturnCode)interval2._2();
                        ReturnCode a = returnCode;
                        ReturnCode b = returnCode2;
                        return a.number() + ".." + b.number();
                    }
                    throw new MatchError((Object)range);
                })).mkString(", "));
                v1 = this.sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)']'));
            } else if (returnCodeMeaning instanceof ReturnCodeMeaning.Failure) {
                RangeSet<ReturnCode> rangeSet;
                ReturnCodeMeaning.Failure failure = (ReturnCodeMeaning.Failure)returnCodeMeaning;
                ReturnCodeMeaning.Failure failure2 = ReturnCodeMeaning$Failure$.MODULE$.unapply(failure);
                RangeSet<ReturnCode> returnCodes = rangeSet = failure2._1();
                this.sb.$plus$plus$eq(", failureReturnCodes=[");
                this.sb.$plus$plus$eq(((IterableOnceOps)returnCodes.ranges().map((Function1 & Serializable)x$1 -> {
                    RangeSet.Range range = x$1;
                    if (range instanceof RangeSet.Single) {
                        ReturnCode returnCode;
                        RangeSet.Single single = (RangeSet.Single)range;
                        RangeSet.Single single2 = RangeSet$Single$.MODULE$.unapply(single);
                        ReturnCode a = returnCode = (ReturnCode)single2._1();
                        return BoxesRunTime.boxToInteger((int)a.number());
                    }
                    if (range instanceof RangeSet.Interval) {
                        RangeSet.Interval interval = (RangeSet.Interval)range;
                        RangeSet.Interval interval2 = RangeSet$Interval$.MODULE$.unapply(interval);
                        ReturnCode returnCode = (ReturnCode)interval2._1();
                        ReturnCode returnCode2 = (ReturnCode)interval2._2();
                        ReturnCode a = returnCode;
                        ReturnCode b = returnCode2;
                        return a.number() + ".." + b.number();
                    }
                    throw new MatchError((Object)range);
                })).mkString(", "));
                v1 = this.sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)']'));
            } else {
                throw new MatchError((Object)returnCodeMeaning);
            }
            ProcessExecutable processExecutable2 = executable2;
            if (processExecutable2 instanceof PathExecutable && !(some = PathExecutable$.MODULE$.unapply(pathExecutable = (PathExecutable)processExecutable2)).isEmpty()) {
                Tuple5 tuple5 = (Tuple5)some.get();
                String path = (String)tuple5._1();
                Map envExpr = (Map)tuple5._2();
                Option login = (Option)tuple5._4();
                boolean v1Compatible = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                if (v1Compatible) {
                    this.sb.$plus$plus$eq(", v1Compatible=true");
                }
                this.appendEnv((Map<String, Expression>)envExpr);
                this.sb.$plus$plus$eq(", executable=");
                this.appendQuoted(path);
                return;
            }
            if (processExecutable2 instanceof ShellScriptExecutable) {
                ShellScriptExecutable shellScriptExecutable = (ShellScriptExecutable)processExecutable2;
                ShellScriptExecutable shellScriptExecutable2 = ShellScriptExecutable$.MODULE$.unapply(shellScriptExecutable);
                String string = shellScriptExecutable2._1();
                Map<String, Expression> map = shellScriptExecutable2._2();
                Option<KeyLogin> option = shellScriptExecutable2._3();
                ReturnCodeMeaning returnCodeMeaning4 = shellScriptExecutable2._4();
                boolean bl = shellScriptExecutable2._5();
                String script = string;
                Map<String, Expression> envExpr = map;
                ReturnCodeMeaning login = returnCodeMeaning4;
                boolean v1Compatible = bl;
                if (v1Compatible) {
                    this.sb.$plus$plus$eq(", v1Compatible=true");
                }
                this.appendEnv(envExpr);
                this.sb.$plus$plus$eq(", script=");
                this.appendQuotedExpression(script);
                return;
            }
            if (processExecutable2 instanceof CommandLineExecutable) {
                CommandLineExecutable commandLineExecutable = (CommandLineExecutable)processExecutable2;
                CommandLineExecutable commandLineExecutable2 = CommandLineExecutable$.MODULE$.unapply(commandLineExecutable);
                CommandLineExpression commandLineExpression = commandLineExecutable2._1();
                Map<String, Expression> map = commandLineExecutable2._2();
                Option<KeyLogin> option = commandLineExecutable2._3();
                ReturnCodeMeaning returnCodeMeaning5 = commandLineExecutable2._4();
                CommandLineExpression command = commandLineExpression;
                Map<String, Expression> envExpr = map;
                ReturnCodeMeaning login = returnCodeMeaning5;
                this.appendEnv(envExpr);
                this.sb.$plus$plus$eq(", command=");
                this.appendQuoted(command.toString());
                return;
            }
            throw new MatchError((Object)processExecutable2);
        }
        if (executable instanceof InternalExecutable) {
            InternalExecutable internalExecutable = (InternalExecutable)executable;
            InternalExecutable internalExecutable2 = InternalExecutable$.MODULE$.unapply(internalExecutable);
            String string = internalExecutable2._1();
            String string2 = internalExecutable2._2();
            Map<String, Expression> map = internalExecutable2._3();
            Map<String, Expression> map2 = internalExecutable2._4();
            String className = string;
            String script = string2;
            Map<String, Expression> jobArguments = map;
            Map<String, Expression> arguments = map2;
            this.sb.$plus$plus$eq(", internalJobClass=");
            this.appendQuoted(className);
            if (jobArguments.nonEmpty()) {
                this.sb.$plus$plus$eq(", jobArguments=");
                this.appendNameToExpression(jobArguments);
            }
            if (arguments.nonEmpty()) {
                this.sb.$plus$plus$eq(", arguments=");
                this.appendNameToExpression(arguments);
                return;
            }
            return;
        }
        throw new MatchError((Object)executable);
    }

    public void appendEnv(Map<String, Expression> env) {
        if (env.nonEmpty()) {
            this.sb.append(", env=");
            this.appendNameToExpression(env);
            return;
        }
    }

    public void appendWorkflowContent(int nesting, Workflow workflow) {
        workflow.labeledInstructions().withFilter((Function1 & Serializable)labeled -> !(labeled.instruction() instanceof ImplicitEnd)).foreach((Function1)(JProcedure1 & Serializable)labeled -> this.appendLabeledInstruction(nesting, (Instruction.Labeled)labeled));
        if (workflow.nameToJob().nonEmpty()) {
            this.sb.$plus$plus$eq("\n");
        }
        workflow.nameToJob().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            WorkflowJob.Name name = (WorkflowJob.Name)tuple2._1();
            WorkflowJob job = (WorkflowJob)tuple2._2();
            this.indent(nesting);
            this.sb.$plus$plus$eq("define job ");
            this.appendIdentifier(name.string());
            this.sb.$plus$plus$eq(" {\n");
            this.indent(nesting + 1);
            this.sb.$plus$plus$eq("execute ");
            this.appendWorkflowExecutable(job);
            this.sb.$plus$plus$eq("\n");
            this.indent(nesting);
            return this.sb.$plus$plus$eq("}\n");
        });
    }

    public void appendLabeledInstruction(int nesting, Instruction.Labeled labeled) {
        this.indent(nesting);
        labeled.maybeLabel().foreach((Function1 & Serializable)label -> {
            this.appendIdentifier(label.string());
            return this.sb.$plus$plus$eq(": ");
        });
        Instruction instruction = labeled.instruction();
        if (instruction instanceof ExplicitEnd) {
            ExplicitEnd explicitEnd = (ExplicitEnd)instruction;
            ExplicitEnd explicitEnd2 = ExplicitEnd$.MODULE$.unapply(explicitEnd);
            Option<SourcePos> option = explicitEnd2._1();
            this.sb.$plus$plus$eq("end;\n");
            return;
        }
        if (instruction instanceof Execute.Anonymous) {
            Execute.Anonymous anonymous = (Execute.Anonymous)instruction;
            Execute.Anonymous anonymous2 = Execute$Anonymous$.MODULE$.unapply(anonymous);
            WorkflowJob workflowJob = anonymous2._1();
            Map<String, Expression> map = anonymous2._2();
            Option<SourcePos> option = anonymous2._3();
            WorkflowJob workflowExecutable = workflowJob;
            this.sb.$plus$plus$eq("execute ");
            this.appendWorkflowExecutable(workflowExecutable);
            this.sb.$plus$plus$eq(";\n");
            return;
        }
        if (instruction instanceof Execute.Named) {
            Execute.Named named = (Execute.Named)instruction;
            Execute.Named named2 = Execute$Named$.MODULE$.unapply(named);
            WorkflowJob.Name name = named2._1();
            Map<String, Expression> map = named2._2();
            Option<SourcePos> option = named2._3();
            WorkflowJob.Name name2 = name;
            Map<String, Expression> defaultArguments = map;
            this.sb.$plus$plus$eq("job ");
            this.appendIdentifier(name2.string());
            if (defaultArguments.nonEmpty()) {
                this.sb.$plus$plus$eq(", defaultArguments=");
                this.appendNameToExpression(defaultArguments);
            }
            this.sb.$plus$plus$eq(";\n");
            return;
        }
        if (instruction instanceof Fail) {
            Fail fail = (Fail)instruction;
            Fail fail2 = Fail$.MODULE$.unapply(fail);
            Option<Expression> option = fail2._1();
            Map<String, Value> map = fail2._2();
            boolean bl = fail2._3();
            Option<SourcePos> option2 = fail2._4();
            Option<Expression> maybeErrorMessage = option;
            Map<String, Value> namedValues = map;
            boolean uncatchable = bl;
            this.sb.$plus$plus$eq("fail");
            if (maybeErrorMessage.isDefined() || namedValues.nonEmpty()) {
                boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(uncatchable);
                boolean RichBoolean_this2 = ScalaUtils$syntax$.MODULE$.RichBoolean(namedValues.nonEmpty());
                this.sb.$plus$plus$eq(((IterableOnceOps)((IterableOps)Option$.MODULE$.option2Iterable(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, WorkflowPrinter::appendLabeledInstruction$$anonfun$2)).$plus$plus((IterableOnce)maybeErrorMessage.map((Function1 & Serializable)o -> "message=" + o.toString()))).$plus$plus(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this2, () -> WorkflowPrinter.appendLabeledInstruction$$anonfun$4(namedValues)))).mkString(" (", ", ", ")"));
            }
            this.sb.$plus$plus$eq(";\n");
            return;
        }
        if (instruction instanceof LockInstruction) {
            LockInstruction lockInstruction = (LockInstruction)instruction;
            LockInstruction lockInstruction2 = LockInstruction$.MODULE$.unapply(lockInstruction);
            List<OrderEvent.LockDemand> list = lockInstruction2._1();
            Workflow workflow = lockInstruction2._2();
            Option<SourcePos> option = lockInstruction2._3();
            SeqOps seqOps = scala.package$.MODULE$.Seq().unapplySeq(list);
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0) {
                String string;
                OrderEvent.LockDemand lockDemand = (OrderEvent.LockDemand)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                OrderEvent.LockDemand lockDemand2 = OrderEvent$LockDemand$.MODULE$.unapply(lockDemand);
                LockPath lockPath = lockDemand2._1();
                Option<Object> option3 = lockDemand2._2();
                LockPath lockPath2 = LockPath$.MODULE$.unapply(lockPath);
                String lockPath3 = string = lockPath2._1();
                Option<Object> maybeCount = option3;
                Workflow lockedWorkflow = workflow;
                this.sb.$plus$plus$eq("lock (lock=");
                this.appendQuoted(lockPath3);
                maybeCount.foreach((Function1 & Serializable)n -> this.appendLabeledInstruction$$anonfun$5(BoxesRunTime.unboxToInt((Object)n)));
                this.sb.$plus$plus$eq(") {\n");
                this.indent(nesting + 1);
                this.appendWorkflowContent(nesting + 1, lockedWorkflow);
                this.indent(nesting);
                this.sb.$plus$plus$eq("};\n");
                return;
            }
        }
        if (instruction instanceof Finish) {
            Finish finish = (Finish)instruction;
            Finish finish2 = Finish$.MODULE$.unapply(finish);
            Option<OrderOutcome.Completed> option = finish2._1();
            Option<SourcePos> option4 = finish2._2();
            this.sb.$plus$plus$eq("finish;\n");
            return;
        }
        if (instruction instanceof Fork) {
            Fork fork = (Fork)instruction;
            Fork fork2 = Fork$.MODULE$.unapply(fork);
            Vector<Fork.Branch> vector = fork2._1();
            Option<AgentPath> option = fork2._2();
            boolean bl = fork2._3();
            Option<SourcePos> option5 = fork2._4();
            Vector<Fork.Branch> branches = vector;
            Option<AgentPath> agentPath = option;
            boolean joinIfFailed = bl;
            this.sb.$plus$plus$eq("fork");
            if (joinIfFailed) {
                this.sb.append(" (");
                this.sb.append("joinIfFailed=");
                this.sb.append(joinIfFailed);
                this.sb.append(')');
            }
            this.sb.$plus$plus$eq(" {\n");
            branches.take(branches.length() - 1).foreach((Function1 & Serializable)b -> {
                this.appendBranch$1(nesting, (Fork.Branch)b);
                return this.sb.append(",\n");
            });
            this.appendBranch$1(nesting, (Fork.Branch)branches.last());
            this.sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
            this.indent(nesting);
            this.sb.$plus$plus$eq("};\n");
            return;
        }
        if (instruction instanceof Gap) {
            Gap gap = (Gap)instruction;
            Gap gap2 = Gap$.MODULE$.unapply(gap);
            Option<SourcePos> option = gap2._1();
            this.sb.$plus$plus$eq("/*gap*/\n");
            return;
        }
        if (instruction instanceof EmptyInstruction) {
            EmptyInstruction emptyInstruction = (EmptyInstruction)instruction;
            EmptyInstruction emptyInstruction2 = EmptyInstruction$.MODULE$.unapply(emptyInstruction);
            Option<SourcePos> option = emptyInstruction2._1();
            this.sb.$plus$plus$eq("/*empty*/\n");
            return;
        }
        if (instruction instanceof If) {
            If if_ = (If)instruction;
            If if_2 = If$.MODULE$.unapply(if_);
            Vector vector = if_2._1();
            Option<Workflow> option = if_2._2();
            Option<SourcePos> option6 = if_2._3();
            Vector ifThens = vector;
            Option<Workflow> elseWorkflow = option;
            ((Vector)ifThens.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                If.IfThen ifThen = If$IfThen$.MODULE$.unapply((If.IfThen)tuple2._1());
                Expression expression = ifThen._1();
                Workflow workflow = ifThen._2();
                Expression predicate = expression;
                Workflow then_ = workflow;
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (i > 0) {
                    this.sb.$plus$plus$eq(" else ");
                }
                this.sb.$plus$plus$eq("if (");
                this.sb.$plus$plus$eq(predicate.toString());
                this.sb.$plus$plus$eq(") {\n");
                this.appendWorkflowContent(nesting + 1, then_);
                this.indent(nesting);
                return this.sb.$plus$plus$eq("}");
            });
            Option<Workflow> option7 = elseWorkflow;
            if (None$.MODULE$.equals(option7)) {
                this.sb.$plus$plus$eq("\n");
                return;
            }
            if (option7 instanceof Some) {
                Some some = (Some)option7;
                Workflow els = (Workflow)some.value();
                this.sb.$plus$plus$eq(" else {\n");
                this.appendWorkflowContent(nesting + 1, els);
                this.indent(nesting);
                this.sb.$plus$plus$eq("}\n");
                return;
            }
            throw new MatchError(option7);
        }
        if (instruction instanceof TryInstruction) {
            TryInstruction tryInstruction = (TryInstruction)instruction;
            TryInstruction tryInstruction2 = TryInstruction$.MODULE$.unapply(tryInstruction);
            Workflow workflow = tryInstruction2._1();
            Workflow workflow2 = tryInstruction2._2();
            Option<IndexedSeq<FiniteDuration>> option = tryInstruction2._3();
            Option<Object> option8 = tryInstruction2._4();
            Option<SourcePos> option9 = tryInstruction2._5();
            Workflow tryWorkflow = workflow;
            Workflow catchWorkflow = workflow2;
            Option<IndexedSeq<FiniteDuration>> retryDelays = option;
            Option<Object> maxTries = option8;
            this.sb.$plus$plus$eq("try ");
            if (retryDelays.isDefined() || maxTries.isDefined()) {
                this.sb.$plus$plus$eq(((IterableOnceOps)Option$.MODULE$.option2Iterable(retryDelays.map((Function1 & Serializable)delays -> "retryDelays=" + ((IterableOnceOps)delays.map((Function1 & Serializable)_$1 -> ScalaTime$RichFiniteDuration$.MODULE$.toBigDecimalSeconds$extension(ScalaTime$.MODULE$.RichFiniteDuration((FiniteDuration)_$1)).toString())).mkString("[", ", ", "]"))).$plus$plus((IterableOnce)maxTries.map((Function1 & Serializable)n -> WorkflowPrinter.appendLabeledInstruction$$anonfun$9(BoxesRunTime.unboxToInt((Object)n))))).mkString("(", ", ", ")"));
            }
            this.sb.$plus$plus$eq("{\n");
            this.appendWorkflowContent(nesting + 1, tryWorkflow);
            this.indent(nesting);
            this.sb.$plus$plus$eq("} catch {\n");
            this.appendWorkflowContent(nesting + 1, catchWorkflow);
            this.indent(nesting);
            this.sb.$plus$plus$eq("}\n");
            return;
        }
        if (instruction instanceof Retry) {
            Retry retry = (Retry)instruction;
            Retry retry2 = Retry$.MODULE$.unapply(retry);
            Option<SourcePos> option = retry2._1();
            this.sb.$plus$plus$eq("retry");
            this.sb.$plus$plus$eq("\n");
            return;
        }
        Instruction instruction2 = instruction;
        Instruction instruction3 = (Instruction)package$.MODULE$.EncoderOps((Object)instruction2);
        this.sb.$plus$plus$eq(CirceUtils$RichJson$.MODULE$.compactPrint$extension(CirceUtils$.MODULE$.RichJson(package.EncoderOps$.MODULE$.asJson$extension((Object)instruction3, Instructions$.MODULE$.jsonCodec()))));
    }

    private void appendIdentifier(String identifier) {
        BasicPrinter$.MODULE$.appendIdentifier(this.sb, identifier);
    }

    private static final /* synthetic */ String q$1$$anonfun$1(String quote$tailLocal1$1, String o) {
        return o + "\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), quote$tailLocal1$1.length() - 1) + "|";
    }

    private final void q$1(String string$1, String quote) {
        while (string$1.contains((CharSequence)quote)) {
            quote = (String)quote + "'";
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(string$1), '\n'));
        this.sb.append('\n').append((String)quote).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, arg_0 -> WorkflowPrinter.q$1$$anonfun$1((String)quote, arg_0), ClassTag$.MODULE$.apply(String.class))).mkString()).append((String)quote).append(".stripMargin");
    }

    private final /* synthetic */ StringBuilder indent$$anonfun$1(int x$1) {
        int n = x$1;
        return this.sb.$plus$plus$eq("  ");
    }

    private static final String appendLabeledInstruction$$anonfun$2() {
        return "uncatchable=true";
    }

    private static final String a$proxy1$1(Map namedValues$1) {
        return "namedValues=" + WorkflowPrinter$.MODULE$.namedValuesToString((Map<String, Value>)namedValues$1);
    }

    private static final String appendLabeledInstruction$$anonfun$4(Map namedValues$2) {
        return WorkflowPrinter.a$proxy1$1(namedValues$2);
    }

    private final /* synthetic */ StringBuilder appendLabeledInstruction$$anonfun$5(int n) {
        this.sb.$plus$plus$eq(", count=");
        return this.sb.append(n);
    }

    private final StringBuilder appendBranch$1(int nesting$3, Fork.Branch branch) {
        this.indent(nesting$3 + 1);
        this.appendQuoted(branch.id().string());
        this.sb.$plus$plus$eq(": {\n");
        this.appendWorkflowContent(nesting$3 + 2, branch.workflow());
        this.indent(nesting$3 + 1);
        return (StringBuilder)this.sb.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'}'));
    }

    private static final /* synthetic */ String appendLabeledInstruction$$anonfun$9(int n) {
        return "maxTries=" + BoxesRunTime.boxToInteger((int)n).toString();
    }
}

