/*
 * Decompiled with CFR 0.152.
 */
package js7.journal;

import cats.FlatMap;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.DeferredSink;
import cats.effect.kernel.DeferredSource;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.effect.std.Queue;
import cats.effect.unsafe.IORuntime;
import cats.syntax.FlatMapIdOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler$;
import fs2.concurrent.SignallingRef;
import izumi.reflect.Tag;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.auth.UserId;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.log.Logger$package$Logger$syntax$;
import js7.base.metering.CallMeter;
import js7.base.monixutils.AsyncVariable;
import js7.base.monixutils.AsyncVariable$;
import js7.base.monixutils.Switch;
import js7.base.monixutils.Switch$;
import js7.base.problem.Problem;
import js7.base.scalasource.ScalaSourceLocation$;
import js7.base.service.Problems$ServiceStoppedProblem$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichLong$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.ScalaTime$RichFiniteDurationCompanion$;
import js7.base.time.Timestamp;
import js7.base.time.WallClock;
import js7.base.utils.Assertions$;
import js7.base.utils.AsyncLock;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.MultipleLinesBracket$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.base.utils.Tests$;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.event.Event;
import js7.data.event.EventCalc;
import js7.data.event.EventDrivenState;
import js7.data.event.EventId$;
import js7.data.event.JournalHeader;
import js7.data.event.JournalHeader$;
import js7.data.event.JournalId;
import js7.data.event.JournalState;
import js7.data.event.KeyedEvent;
import js7.data.event.SnapshotableState;
import js7.data.event.SnapshotableState$;
import js7.data.event.TimeCtx;
import js7.journal.CommitOptions;
import js7.journal.Committer;
import js7.journal.Committer$Applied$;
import js7.journal.Committer$CommitterService$;
import js7.journal.Committer$Written$;
import js7.journal.EventIdGenerator;
import js7.journal.FileJournal$;
import js7.journal.FileJournal$QueueEntry$;
import js7.journal.FileJournal$State$;
import js7.journal.FileJournalMXBean;
import js7.journal.Journal;
import js7.journal.Persist;
import js7.journal.Persisted;
import js7.journal.Snapshotter;
import js7.journal.configuration.JournalConf;
import js7.journal.data.JournalLocation;
import js7.journal.data.JournalLocation$;
import js7.journal.files.JournalFiles$extensions$;
import js7.journal.log.JournalLogger;
import js7.journal.problems.Problems$JournalKilledProblem$;
import js7.journal.recover.Recovered;
import js7.journal.recover.RecoveredJournalFile;
import js7.journal.watch.JournalEventWatch;
import js7.journal.watch.JournalingObserver;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichLong$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import sourcecode.Enclosing$;
import sourcecode.FullName$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class FileJournal<S extends SnapshotableState<S>>
implements Service.StoppableByRequest,
Committer<S>,
Snapshotter<S>,
Journal<S>,
PossibleFailover {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(FileJournal.class.getDeclaredField("js7$journal$Committer$$Written$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(FileJournal.class.getDeclaredField("js7$journal$Committer$$Applied$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FileJournal.class.getDeclaredField("js7$journal$Committer$$CommitterService$lzy1"));
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private AsyncVariable js7$journal$Committer$$currentService;
    private boolean js7$journal$Committer$$_isSwitchedOver;
    private Deferred js7$journal$Committer$$committerTerminatedUnexpectedly;
    private JournalLogger js7$journal$Committer$$journalLogger;
    private Statistics js7$journal$Committer$$statistics;
    private volatile Object js7$journal$Committer$$CommitterService$lzy1;
    private volatile Object js7$journal$Committer$$Applied$lzy1;
    private volatile Object js7$journal$Committer$$Written$lzy1;
    private AsyncLock js7$journal$Snapshotter$$snapshotLock;
    private long js7$journal$Snapshotter$$_lastSnapshotTakenEventId;
    private Switch js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch;
    private IO whenNoFailoverByOtherNode;
    private final JournalConf conf;
    private final Queue<IO, Option<QueueEntry<S>>> journalQueue;
    private final SignallingRef<IO, BoxedUnit> restartSnapshotTimerSignal;
    private final SignallingRef<IO, Object> requireClusterAck;
    private final SignallingRef<IO, Object> ackSignal;
    private final WallClock clock;
    private final EventIdGenerator eventIdGenerator;
    private final FileJournalMXBean.Bean bean;
    private final SnapshotableState.Companion<S> S;
    private final IORuntime ioRuntime;
    private final Deadline totalRunningSince;
    private final JournalLocation journalLocation;
    private final JournalEventWatch eventWatch;
    private final JournalingObserver journalingObserver;
    private JournalHeader lastJournalHeader;
    private final AsyncVariable<State<S>> state;
    private final JournalId journalId;
    private final Ref<IO, Object> _deleteJournalWhenStopping;
    private final Deferred<IO, BoxedUnit> whenBeingKilled;
    private volatile boolean isBeingKilled;
    private Option<Object> releaseEventIdsAfterClusterCoupledAck;
    private boolean _suppressSnapshotWhenStopping;

    public static CallMeter persistMeter() {
        return FileJournal$.MODULE$.persistMeter();
    }

    public static <S extends SnapshotableState<S>> Resource<IO, FileJournal<S>> service(Recovered<S> recovered, JournalConf journalConf, Option<EventIdGenerator> option, SnapshotableState.Companion<S> companion, Tag<S> tag, IORuntime iORuntime) {
        return FileJournal$.MODULE$.service(recovered, journalConf, option, companion, tag, iORuntime);
    }

    public static <S extends SnapshotableState<S>> Option<EventIdGenerator> service$default$3() {
        return FileJournal$.MODULE$.service$default$3();
    }

    public FileJournal(Recovered<S> recovered, JournalConf conf, Queue<IO, Option<QueueEntry<S>>> journalQueue, SignallingRef<IO, BoxedUnit> restartSnapshotTimerSignal, SignallingRef<IO, Object> requireClusterAck, SignallingRef<IO, Object> ackSignal, WallClock clock, EventIdGenerator eventIdGenerator, FileJournalMXBean.Bean bean, Tag<S> evidence$1, SnapshotableState.Companion<S> S, IORuntime ioRuntime) {
        JournalHeader journalHeader;
        this.conf = conf;
        this.journalQueue = journalQueue;
        this.restartSnapshotTimerSignal = restartSnapshotTimerSignal;
        this.requireClusterAck = requireClusterAck;
        this.ackSignal = ackSignal;
        this.clock = clock;
        this.eventIdGenerator = eventIdGenerator;
        this.bean = bean;
        this.S = S;
        this.ioRuntime = ioRuntime;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        Committer.$init$(this);
        Snapshotter.$init$(this);
        PossibleFailover.$init$(this);
        if (recovered.journalLocation().S() != S) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.totalRunningSince = recovered.totalRunningSince();
        this.journalLocation = recovered.journalLocation();
        this.eventWatch = recovered.eventWatch();
        this.journalingObserver = recovered.eventWatch();
        Option<RecoveredJournalFile<S>> option = recovered.recoveredJournalFile();
        if (None$.MODULE$.equals(option)) {
            Timestamp timestamp = clock.now();
            JournalId journalId = JournalHeader$.MODULE$.initial$default$1();
            journalHeader = JournalHeader$.MODULE$.initial(journalId, timestamp, S);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            RecoveredJournalFile o = (RecoveredJournalFile)some.value();
            journalHeader = o.nextJournalHeader();
        } else {
            throw new MatchError(option);
        }
        this.lastJournalHeader = journalHeader;
        this.state = AsyncVariable$.MODULE$.apply(FileJournal$State$.MODULE$.initial(recovered.state(), this.lastJournalHeader().totalEventCount()), true, AsyncVariable$.MODULE$.apply$default$3(), Enclosing$.MODULE$.apply("js7.journal.FileJournal#state"), Tag$.MODULE$.appliedTag(Tag$.MODULE$.apply(State.class, LightTypeTag$.MODULE$.parse(-769933936, "\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u001ejs7.journal.FileJournal$.State\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0000\u0002\u0003\u0000\u0000\u0017js7.journal.FileJournal\u0001\u0001", "\u0000\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u001ejs7.journal.FileJournal$.State\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0000\u0002\u0003\u0000\u0000\u0017js7.journal.FileJournal\u0001\u0001\u0003\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), (List)new .colon.colon((Object)evidence$1.tag(), (List)Nil$.MODULE$)));
        this.journalId = this.lastJournalHeader().journalId();
        this._deleteJournalWhenStopping = package$.MODULE$.Ref().unsafe((Object)BoxesRunTime.boxToBoolean((boolean)false), (Sync)IO$.MODULE$.asyncForIO());
        this.whenBeingKilled = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this.isBeingKilled = false;
        this.releaseEventIdsAfterClusterCoupledAck = None$.MODULE$;
        this._suppressSnapshotWhenStopping = false;
        eventIdGenerator.updateLastEventId(this.state().get().uncommitted().eventId());
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    @Override
    public AsyncVariable js7$journal$Committer$$currentService() {
        return this.js7$journal$Committer$$currentService;
    }

    @Override
    public boolean js7$journal$Committer$$_isSwitchedOver() {
        return this.js7$journal$Committer$$_isSwitchedOver;
    }

    @Override
    public Deferred js7$journal$Committer$$committerTerminatedUnexpectedly() {
        return this.js7$journal$Committer$$committerTerminatedUnexpectedly;
    }

    @Override
    public JournalLogger js7$journal$Committer$$journalLogger() {
        return this.js7$journal$Committer$$journalLogger;
    }

    @Override
    public Statistics js7$journal$Committer$$statistics() {
        return this.js7$journal$Committer$$statistics;
    }

    @Override
    public final Committer$CommitterService$ js7$journal$Committer$$CommitterService() {
        Object object = this.js7$journal$Committer$$CommitterService$lzy1;
        if (object instanceof Committer$CommitterService$) {
            return (Committer$CommitterService$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Committer$CommitterService$)this.js7$journal$Committer$$CommitterService$lzyINIT1();
    }

    private Object js7$journal$Committer$$CommitterService$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.js7$journal$Committer$$CommitterService$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Committer$CommitterService$ committer$CommitterService$ = null;
                    try {
                        committer$CommitterService$ = new Committer$CommitterService$(this);
                        object2 = committer$CommitterService$ == null ? LazyVals.NullValue$.MODULE$ : committer$CommitterService$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$journal$Committer$$CommitterService$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return committer$CommitterService$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final Committer$Applied$ js7$journal$Committer$$Applied() {
        Object object = this.js7$journal$Committer$$Applied$lzy1;
        if (object instanceof Committer$Applied$) {
            return (Committer$Applied$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Committer$Applied$)this.js7$journal$Committer$$Applied$lzyINIT1();
    }

    private Object js7$journal$Committer$$Applied$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.js7$journal$Committer$$Applied$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Committer$Applied$ committer$Applied$ = null;
                    try {
                        committer$Applied$ = new Committer$Applied$(this);
                        object2 = committer$Applied$ == null ? LazyVals.NullValue$.MODULE$ : committer$Applied$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$journal$Committer$$Applied$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return committer$Applied$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final Committer$Written$ js7$journal$Committer$$Written() {
        Object object = this.js7$journal$Committer$$Written$lzy1;
        if (object instanceof Committer$Written$) {
            return (Committer$Written$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Committer$Written$)this.js7$journal$Committer$$Written$lzyINIT1();
    }

    private Object js7$journal$Committer$$Written$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.js7$journal$Committer$$Written$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Committer$Written$ committer$Written$ = null;
                    try {
                        committer$Written$ = new Committer$Written$(this);
                        object2 = committer$Written$ == null ? LazyVals.NullValue$.MODULE$ : committer$Written$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$journal$Committer$$Written$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return committer$Written$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void js7$journal$Committer$$_isSwitchedOver_$eq(boolean x$1) {
        this.js7$journal$Committer$$_isSwitchedOver = x$1;
    }

    @Override
    public void js7$journal$Committer$_setter_$js7$journal$Committer$$currentService_$eq(AsyncVariable x$0) {
        this.js7$journal$Committer$$currentService = x$0;
    }

    @Override
    public void js7$journal$Committer$_setter_$js7$journal$Committer$$committerTerminatedUnexpectedly_$eq(Deferred x$0) {
        this.js7$journal$Committer$$committerTerminatedUnexpectedly = x$0;
    }

    @Override
    public void js7$journal$Committer$_setter_$js7$journal$Committer$$journalLogger_$eq(JournalLogger x$0) {
        this.js7$journal$Committer$$journalLogger = x$0;
    }

    @Override
    public void js7$journal$Committer$_setter_$js7$journal$Committer$$statistics_$eq(Statistics x$0) {
        this.js7$journal$Committer$$statistics = x$0;
    }

    @Override
    public AsyncLock js7$journal$Snapshotter$$snapshotLock() {
        return this.js7$journal$Snapshotter$$snapshotLock;
    }

    @Override
    public long js7$journal$Snapshotter$$_lastSnapshotTakenEventId() {
        return this.js7$journal$Snapshotter$$_lastSnapshotTakenEventId;
    }

    @Override
    public void js7$journal$Snapshotter$$_lastSnapshotTakenEventId_$eq(long x$1) {
        this.js7$journal$Snapshotter$$_lastSnapshotTakenEventId = x$1;
    }

    @Override
    public void js7$journal$Snapshotter$_setter_$js7$journal$Snapshotter$$snapshotLock_$eq(AsyncLock x$0) {
        this.js7$journal$Snapshotter$$snapshotLock = x$0;
    }

    @Override
    public Switch js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch() {
        return this.js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch;
    }

    @Override
    public final IO whenNoFailoverByOtherNode() {
        return this.whenNoFailoverByOtherNode;
    }

    @Override
    public void js7$journal$FileJournal$PossibleFailover$_setter_$js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch_$eq(Switch x$0) {
        this.js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch = x$0;
    }

    @Override
    public void js7$journal$FileJournal$PossibleFailover$_setter_$whenNoFailoverByOtherNode_$eq(IO x$0) {
        this.whenNoFailoverByOtherNode = x$0;
    }

    public JournalConf conf() {
        return this.conf;
    }

    public Queue<IO, Option<QueueEntry<S>>> journalQueue() {
        return this.journalQueue;
    }

    public SignallingRef<IO, BoxedUnit> restartSnapshotTimerSignal() {
        return this.restartSnapshotTimerSignal;
    }

    public SignallingRef<IO, Object> requireClusterAck() {
        return this.requireClusterAck;
    }

    public SignallingRef<IO, Object> ackSignal() {
        return this.ackSignal;
    }

    public WallClock clock() {
        return this.clock;
    }

    public EventIdGenerator eventIdGenerator() {
        return this.eventIdGenerator;
    }

    public FileJournalMXBean.Bean bean() {
        return this.bean;
    }

    public SnapshotableState.Companion<S> S() {
        return this.S;
    }

    public IORuntime ioRuntime() {
        return this.ioRuntime;
    }

    public JournalLocation journalLocation() {
        return this.journalLocation;
    }

    @Override
    public JournalEventWatch eventWatch() {
        return this.eventWatch;
    }

    public JournalingObserver journalingObserver() {
        return this.journalingObserver;
    }

    public JournalHeader lastJournalHeader() {
        return this.lastJournalHeader;
    }

    public void lastJournalHeader_$eq(JournalHeader x$1) {
        this.lastJournalHeader = x$1;
    }

    public AsyncVariable<State<S>> state() {
        return this.state;
    }

    @Override
    public JournalId journalId() {
        return this.journalId;
    }

    public Deferred<IO, BoxedUnit> whenBeingKilled() {
        return this.whenBeingKilled;
    }

    public boolean isBeingKilled() {
        return this.isBeingKilled;
    }

    public void isBeingKilled_$eq(boolean x$1) {
        this.isBeingKilled = x$1;
    }

    public Option<Object> releaseEventIdsAfterClusterCoupledAck() {
        return this.releaseEventIdsAfterClusterCoupledAck;
    }

    public void releaseEventIdsAfterClusterCoupledAck_$eq(Option<Object> x$1) {
        this.releaseEventIdsAfterClusterCoupledAck = x$1;
    }

    public boolean _suppressSnapshotWhenStopping() {
        return this._suppressSnapshotWhenStopping;
    }

    public void _suppressSnapshotWhenStopping_$eq(boolean x$1) {
        this._suppressSnapshotWhenStopping = x$1;
    }

    @Override
    public boolean isHalted() {
        return this.isSwitchedOver() || this.isStopping();
    }

    public FiniteDuration totalRunningTime() {
        return ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.totalRunningSince));
    }

    public Timestamp initiallyStartedAt() {
        return this.lastJournalHeader().initiallyStartedAt();
    }

    public void suppressSnapshotWhenStopping() {
        this._suppressSnapshotWhenStopping_$eq(true);
    }

    @Override
    public IO<Service.Started> start() {
        return IO$.MODULE$.defer(this::start$$anonfun$1);
    }

    private IO<BoxedUnit> rejectQueuedEntries() {
        return IO$.MODULE$.defer(this::rejectQueuedEntries$$anonfun$1);
    }

    @Override
    public IO<BoxedUnit> stop() {
        return StoppableByRequest.stop$(this);
    }

    public IO<BoxedUnit> kill() {
        return Logger$package$Logger$syntax$.MODULE$.debugIO(FileJournal$.js7$journal$FileJournal$$$logger, IO$.MODULE$.defer(this::kill$$anonfun$1), Name$.MODULE$.apply("kill"));
    }

    public IO<BoxedUnit> deleteJournalWhenStopping() {
        return (IO)this._deleteJournalWhenStopping.set((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public IO<BoxedUnit> prepareForStopOfClusterNodeStop() {
        return this.noMoreAcks("prepareForStopOfClusterNodeStop");
    }

    public IO<BoxedUnit> noMoreAcks(String reason) {
        return ((IO)this.requireClusterAck().getAndUpdate((Function1 & Serializable)_$3 -> FileJournal.noMoreAcks$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$3)))).map((Function1 & Serializable)v1 -> {
            IO$.MODULE$.apply((Function0 & Serializable)() -> {
                FileJournal.noMoreAcks$$anonfun$2$$anonfun$1(wasAck, reason$2);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public <E extends Event> IO<Either<Problem, Persisted<S, E>>> persist_(Persist<S, E> persist) {
        if (Tests$.MODULE$.isTest()) {
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)FileJournal.v$proxy1$1(persist)), "!persist.commitOptions.commitLater"), FullName$.MODULE$.apply("js7.journal.FileJournal.persist_"), ScalaSourceLocation$.MODULE$.apply("FileJournal.scala", 189));
        }
        return CatsUtils$syntax$.MODULE$.logWhenMethodTakesLonger(this.enqueue(persist).flatMap((Function1 & Serializable)x$1 -> {
            DeferredSource deferredSource = (DeferredSource)x$1._1();
            DeferredSource deferredSource2 = (DeferredSource)x$1._2();
            return (IO)deferredSource2.get();
        }), Enclosing$.MODULE$.apply("js7.journal.FileJournal#persist_"));
    }

    public <E extends Event> IO<Tuple2<DeferredSource<IO, Either<Problem, Persisted<S, E>>>, DeferredSource<IO, Either<Problem, Persisted<S, E>>>>> enqueue(Persist<S, E> persist) {
        return IO$.MODULE$.defer(() -> this.enqueue$$anonfun$1(persist));
    }

    public IO<BoxedUnit> onPassiveNodeHasAcknowledged(long eventId) {
        return ((IO)this.ackSignal().update((Function1)(JFunction1.mcJJ.sp & Serializable)lastAck -> {
            if (eventId < lastAck) {
                Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("Passive cluster node acknowledged old {} EventId after {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)eventId), BoxesRunTime.boxToLong((long)lastAck)}), Object.class));
                }
                return lastAck;
            }
            long lastEventId = this.state().get().uncommitted().eventId();
            if (this.isSwitchedOver() && lastEventId < eventId) {
                LazyRef lazyRef = new LazyRef();
                if (lastAck < lastEventId) {
                    Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn(FileJournal.msg$1(lazyRef, eventId, lastEventId));
                    }
                } else {
                    Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("\u2753 {}", (Object)FileJournal.msg$1(lazyRef, eventId, lastEventId));
                    }
                }
                return lastEventId;
            }
            return eventId;
        })).productR(IO$.MODULE$.defer(this::onPassiveNodeHasAcknowledged$$anonfun$2));
    }

    public IO<BoxedUnit> releaseObsoleteEvents() {
        return IO$.MODULE$.whenA(this.conf().deleteObsoleteFiles(), this::releaseObsoleteEvents$$anonfun$1);
    }

    private void releaseObsoleteEventsUntil(long untilEventId) {
        S committedState = this.state().get().committed();
        Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("releaseObsoleteEvents({}) {}, clusterState={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)untilEventId), committedState.journalState(), committedState.clusterState()}), Object.class));
        }
        this.journalingObserver().releaseEvents(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(untilEventId), this.lastJournalHeader().eventId()), this.ioRuntime());
    }

    @Override
    public IO<S> aggregate() {
        return this.state().value().map((Function1 & Serializable)_$7 -> _$7.committed());
    }

    public IO<JournalState> journalState() {
        return this.aggregate().map((Function1 & Serializable)_$8 -> _$8.journalState());
    }

    public IO<ClusterState> clusterState() {
        return this.aggregate().map((Function1 & Serializable)_$9 -> _$9.clusterState());
    }

    @Override
    public S unsafeAggregate() {
        return this.state().get().committed();
    }

    @Override
    public S unsafeUncommittedAggregate() {
        return this.state().get().uncommitted();
    }

    public IO<Object> isRequiringClusterAcknowledgement() {
        return (IO)this.requireClusterAck().get();
    }

    public void assertIsRecoverable(S aggregate, Seq<KeyedEvent<Event>> keyedEvents) {
        if (this.conf().slowCheckState()) {
            this.assertEqualSnapshotState("Recovered", aggregate, aggregate.toRecovered(), keyedEvents);
            return;
        }
    }

    public Seq<KeyedEvent<Event>> assertIsRecoverable$default$2() {
        return scala.package$.MODULE$.Nil();
    }

    public void assertEqualSnapshotState(String what, S aggregate, S couldBeRecoveredState, Seq<KeyedEvent<Event>> keyedEvents) {
        S s = couldBeRecoveredState;
        S s2 = aggregate;
        if (s == null ? s2 != null : !s.equals(s2)) {
            String msg = what + " does not match actual '" + this.S() + "'";
            Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error(msg);
            }
            try {
                ScalaUtils$syntax$.MODULE$.foreachWithBracket(keyedEvents, MultipleLinesBracket$.MODULE$.Round(), (Function2 & Serializable)(v1, v2) -> {
                    FileJournal.assertEqualSnapshotState$$anonfun$1((KeyedEvent)v1, BoxesRunTime.unboxToChar((Object)v2));
                    return BoxedUnit.UNIT;
                });
                Logger LoggerImpl_this2 = FileJournal$.js7$journal$FileJournal$$$logger;
                if (LoggerImpl_this2.underlying().isErrorEnabled()) {
                    LoggerImpl_this2.underlying().error("Snapshot objects: \u23ce");
                }
                MultipleLinesBracket$.MODULE$.zipWithBracket(aggregate.toSnapshotStream(), MultipleLinesBracket$.MODULE$.Square()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Object object = x$1._1();
                    char c = BoxesRunTime.unboxToChar((Object)x$1._2());
                    Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                        LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToCharacter((char)c), object}), Object.class));
                        return;
                    }
                }).compile(Compiler$.MODULE$.pureInstance()).drain();
                boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(Tests$.MODULE$.isTest());
                SnapshotableState$.MODULE$.logBoth(couldBeRecoveredState, what + " is WRONG?", aggregate, this.S() + " is EXPECTED?", (Option<Path>)ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, FileJournal::assertEqualSnapshotState$$anonfun$3));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    ScalaUtils$syntax$.MODULE$.foreachWithBracket(keyedEvents, MultipleLinesBracket$.MODULE$.Round(), (Function2 & Serializable)(v1, v2) -> {
                        FileJournal.assertEqualSnapshotState$$anonfun$4((KeyedEvent)v1, BoxesRunTime.unboxToChar((Object)v2));
                        return BoxedUnit.UNIT;
                    });
                    aggregate.emitLineStream((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)_$10 -> {
                        Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error(_$10);
                            return;
                        }
                    });
                    MultipleLinesBracket$.MODULE$.zipWithBracket(aggregate.toSnapshotStream(), MultipleLinesBracket$.MODULE$.Square()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Object object = x$1._1();
                        char c = BoxesRunTime.unboxToChar((Object)x$1._2());
                        Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToCharacter((char)c), object}), Object.class));
                            return;
                        }
                    }).compile(Compiler$.MODULE$.pureInstance()).drain();
                    throw t;
                }
                throw throwable;
            }
            throw new AssertionError((Object)msg);
        }
    }

    public Seq<KeyedEvent<Event>> assertEqualSnapshotState$default$4() {
        return scala.package$.MODULE$.Nil();
    }

    public String toString() {
        return "FileJournal[" + this.journalLocation().S() + "]";
    }

    private final IO start$$anonfun$1$$anonfun$3$$anonfun$1() {
        return this.takeSnapshot(true, BoxedUnit.UNIT);
    }

    private final IO start$$anonfun$1$$anonfun$3() {
        return IO$.MODULE$.whenA(!this.isSwitchedOver() && !this._suppressSnapshotWhenStopping(), this::start$$anonfun$1$$anonfun$3$$anonfun$1);
    }

    private final void start$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1() {
        JournalFiles$extensions$.MODULE$.deleteJournal(this.journalLocation(), true);
    }

    private final IO start$$anonfun$1$$anonfun$4$$anonfun$1() {
        return IO$.MODULE$.blocking((Function0 & Serializable)() -> {
            this.start$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ IO start$$anonfun$1$$anonfun$4(boolean _$1) {
        return IO$.MODULE$.whenA(_$1, this::start$$anonfun$1$$anonfun$4$$anonfun$1);
    }

    private final void start$$anonfun$1$$anonfun$5() {
        this.logStatistics();
    }

    private final IO start$$anonfun$1() {
        Logger LoggerImpl_this;
        Logger LoggerImpl_this2;
        Logger LoggerImpl_this3;
        FiniteDuration a$proxy1 = this.lastJournalHeader().totalRunningTime();
        this.bean().totalOperatingTimeUntilStart().set(a$proxy1);
        this.conf().simulateSync().foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Disk sync is simulated with a {} pause", (Object)ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration((FiniteDuration)o)));
                return;
            }
        });
        if (this.lastJournalHeader().eventId() == EventId$.MODULE$.BeforeFirst() && (LoggerImpl_this3 = FileJournal$.js7$journal$FileJournal$$$logger).underlying().isInfoEnabled()) {
            LoggerImpl_this3.underlying().info("Starting a new empty journal");
        }
        if ((LoggerImpl_this2 = FileJournal$.js7$journal$FileJournal$$$logger).underlying().isTraceEnabled() && (LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger).underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Logger isTraceEnabled=true");
        }
        this.assertIsRecoverable(this.state().get().uncommitted(), this.assertIsRecoverable$default$2());
        Path tmpFile = JournalLocation$.MODULE$.toTemporaryFile(JournalFiles$extensions$.MODULE$.file(this.journalLocation(), this.state().get().committed().eventId()));
        if (Files.exists(tmpFile, new LinkOption[0])) {
            Logger LoggerImpl_this4 = FileJournal$.js7$journal$FileJournal$$$logger;
            if (LoggerImpl_this4.underlying().isWarnEnabled()) {
                LoggerImpl_this4.underlying().warn("JournalWriter: Deleting existent file '{}'", (Object)tmpFile);
            }
            Files.delete(tmpFile);
        }
        return this.startCommitter(true).$times$greater(this.startService((IO)this.snapshotPeriodically().background().surround((Object)IO$.MODULE$.race(this.untilStopRequested(), this.whenCommitterTerminatedUnexpectedly()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = left.value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return IO$.MODULE$.unit();
                }
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Either either2 = (Either)right.value();
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    Throwable t = (Throwable)left.value();
                    return IO$.MODULE$.raiseError(t);
                }
                if (either2 instanceof Right) {
                    Right right2 = (Right)either2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = right2.value();
                    if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                        return IO$.MODULE$.raiseError((Throwable)new RuntimeException("Journal committer terminated unexpectedly"));
                    }
                }
            }
            throw new MatchError((Object)either);
        }).guarantee(IO$.MODULE$.defer(this::start$$anonfun$1$$anonfun$3)).guarantee(this.stopCommitter()).guarantee(this.rejectQueuedEntries()).guarantee(((IO)this._deleteJournalWhenStopping.get()).flatMap((Function1 & Serializable)_$1 -> this.start$$anonfun$1$$anonfun$4(BoxesRunTime.unboxToBoolean((Object)_$1)))).guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.start$$anonfun$1$$anonfun$5();
            return BoxedUnit.UNIT;
        })), (MonadCancel)IO$.MODULE$.asyncForIO())));
    }

    private final IO rejectQueuedEntries$$anonfun$1() {
        Left problem = scala.package$.MODULE$.Left().apply((Object)(this.isBeingKilled() ? Problems$JournalKilledProblem$.MODULE$ : Problems$ServiceStoppedProblem$.MODULE$.apply(this.toString(), Problems$ServiceStoppedProblem$.MODULE$.$lessinit$greater$default$2())));
        BoxedUnit boxedUnit = (BoxedUnit)package.flatMap$.MODULE$.catsSyntaxFlatMapIdOps((Object)BoxedUnit.UNIT);
        return (IO)FlatMapIdOps$.MODULE$.tailRecM$extension((Object)boxedUnit, (Function1 & Serializable)_$2 -> ((IO)this.journalQueue().tryTake()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return CatsEffectExtensions$.MODULE$.inline$rightUnitIO();
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Option option2 = (Option)some.value();
                if (None$.MODULE$.equals(option2)) {
                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, BoxedUnit.UNIT);
                }
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    QueueEntry queuedEntry = (QueueEntry)some2.value();
                    return ((IO)queuedEntry.whenApplied().complete((Object)problem)).$times$greater(((IO)queuedEntry.whenPersisted().complete((Object)problem)).as((Object)scala.package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT)));
                }
            }
            throw new MatchError((Object)option);
        }), (FlatMap)IO$.MODULE$.asyncForIO());
    }

    private final IO kill$$anonfun$1() {
        this._suppressSnapshotWhenStopping_$eq(true);
        this.isBeingKilled_$eq(true);
        return ((IO)this.whenBeingKilled().complete((Object)BoxedUnit.UNIT)).$times$greater(this.noMoreAcks("kill")).$times$greater(this.stop());
    }

    private static final /* synthetic */ boolean noMoreAcks$$anonfun$1(boolean _$3) {
        return false;
    }

    private static final void noMoreAcks$$anonfun$2$$anonfun$1(boolean wasAck$1, String reason$1) {
        if (wasAck$1) {
            Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("Cluster passive node acknowledgements are no longer awaited due to {}", (Object)reason$1);
                return;
            }
            return;
        }
    }

    private static final boolean v$proxy1$1(Persist persist$1) {
        return !persist$1.commitOptions().commitLater();
    }

    private static final Problems$JournalKilledProblem$ enqueue$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Problems$JournalKilledProblem$.MODULE$;
    }

    private final Either enqueue$$anonfun$1$$anonfun$1() {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(!this.isBeingKilled());
        return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, FileJournal::enqueue$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    private final IO enqueue$$anonfun$1(Persist persist$2) {
        Deferred whenApplied = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        Deferred whenPersisted = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        EventCalc EventCalc_this = persist$2.eventCalc();
        QueueEntry queueEntry = FileJournal$QueueEntry$.MODULE$.apply(EventCalc_this, persist$2.commitOptions(), persist$2.since(), FileJournal$.MODULE$.persistMeter().startMetering(), whenApplied, whenPersisted);
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(this::enqueue$$anonfun$1$$anonfun$1));
        DeferredSource deferredSource = (DeferredSource)Predef$.MODULE$.ArrowAssoc((Object)whenApplied);
        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$5 -> this.requireNotStopping(), IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Problem problem = (Problem)left.value();
                return ((IO)whenApplied.complete((Object)scala.package$.MODULE$.Left().apply((Object)problem))).$times$greater((IO)whenPersisted.complete((Object)scala.package$.MODULE$.Left().apply((Object)problem)));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = right.value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return (IO)this.journalQueue().offer((Object)Some$.MODULE$.apply((Object)queueEntry));
                }
            }
            throw new MatchError((Object)either);
        }).as((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)deferredSource, (Object)whenPersisted));
    }

    private static final String msg$lzyINIT1$1(LazyRef msg$lzy1$1, long eventId$2, long lastEventId$1) {
        String string;
        LazyRef lazyRef = msg$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(msg$lzy1$1.initialized() ? msg$lzy1$1.value() : msg$lzy1$1.initialize((Object)("Passive cluster node isAcknowledged future event " + EventId$.MODULE$.toString(eventId$2) + (" while lastEventId=" + EventId$.MODULE$.toString(lastEventId$1) + " (okay when switching over)"))));
        }
        return string;
    }

    private static final String msg$1(LazyRef msg$lzy1$2, long eventId$3, long lastEventId$2) {
        return (String)(msg$lzy1$2.initialized() ? msg$lzy1$2.value() : FileJournal.msg$lzyINIT1$1(msg$lzy1$2, eventId$3, lastEventId$2));
    }

    private final IO onPassiveNodeHasAcknowledged$$anonfun$2$$anonfun$1() {
        return this.releaseObsoleteEvents();
    }

    private final IO onPassiveNodeHasAcknowledged$$anonfun$2() {
        return IO$.MODULE$.whenA(this.releaseEventIdsAfterClusterCoupledAck().isDefined(), this::onPassiveNodeHasAcknowledged$$anonfun$2$$anonfun$1);
    }

    private final void releaseObsoleteEvents$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(State state$3, boolean requireAck$2, long lastAck$1) {
        ClusterState clusterState;
        Object committed = state$3.committed();
        ClusterState clusterState2 = clusterState = committed.clusterState();
        ClusterState$Empty$ clusterState$Empty$ = ClusterState$Empty$.MODULE$;
        if (!(clusterState2 == null ? clusterState$Empty$ != null : !clusterState2.equals(clusterState$Empty$)) || requireAck$2 && (clusterState instanceof ClusterState.Coupled || clusterState instanceof ClusterState.ActiveShutDown) && this.releaseEventIdsAfterClusterCoupledAck().forall((Function1)(JFunction1.mcZJ.sp & Serializable)_$6 -> _$6 <= lastAck$1)) {
            ClusterState clusterState3 = clusterState;
            ClusterState$Empty$ clusterState$Empty$2 = ClusterState$Empty$.MODULE$;
            long eventId = !(clusterState3 != null ? !clusterState3.equals(clusterState$Empty$2) : clusterState$Empty$2 != null) ? committed.eventId() : RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(lastAck$1 - 1L), EventId$.MODULE$.BeforeFirst());
            this.releaseObsoleteEventsUntil(committed.journalState().toReleaseEventId(eventId, (Iterable<UserId>)this.conf().releaseEventsUserIds()));
            this.releaseEventIdsAfterClusterCoupledAck_$eq((Option<Object>)None$.MODULE$);
            return;
        }
    }

    private final /* synthetic */ IO releaseObsoleteEvents$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(State state$2, boolean requireAck$1, long lastAck) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.releaseObsoleteEvents$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(state$2, requireAck$1, lastAck);
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ IO releaseObsoleteEvents$$anonfun$1$$anonfun$1$$anonfun$1(State state$1, boolean requireAck) {
        return ((IO)this.ackSignal().get()).flatMap((Function1 & Serializable)lastAck -> this.releaseObsoleteEvents$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(state$1, requireAck, BoxesRunTime.unboxToLong((Object)lastAck)));
    }

    private final IO releaseObsoleteEvents$$anonfun$1() {
        return this.state().value().flatMap((Function1 & Serializable)state -> ((IO)this.requireClusterAck().get()).flatMap((Function1 & Serializable)requireAck -> this.releaseObsoleteEvents$$anonfun$1$$anonfun$1$$anonfun$1((State)state, BoxesRunTime.unboxToBoolean((Object)requireAck))));
    }

    private static final /* synthetic */ void assertEqualSnapshotState$$anonfun$1(KeyedEvent keyedEvent, char bracket) {
        Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = BoxesRunTime.boxToCharacter((char)bracket);
            String string = ScalaUtils$syntax$.MODULE$.RichString(keyedEvent.toString());
            objectArray[1] = ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 200, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
            LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            return;
        }
    }

    private static final Path a$proxy2$1() {
        return Paths.get("logs/snapshot-error.txt", new String[0]);
    }

    private static final Path assertEqualSnapshotState$$anonfun$3() {
        return FileJournal.a$proxy2$1();
    }

    private static final /* synthetic */ void assertEqualSnapshotState$$anonfun$4(KeyedEvent keyedEvent, char bracket) {
        Logger LoggerImpl_this = FileJournal$.js7$journal$FileJournal$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = BoxesRunTime.boxToCharacter((char)bracket);
            String string = ScalaUtils$syntax$.MODULE$.RichString(keyedEvent.toString());
            objectArray[1] = ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 200, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
            LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            return;
        }
    }

    public static interface PossibleFailover {
        public static void $init$(PossibleFailover $this) {
            $this.js7$journal$FileJournal$PossibleFailover$_setter_$js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch_$eq(Switch$.MODULE$.apply(false));
            $this.js7$journal$FileJournal$PossibleFailover$_setter_$whenNoFailoverByOtherNode_$eq(CatsUtils$syntax$.MODULE$.logWhenMethodTakesLonger($this.js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch().whenOff(), Enclosing$.MODULE$.apply("js7.journal.FileJournal.PossibleFailover#whenNoFailoverByOtherNode")));
        }

        public Switch js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch();

        public void js7$journal$FileJournal$PossibleFailover$_setter_$js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch_$eq(Switch var1);

        public static IO forPossibleFailoverByOtherNode$(PossibleFailover $this, IO io) {
            return $this.forPossibleFailoverByOtherNode(io);
        }

        default public <A> IO<A> forPossibleFailoverByOtherNode(IO<A> io) {
            return this.js7$journal$FileJournal$PossibleFailover$$tryingPassiveLostSwitch().switchOnAround(io);
        }

        public IO<BoxedUnit> whenNoFailoverByOtherNode();

        public void js7$journal$FileJournal$PossibleFailover$_setter_$whenNoFailoverByOtherNode_$eq(IO var1);
    }

    public static final class QueueEntry<S extends EventDrivenState<S, Event>>
    implements Product,
    Serializable {
        private final EventCalc<S, Event, TimeCtx> eventCalc;
        private final CommitOptions commitOptions;
        private final Deadline since;
        private final long metering;
        private final DeferredSink<IO, Either<Problem, Persisted<S, Event>>> whenApplied;
        private final DeferredSink<IO, Either<Problem, Persisted<S, Event>>> whenPersisted;

        public static <S extends EventDrivenState<S, Event>> QueueEntry<S> apply(EventCalc<S, Event, TimeCtx> eventCalc, CommitOptions commitOptions, Deadline deadline, long l, DeferredSink<IO, Either<Problem, Persisted<S, Event>>> deferredSink, DeferredSink<IO, Either<Problem, Persisted<S, Event>>> deferredSink2) {
            return FileJournal$QueueEntry$.MODULE$.apply(eventCalc, commitOptions, deadline, l, deferredSink, deferredSink2);
        }

        public static QueueEntry<?> fromProduct(Product product) {
            return FileJournal$QueueEntry$.MODULE$.fromProduct(product);
        }

        public static <S extends EventDrivenState<S, Event>> QueueEntry<S> unapply(QueueEntry<S> queueEntry) {
            return FileJournal$QueueEntry$.MODULE$.unapply(queueEntry);
        }

        public QueueEntry(EventCalc<S, Event, TimeCtx> eventCalc, CommitOptions commitOptions, Deadline since, long metering, DeferredSink<IO, Either<Problem, Persisted<S, Event>>> whenApplied, DeferredSink<IO, Either<Problem, Persisted<S, Event>>> whenPersisted) {
            this.eventCalc = eventCalc;
            this.commitOptions = commitOptions;
            this.since = since;
            this.metering = metering;
            this.whenApplied = whenApplied;
            this.whenPersisted = whenPersisted;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)-403907071);
            n = Statics.mix((int)n, (int)Statics.anyHash(this.eventCalc()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.commitOptions()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.since()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.metering()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.whenApplied()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.whenPersisted()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            QueueEntry queueEntry;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof QueueEntry)) return false;
            QueueEntry queueEntry2 = queueEntry = (QueueEntry)object;
            EventCalc<S, Event, TimeCtx> eventCalc = this.eventCalc();
            EventCalc<S, Event, TimeCtx> eventCalc2 = queueEntry2.eventCalc();
            if (eventCalc == null) {
                if (eventCalc2 != null) {
                    return false;
                }
            } else if (!eventCalc.equals(eventCalc2)) return false;
            CommitOptions commitOptions = this.commitOptions();
            CommitOptions commitOptions2 = queueEntry2.commitOptions();
            if (commitOptions == null) {
                if (commitOptions2 != null) {
                    return false;
                }
            } else if (!((Object)commitOptions).equals(commitOptions2)) return false;
            Deadline deadline = this.since();
            Deadline deadline2 = queueEntry2.since();
            if (deadline == null) {
                if (deadline2 != null) {
                    return false;
                }
            } else if (!deadline.equals(deadline2)) return false;
            if (this.metering() != queueEntry2.metering()) return false;
            DeferredSink<IO, Either<Problem, Persisted<S, Event>>> deferredSink = this.whenApplied();
            DeferredSink<IO, Either<Problem, Persisted<S, Event>>> deferredSink2 = queueEntry2.whenApplied();
            if (deferredSink == null) {
                if (deferredSink2 != null) {
                    return false;
                }
            } else if (!deferredSink.equals(deferredSink2)) return false;
            DeferredSink<IO, Either<Problem, Persisted<S, Event>>> deferredSink3 = this.whenPersisted();
            DeferredSink<IO, Either<Problem, Persisted<S, Event>>> deferredSink4 = queueEntry2.whenPersisted();
            if (deferredSink3 == null) {
                if (deferredSink4 == null) return true;
                return false;
            } else {
                if (!deferredSink3.equals(deferredSink4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof QueueEntry;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "QueueEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "eventCalc";
                }
                case 1: {
                    return "commitOptions";
                }
                case 2: {
                    return "since";
                }
                case 3: {
                    return "metering";
                }
                case 4: {
                    return "whenApplied";
                }
                case 5: {
                    return "whenPersisted";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public EventCalc<S, Event, TimeCtx> eventCalc() {
            return this.eventCalc;
        }

        public CommitOptions commitOptions() {
            return this.commitOptions;
        }

        public Deadline since() {
            return this.since;
        }

        public long metering() {
            return this.metering;
        }

        public DeferredSink<IO, Either<Problem, Persisted<S, Event>>> whenApplied() {
            return this.whenApplied;
        }

        public DeferredSink<IO, Either<Problem, Persisted<S, Event>>> whenPersisted() {
            return this.whenPersisted;
        }

        public IO<BoxedUnit> completePersistedWithProblem(Problem problem) {
            return IO$.MODULE$.defer(() -> this.completePersistedWithProblem$$anonfun$1(problem));
        }

        public <S extends EventDrivenState<S, Event>> QueueEntry<S> copy(EventCalc<S, Event, TimeCtx> eventCalc, CommitOptions commitOptions, Deadline since, long metering, DeferredSink<IO, Either<Problem, Persisted<S, Event>>> whenApplied, DeferredSink<IO, Either<Problem, Persisted<S, Event>>> whenPersisted) {
            return new QueueEntry<S>(eventCalc, commitOptions, since, metering, whenApplied, whenPersisted);
        }

        public <S extends EventDrivenState<S, Event>> EventCalc<S, Event, TimeCtx> copy$default$1() {
            return this.eventCalc();
        }

        public <S extends EventDrivenState<S, Event>> CommitOptions copy$default$2() {
            return this.commitOptions();
        }

        public <S extends EventDrivenState<S, Event>> Deadline copy$default$3() {
            return this.since();
        }

        public long copy$default$4() {
            return this.metering();
        }

        public <S extends EventDrivenState<S, Event>> DeferredSink<IO, Either<Problem, Persisted<S, Event>>> copy$default$5() {
            return this.whenApplied();
        }

        public <S extends EventDrivenState<S, Event>> DeferredSink<IO, Either<Problem, Persisted<S, Event>>> copy$default$6() {
            return this.whenPersisted();
        }

        public EventCalc<S, Event, TimeCtx> _1() {
            return this.eventCalc();
        }

        public CommitOptions _2() {
            return this.commitOptions();
        }

        public Deadline _3() {
            return this.since();
        }

        public long _4() {
            return this.metering();
        }

        public DeferredSink<IO, Either<Problem, Persisted<S, Event>>> _5() {
            return this.whenApplied();
        }

        public DeferredSink<IO, Either<Problem, Persisted<S, Event>>> _6() {
            return this.whenPersisted();
        }

        private final IO completePersistedWithProblem$$anonfun$1(Problem problem$3) {
            FileJournal$.MODULE$.persistMeter().stopMetering(this.metering());
            return ((IO)this.whenApplied().complete((Object)scala.package$.MODULE$.Left().apply((Object)problem$3))).$times$greater(((IO)this.whenPersisted().complete((Object)scala.package$.MODULE$.Left().apply((Object)problem$3))).void());
        }
    }

    public static class State<S extends SnapshotableState<S>>
    implements Product,
    Serializable {
        private final S uncommitted;
        private final S committed;
        private final long totalEventCount;

        public static <S extends SnapshotableState<S>> State<S> apply(S s, S s2, long l) {
            return FileJournal$State$.MODULE$.apply(s, s2, l);
        }

        public static State<?> fromProduct(Product product) {
            return FileJournal$State$.MODULE$.fromProduct(product);
        }

        public static <S extends SnapshotableState<S>> State<S> initial(S s, long l) {
            return FileJournal$State$.MODULE$.initial(s, l);
        }

        public static <S extends SnapshotableState<S>> State<S> unapply(State<S> state) {
            return FileJournal$State$.MODULE$.unapply(state);
        }

        public State(S uncommitted, S committed, long totalEventCount) {
            this.uncommitted = uncommitted;
            this.committed = committed;
            this.totalEventCount = totalEventCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)80204913);
            n = Statics.mix((int)n, (int)Statics.anyHash(this.uncommitted()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.committed()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.totalEventCount()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            State state;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state2 = state = (State)object;
            if (this.totalEventCount() != state2.totalEventCount()) return false;
            S s = this.uncommitted();
            S s2 = state2.uncommitted();
            if (s == null) {
                if (s2 != null) {
                    return false;
                }
            } else if (!s.equals(s2)) return false;
            S s3 = this.committed();
            S s4 = state2.committed();
            if (s3 == null) {
                if (s4 != null) {
                    return false;
                }
            } else if (!s3.equals(s4)) return false;
            if (!state2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "uncommitted";
                }
                case 1: {
                    return "committed";
                }
                case 2: {
                    return "totalEventCount";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public S uncommitted() {
            return this.uncommitted;
        }

        public S committed() {
            return this.committed;
        }

        public long totalEventCount() {
            return this.totalEventCount;
        }

        public <S extends SnapshotableState<S>> State<S> copy(S uncommitted, S committed, long totalEventCount) {
            return new State<S>(uncommitted, committed, totalEventCount);
        }

        public <S extends SnapshotableState<S>> S copy$default$1() {
            return this.uncommitted();
        }

        public <S extends SnapshotableState<S>> S copy$default$2() {
            return this.committed();
        }

        public long copy$default$3() {
            return this.totalEventCount();
        }

        public S _1() {
            return this.uncommitted();
        }

        public S _2() {
            return this.committed();
        }

        public long _3() {
            return this.totalEventCount();
        }
    }

    public static class Statistics {
        private long eventCount = 0L;
        private long persistCount = 0L;
        private long persistDurationMin = ScalaTime$RichFiniteDurationCompanion$.MODULE$.MaxValue$extension(ScalaTime$.MODULE$.RichFiniteDurationCompanion(FiniteDuration$.MODULE$)).toMillis();
        private long persistDurationMax = 0L;
        private long persistDurationSum = 0L;

        public void onPersisted(int persistCount, int eventCount, Deadline since) {
            this.eventCount += (long)eventCount;
            this.persistCount += (long)persistCount;
            long duration = ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since)).toNanos();
            this.persistDurationSum += duration;
            if (this.persistDurationMin > duration) {
                this.persistDurationMin = duration;
            }
            if (this.persistDurationMax < duration) {
                this.persistDurationMax = duration;
                return;
            }
        }

        public Option<String> logLine() {
            return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.persistCount > 0L), this::logLine$$anonfun$1);
        }

        private FiniteDuration persistDurationAvg() {
            return ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(this.persistDurationSum / this.persistCount));
        }

        private final String logLine$$anonfun$1() {
            double persist = 1.0 * (double)this.eventCount / (double)this.persistCount;
            String min = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(this.persistDurationMin))));
            String max = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(this.persistDurationMax))));
            String avg = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.persistDurationAvg()));
            return StringOps$.MODULE$.format$extension("%s persists \u00b7 %s events (%.1f/persist) %s\u2026\u2205%s\u2026%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.persistCount), BoxesRunTime.boxToLong((long)this.eventCount), BoxesRunTime.boxToDouble((double)persist), min, avg, max}));
        }
    }
}

