/*
 * Decompiled with CFR 0.152.
 */
package js7.journal;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.journal.FileJournalMXBean$Bean$;
import scala.Int$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;

public interface FileJournalMXBean {
    public long getFileSize();

    public long getEventTotal();

    public long getCommitTotal();

    public long getPersistTotal();

    public double getPersistSecondsTotal();

    public long getFlushTotal();

    public double getEventCalcSecondsTotal();

    public double getJsonWriteSecondsTotal();

    public double getAckSecondsTotal();

    public double getOperatingSeconds();

    public static final class Bean
    implements FileJournalMXBean {
        private final Deadline sinceStart = Deadline$.MODULE$.now();
        private final AtomicReference<FiniteDuration> totalOperatingTimeUntilStart = new AtomicReference<FiniteDuration>(ScalaTime$.MODULE$.ZeroDuration());
        private long fileSize = 0L;
        private final AtomicLong eventTotal = new AtomicLong(0L);
        private final AtomicLong persistTotal = new AtomicLong(0L);
        private final AtomicLong persistNanos = new AtomicLong(0L);
        private final AtomicLong commitTotal = new AtomicLong(0L);
        private final AtomicLong flushTotal = new AtomicLong(0L);
        private final AtomicLong eventCalcNanos = new AtomicLong(0L);
        private final AtomicLong jsonWriteNanos = new AtomicLong(0L);
        private final AtomicLong ackNanos = new AtomicLong(0L);

        public static Bean dummy() {
            return FileJournalMXBean$Bean$.MODULE$.dummy();
        }

        public AtomicReference<FiniteDuration> totalOperatingTimeUntilStart() {
            return this.totalOperatingTimeUntilStart;
        }

        public long fileSize() {
            return this.fileSize;
        }

        public void fileSize_$eq(long x$1) {
            this.fileSize = x$1;
        }

        public AtomicLong persistTotal() {
            return this.persistTotal;
        }

        public AtomicLong persistNanos() {
            return this.persistNanos;
        }

        public AtomicLong commitTotal() {
            return this.commitTotal;
        }

        public AtomicLong flushTotal() {
            return this.flushTotal;
        }

        public AtomicLong eventCalcNanos() {
            return this.eventCalcNanos;
        }

        public AtomicLong jsonWriteNanos() {
            return this.jsonWriteNanos;
        }

        public AtomicLong ackNanos() {
            return this.ackNanos;
        }

        @Override
        public long getFileSize() {
            return this.fileSize();
        }

        public void addEventCount(int n) {
            long n$proxy1 = Int$.MODULE$.int2long(n);
            this.eventTotal.getAndAdd(n$proxy1);
        }

        @Override
        public long getEventTotal() {
            return this.eventTotal.get();
        }

        @Override
        public long getPersistTotal() {
            return this.persistTotal().get();
        }

        @Override
        public double getPersistSecondsTotal() {
            return (double)this.persistNanos().get() / 1.0E9;
        }

        @Override
        public long getCommitTotal() {
            return this.commitTotal().get();
        }

        @Override
        public long getFlushTotal() {
            return this.flushTotal().get();
        }

        @Override
        public double getEventCalcSecondsTotal() {
            return (double)this.eventCalcNanos().get() / 1.0E9;
        }

        @Override
        public double getJsonWriteSecondsTotal() {
            return (double)this.jsonWriteNanos().get() / 1.0E9;
        }

        @Override
        public double getAckSecondsTotal() {
            return (double)this.ackNanos().get() / 1.0E9;
        }

        @Override
        public double getOperatingSeconds() {
            return ScalaTime$RichFiniteDuration$.MODULE$.toDoubleSeconds$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.totalOperatingTimeUntilStart().get().$plus(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.sinceStart)))));
        }

        private boolean isUsed() {
            return this.persistTotal().get() > 0L;
        }

        public final boolean inline$isUsed() {
            return this.isUsed();
        }
    }
}

