/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.files;

import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.regex.Pattern;
import js7.base.generic.GenericString$EmptyStringProblem$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.journal.files.JournalFile$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.boundary;
import scala.util.boundary$;

public final class JournalFile
implements Product,
Serializable {
    private final long fileEventId;
    private final Path file;

    public static Pattern anyJournalFilePattern(Path path) {
        return JournalFile$.MODULE$.anyJournalFilePattern(path);
    }

    public static JournalFile apply(long l, Path path) {
        return JournalFile$.MODULE$.apply(l, path);
    }

    public static JournalFile fromProduct(Product product) {
        return JournalFile$.MODULE$.fromProduct(product);
    }

    public static Pattern garbagePattern(Path path) {
        return JournalFile$.MODULE$.garbagePattern(path);
    }

    public static Path toFile(Path path, long l) {
        return JournalFile$.MODULE$.toFile(path, l);
    }

    public static JournalFile unapply(JournalFile journalFile) {
        return JournalFile$.MODULE$.unapply(journalFile);
    }

    public JournalFile(long fileEventId, Path file) {
        this.fileEventId = fileEventId;
        this.file = file;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)1644645683);
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.fileEventId()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.file()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        JournalFile journalFile;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof JournalFile)) return false;
        JournalFile journalFile2 = journalFile = (JournalFile)object;
        if (this.fileEventId() != journalFile2.fileEventId()) return false;
        Path path = this.file();
        Path path2 = journalFile2.file();
        if (path != null) {
            if (!((Object)path).equals(path2)) return false;
            return true;
        }
        if (path2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof JournalFile;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "JournalFile";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToLong((long)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "fileEventId";
        }
        if (1 == n2) {
            return "file";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public long fileEventId() {
        return this.fileEventId;
    }

    public Path file() {
        return this.file;
    }

    public String toString() {
        return this.file().getFileName().toString();
    }

    public long properLength() {
        long l;
        boundary.Label local = new boundary.Label();
        try {
            l = BoxesRunTime.unboxToLong(AutoClosing$.MODULE$.autoClosing(new RandomAccessFile(this.file().toFile(), "r"), (Function1 & Serializable)f -> {
                for (long truncated = f.length(); truncated > 0L; --truncated) {
                    f.seek(truncated - 1L);
                    if (f.read() != 10) continue;
                    throw boundary$.MODULE$.break((Object)BoxesRunTime.boxToLong((long)truncated), local);
                }
                return 0L;
            }));
        }
        catch (boundary.Break ex) {
            if (ex.label() == local) {
                l = BoxesRunTime.unboxToLong((Object)ex.value());
            }
            throw ex;
        }
        return l;
    }

    public JournalFile copy(long fileEventId, Path file) {
        return new JournalFile(fileEventId, file);
    }

    public long copy$default$1() {
        return this.fileEventId();
    }

    public Path copy$default$2() {
        return this.file();
    }

    public long _1() {
        return this.fileEventId();
    }

    public Path _2() {
        return this.file();
    }

    public static final class Matcher {
        private final Pattern pattern;

        public Matcher(Path fileBase) {
            this.pattern = Pattern.compile(Pattern.quote(fileBase.toString()) + "--([0-9]+)\\.journal");
        }

        public Either<Problem, JournalFile> checkedJournalFile(Path file) {
            return this.checkedFileEventId(file).map(arg_0 -> JournalFile$.js7$journal$files$JournalFile$Matcher$$_$checkedJournalFile$$anonfun$adapted$1(file, arg_0));
        }

        public Either<Problem, Object> checkedFileEventId(Path file) {
            Path path = file.getFileName();
            if (path == null) {
                return package$.MODULE$.Left().apply((Object)GenericString$EmptyStringProblem$.MODULE$.apply("File"));
            }
            Path filename = path;
            java.util.regex.Matcher matcher = this.pattern.matcher(filename.toString());
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(matcher.matches());
            Option option = Checked$.MODULE$.CheckedOption(ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.checkedFileEventId$$anonfun$1(matcher)));
            return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> JournalFile$.js7$journal$files$JournalFile$Matcher$$_$checkedFileEventId$$anonfun$2(filename)));
        }

        private final long a$proxy1$1(java.util.regex.Matcher matcher$1) {
            return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(matcher$1.group(1)));
        }

        private final long checkedFileEventId$$anonfun$1(java.util.regex.Matcher matcher$2) {
            return this.a$proxy1$1(matcher$2);
        }
    }
}

