/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.watch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import js7.base.log.LogLevel;
import js7.base.log.LogLevel$;
import js7.base.log.Logger$package$Logger$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.metering.CallMeter;
import js7.base.metering.CallMeterMacros$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ByteUnits$;
import js7.base.utils.CloseableIterator;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalId;
import js7.data.event.KeyedEvent;
import js7.data.event.SnapshotableState;
import js7.data.event.Stamped;
import js7.journal.recover.JournalReader;
import js7.journal.watch.FileEventIterator$;
import js7.journal.watch.JournalIndex;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;

public class FileEventIterator
implements CloseableIterator<Stamped<KeyedEvent<Event>>> {
    private final Path journalFile;
    private final long fileEventId;
    private final Function0<Object> committedLength;
    public final Logger js7$journal$watch$FileEventIterator$$logger;
    private final JournalReader journalReader;
    private Stamped<KeyedEvent<Event>> nextEvent;
    private boolean closed;

    public FileEventIterator(SnapshotableState.HasCodec S, Path journalFile, JournalId expectedJournalId, long fileEventId, Function0<Object> committedLength) {
        this.journalFile = journalFile;
        this.fileEventId = fileEventId;
        this.committedLength = committedLength;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.js7$journal$watch$FileEventIterator$$logger = Logger$package$Logger$.MODULE$.withPrefix(journalFile.getFileName().toString(), ClassTag$.MODULE$.apply(FileEventIterator.class));
        this.journalReader = new JournalReader(S, journalFile, expectedJournalId);
        this.nextEvent = null;
        this.closed = false;
        AutoClosing$.MODULE$.closeOnError(this.journalReader, (Function0 & Serializable)() -> {
            this.$init$$$anonfun$1(fileEventId, journalFile);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public /* synthetic */ Vector js7$base$utils$CloseableIterator$$super$toVector() {
        return IterableOnceOps.toVector$((IterableOnceOps)this);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$takeWhile(Function1 p) {
        return Iterator.takeWhile$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$dropWhile(Function1 p) {
        return Iterator.dropWhile$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$filter(Function1 p) {
        return Iterator.filter$((Iterator)this, (Function1)p);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$map(Function1 f) {
        return Iterator.map$((Iterator)this, (Function1)f);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$flatMap(Function1 f) {
        return Iterator.flatMap$((Iterator)this, (Function1)f);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$tapEach(Function1 f) {
        return Iterator.tapEach$((Iterator)this, (Function1)f);
    }

    @Override
    public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$collect(PartialFunction pf) {
        return Iterator.collect$((Iterator)this, (PartialFunction)pf);
    }

    public Path journalFile() {
        return this.journalFile;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.journalReader.close();
            return;
        }
    }

    public final long firstEventPosition() {
        return this.journalReader.firstEventPosition();
    }

    public final void seek(PositionAnd<Object> positionAndEventId) {
        this.journalReader.seekEvent(positionAndEventId);
        this.nextEvent = null;
    }

    public final boolean skipToEventAfter(JournalIndex journalIndex, long after) {
        CallMeter CallMeter_this;
        return this.eventId() <= after && (this.eventId() == after || BoxesRunTime.unboxToBoolean(CallMeterMacros$.MODULE$.inline$meterCall$i1(CallMeter_this = FileEventIterator$.js7$journal$watch$FileEventIterator$$$meterSkip, () -> this.skipToEventAfter$$anonfun$1(journalIndex, after))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasNext() {
        if (this.nextEvent != null) return true;
        if (this.journalReader.position() >= this.committedLength.apply$mcJ$sp()) return false;
        this.nextEvent = (Stamped)this.journalReader.nextEvent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (this.nextEvent == null) return false;
        return true;
    }

    public final Stamped<KeyedEvent<Event>> next() {
        this.hasNext();
        Stamped<KeyedEvent<Event>> r = this.nextEvent;
        if (r == null) {
            throw new NoSuchElementException("End of committed part of journal file '" + this.journalFile().getFileName() + "' reached");
        }
        this.nextEvent = null;
        return r;
    }

    public final long eventId() {
        return this.journalReader.eventId();
    }

    public final long position() {
        return this.journalReader.position();
    }

    public final PositionAnd<Object> positionAndEventId() {
        return this.journalReader.positionAndEventId();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "FileEventIterator(" + this.journalFile().getFileName() + " fileEventId=" + EventId$.MODULE$.toString(this.fileEventId) + " " + ("eventId=" + this.eventId() + ")");
    }

    private final void $init$$$anonfun$1(long fileEventId$1, Path journalFile$1) {
        if (this.journalReader.fileEventId() != fileEventId$1) {
            throw package$.MODULE$.error("Journal file '" + journalFile$1 + "': found fileEventId=" + this.journalReader.fileEventId() + ", " + ("expected was: " + fileEventId$1));
        }
    }

    private final boolean skipToEventAfter$$anonfun$1$$anonfun$1(long after$2, JournalIndex journalIndex$2) {
        TimeWatch watch = new TimeWatch(this, after$2);
        while (this.eventId() < after$2 && this.hasNext()) {
            this.next();
            PositionAnd<Object> positionAnd = this.positionAndEventId();
            if (positionAnd == null) {
                throw new MatchError(positionAnd);
            }
            PositionAnd<Object> positionAnd2 = PositionAnd$.MODULE$.unapply(positionAnd);
            long l = positionAnd2._1();
            long l2 = BoxesRunTime.unboxToLong((Object)positionAnd2._2());
            long position = l;
            long eventId = l2;
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(position, eventId);
            long position2 = sp2._1$mcJ$sp();
            long eventId2 = sp2._2$mcJ$sp();
            journalIndex$2.tryAddAfter(eventId2, position2, journalIndex$2.tryAddAfter$default$3());
            watch.onSkipped();
        }
        watch.end();
        return this.eventId() == after$2;
    }

    private final boolean skipToEventAfter$$anonfun$1(JournalIndex journalIndex$1, long after$1) {
        return BoxesRunTime.unboxToBoolean(journalIndex$1.synchronizeBuilding(() -> this.skipToEventAfter$$anonfun$1$$anonfun$1(after$1, journalIndex$1)));
    }

    public class TimeWatch {
        private final long after;
        private final long startPosition;
        private final long startEventId;
        private final Deadline runningSince;
        private int skipped;
        private boolean debugIssued;
        private final /* synthetic */ FileEventIterator $outer;

        public TimeWatch(FileEventIterator $outer, long after) {
            this.after = after;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            PositionAnd<Object> positionAnd = $outer.positionAndEventId();
            if (positionAnd == null) {
                throw new MatchError(positionAnd);
            }
            PositionAnd<Object> positionAnd2 = PositionAnd$.MODULE$.unapply(positionAnd);
            long l = positionAnd2._1();
            long l2 = BoxesRunTime.unboxToLong((Object)positionAnd2._2());
            long startPosition = l;
            long startEventId = l2;
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(startPosition, startEventId);
            this.startPosition = sp2._1$mcJ$sp();
            this.startEventId = sp2._2$mcJ$sp();
            this.runningSince = Deadline$.MODULE$.now();
            this.skipped = 0;
            this.debugIssued = false;
        }

        public void onSkipped() {
            ++this.skipped;
            FiniteDuration duration = ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.runningSince));
            if (duration.$greater$eq((Object)FileEventIterator$.js7$journal$watch$FileEventIterator$$$LogThreshold) && !this.debugIssued && (this.$outer.position() - this.startPosition >= (long)FileEventIterator$.js7$journal$watch$FileEventIterator$$$InfoSkippedSize || duration.$greater$eq((Object)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1))))) {
                Logger LoggerImpl_this = this.$outer.js7$journal$watch$FileEventIterator$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("\u23f3 {} events ({}) skipped since {} ago: {}..{} in journal file", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger((int)this.skipped), ByteUnits$.MODULE$.toKBGB(this.$outer.position() - this.startPosition), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration)), EventId$.MODULE$.toDateTimeString(this.startEventId), EventId$.MODULE$.toDateTimeString(this.after)}), Object.class));
                }
                this.debugIssued = true;
                return;
            }
        }

        public void end() {
            FiniteDuration duration = ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.runningSince));
            if (duration.$greater$eq((Object)FileEventIterator$.js7$journal$watch$FileEventIterator$$$LogThreshold)) {
                long skippedSize = this.$outer.position() - this.startPosition;
                LogLevel logLevel = this.skipped == 0 ? LogLevel$.None : (skippedSize >= (long)FileEventIterator$.js7$journal$watch$FileEventIterator$$$InfoSkippedSize || duration.$greater$eq((Object)FileEventIterator$.js7$journal$watch$FileEventIterator$$$InfoDuration) ? LogLevel$.Info : LogLevel$.Trace);
                Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(this.$outer.js7$journal$watch$FileEventIterator$$logger.underlying()), logLevel, (Function0<String>)((Function0 & Serializable)() -> this.end$$anonfun$1(skippedSize, duration)));
                return;
            }
        }

        public final /* synthetic */ FileEventIterator js7$journal$watch$FileEventIterator$TimeWatch$$$outer() {
            return this.$outer;
        }

        private final String message$proxy2$1(long skippedSize$1, FiniteDuration duration$1) {
            return "\u23f3 " + this.skipped + " events (" + ByteUnits$.MODULE$.toKBGB(skippedSize$1) + ") skipped in " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$1)) + ": " + EventId$.MODULE$.toString(this.startEventId) + ".." + EventId$.MODULE$.toString(this.after);
        }

        private final String end$$anonfun$1(long skippedSize$2, FiniteDuration duration$2) {
            return this.message$proxy2$1(skippedSize$2, duration$2);
        }
    }
}

