/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.write;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.IORuntime;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.nio.file.Path;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.data.ByteArray;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.log.Logger$package$Logger$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.Stopwatch$;
import js7.common.jsonseq.PositionAnd;
import js7.data.event.JournalEvent$SnapshotTaken$;
import js7.data.event.JournalHeader;
import js7.data.event.JournalSeparators$;
import js7.data.event.KeyedEvent;
import js7.data.event.SnapshotMeta;
import js7.data.event.SnapshotMeta$SnapshotEventId$;
import js7.data.event.SnapshotableState;
import js7.data.event.Stamped;
import js7.journal.FileJournalMXBean;
import js7.journal.data.JournalLocation;
import js7.journal.write.JournalWriter;
import js7.journal.write.JournalWriter$;
import js7.journal.write.SnapshotJournalWriter$;
import js7.journal.write.SnapshotStatisticsCounter;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;

public final class SnapshotJournalWriter
extends JournalWriter {
    private final SnapshotableState.HasCodec S;
    private final Option<FiniteDuration> simulateSync;
    private final IORuntime ioRuntime;
    private final Logger logger;
    private final SnapshotStatisticsCounter statistics;
    private boolean snapshotStarted;
    private int snapshotCount;
    private final Deadline runningSince;

    public static SnapshotJournalWriter forTest(JournalLocation journalLocation, long l, FileJournalMXBean.Bean bean, IORuntime iORuntime) {
        return SnapshotJournalWriter$.MODULE$.forTest(journalLocation, l, bean, iORuntime);
    }

    public static <S extends SnapshotableState<S>> IO<Tuple2<Object, PositionAnd<Object>>> writeSnapshotStream(SnapshotableState.HasCodec hasCodec, Path path, JournalHeader journalHeader, Stream<Nothing$, Object> stream, Stamped<KeyedEvent<JournalEvent$SnapshotTaken$>> stamped, FileJournalMXBean.Bean bean, boolean bl, Option<FiniteDuration> option, IORuntime iORuntime) {
        return SnapshotJournalWriter$.MODULE$.writeSnapshotStream(hasCodec, path, journalHeader, stream, stamped, bean, bl, option, iORuntime);
    }

    public static FileJournalMXBean.Bean $lessinit$greater$default$3() {
        return SnapshotJournalWriter$.MODULE$.$lessinit$greater$default$3();
    }

    public static FileJournalMXBean.Bean forTest$default$3() {
        return SnapshotJournalWriter$.MODULE$.forTest$default$3();
    }

    public static <S extends SnapshotableState<S>> boolean writeSnapshotStream$default$7() {
        return SnapshotJournalWriter$.MODULE$.writeSnapshotStream$default$7();
    }

    public static <S extends SnapshotableState<S>> Option<FiniteDuration> writeSnapshotStream$default$8() {
        return SnapshotJournalWriter$.MODULE$.writeSnapshotStream$default$8();
    }

    public SnapshotJournalWriter(SnapshotableState.HasCodec S, Path file, FileJournalMXBean.Bean bean, long after, Option<FiniteDuration> simulateSync, IORuntime ioRuntime) {
        this.S = S;
        this.simulateSync = simulateSync;
        this.ioRuntime = ioRuntime;
        super(S, file, bean, after, false, JournalWriter$.MODULE$.$lessinit$greater$default$6());
        this.logger = Logger$package$Logger$.MODULE$.withPrefix(this.getClass(), file.getFileName().toString());
        this.statistics = new SnapshotStatisticsCounter();
        this.snapshotStarted = false;
        this.snapshotCount = 0;
        this.runningSince = Deadline$.MODULE$.now();
    }

    private Path file$accessor() {
        return super.file();
    }

    @Override
    public Option<FiniteDuration> simulateSync() {
        return this.simulateSync;
    }

    @Override
    public IORuntime ioRuntime() {
        return this.ioRuntime;
    }

    @Override
    public SnapshotStatisticsCounter statistics() {
        return this.statistics;
    }

    public void js7$journal$write$SnapshotJournalWriter$$log() {
        FiniteDuration elapsed = ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.runningSince));
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Snapshot finished - " + Stopwatch$.MODULE$.itemsPerSecondString(elapsed, Int$.MODULE$.int2long(this.snapshotCount), "objects") + " \u00b7 " + Stopwatch$.MODULE$.bytesPerSecondString(elapsed, this.fileLength()));
        }
        this.statistics().debugString().foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info(o);
                return;
            }
        });
    }

    public void beginSnapshotSection() {
        if (this.snapshotStarted) {
            throw new IllegalStateException("SnapshotJournalWriter: duplicate beginSnapshotSection()");
        }
        this.jsonWriter().write(CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(JournalSeparators$.MODULE$.SnapshotHeader())));
        this.flush(false);
        this.snapshotStarted = true;
    }

    public IO<BoxedUnit> js7$journal$write$SnapshotJournalWriter$$writeSnapshotStream(Stream<Nothing$, Object> snapshotStream) {
        Stream stream = snapshotStream.filter((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof SnapshotMeta.SnapshotEventId) {
                SnapshotMeta.SnapshotEventId snapshotEventId = (SnapshotMeta.SnapshotEventId)object;
                SnapshotMeta.SnapshotEventId snapshotEventId2 = SnapshotMeta$SnapshotEventId$.MODULE$.unapply(snapshotEventId);
                long l = snapshotEventId2._1();
                return false;
            }
            return true;
        });
        return (IO)StreamExtensions$.MODULE$.mapParallelBatch(stream, StreamExtensions$.MODULE$.mapParallelBatch$default$2(stream), StreamExtensions$.MODULE$.mapParallelBatch$default$3(stream), StreamExtensions$.MODULE$.mapParallelBatch$default$4(stream), (Function1 & Serializable)snapshotObject -> {
            Object object = package$.MODULE$.EncoderOps(snapshotObject);
            return CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(package.EncoderOps$.MODULE$.asJson$extension(object, this.S.snapshotObjectJsonCodec())));
        }).foreach((Function1 & Serializable)byteArray -> IO$.MODULE$.blocking((Function0 & Serializable)() -> {
            this.writeSnapshotStream$$anonfun$2$$anonfun$1((ByteArray)byteArray);
            return BoxedUnit.UNIT;
        })).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    public void writeSnapshot(ByteArray json) {
        if (!this.snapshotStarted) {
            throw new IllegalStateException("SnapshotJournalWriter: writeSnapshots(), but snapshots have not been started");
        }
        this.statistics().countSnapshot();
        this.jsonWriter().write(json);
        ++this.snapshotCount;
    }

    public void endSnapshotSection() {
        this.jsonWriter().write(CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(JournalSeparators$.MODULE$.SnapshotFooter())));
        this.statistics().setFileLength(this.jsonWriter().fileLength());
    }

    public String toString() {
        return "SnapshotJournalWriter(" + this.file$accessor().getFileName() + ")";
    }

    private final void writeSnapshotStream$$anonfun$2$$anonfun$1(ByteArray byteArray$1) {
        this.writeSnapshot(byteArray$1);
    }
}

