/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.forwindows;

import java.util.concurrent.atomic.AtomicBoolean;
import js7.launcher.forwindows.ResourceGuard$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;

public final class ResourceGuard<A> {
    private final A resource;
    private final Function1<A, BoxedUnit> release;
    private int usage;
    private final AtomicBoolean _releaseAfterUse;

    public static <A> ResourceGuard<A> apply(A a, Function1<A, BoxedUnit> function1) {
        return ResourceGuard$.MODULE$.apply(a, function1);
    }

    public ResourceGuard(A resource, Function1<A, BoxedUnit> release) {
        this.resource = resource;
        this.release = release;
        this.usage = 1;
        this._releaseAfterUse = new AtomicBoolean(false);
    }

    public <B> B use(Function1<Option<A>, B> body) {
        if (this.increment() > 0) {
            Object object;
            try {
                object = body.apply((Object)Some$.MODULE$.apply(this.resource));
            }
            finally {
                this.decrement();
            }
            return (B)object;
        }
        return (B)body.apply((Object)None$.MODULE$);
    }

    public void releaseAfterUse() {
        if (!this._releaseAfterUse.getAndSet(true)) {
            this.decrement();
            return;
        }
    }

    private int increment() {
        int n;
        ResourceGuard resourceGuard = this;
        synchronized (resourceGuard) {
            if (this.usage > 0) {
                ++this.usage;
            }
            n = this.usage;
        }
        return n;
    }

    private void decrement() {
        int n;
        ResourceGuard resourceGuard = this;
        synchronized (resourceGuard) {
            block5: {
                if (this.usage > 0) break block5;
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            --this.usage;
            n = this.usage;
        }
        int n2 = n;
        if (0 == n2) {
            this.release.apply(this.resource);
            return;
        }
    }
}

