/*
 * Decompiled with CFR 0.152.
 */
package js7.provider;

import cats.Applicative;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.thread.IOExecutor$env$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDuration$;
import js7.base.utils.AutoClosing$;
import js7.provider.DirectoryWatcher$;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class DirectoryWatcher
implements AutoCloseable {
    private final Path directory;
    private final Duration timeout;
    private final WatchService watchService;
    private final AtomicBoolean closed;

    public DirectoryWatcher(Path directory, Duration timeout) {
        this.directory = directory;
        this.timeout = timeout;
        this.watchService = directory.getFileSystem().newWatchService();
        this.closed = new AtomicBoolean(false);
        AutoClosing$.MODULE$.closeOnError(this.watchService, () -> this.$init$$$anonfun$1(directory));
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            Logger LoggerImpl_this = DirectoryWatcher$.js7$provider$DirectoryWatcher$$$logger;
            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                LoggerImpl_this.underlying().trace("{}: watchService.close", (Object)this.directory);
            }
            this.watchService.close();
            return;
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public Stream<IO, BoxedUnit> singleUseStream() {
        return Stream$.MODULE$.repeatEval((Object)this.waitForNextChange(this.timeout).void()).onFinalizeCase((Function1 & Serializable)x$1 -> {
            Resource.ExitCase exitCase = x$1;
            cats.effect.package$.MODULE$.Resource();
            if (Resource.ExitCase$.Canceled$.MODULE$.equals(exitCase)) {
                return IO$.MODULE$.blocking((Function0 & Serializable)() -> {
                    this.singleUseStream$$anonfun$1$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
            }
            return IO$.MODULE$.unit();
        }, (Applicative)IO$.MODULE$.asyncForIO());
    }

    private IO<Object> waitForNextChange(Duration timeout) {
        return IOExecutor$env$.MODULE$.interruptibleVirtualThread(() -> this.waitForNextChange$$anonfun$1(timeout));
    }

    private final WatchKey $init$$$anonfun$1(Path directory$1) {
        return directory$1.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
    }

    private final void singleUseStream$$anonfun$1$$anonfun$1() {
        Logger LoggerImpl_this = DirectoryWatcher$.js7$provider$DirectoryWatcher$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("{}: cancel", (Object)this.directory);
        }
        this.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean waitForNextChange$$anonfun$1(Duration timeout$1) {
        WatchKey watchKey;
        long remainingMillis = timeout$1.toMillis();
        if (remainingMillis <= 0L) return true;
        Logger LoggerImpl_this = DirectoryWatcher$.js7$provider$DirectoryWatcher$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("{}: poll {} ...", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.directory, ScalaTime$RichDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichDuration(timeout$1))}), Object.class));
        }
        if ((watchKey = this.watchService.poll(remainingMillis, package$.MODULE$.MILLISECONDS())) == null) {
            Logger LoggerImpl_this2 = DirectoryWatcher$.js7$provider$DirectoryWatcher$$$logger;
            if (LoggerImpl_this2.underlying().isTraceEnabled()) {
                LoggerImpl_this2.underlying().trace("{}: poll timed out", (Object)this.directory);
            }
        } else {
            try {
                List<WatchEvent<?>> events = watchKey.pollEvents();
                Logger LoggerImpl_this3 = DirectoryWatcher$.js7$provider$DirectoryWatcher$$$logger;
                if (LoggerImpl_this3.underlying().isTraceEnabled()) {
                    if (events.isEmpty()) {
                        Logger LoggerImpl_this4 = DirectoryWatcher$.js7$provider$DirectoryWatcher$$$logger;
                        if (LoggerImpl_this4.underlying().isTraceEnabled()) {
                            LoggerImpl_this4.underlying().trace("{}: poll returned no events", (Object)this.directory);
                        }
                    } else {
                        CollectionConverters$.MODULE$.ListHasAsScala(events).asScala().foreach((Function1)(JProcedure1 & Serializable)o -> {
                            Logger LoggerImpl_this = DirectoryWatcher$.js7$provider$DirectoryWatcher$$$logger;
                            if (LoggerImpl_this.underlying().isTraceEnabled()) {
                                LoggerImpl_this.underlying().trace("{}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.directory, DirectoryWatcher$.js7$provider$DirectoryWatcher$$$watchEventShow.show(o)}), Object.class));
                                return;
                            }
                        });
                    }
                }
            }
            finally {
                watchKey.reset();
            }
            if (!true) return false;
            return true;
        }
        if (false) return true;
        return false;
    }
}

