/*
 * Decompiled with CFR 0.152.
 */
package js7.service.prometheus;

import com.typesafe.scalalogging.Logger;
import io.prometheus.jmx.JmxCollector;
import io.prometheus.metrics.exporter.common.PrometheusHttpExchange;
import io.prometheus.metrics.exporter.common.PrometheusScrapeHandler;
import io.prometheus.metrics.expositionformats.PrometheusTextFormatWriter;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import js7.base.data.ByteSeqOutputStream;
import js7.base.io.file.FileUtils;
import js7.base.metering.CallMeter;
import js7.base.metering.CallMeterMacros$;
import js7.common.pekkoutils.ByteStrings;
import js7.service.prometheus.PrometheusJmxAdapter$;
import js7.service.prometheus.PrometheusJmxAdapterForHttp;
import org.apache.pekko.http.scaladsl.model.HttpMethods$;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.ScalaRunTime$;

public final class PrometheusJmxAdapter {
    private final PrometheusRegistry registry = new PrometheusRegistry();
    private final PrometheusScrapeHandler scrapeHandler;
    private final PrometheusTextFormatWriter textWriter;
    private int lastSize;

    public static Option<Path> $lessinit$greater$default$1() {
        return PrometheusJmxAdapter$.MODULE$.$lessinit$greater$default$1();
    }

    public PrometheusJmxAdapter(Option<Path> configDir2) {
        JmxCollector jmxCollector = new JmxCollector((String)configDir2.fold(PrometheusJmxAdapter::$init$$$anonfun$1, (Function1 & Serializable)configDir -> {
            String string;
            Path file = FileUtils.syntax$.RichPath$.MODULE$.$div$extension(FileUtils.syntax$.MODULE$.RichPath(configDir), "prometheus.yaml");
            try {
                string = FileUtils.syntax$.RichPath$.MODULE$.contentString$extension(FileUtils.syntax$.MODULE$.RichPath(file));
            }
            catch (NoSuchFileException noSuchFileException) {
                string = PrometheusJmxAdapter$.js7$service$prometheus$PrometheusJmxAdapter$$$DefaultYamlConfig;
            }
            catch (IOException e) {
                Logger LoggerImpl_this = PrometheusJmxAdapter$.js7$service$prometheus$PrometheusJmxAdapter$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("{}: {} \u2022 Using default configuration", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{file, e}), Object.class));
                }
                string = PrometheusJmxAdapter$.js7$service$prometheus$PrometheusJmxAdapter$$$DefaultYamlConfig;
            }
            return string;
        }));
        jmxCollector.register(this.registry);
        this.scrapeHandler = new PrometheusScrapeHandler(this.registry);
        this.textWriter = PrometheusTextFormatWriter.builder().build();
        this.lastSize = 131072;
    }

    public ByteString metricsByteString() {
        CallMeter CallMeter_this = PrometheusJmxAdapter$.js7$service$prometheus$PrometheusJmxAdapter$$$meter;
        return (ByteString)CallMeterMacros$.MODULE$.inline$meterCall$i1(CallMeter_this, this::metricsByteString$$anonfun$1);
    }

    private ByteString metricsByteString(HttpRequest request) {
        PrometheusJmxAdapterForHttp.PekkoPromtheusExchange exchange = new PrometheusJmxAdapterForHttp.PekkoPromtheusExchange(request);
        this.scrapeHandler.handleRequest((PrometheusHttpExchange)exchange);
        return exchange.metricsByteString();
    }

    private HttpRequest metricsByteString$default$1() {
        return HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), Uri$.MODULE$.apply("/metrics"), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5());
    }

    private static final String $init$$$anonfun$1() {
        return PrometheusJmxAdapter$.js7$service$prometheus$PrometheusJmxAdapter$$$DefaultYamlConfig;
    }

    private final ByteString metricsByteString$$anonfun$1() {
        ByteSeqOutputStream outputStream = new ByteSeqOutputStream(this.lastSize + this.lastSize / 5);
        this.textWriter.write((OutputStream)outputStream, this.registry.scrape());
        this.lastSize = outputStream.size();
        return (ByteString)outputStream.byteSeq(ByteStrings.syntax$.MODULE$.byteStringByteSequence());
    }
}

