/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.credentialstore;

import com.sos.commons.credentialstore.exceptions.SOSCredentialStoreException;
import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.credentialstore.keepass.SOSKeePassResolver;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import org.linguafranca.pwdb.Entry;

public class CredentialStoreArguments
extends ASOSArguments {
    public static final String CLASS_KEY = "CREDENTIAL_STORE";
    public static final String ARG_NAME_FILE = "credential_store_file";
    public static final String ARG_NAME_KEY_FILE = "credential_store_key_file";
    public static final String ARG_NAME_PASSWORD = "credential_store_password";
    public static final String ARG_NAME_ENTRY_PATH = "credential_store_entry_path";
    public static final String ARG_NAME_KEEPASS_MODULE = "credential_store_keepass_module";
    private SOSArgument<String> file = new SOSArgument("credential_store_file", false);
    private SOSArgument<String> keyFile = new SOSArgument("credential_store_key_file", false);
    private SOSArgument<String> password = new SOSArgument("credential_store_password", false, SOSArgument.DisplayMode.MASKED);
    private SOSArgument<String> entryPath = new SOSArgument("credential_store_entry_path", false);
    private SOSArgument<String> keePassModule = new SOSArgument("credential_store_keepass_module", false, (Object)SOSKeePassDatabase.DEFAULT_MODULE.name());
    private SOSArgument<SOSKeePassDatabase> keepassDatabase = new SOSArgument(null, false);
    private SOSArgument<Entry<?, ?, ?, ?>> keepassDatabaseEntry = new SOSArgument(null, false);
    private SOSArgument<String> keepassAttachmentPropertyName = new SOSArgument(null, false);

    public SOSArgument<String> getFile() {
        return this.file;
    }

    public void setFile(String val) {
        this.file.setValue((Object)val);
    }

    public SOSArgument<String> getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(String val) {
        this.keyFile.setValue((Object)val);
    }

    public SOSArgument<String> getPassword() {
        return this.password;
    }

    public void setPassword(String val) {
        this.password.setValue((Object)val);
    }

    public SOSArgument<String> getKeePassModule() {
        return this.keePassModule;
    }

    public void setKeePassModule(String val) {
        this.keePassModule.setValue((Object)val);
    }

    public SOSArgument<String> getEntryPath() {
        return this.entryPath;
    }

    public void setEntryPath(String val) {
        this.entryPath.setValue((Object)val);
    }

    public SOSKeePassDatabase getKeepassDatabase() {
        return (SOSKeePassDatabase)this.keepassDatabase.getValue();
    }

    public void setKeepassDatabase(SOSKeePassDatabase val) {
        this.keepassDatabase.setValue((Object)val);
    }

    public Entry<?, ?, ?, ?> getKeepassDatabaseEntry() {
        return (Entry)this.keepassDatabaseEntry.getValue();
    }

    public void setKeepassDatabaseEntry(Entry<?, ?, ?, ?> val) {
        this.keepassDatabaseEntry.setValue(val);
    }

    public String getKeepassAttachmentPropertyName() {
        return (String)this.keepassAttachmentPropertyName.getValue();
    }

    public void setKeepassAttachmentPropertyName(String val) {
        this.keepassAttachmentPropertyName.setValue((Object)val);
    }

    public CredentialStoreResolver newResolver() {
        return new CredentialStoreResolver();
    }

    public class CredentialStoreResolver {
        private SOSKeePassResolver resolver = null;

        private CredentialStoreResolver() {
            if (CredentialStoreArguments.this.file.getValue() != null) {
                this.resolver = new SOSKeePassResolver((String)CredentialStoreArguments.this.file.getValue(), (String)CredentialStoreArguments.this.keyFile.getValue(), (String)CredentialStoreArguments.this.password.getValue());
                this.resolver.setEntryPath((String)CredentialStoreArguments.this.entryPath.getValue());
            }
        }

        public String resolve(String cs) throws SOSCredentialStoreException {
            return this.resolver == null ? cs : this.resolver.resolve(cs);
        }
    }
}

