/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;

public class SOSParameterSubstitutor {
    private Map<String, String> keylist;
    private StringSubstitutor strSubstitutorEnv;
    private StringSubstitutor strSubstitutor;
    private boolean caseSensitive = false;
    private String openTag = "${";
    private String closeTag = "}";

    public void setOpenTag(String openTag) {
        this.openTag = openTag;
    }

    public void setCloseTag(String closeTag) {
        this.closeTag = closeTag;
    }

    public SOSParameterSubstitutor() {
    }

    public SOSParameterSubstitutor(boolean caseSensitive_) {
        this.caseSensitive = caseSensitive_;
    }

    public SOSParameterSubstitutor(boolean caseSensitive_, String openTag_, String closeTag_) {
        this.openTag = openTag_;
        this.closeTag = closeTag_;
        this.caseSensitive = caseSensitive_;
    }

    public SOSParameterSubstitutor(String openTag_, String closeTag_) {
        this.openTag = openTag_;
        this.closeTag = closeTag_;
    }

    public void addKey(String k, String v) {
        if (this.keylist == null) {
            this.keylist = new HashMap<String, String>();
        }
        if (this.caseSensitive) {
            this.keylist.put(k, v);
        } else {
            this.keylist.put(k.toLowerCase(), v);
        }
    }

    public String replaceEnvVars(String source) {
        if (this.strSubstitutorEnv == null) {
            this.strSubstitutorEnv = new StringSubstitutor(System.getenv());
        }
        this.strSubstitutorEnv.setVariablePrefix(this.openTag);
        this.strSubstitutorEnv.setVariableSuffix(this.closeTag);
        return this.strSubstitutorEnv.replace(source);
    }

    public String replaceSystemProperties(String source) {
        return StringSubstitutor.replaceSystemProperties((Object)source);
    }

    public String replace(String source) {
        if (this.strSubstitutor == null) {
            this.strSubstitutor = this.caseSensitive ? new StringSubstitutor(this.keylist) : new StringSubstitutor(new SOSCaseInsensitivStrLookup<String>(this.keylist));
        }
        this.strSubstitutor.setVariablePrefix(this.openTag);
        this.strSubstitutor.setVariableSuffix(this.closeTag);
        return this.strSubstitutor.replace(source);
    }

    public String replace(Path path) throws IOException {
        return this.replace(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
    }

    public void replaceInFile(File in, File out) throws IOException {
        Path inPath = Paths.get(in.getAbsolutePath(), new String[0]);
        Path outPath = Paths.get(out.getAbsolutePath(), new String[0]);
        Charset charset = StandardCharsets.UTF_8;
        String content = new String(Files.readAllBytes(inPath), charset);
        content = this.replace(content);
        Files.write(outPath, content.getBytes(charset), new OpenOption[0]);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public List<String> getParameterNameFromString(String s) {
        ArrayList<String> l = new ArrayList<String>();
        String ot = Pattern.quote(this.openTag);
        String ct = Pattern.quote(this.closeTag);
        String regEx = ot + "([^" + ct + "]+)" + ct;
        Matcher m = Pattern.compile(regEx).matcher(s);
        while (m.find()) {
            l.add(m.group(1));
        }
        return l;
    }

    private class SOSCaseInsensitivStrLookup<V>
    implements StringLookup {
        private final Map<String, V> map;

        SOSCaseInsensitivStrLookup(Map<String, V> map) {
            this.map = map;
        }

        public String lookup(String key) {
            String lowercaseKey = key.toLowerCase();
            if (this.map == null) {
                return null;
            }
            V obj = this.map.get(lowercaseKey);
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
    }
}

