/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx;

import java.io.InputStream;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.kdbx.KdbxKeyFile;
import org.linguafranca.pwdb.security.Encryption;

public class KdbxCreds
implements Credentials {
    private final byte[] key;

    public KdbxCreds(@NotNull byte[] password, @NotNull InputStream inputStream) {
        MessageDigest md = Encryption.getSha256MessageDigestInstance();
        byte[] pwKey = md.digest(password);
        md.update(pwKey);
        byte[] keyFileData = KdbxKeyFile.load(inputStream);
        if (keyFileData == null) {
            throw new IllegalStateException("Could not read key file");
        }
        this.key = md.digest(keyFileData);
    }

    public KdbxCreds(@NotNull InputStream inputStream) {
        MessageDigest md = Encryption.getSha256MessageDigestInstance();
        byte[] keyFileData = KdbxKeyFile.load(inputStream);
        if (keyFileData == null) {
            throw new IllegalStateException("Could not read key file");
        }
        this.key = md.digest(keyFileData);
    }

    public KdbxCreds(@NotNull byte[] password) {
        MessageDigest md = Encryption.getSha256MessageDigestInstance();
        byte[] digest = md.digest(password);
        this.key = md.digest(digest);
    }

    public byte[] getKey() {
        return this.key;
    }
}

