/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.JmxMBeanPropertyCache;
import io.prometheus.jmx.JmxScraper;
import io.prometheus.jmx.MatchedRule;
import io.prometheus.jmx.MatchedRuleToMetricSnapshotsConverter;
import io.prometheus.jmx.MatchedRulesCache;
import io.prometheus.jmx.ObjectNameAttributeFilter;
import io.prometheus.jmx.logger.Logger;
import io.prometheus.jmx.logger.LoggerFactory;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.core.metrics.Gauge;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.Unit;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.yaml.snakeyaml.Yaml;

public class JmxCollector
implements MultiCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxCollector.class);
    private final Mode mode;
    private Config config;
    private File configFile;
    private final long createTimeNanoSecs = System.nanoTime();
    private Counter configReloadSuccess;
    private Counter configReloadFailure;
    private Gauge jmxScrapeDurationSeconds;
    private Gauge jmxScrapeError;
    private Gauge jmxScrapeCachedBeans;
    private final JmxMBeanPropertyCache jmxMBeanPropertyCache = new JmxMBeanPropertyCache();

    public JmxCollector(File in) throws IOException, MalformedObjectNameException {
        this(in, null);
    }

    public JmxCollector(File in, Mode mode) throws IOException, MalformedObjectNameException {
        this.configFile = in;
        this.mode = mode;
        this.config = this.loadConfig((Map)new Yaml().load((Reader)new FileReader(in)));
        this.config.lastUpdate = this.configFile.lastModified();
        this.exitOnConfigError();
    }

    public JmxCollector(String yamlConfig) throws MalformedObjectNameException {
        this.config = this.loadConfig((Map)new Yaml().load(yamlConfig));
        this.mode = null;
    }

    public JmxCollector(InputStream inputStream) throws MalformedObjectNameException {
        this.config = this.loadConfig((Map)new Yaml().load(inputStream));
        this.mode = null;
    }

    public JmxCollector register() {
        return this.register(PrometheusRegistry.defaultRegistry);
    }

    public JmxCollector register(PrometheusRegistry prometheusRegistry) {
        this.configReloadSuccess = (Counter)((Counter.Builder)Counter.builder().name("jmx_config_reload_success_total").help("Number of times configuration have successfully been reloaded.")).register(prometheusRegistry);
        this.configReloadFailure = (Counter)((Counter.Builder)Counter.builder().name("jmx_config_reload_failure_total").help("Number of times configuration have failed to be reloaded.")).register(prometheusRegistry);
        this.jmxScrapeDurationSeconds = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("jmx_scrape_duration_seconds")).help("Time this JMX scrape took, in seconds.")).unit(Unit.SECONDS)).register(prometheusRegistry);
        this.jmxScrapeError = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("jmx_scrape_error")).help("Non-zero if this scrape failed.")).register(prometheusRegistry);
        this.jmxScrapeCachedBeans = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.builder().name("jmx_scrape_cached_beans")).help("Number of beans with their matching rule cached")).register(prometheusRegistry);
        prometheusRegistry.register((MultiCollector)this);
        return this;
    }

    private void exitOnConfigError() {
        if (this.mode == Mode.AGENT && !this.config.jmxUrl.isEmpty()) {
            LOGGER.error("Configuration error: When running jmx_exporter as a Java agent, you must not configure 'jmxUrl' or 'hostPort' because you don't want to monitor a remote JVM.");
            System.exit(-1);
        }
        if (this.mode == Mode.STANDALONE && this.config.jmxUrl.isEmpty()) {
            LOGGER.error("Configuration error: When running jmx_exporter in standalone mode (using jmx_prometheus_standalone-*.jar) you must configure 'jmxUrl' or 'hostPort'.");
            System.exit(-1);
        }
    }

    private void reloadConfig() {
        try (FileReader fr = new FileReader(this.configFile);){
            Map newYamlConfig = (Map)new Yaml().load((Reader)fr);
            Config newConfig = this.loadConfig(newYamlConfig);
            newConfig.lastUpdate = this.configFile.lastModified();
            this.config = newConfig;
            this.configReloadSuccess.inc();
        }
        catch (Exception e) {
            LOGGER.error("Configuration reload failed: %s: ", e);
            this.configReloadFailure.inc();
        }
    }

    private synchronized Config getLatestConfig() {
        long lastModified;
        if (this.configFile != null && (lastModified = this.configFile.lastModified()) > this.config.lastUpdate) {
            LOGGER.trace("Configuration file changed, reloading...");
            this.reloadConfig();
        }
        this.exitOnConfigError();
        return this.config;
    }

    private Config loadConfig(Map<String, Object> yamlConfig) throws MalformedObjectNameException {
        Boolean excludeJvmMetrics;
        List names;
        Config cfg = new Config();
        if (yamlConfig == null) {
            yamlConfig = new HashMap<String, Object>();
        }
        if (yamlConfig.containsKey("startDelaySeconds")) {
            try {
                cfg.startDelaySeconds = (Integer)yamlConfig.get("startDelaySeconds");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number provided for startDelaySeconds", e);
            }
        }
        if (yamlConfig.containsKey("hostPort")) {
            if (yamlConfig.containsKey("jmxUrl")) {
                throw new IllegalArgumentException("At most one of hostPort and jmxUrl must be provided");
            }
            cfg.jmxUrl = "service:jmx:rmi:///jndi/rmi://" + yamlConfig.get("hostPort") + "/jmxrmi";
        } else if (yamlConfig.containsKey("jmxUrl")) {
            cfg.jmxUrl = (String)yamlConfig.get("jmxUrl");
        }
        if (yamlConfig.containsKey("username")) {
            cfg.username = (String)yamlConfig.get("username");
        }
        if (yamlConfig.containsKey("password")) {
            cfg.password = (String)yamlConfig.get("password");
        }
        if (yamlConfig.containsKey("ssl")) {
            cfg.ssl = (Boolean)yamlConfig.get("ssl");
        }
        if (yamlConfig.containsKey("lowercaseOutputName")) {
            cfg.lowercaseOutputName = (Boolean)yamlConfig.get("lowercaseOutputName");
        }
        if (yamlConfig.containsKey("lowercaseOutputLabelNames")) {
            cfg.lowercaseOutputLabelNames = (Boolean)yamlConfig.get("lowercaseOutputLabelNames");
        }
        if (yamlConfig.containsKey("inferCounterTypeFromName")) {
            cfg.inferCounterTypeFromName = (Boolean)yamlConfig.get("inferCounterTypeFromName");
        }
        if (yamlConfig.containsKey("includeObjectNames")) {
            names = (List)yamlConfig.get("includeObjectNames");
            for (Object name : names) {
                cfg.includeObjectNames.add(new ObjectName((String)name));
            }
        } else if (yamlConfig.containsKey("whitelistObjectNames")) {
            names = (List)yamlConfig.get("whitelistObjectNames");
            for (Object name : names) {
                cfg.includeObjectNames.add(new ObjectName((String)name));
            }
        } else {
            cfg.includeObjectNames.add(null);
        }
        if (yamlConfig.containsKey("excludeObjectNames")) {
            names = (List)yamlConfig.get("excludeObjectNames");
            for (Object name : names) {
                cfg.excludeObjectNames.add(new ObjectName((String)name));
            }
        } else if (yamlConfig.containsKey("blacklistObjectNames")) {
            names = (List)yamlConfig.get("blacklistObjectNames");
            for (Object name : names) {
                cfg.excludeObjectNames.add(new ObjectName((String)name));
            }
        }
        if (yamlConfig.containsKey("excludeJvmMetrics") && (excludeJvmMetrics = (Boolean)yamlConfig.get("excludeJvmMetrics")) != null && excludeJvmMetrics.booleanValue()) {
            cfg.excludeObjectNames.add(new ObjectName("com.sun.management:*"));
            cfg.excludeObjectNames.add(new ObjectName("com.sun.management.jmxremote:*"));
            cfg.excludeObjectNames.add(new ObjectName("java.lang:*"));
            cfg.excludeObjectNames.add(new ObjectName("java.nio:*"));
            cfg.excludeObjectNames.add(new ObjectName("java.util.logging:*"));
            cfg.excludeObjectNames.add(new ObjectName("javax.management:*"));
            cfg.excludeObjectNames.add(new ObjectName("javax.management.remote:*"));
            cfg.excludeObjectNames.add(new ObjectName("jdk.internal:*"));
            cfg.excludeObjectNames.add(new ObjectName("jdk.management:*"));
            cfg.excludeObjectNames.add(new ObjectName("jdk.management.jfr:*"));
            cfg.excludeObjectNames.add(new ObjectName("sun.management:*"));
        }
        if (yamlConfig.containsKey("metricCustomizers")) {
            List metricCustomizersYaml = (List)yamlConfig.get("metricCustomizers");
            if (metricCustomizersYaml != null) {
                for (Map metricCustomizerYaml : metricCustomizersYaml) {
                    Map mbeanFilterYaml = (Map)metricCustomizerYaml.get("mbeanFilter");
                    if (mbeanFilterYaml == null) {
                        throw new IllegalArgumentException("Must provide mbeanFilter, if metricCustomizers is given: " + metricCustomizersYaml);
                    }
                    MBeanFilter mbeanFilter = new MBeanFilter();
                    mbeanFilter.domain = (String)mbeanFilterYaml.get("domain");
                    if (mbeanFilter.domain == null) {
                        throw new IllegalArgumentException("Must provide domain, if metricCustomizers is given: " + metricCustomizersYaml);
                    }
                    mbeanFilter.properties = mbeanFilterYaml.getOrDefault("properties", new HashMap());
                    List attributesAsLabelsYaml = (List)metricCustomizerYaml.get("attributesAsLabels");
                    List extraMetricsYaml = (List)metricCustomizerYaml.get("extraMetrics");
                    if (attributesAsLabelsYaml == null && extraMetricsYaml == null) {
                        throw new IllegalArgumentException("Must provide attributesAsLabels or extraMetrics, if metricCustomizers is given: " + metricCustomizersYaml);
                    }
                    MetricCustomizer metricCustomizer = new MetricCustomizer();
                    metricCustomizer.mbeanFilter = mbeanFilter;
                    metricCustomizer.attributesAsLabels = attributesAsLabelsYaml;
                    if (extraMetricsYaml != null) {
                        ArrayList<ExtraMetric> extraMetrics = new ArrayList<ExtraMetric>();
                        for (Map extraMetricYaml : extraMetricsYaml) {
                            ExtraMetric extraMetric = new ExtraMetric();
                            extraMetric.name = (String)extraMetricYaml.get("name");
                            if (extraMetric.name == null) {
                                throw new IllegalArgumentException("Must provide name, if extraMetric is given: " + extraMetricsYaml);
                            }
                            extraMetric.value = extraMetricYaml.get("value");
                            if (extraMetric.value == null) {
                                throw new IllegalArgumentException("Must provide value, if extraMetric is given: " + extraMetricsYaml);
                            }
                            extraMetric.description = (String)extraMetricYaml.get("description");
                            extraMetrics.add(extraMetric);
                        }
                        metricCustomizer.extraMetrics = extraMetrics;
                    }
                    cfg.metricCustomizers.add(metricCustomizer);
                }
            } else {
                throw new IllegalArgumentException("Must provide mbeanFilter, if metricCustomizers is given ");
            }
        }
        if (yamlConfig.containsKey("rules")) {
            List configRules = (List)yamlConfig.get("rules");
            for (Map yamlRule : configRules) {
                Rule rule = new Rule();
                cfg.rules.add(rule);
                if (yamlRule.containsKey("pattern")) {
                    rule.pattern = Pattern.compile("^.*(?:" + yamlRule.get("pattern") + ").*$");
                }
                if (yamlRule.containsKey("name")) {
                    rule.name = (String)yamlRule.get("name");
                }
                if (yamlRule.containsKey("value")) {
                    rule.value = String.valueOf(yamlRule.get("value"));
                }
                if (yamlRule.containsKey("valueFactor")) {
                    String valueFactor = String.valueOf(yamlRule.get("valueFactor"));
                    try {
                        rule.valueFactor = Double.valueOf(valueFactor);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (yamlRule.containsKey("attrNameSnakeCase")) {
                    rule.attrNameSnakeCase = (Boolean)yamlRule.get("attrNameSnakeCase");
                }
                if (yamlRule.containsKey("cache")) {
                    rule.cache = (Boolean)yamlRule.get("cache");
                }
                if (yamlRule.containsKey("type")) {
                    String t = (String)yamlRule.get("type");
                    if ("UNTYPED".equals(t)) {
                        t = "UNKNOWN";
                    }
                    rule.type = t;
                }
                if (yamlRule.containsKey("help")) {
                    rule.help = (String)yamlRule.get("help");
                }
                if (yamlRule.containsKey("labels")) {
                    TreeMap labels = new TreeMap((Map)yamlRule.get("labels"));
                    rule.labelNames = new ArrayList();
                    rule.labelValues = new ArrayList();
                    for (Map.Entry entry : labels.entrySet()) {
                        rule.labelNames.add((String)entry.getKey());
                        rule.labelValues.add((String)entry.getValue());
                    }
                }
                if ((rule.labelNames != null || rule.help != null) && rule.name == null) {
                    throw new IllegalArgumentException("Must provide name, if help or labels are given: " + yamlRule);
                }
                if (rule.name == null || rule.pattern != null) continue;
                throw new IllegalArgumentException("Must provide pattern, if name is given: " + yamlRule);
            }
        } else {
            cfg.rules.add(new Rule());
        }
        boolean hasCachedRules = false;
        for (Rule rule : cfg.rules) {
            hasCachedRules |= rule.cache;
        }
        if (hasCachedRules) {
            cfg.rulesCache = new MatchedRulesCache();
        }
        cfg.objectNameAttributeFilter = ObjectNameAttributeFilter.create(yamlConfig);
        return cfg;
    }

    static String toSnakeAndLowerCase(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        char firstChar = name.charAt(0);
        boolean prevCharIsUpperCaseOrUnderscore = Character.isUpperCase(firstChar) || firstChar == '_';
        StringBuilder stringBuilder = new StringBuilder(name.length()).append(Character.toLowerCase(firstChar));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean charIsUpperCase = Character.isUpperCase(c);
            if (!prevCharIsUpperCaseOrUnderscore && charIsUpperCase) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(c));
            prevCharIsUpperCaseOrUnderscore = charIsUpperCase || c == '_';
        }
        return stringBuilder.toString();
    }

    static String toSafeName(String name) {
        if (name == null) {
            return null;
        }
        boolean prevCharIsUnderscore = false;
        StringBuilder stringBuilder = new StringBuilder(name.length());
        if (!name.isEmpty() && Character.isDigit(name.charAt(0))) {
            stringBuilder.append("_");
        }
        for (int i = 0; i < name.length(); ++i) {
            boolean isUnsafeChar;
            char c = name.charAt(i);
            boolean bl = isUnsafeChar = !JmxCollector.isLegalCharacter(c);
            if (isUnsafeChar || c == '_') {
                if (prevCharIsUnderscore) continue;
                stringBuilder.append("_");
                prevCharIsUnderscore = true;
                continue;
            }
            stringBuilder.append(c);
            prevCharIsUnderscore = false;
        }
        return stringBuilder.toString();
    }

    private static boolean isLegalCharacter(char input) {
        return input == ':' || input == '_' || input >= 'a' && input <= 'z' || input >= 'A' && input <= 'Z' || input >= '0' && input <= '9';
    }

    private static void addAttributesAsLabelsWithValuesToLabels(Config config, Map<String, String> attributesAsLabelsWithValues, List<String> labelNames, List<String> labelValues) {
        attributesAsLabelsWithValues.forEach((attributeAsLabelName, attributeValue) -> {
            String labelName = JmxCollector.toSafeName(attributeAsLabelName);
            if (config.lowercaseOutputLabelNames) {
                labelName = labelName.toLowerCase();
            }
            labelNames.add(labelName);
            labelValues.add((String)attributeValue);
        });
    }

    public MetricSnapshots collect() {
        Config config = this.getLatestConfig();
        MatchedRulesCache.StalenessTracker stalenessTracker = new MatchedRulesCache.StalenessTracker();
        Receiver receiver = new Receiver(config, stalenessTracker);
        JmxScraper scraper = new JmxScraper(config.jmxUrl, config.username, config.password, config.ssl, config.includeObjectNames, config.excludeObjectNames, config.objectNameAttributeFilter, config.metricCustomizers, receiver, this.jmxMBeanPropertyCache);
        long start = System.nanoTime();
        double error = 0.0;
        if (config.startDelaySeconds > 0 && (start - this.createTimeNanoSecs) / 1000000000L < (long)config.startDelaySeconds.intValue()) {
            throw new IllegalStateException("JMXCollector waiting for startDelaySeconds");
        }
        try {
            scraper.doScrape();
        }
        catch (Exception e) {
            error = 1.0;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOGGER.error("JMX scrape failed: %s", sw);
        }
        if (config.rulesCache != null) {
            config.rulesCache.evictStaleEntries(stalenessTracker);
        }
        this.jmxScrapeDurationSeconds.set((double)(System.nanoTime() - start) / 1.0E9);
        this.jmxScrapeError.set(error);
        this.jmxScrapeCachedBeans.set((double)stalenessTracker.freshCount());
        return MatchedRuleToMetricSnapshotsConverter.convert(receiver.matchedRules);
    }

    private static class Config {
        Integer startDelaySeconds = 0;
        String jmxUrl = "";
        String username = "";
        String password = "";
        boolean ssl = false;
        boolean lowercaseOutputName;
        boolean lowercaseOutputLabelNames;
        boolean inferCounterTypeFromName;
        final List<ObjectName> includeObjectNames = new ArrayList<ObjectName>();
        final List<ObjectName> excludeObjectNames = new ArrayList<ObjectName>();
        ObjectNameAttributeFilter objectNameAttributeFilter;
        final List<Rule> rules = new ArrayList<Rule>();
        long lastUpdate = 0L;
        List<MetricCustomizer> metricCustomizers = new ArrayList<MetricCustomizer>();
        MatchedRulesCache rulesCache;

        private Config() {
        }
    }

    public static enum Mode {
        AGENT,
        STANDALONE;

    }

    public static class MBeanFilter {
        String domain;
        Map<String, String> properties;
    }

    public static class MetricCustomizer {
        MBeanFilter mbeanFilter;
        List<String> attributesAsLabels;
        List<ExtraMetric> extraMetrics;
    }

    static class ExtraMetric {
        String name;
        Object value;
        String description;

        ExtraMetric() {
        }
    }

    static class Rule {
        Pattern pattern;
        String name;
        String value;
        Double valueFactor = 1.0;
        String help;
        boolean attrNameSnakeCase;
        boolean cache = false;
        String type = "UNKNOWN";
        ArrayList<String> labelNames;
        ArrayList<String> labelValues;

        Rule() {
        }
    }

    static class Receiver
    implements JmxScraper.MBeanReceiver {
        final List<MatchedRule> matchedRules = new ArrayList<MatchedRule>();
        final Config config;
        final MatchedRulesCache.StalenessTracker stalenessTracker;
        private static final char SEP = '_';

        Receiver(Config config, MatchedRulesCache.StalenessTracker stalenessTracker) {
            this.config = config;
            this.stalenessTracker = stalenessTracker;
        }

        private String angleBrackets(String s) {
            return "<" + s.substring(1, s.length() - 1) + ">";
        }

        private void addToCache(MatchedRulesCache.CacheKey cacheKey, MatchedRule matchedRule) {
            if (this.config.rulesCache != null && cacheKey != null) {
                this.config.rulesCache.put(cacheKey, matchedRule);
                this.stalenessTracker.markAsFresh(cacheKey);
            }
        }

        private MatchedRule defaultExport(String matchName, String domain, LinkedHashMap<String, String> beanProperties, LinkedList<String> attrKeys, String attrName, String help, Double value, double valueFactor, String type, Map<String, String> attributesAsLabelsWithValues) {
            StringBuilder name = new StringBuilder();
            name.append(domain);
            if (!beanProperties.isEmpty()) {
                name.append('_');
                name.append(beanProperties.values().iterator().next());
            }
            for (String k : attrKeys) {
                name.append('_');
                name.append(k);
            }
            name.append('_');
            name.append(attrName);
            String fullname = JmxCollector.toSafeName(name.toString());
            if (this.config.lowercaseOutputName) {
                fullname = fullname.toLowerCase();
            }
            if (this.config.inferCounterTypeFromName && fullname.endsWith("_total")) {
                type = "COUNTER";
            }
            ArrayList<String> labelNames = new ArrayList<String>();
            ArrayList<String> labelValues = new ArrayList<String>();
            if (beanProperties.size() > 1) {
                Iterator<Map.Entry<String, String>> iter = beanProperties.entrySet().iterator();
                iter.next();
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    String labelName = JmxCollector.toSafeName(entry.getKey());
                    if (this.config.lowercaseOutputLabelNames) {
                        labelName = labelName.toLowerCase();
                    }
                    labelNames.add(labelName);
                    labelValues.add(entry.getValue());
                }
            }
            JmxCollector.addAttributesAsLabelsWithValuesToLabels(this.config, attributesAsLabelsWithValues, labelNames, labelValues);
            return new MatchedRule(fullname, matchName, type, help, labelNames, labelValues, value, valueFactor);
        }

        @Override
        public void recordBean(String domain, LinkedHashMap<String, String> beanProperties, Map<String, String> attributesAsLabelsWithValues, LinkedList<String> attrKeys, String attrName, String attrType, String attrDescription, Object beanValue) {
            Number value;
            MatchedRule matchedRule = MatchedRule.unmatched();
            MatchedRulesCache.CacheKey cacheKey = null;
            MatchedRule cachedRule = null;
            if (this.config.rulesCache != null && (cachedRule = this.config.rulesCache.get(cacheKey = new MatchedRulesCache.CacheKey(domain, beanProperties, attrKeys, attrName))) != null) {
                this.stalenessTracker.markAsFresh(cacheKey);
                matchedRule = cachedRule;
            }
            if (matchedRule.isUnmatched()) {
                String beanName = domain + this.angleBrackets(beanProperties.toString()) + this.angleBrackets(attrKeys.toString());
                String help = domain + ":name=" + beanProperties.get("name") + ",type=" + beanProperties.get("type") + ",attribute=" + attrName;
                if (attrDescription != null && !attrDescription.equals(attrName)) {
                    help = attrDescription + " " + help;
                }
                for (Rule rule : this.config.rules) {
                    if (rule.cache && cachedRule != null) continue;
                    Object matchBeanValue = rule.cache ? "<cache>" : beanValue;
                    String attributeName = rule.attrNameSnakeCase ? JmxCollector.toSnakeAndLowerCase(attrName) : attrName;
                    String matchName = beanName + attributeName + ": " + matchBeanValue;
                    Matcher matcher = null;
                    if (rule.pattern != null && !(matcher = rule.pattern.matcher(matchName)).matches()) continue;
                    Double value2 = null;
                    if (rule.value != null && !rule.value.isEmpty()) {
                        String val = matcher.replaceAll(rule.value);
                        try {
                            value2 = Double.valueOf(val);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.trace("Unable to parse configured value '%s' to number for bean: %s%s: %s", val, beanName, attrName, beanValue);
                            return;
                        }
                    }
                    if (rule.name == null) {
                        matchedRule = this.defaultExport(matchName, domain, beanProperties, attrKeys, attributeName, help, value2, rule.valueFactor, rule.type, attributesAsLabelsWithValues);
                        if (!rule.cache) break;
                        this.addToCache(cacheKey, matchedRule);
                        break;
                    }
                    String name = JmxCollector.toSafeName(matcher.replaceAll(rule.name));
                    if (name.isEmpty()) {
                        return;
                    }
                    if (this.config.lowercaseOutputName) {
                        name = name.toLowerCase();
                    }
                    String type = rule.type;
                    if (this.config.inferCounterTypeFromName && name.endsWith("_total")) {
                        type = "COUNTER";
                    }
                    if (rule.help != null) {
                        help = matcher.replaceAll(rule.help);
                    }
                    ArrayList<String> labelNames = new ArrayList<String>();
                    ArrayList<String> labelValues = new ArrayList<String>();
                    JmxCollector.addAttributesAsLabelsWithValuesToLabels(this.config, attributesAsLabelsWithValues, labelNames, labelValues);
                    if (rule.labelNames != null) {
                        for (int i = 0; i < rule.labelNames.size(); ++i) {
                            String unsafeLabelName = rule.labelNames.get(i);
                            String labelValReplacement = rule.labelValues.get(i);
                            try {
                                String labelName = JmxCollector.toSafeName(matcher.replaceAll(unsafeLabelName));
                                String labelValue = matcher.replaceAll(labelValReplacement);
                                if (this.config.lowercaseOutputLabelNames) {
                                    labelName = labelName.toLowerCase();
                                }
                                if (labelName.isEmpty() || labelValue.isEmpty()) continue;
                                labelNames.add(labelName);
                                labelValues.add(labelValue);
                                continue;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(String.format("Matcher '%s' unable to use: '%s' value: '%s'", matcher, unsafeLabelName, labelValReplacement), e);
                            }
                        }
                    }
                    matchedRule = new MatchedRule(name, matchName, type, help, labelNames, labelValues, value2, rule.valueFactor);
                    if (!rule.cache) break;
                    this.addToCache(cacheKey, matchedRule);
                    break;
                }
            }
            if (matchedRule.isUnmatched()) {
                this.addToCache(cacheKey, matchedRule);
                return;
            }
            if (matchedRule.value != null) {
                beanValue = matchedRule.value;
            }
            if (beanValue instanceof Number) {
                value = ((Number)beanValue).doubleValue() * matchedRule.valueFactor;
            } else if (beanValue instanceof Boolean) {
                value = (Boolean)beanValue != false ? 1 : 0;
            } else {
                LOGGER.trace("Ignoring unsupported bean: %s%s%s%s: %s ", domain, this.angleBrackets(beanProperties.toString()), this.angleBrackets(attrKeys.toString()), attrName, beanValue);
                return;
            }
            LOGGER.trace("add metric sample: %s %s %s", matchedRule.name, matchedRule.labels, value.doubleValue());
            this.matchedRules.add(matchedRule.withValue(value.doubleValue()));
        }
    }
}

