/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;
import java.util.List;
import java.util.Objects;

public class MatchedRule {
    final String name;
    final String matchName;
    final String type;
    final String help;
    final Labels labels;
    final Double value;
    final double valueFactor;
    private static final MatchedRule _unmatched = new MatchedRule();

    private MatchedRule() {
        this.name = null;
        this.matchName = null;
        this.type = null;
        this.help = null;
        this.labels = null;
        this.value = null;
        this.valueFactor = 1.0;
    }

    public MatchedRule(String name, String matchName, String type, String help, List<String> labelNames, List<String> labelValues, Double value, double valueFactor) {
        this.name = PrometheusNaming.sanitizeMetricName((String)name);
        this.matchName = matchName;
        this.type = type;
        this.help = help;
        this.labels = Labels.of(labelNames, labelValues);
        this.value = value;
        this.valueFactor = valueFactor;
    }

    private MatchedRule(String name, String matchName, String type, String help, Labels labels, Double value, double valueFactor) {
        this.name = name;
        this.matchName = matchName;
        this.type = type;
        this.help = help;
        this.labels = labels;
        this.value = value;
        this.valueFactor = valueFactor;
    }

    public MatchedRule withValue(double value) {
        return new MatchedRule(this.name, this.matchName, this.type, this.help, this.labels, value, this.valueFactor);
    }

    public static MatchedRule unmatched() {
        return _unmatched;
    }

    public boolean isUnmatched() {
        return this == _unmatched;
    }

    public boolean isMatched() {
        return !this.isUnmatched();
    }

    public String toString() {
        return "MatchedRule{name='" + this.name + '\'' + ", matchName='" + this.matchName + '\'' + ", type='" + this.type + '\'' + ", help='" + this.help + '\'' + ", labels=" + this.labels + ", value=" + this.value + ", valueFactor=" + this.valueFactor + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchedRule that = (MatchedRule)o;
        return Double.compare(this.valueFactor, that.valueFactor) == 0 && Objects.equals(this.name, that.name) && Objects.equals(this.matchName, that.matchName) && Objects.equals(this.type, that.type) && Objects.equals(this.help, that.help) && Objects.equals(this.labels, that.labels) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.matchName, this.type, this.help, this.labels, this.value, this.valueFactor);
    }
}

