/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.MatchedRule;
import io.prometheus.jmx.logger.Logger;
import io.prometheus.jmx.logger.LoggerFactory;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class MatchedRuleToMetricSnapshotsConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatchedRuleToMetricSnapshotsConverter.class);
    private static final String OBJECTNAME = "_objectname";

    public static MetricSnapshots convert(List<MatchedRule> matchedRules) {
        HashMap<String, List> rulesByPrometheusMetricName = new HashMap<String, List>();
        for (MatchedRule matchedRule : matchedRules) {
            List matchedRulesWithSameName = rulesByPrometheusMetricName.computeIfAbsent(matchedRule.name, name -> new ArrayList());
            matchedRulesWithSameName.add(matchedRule);
        }
        if (LOGGER.isTraceEnabled()) {
            rulesByPrometheusMetricName.values().forEach(matchedRules1 -> matchedRules1.forEach(matchedRule -> LOGGER.trace("matchedRule %s", matchedRule)));
        }
        MetricSnapshots.Builder result = MetricSnapshots.builder();
        for (List rulesWithSameName : rulesByPrometheusMetricName.values()) {
            result.metricSnapshot(MatchedRuleToMetricSnapshotsConverter.convertRulesWithSameName(rulesWithSameName));
        }
        return result.build();
    }

    private static MetricSnapshot convertRulesWithSameName(List<MatchedRule> rulesWithSameName) {
        boolean labelsUnique = MatchedRuleToMetricSnapshotsConverter.isLabelsUnique(rulesWithSameName);
        switch (MatchedRuleToMetricSnapshotsConverter.getType(rulesWithSameName)) {
            case "COUNTER": {
                CounterSnapshot.Builder counterBuilder = (CounterSnapshot.Builder)((CounterSnapshot.Builder)CounterSnapshot.builder().name(rulesWithSameName.get((int)0).name)).help(rulesWithSameName.get((int)0).help);
                for (MatchedRule rule : rulesWithSameName) {
                    Labels labels = rule.labels;
                    if (!labelsUnique) {
                        labels = labels.merge(Labels.of((String[])new String[]{OBJECTNAME, rule.matchName.substring(0, rule.matchName.lastIndexOf(":"))}));
                    }
                    counterBuilder.dataPoint(((CounterSnapshot.CounterDataPointSnapshot.Builder)CounterSnapshot.CounterDataPointSnapshot.builder().labels(labels)).value(rule.value.doubleValue()).build());
                }
                return counterBuilder.build();
            }
            case "GAUGE": {
                GaugeSnapshot.Builder gaugeBuilder = (GaugeSnapshot.Builder)((GaugeSnapshot.Builder)GaugeSnapshot.builder().name(rulesWithSameName.get((int)0).name)).help(rulesWithSameName.get((int)0).help);
                for (MatchedRule rule : rulesWithSameName) {
                    Labels labels = rule.labels;
                    if (!labelsUnique) {
                        labels = labels.merge(Labels.of((String[])new String[]{OBJECTNAME, rule.matchName.substring(0, rule.matchName.lastIndexOf(":"))}));
                    }
                    gaugeBuilder.dataPoint(((GaugeSnapshot.GaugeDataPointSnapshot.Builder)GaugeSnapshot.GaugeDataPointSnapshot.builder().labels(labels)).value(rule.value.doubleValue()).build());
                }
                return gaugeBuilder.build();
            }
        }
        UnknownSnapshot.Builder unknownBuilder = (UnknownSnapshot.Builder)((UnknownSnapshot.Builder)UnknownSnapshot.builder().name(rulesWithSameName.get((int)0).name)).help(rulesWithSameName.get((int)0).help);
        for (MatchedRule rule : rulesWithSameName) {
            Labels labels = rule.labels;
            if (!labelsUnique) {
                labels = labels.merge(Labels.of((String[])new String[]{OBJECTNAME, rule.matchName.substring(0, rule.matchName.lastIndexOf(":"))}));
            }
            unknownBuilder.dataPoint(((UnknownSnapshot.UnknownDataPointSnapshot.Builder)UnknownSnapshot.UnknownDataPointSnapshot.builder().labels(labels)).value(rule.value.doubleValue()).build());
        }
        return unknownBuilder.build();
    }

    private static String getType(List<MatchedRule> rulesWithSameName) {
        if (rulesWithSameName.stream().map(rule -> rule.type).distinct().count() == 1L) {
            return rulesWithSameName.get((int)0).type;
        }
        return "UNKNOWN";
    }

    private static boolean isLabelsUnique(List<MatchedRule> rulesWithSameName) {
        HashSet<Labels> labelsSet = new HashSet<Labels>(rulesWithSameName.size());
        for (MatchedRule matchedRule : rulesWithSameName) {
            Labels labels = matchedRule.labels;
            if (labelsSet.contains(labels)) {
                return false;
            }
            labelsSet.add(labels);
        }
        return true;
    }
}

