/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx;

import io.prometheus.jmx.logger.Logger;
import io.prometheus.jmx.logger.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameAttributeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectNameAttributeFilter.class);
    public static final String EXCLUDE_OBJECT_NAME_ATTRIBUTES = "excludeObjectNameAttributes";
    public static final String INCLUDE_OBJECT_NAME_ATTRIBUTES = "includeObjectNameAttributes";
    public static final String AUTO_EXCLUDE_OBJECT_NAME_ATTRIBUTES = "autoExcludeObjectNameAttributes";
    private final Map<ObjectName, Set<String>> configExcludeObjectNameAttributesMap = new ConcurrentHashMap<ObjectName, Set<String>>();
    private final Map<ObjectName, Set<String>> dynamicExcludeObjectNameAttributesMap = new ConcurrentHashMap<ObjectName, Set<String>>();
    private final Map<ObjectName, Set<String>> includeObjectNameAttributesMap = new ConcurrentHashMap<ObjectName, Set<String>>();
    private boolean autoExcludeObjectNameAttributes;

    private ObjectNameAttributeFilter() {
    }

    private ObjectNameAttributeFilter initialize(Map<String, Object> yamlConfig) throws MalformedObjectNameException {
        this.initializeObjectNameAttributes(yamlConfig, EXCLUDE_OBJECT_NAME_ATTRIBUTES, this.configExcludeObjectNameAttributesMap);
        this.initializeObjectNameAttributes(yamlConfig, INCLUDE_OBJECT_NAME_ATTRIBUTES, this.includeObjectNameAttributesMap);
        this.autoExcludeObjectNameAttributes = yamlConfig.containsKey(AUTO_EXCLUDE_OBJECT_NAME_ATTRIBUTES) ? (Boolean)yamlConfig.get(AUTO_EXCLUDE_OBJECT_NAME_ATTRIBUTES) : true;
        LOGGER.trace("dynamicExclusion [%b]", (Object)this.autoExcludeObjectNameAttributes);
        return this;
    }

    private void initializeObjectNameAttributes(Map<String, Object> yamlConfig, String key, Map<ObjectName, Set<String>> objectNameAttributesMap) throws MalformedObjectNameException {
        if (yamlConfig.containsKey(key)) {
            Map objectNameAttributeMap = (Map)yamlConfig.get(key);
            for (Map.Entry entry : objectNameAttributeMap.entrySet()) {
                ObjectName objectName = new ObjectName((String)entry.getKey());
                List attributeNames = (List)entry.getValue();
                Set attributeNameSet = objectNameAttributesMap.computeIfAbsent(objectName, o -> Collections.synchronizedSet(new HashSet()));
                attributeNameSet.addAll(attributeNames);
            }
        }
    }

    public void add(ObjectName objectName, String attributeName) {
        if (this.autoExcludeObjectNameAttributes) {
            Set attributeNameSet = this.dynamicExcludeObjectNameAttributesMap.computeIfAbsent(objectName, o -> Collections.synchronizedSet(new HashSet()));
            LOGGER.trace("auto adding exclusion of object name [%s] attribute name [%s]", objectName.getCanonicalName(), attributeName);
            attributeNameSet.add(attributeName);
        }
    }

    public void onlyKeepMBeans(Set<ObjectName> aliveMBeans) {
        if (this.autoExcludeObjectNameAttributes) {
            for (ObjectName prevName : this.dynamicExcludeObjectNameAttributesMap.keySet()) {
                if (aliveMBeans.contains(prevName)) continue;
                this.dynamicExcludeObjectNameAttributesMap.remove(prevName);
            }
        }
    }

    public boolean exclude(ObjectName objectName, String attributeName) {
        return this.exclude(this.configExcludeObjectNameAttributesMap, objectName, attributeName) || this.exclude(this.dynamicExcludeObjectNameAttributesMap, objectName, attributeName);
    }

    private boolean exclude(Map<ObjectName, Set<String>> exclusionMap, ObjectName objectName, String attributeName) {
        Set<String> attributeNameSet;
        boolean result = false;
        if (!exclusionMap.isEmpty() && (attributeNameSet = exclusionMap.get(objectName)) != null) {
            result = attributeNameSet.contains(attributeName);
        }
        return result;
    }

    public boolean include(ObjectName objectName, String attributeName) {
        boolean result = false;
        Set<String> attributeNameSet = this.includeObjectNameAttributesMap.get(objectName);
        if (attributeNameSet != null) {
            result = attributeNameSet.contains(attributeName);
        }
        return result;
    }

    public boolean includeObjectNameAttributesIsEmpty() {
        return this.includeObjectNameAttributesMap.isEmpty();
    }

    public static ObjectNameAttributeFilter create(Map<String, Object> yamlConfig) {
        try {
            return new ObjectNameAttributeFilter().initialize(yamlConfig);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid configuration format for excludeObjectNameAttributes", e);
        }
    }
}

