/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.logger;

import io.prometheus.jmx.logger.Logger;
import io.prometheus.jmx.logger.LoggerFormatter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Handler;
import java.util.logging.SimpleFormatter;

public class LoggerFactory {
    private static final String ROOT_LOGGER = "";
    private static final ConcurrentMap<Class<?>, Logger> CACHE = new ConcurrentHashMap();

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return CACHE.computeIfAbsent(clazz, Logger::new);
    }

    static {
        for (Handler handler : java.util.logging.Logger.getLogger(ROOT_LOGGER).getHandlers()) {
            if (!handler.getFormatter().getClass().getName().endsWith(SimpleFormatter.class.getName())) continue;
            handler.setFormatter(new LoggerFormatter());
        }
    }
}

