/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.yaml.internal.load.reader;

import org.virtuslab.yaml.Position;
import org.virtuslab.yaml.Position$;
import org.virtuslab.yaml.Range;
import org.virtuslab.yaml.Range$;
import org.virtuslab.yaml.internal.load.reader.Reader;
import org.virtuslab.yaml.internal.load.reader.Reader$;
import scala.Predef$;
import scala.collection.immutable.Vector;

public class StringReader
implements Reader {
    private final String in;
    private int line;
    private int column;
    private int offset;
    private final Vector lines;

    public StringReader(String in) {
        this.in = in;
        this.line = 0;
        this.column = 0;
        this.offset = 0;
        this.lines = Predef$.MODULE$.wrapRefArray((Object[])in.split("\n", -1)).toVector();
    }

    @Override
    public int line() {
        return this.line;
    }

    public void line_$eq(int x$1) {
        this.line = x$1;
    }

    @Override
    public int column() {
        return this.column;
    }

    public void column_$eq(int x$1) {
        this.column = x$1;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    public void offset_$eq(int x$1) {
        this.offset = x$1;
    }

    public Vector<String> lines() {
        return this.lines;
    }

    @Override
    public Position pos() {
        return Position$.MODULE$.apply(this.offset(), this.line(), this.column());
    }

    @Override
    public Range range() {
        return Range$.MODULE$.apply(this.pos(), this.lines(), Range$.MODULE$.$lessinit$greater$default$3());
    }

    @Override
    public char peek(int n) {
        if (this.offset() + n < this.in.length()) {
            return this.in.charAt(this.offset() + n);
        }
        return Reader$.MODULE$.nullTerminator();
    }

    @Override
    public int peek$default$1() {
        return 0;
    }

    private void nextLine() {
        this.column_$eq(0);
        this.line_$eq(this.line() + 1);
    }

    private int skipAndMantainPosition() {
        char c = this.in.charAt(this.offset());
        if (this.isWindowsNewline(c)) {
            this.offset_$eq(this.offset() + 2);
            this.nextLine();
            return 2;
        }
        if (c == '\n') {
            this.offset_$eq(this.offset() + 1);
            this.nextLine();
            return 1;
        }
        this.offset_$eq(this.offset() + 1);
        this.column_$eq(this.column() + 1);
        return 1;
    }

    @Override
    public void skipN(int n) {
        this.loop$1(n);
    }

    @Override
    public void skipCharacter() {
        this.skipAndMantainPosition();
    }

    @Override
    public void skipWhitespaces() {
        while (this.isWhitespace()) {
            this.skipCharacter();
        }
    }

    @Override
    public char read() {
        this.skipCharacter();
        return this.in.charAt(this.offset() - 1);
    }

    private final void loop$1(int left) {
        while (left > 0) {
            int skipped = this.skipAndMantainPosition();
            left -= skipped;
        }
        return;
    }
}

