#! /bin/sh
# Purpose : Anonymize log files
# Date    : 2022-05-13


JS7_CONTROLLER_BINDIR="$(dirname "$0")"
JS7_CONTROLLER_LIBDIR="$(cd "${JS7_CONTROLLER_BINDIR}/../lib" >/dev/null && pwd)"

RETURN_CODE=0
JAVA_BIN="${JAVA_HOME}/bin/java"
test -x "${JAVA_BIN}" || JAVA_BIN="java"

# set_classpath
CP="${JS7_CONTROLLER_LIBDIR}/stdout:${JS7_CONTROLLER_LIBDIR}/patches/*:${JS7_CONTROLLER_LIBDIR}/user_lib/*:${JS7_CONTROLLER_LIBDIR}/ext/3rd-party/*:${JS7_CONTROLLER_LIBDIR}/ext/sos/*"

echo "... executing"
"${JAVA_BIN}" ${JAVA_OPTIONS} -classpath "${CP}" com.sos.loganonymizer.SOSLogAnonymizer $*
RETURN_CODE=$?
echo "... done"

exit $RETURN_CODE
