/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.ElementReader;
import com.izforge.izpack.panels.userinput.field.FieldConfig;
import com.izforge.izpack.panels.userinput.field.FieldProcessor;
import com.izforge.izpack.panels.userinput.field.FieldValidator;
import com.izforge.izpack.panels.userinput.field.FieldValidatorReader;
import java.util.ArrayList;
import java.util.List;

public class FieldReader
extends ElementReader
implements FieldConfig {
    private final IXMLElement field;
    private final IXMLElement spec;
    public static final String VARIABLE = "variable";
    private static final String SUMMARY_KEY = "summaryKey";
    private static final String DISPLAY_HIDDEN = "displayHidden";
    private static final String DISPLAY_HIDDEN_CONDITION = "displayHiddenCondition";
    private static final String READONLY = "readonly";
    private static final String READONLY_CONDITION = "readonlyCondition";
    private static final String TEXT_SIZE = "size";
    public static final String SPEC = "spec";
    private static final String VALIDATOR = "validator";
    private static final String PROCESSOR = "processor";
    private static final String TOOLTIP = "tooltip";
    public static final String OMIT_FROM_AUTO = "omitFromAuto";

    public FieldReader(IXMLElement field, Config config) {
        super(config);
        this.field = field;
        this.spec = this.getSpec(field, config);
    }

    public IXMLElement getField() {
        return this.field;
    }

    public IXMLElement getSpec() {
        return this.spec;
    }

    @Override
    public boolean getOmitFromAuto() {
        return this.getConfig().getBoolean(this.getSpec(), OMIT_FROM_AUTO, false);
    }

    @Override
    public String getVariable() {
        return this.getConfig().getAttribute(this.getField(), VARIABLE);
    }

    @Override
    public String getSummaryKey() {
        return this.getConfig().getAttribute(this.getField(), SUMMARY_KEY, true);
    }

    @Override
    public Boolean isDisplayHidden() {
        return this.getConfig().getBooleanOrNull(this.getField(), DISPLAY_HIDDEN);
    }

    @Override
    public String getDisplayHiddenCondition() {
        return this.getConfig().getAttribute(this.getField(), DISPLAY_HIDDEN_CONDITION, true);
    }

    @Override
    public Boolean isReadonly() {
        return this.getConfig().getBooleanOrNull(this.getField(), READONLY);
    }

    @Override
    public String getReadonlyCondition() {
        return this.getConfig().getAttribute(this.getField(), READONLY_CONDITION, true);
    }

    @Override
    public List<String> getPacks() {
        return this.getPacks(this.field);
    }

    @Override
    public List<OsModel> getOsModels() {
        return this.getOsModels(this.field);
    }

    @Override
    public String getDefaultValue() {
        return this.spec != null ? this.getConfig().getRawString(this.spec, "default", null) : null;
    }

    @Override
    public String getInitialValue() {
        return this.spec != null ? this.getConfig().getRawString(this.spec, "set", null) : null;
    }

    @Override
    public int getSize() {
        int result = -1;
        if (this.spec != null) {
            result = this.getConfig().getInt(this.spec, TEXT_SIZE, result);
        }
        return result;
    }

    @Override
    public List<FieldValidator> getValidators(IXMLElement field) {
        ArrayList<FieldValidator> result = new ArrayList<FieldValidator>();
        Config config = this.getConfig();
        for (IXMLElement element : field.getChildrenNamed(VALIDATOR)) {
            FieldValidatorReader reader = new FieldValidatorReader(element, config);
            result.add(new FieldValidator(reader, config.getFactory()));
        }
        return result;
    }

    @Override
    public List<FieldValidator> getValidators() {
        return this.getValidators(this.field);
    }

    @Override
    public List<FieldProcessor> getProcessors() {
        ArrayList<FieldProcessor> result = new ArrayList<FieldProcessor>();
        if (this.spec != null) {
            Config config = this.getConfig();
            for (IXMLElement element : this.spec.getChildrenNamed(PROCESSOR)) {
                result.add(new FieldProcessor(element, config));
            }
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.getText(this.field.getFirstChildNamed("description"));
    }

    @Override
    public String getTooltip() {
        return this.getConfig().getAttribute(this.field, TOOLTIP, true);
    }

    @Override
    public String getLabel() {
        return this.getText(this.getSpec());
    }

    @Override
    public String getCondition() {
        return this.getConfig().getString(this.getField(), "conditionid", null);
    }

    protected IXMLElement getSpec(IXMLElement field, Config config) {
        return config.getElement(field, SPEC);
    }

    protected String getText(IXMLElement element) {
        return this.getConfig().getText(element);
    }
}

