/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userpath;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.userpath.UserPathInputPanel;
import com.izforge.izpack.panels.userpath.UserPathPanelAutomationHelper;
import java.util.logging.Logger;

public class UserPathPanel
extends UserPathInputPanel {
    private static final long serialVersionUID = 3256443616359429170L;
    private static final Logger logger = Logger.getLogger(UserPathPanel.class.getName());
    private boolean skip = false;
    public static String pathVariableName = "UserPathPanelVariable";
    public static String pathPackDependsName = "UserPathPanelDependsName";
    public static String pathElementName = "UserPathPanelElement";

    public UserPathPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, UserPathPanel.class.getSimpleName(), resources, log);
        if (this.getDefaultDir() != null) {
            installData.setVariable(pathVariableName, this.getDefaultDir());
        }
    }

    @Override
    public void panelActivate() {
        boolean found = false;
        logger.fine("Looking for activation condition");
        String dependsName = this.installData.getVariable(pathPackDependsName);
        if (dependsName != null && !dependsName.equalsIgnoreCase("")) {
            logger.fine("Checking for pack dependency of " + dependsName);
            for (Pack pack : this.installData.getSelectedPacks()) {
                logger.fine("- Checking if " + pack.getName() + " equals " + dependsName);
                if (!pack.getName().equalsIgnoreCase(dependsName)) continue;
                found = true;
                logger.fine("-- Found " + dependsName + ", panel will be shown");
                break;
            }
            this.skip = !found;
        } else {
            logger.fine("Not Checking for a pack dependency, panel will be shown");
            this.skip = false;
        }
        if (this.skip) {
            logger.fine(UserPathPanel.class.getSimpleName() + " will not be shown");
            this.parent.skipPanel();
            return;
        }
        super.panelActivate();
        Variables variables = this.installData.getVariables();
        String expandedPath = variables.get(pathVariableName);
        expandedPath = variables.replace(expandedPath);
        this._pathSelectionPanel.setPath(expandedPath);
    }

    @Override
    public boolean isValidated() {
        if (!super.isValidated()) {
            return false;
        }
        this.installData.setVariable(pathVariableName, this._pathSelectionPanel.getPath());
        return true;
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        if (!this.skip) {
            new UserPathPanelAutomationHelper().createInstallationRecord(this.installData, panelRoot);
        }
    }

    @Override
    public String getSummaryBody() {
        if (this.skip) {
            return null;
        }
        return this.installData.getVariable(pathVariableName);
    }
}

