/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessConfigFileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigureJocProperties
extends ProcessConfigFileHelper {
    private static final Map<String, String> furtherProps = Collections.unmodifiableMap(new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("running_task_log_event_based", "https://change.sos-berlin.com/browse/JOC-2114");
        }
    });

    @Override
    protected String getConfigFilename() {
        return "joc.properties";
    }

    @Override
    protected String getConfigDir() {
        return this.idata.getVariable("APPDATA_PATH");
    }

    @Override
    protected String getConfigSubDir() {
        return "resources" + File.separator + "joc";
    }

    @Override
    protected void process(File configTmpFile) throws Exception {
    }

    @Override
    protected void process(File jocProp, File jocTmpProp) throws Exception {
        BufferedReader inStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jocProp), "UTF-8"));
        Properties curProps = new Properties();
        curProps.load(inStream);
        inStream.close();
        inStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jocTmpProp), "UTF-8"));
        Properties newProps = new Properties();
        newProps.load(inStream);
        inStream.close();
        inStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jocTmpProp), "UTF-8"));
        StringWriter writer = new StringWriter();
        String str = "";
        String key = "";
        String val = "";
        Pattern p = Pattern.compile("^([^\\s=#]+)(\\s*=\\s*)(.*)");
        Pattern p2 = Pattern.compile("^#([^\\s=#]+)(\\s*=\\s*)(.*)");
        Matcher m = null;
        while ((str = inStream.readLine()) != null) {
            if (str.trim().isEmpty() || str.startsWith("###")) {
                writer.append(str + this.newline);
                continue;
            }
            if (str.startsWith("#")) {
                m = p2.matcher(str);
                if (m.find()) {
                    key = m.group(1);
                    val = m.group(3);
                    if (curProps.containsKey(key)) {
                        val = curProps.getProperty(key);
                        if (val.contains(";")) {
                            val = val.replaceAll(";\\s*", "; \\\\" + this.newline + "\t\t\t");
                        }
                        writer.append(key + m.group(2) + val + this.newline);
                        continue;
                    }
                }
                writer.append(str + this.newline);
                continue;
            }
            m = p.matcher(str);
            if (!m.find()) continue;
            key = m.group(1);
            val = m.group(3);
            if ("hibernate_configuration_file".equals(key)) {
                writer.append(key + m.group(2) + newProps.getProperty(key) + this.newline);
                continue;
            }
            val = curProps.containsKey(key) ? curProps.getProperty(key) : newProps.getProperty(key);
            try {
                if ("controller_socket_timeout".equals(key) && Integer.parseInt(val) < 5) {
                    val = "5";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ("title".equals(key)) {
                val = this.idata.getVariable("jocTitle");
            }
            if ("cluster_id".equals(key)) {
                val = this.idata.getVariable("jocClusterId");
            }
            if ("ordering".equals(key)) {
                val = this.idata.getVariable("ordering");
            }
            if ("create_db_tables".equals(key)) {
                val = this.idata.getVariable("createTablesByJoc");
            }
            if ("comments".equals(key) && val.contains(";")) {
                val = val.replaceAll(";\\s*", "; \\\\" + this.newline + "\t\t\t");
            }
            writer.append(key + m.group(2) + val + this.newline);
        }
        for (Map.Entry<String, String> prop : furtherProps.entrySet()) {
            if (!curProps.containsKey(prop.getKey()) || newProps.containsKey(prop.getKey())) continue;
            writer.append(this.newline + this.newline);
            if (!prop.getValue().isEmpty()) {
                writer.append("### see " + prop.getValue() + this.newline + this.newline);
            }
            writer.append(prop.getKey() + " = " + curProps.getProperty(prop.getKey()) + this.newline);
        }
        inStream.close();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(jocProp), "UTF-8");
        out.write(writer.toString());
        ((Writer)out).close();
        writer.close();
    }
}

