/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import java.nio.charset.Charset;

public class SOSCommandResult {
    private final StringBuilder stdOut;
    private final StringBuilder stdErr;
    private final Charset encoding;
    private String command;
    private Integer exitCode;
    private boolean timeoutExeeded;

    public SOSCommandResult() {
        this.encoding = null;
        this.stdOut = null;
        this.stdErr = null;
    }

    public SOSCommandResult(String cmd, Charset encoding) {
        this.command = cmd;
        this.encoding = encoding;
        this.stdOut = new StringBuilder();
        this.stdErr = new StringBuilder();
    }

    public void setCommand(String val) {
        this.command = val;
    }

    public String getCommand() {
        return this.command;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer val) {
        this.exitCode = val;
    }

    public boolean isTimeoutExeeded() {
        return this.timeoutExeeded;
    }

    public void setTimeoutExeeded(boolean val) {
        this.timeoutExeeded = val;
    }

    public String getStdOut() {
        return this.stdOut.toString();
    }

    public void setStdOut(String val) {
        this.stdOut.append(val);
    }

    public boolean hasStdOut() {
        return this.stdOut.length() > 0;
    }

    public String getStdErr() {
        return this.stdErr.toString();
    }

    public void setStdErr(String val) {
        this.stdErr.append(val);
    }

    public boolean hasStdErr() {
        return this.stdErr.length() > 0;
    }

    public boolean hasError() {
        return this.hasError(true);
    }

    public boolean hasError(boolean checkStdError) {
        if (this.exitCode != null && this.exitCode > 0) {
            return true;
        }
        return checkStdError && this.stdErr.length() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.command).append("]");
        sb.append("[exitCode=").append(this.exitCode).append("]");
        if (this.encoding != null) {
            sb.append("[encoding=").append(this.encoding).append("]");
        }
        sb.append("[std:out=").append(this.stdOut.toString().trim()).append("]");
        sb.append("[std:err=").append(this.stdErr.toString().trim()).append("]");
        return sb.toString();
    }
}

