/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSShell;
import com.sos.izpack.util.Install;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class StartJetty
extends ProcessHelper {
    @Override
    public boolean run(String[] args) throws Exception {
        try {
            String command = args.length > 0 ? args[0] : "start";
            SOSCommandResult pr = new SOSCommandResult();
            String serviceName = this.idata.getVariable("jettyServiceName");
            if (OsVersion.IS_WINDOWS) {
                String windowServiceName = "js7_" + serviceName;
                pr = SOSShell.executeCommand("sc.exe", "query", windowServiceName);
                if (pr.getExitCode() == 1060) {
                    return true;
                }
                this.writeHeader(command.replace('s', 'S') + " Jetty Windows Service for " + this.idata.getVariable("APP_NAME"));
                if (this.serviceIs("RUNNING", pr.getStdOut())) {
                    pr = SOSShell.executeCommand("sc.exe", "stop", windowServiceName);
                    this.log(pr.getStdOut(), new Object[0]);
                    this.log("... check service status in 20 seconds", new Object[0]);
                    Thread.sleep(20000L);
                    pr = SOSShell.executeCommand("sc.exe", "query", windowServiceName);
                    this.log(pr.getStdOut(), new Object[0]);
                    if (this.serviceIs("STOPPED", pr.getStdOut())) {
                        this.log("... service not stopped -> check service status again in 20 seconds", new Object[0]);
                        Thread.sleep(20000L);
                        pr = SOSShell.executeCommand("sc.exe", "query", windowServiceName);
                        this.log(pr.getStdOut(), new Object[0]);
                    }
                } else if ("stop".equals(command)) {
                    this.log("... Windows Service %s is already stopped.", windowServiceName);
                    return true;
                }
                if ("start".equals(command)) {
                    if ("yes".equals(this.idata.getVariable("launchJetty")) && !this.breakStart()) {
                        pr = SOSShell.executeCommand("net.exe", "start", windowServiceName);
                        this.log(pr.getStdOut().trim(), new Object[0]);
                    } else {
                        this.log("... skipped", new Object[0]);
                    }
                }
            } else {
                Path jocHome = Paths.get(this.idata.getInstallPath(), new String[0]);
                Path startScript = jocHome.resolve("jetty/bin/jetty.sh");
                if (!Files.isExecutable(startScript)) {
                    return true;
                }
                Path serviceFile = Paths.get("/usr/lib/systemd/system/" + serviceName + ".service", new String[0]);
                boolean daemonInstalled = Files.exists(serviceFile, new LinkOption[0]);
                this.writeHeader(command.replace('s', 'S') + " Jetty for " + this.idata.getVariable("APP_NAME"));
                Path jettyBase = Paths.get(this.idata.getVariable("APPDATA_PATH"), new String[0]);
                if (this.serviceIsRunning(serviceName, jettyBase)) {
                    pr = SOSShell.executeCommand(startScript.toString(), "stop");
                    this.log(pr.getStdOut(), new Object[0]);
                } else if ("stop".equals(command)) {
                    this.log("... Jetty is already stopped.", new Object[0]);
                    return true;
                }
                if ("start".equals(command)) {
                    if ("yes".equals(this.idata.getVariable("launchJetty")) && !this.breakStart()) {
                        if (daemonInstalled) {
                            pr = SOSShell.executeCommand("systemctl", "start", serviceName);
                            this.log(pr.getStdOut(), new Object[0]);
                            if (!pr.getStdErr().trim().isEmpty()) {
                                this.log(pr.getStdErr(), new Object[0]);
                            }
                            if ((pr = SOSShell.executeCommand("systemctl", "is-active", serviceName)).getExitCode() == 0) {
                                this.log("... %s has been started.", this.idata.getVariable("APP_NAME"));
                            } else {
                                this.log("... failed to start %s. Refer to log in %s/logs.", this.idata.getVariable("APP_NAME"), jettyBase);
                            }
                        } else {
                            pr = SOSShell.executeCommand(startScript.toString(), "start");
                            this.log(pr.getStdOut(), new Object[0]);
                            if (!pr.getStdErr().trim().isEmpty()) {
                                this.log(pr.getStdErr().trim(), new Object[0]);
                            }
                        }
                    } else {
                        this.log("... skipped", new Object[0]);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
        return true;
    }

    public boolean serviceIsRunning(String serviceName, Path jettyBase) throws Throwable {
        SOSCommandResult pr;
        if (OsVersion.IS_WINDOWS) {
            SOSCommandResult pr2 = SOSShell.executeCommand("sc.exe", "query", "js7_" + serviceName);
            return this.serviceIs("RUNNING", pr2.getStdOut());
        }
        Path pidFile = jettyBase.resolve(serviceName + ".pid");
        return Files.exists(pidFile, new LinkOption[0]) && Files.size(pidFile) > 0L && (pr = SOSShell.executeCommand("kill", "-0", new String(Files.readAllBytes(pidFile)).trim())).getExitCode() == 0;
    }

    private boolean serviceIs(String status, String stdOut) throws InterruptedException, IOException, RuntimeException {
        String[] lines;
        for (String line : lines = stdOut.trim().split("\r?\n")) {
            if (!(line = line.trim()).startsWith("STATE") || !line.endsWith(status)) continue;
            return true;
        }
        return false;
    }

    private boolean breakStart() {
        String installError = Install.getInstallError();
        String dbError = Install.getDbConnectionError();
        if (installError != null && !installError.isEmpty() || dbError != null && !dbError.isEmpty()) {
            this.log("... the Jetty won't be started due to a previous installation error:", new Object[0]);
            if (installError != null && !installError.isEmpty()) {
                this.log(installError, new Object[0]);
            } else if (dbError != null && !dbError.isEmpty()) {
                this.log(dbError, new Object[0]);
            }
            this.updateInstallResult();
            return true;
        }
        return false;
    }
}

