/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.SOSFile;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public class AccessValidator
implements DataValidator {
    @Override
    public DataValidator.Status validateData(InstallData idata) {
        DataValidator.Status state = DataValidator.Status.OK;
        idata.setVariable("accessError", "");
        if (OsVersion.IS_WINDOWS) {
            Path installPath = Paths.get(idata.getInstallPath(), new String[0]);
            if ("controller".equals(idata.getVariable("installMode"))) {
                boolean isStandby = "yes".equals(idata.getVariable("isStandby"));
                installPath = isStandby ? installPath.resolve(idata.getVariable("controllerId").toLowerCase() + "-backup") : installPath.resolve(idata.getVariable("controllerId").toLowerCase());
            }
            Path libdir = installPath.resolve("lib/sos");
            try {
                if (Files.isDirectory(libdir, LinkOption.NOFOLLOW_LINKS) && state != DataValidator.Status.ERROR) {
                    state = this.checkAccess(libdir, idata);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    private DataValidator.Status checkAccess(Path path, InstallData idata) throws IOException {
        DataValidator.Status state = DataValidator.Status.OK;
        DirectoryStream<Path> jarFiles = null;
        if (state != DataValidator.Status.ERROR) {
            jarFiles = SOSFile.getFileListStream(path, "^com\\.sos-berlin\\.js7\\.engine\\.js7-core-.*\\.jar$", 2);
            for (Path jarFile : jarFiles) {
                if (state == DataValidator.Status.ERROR) break;
                state = this.checkFileAccess(jarFile, idata);
            }
        }
        return state;
    }

    private DataValidator.Status checkFileAccess(Path path, InstallData idata) {
        try {
            Path tmpPath = this.createTempFilename(path);
            Files.move(path, tmpPath, StandardCopyOption.ATOMIC_MOVE);
            Files.move(tmpPath, path, StandardCopyOption.ATOMIC_MOVE);
            idata.setVariable("accessError", "");
            return DataValidator.Status.OK;
        }
        catch (Exception e) {
            String[] messageParts = e.getMessage().split("\\s*->\\s*");
            idata.setVariable("accessError", String.format("%1$s: %2$s", e.getClass().getSimpleName(), messageParts[0]));
            System.out.println(String.format("%1$s%nStop all applications that access the above file %2$s.", e.toString(), path.toString()));
            return DataValidator.Status.ERROR;
        }
    }

    private Path createTempFilename(Path path) {
        Path tmpPath = null;
        try {
            tmpPath = Files.createTempFile(path.getParent(), path.getFileName().toString(), "", new FileAttribute[0]);
            Files.deleteIfExists(tmpPath);
        }
        catch (Exception e) {
            tmpPath = path.resolveSibling(path.getFileName().toString() + UUID.randomUUID().toString());
        }
        return tmpPath;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "access.validation.error";
    }

    @Override
    public String getWarningMessageId() {
        return "access.validation.warning";
    }
}

