/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sos.izpack.util.DbConnectionValidator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;

public class DbNotEmptyValidator
implements DataValidator {
    private String errorMessageId = "database.dbms.valid";

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        return this.validateHibernateFile(idata);
    }

    private DataValidator.Status validateHibernateFile(InstallData idata) {
        DbConnectionValidator c = new DbConnectionValidator();
        String method = idata.getVariable("databaseConfigurationMethod");
        if ("withHibernateFile".equals(method)) {
            String hibernateConfFile = idata.getVariable("hibernateConfFile");
            if (hibernateConfFile == null) {
                hibernateConfFile = "";
            }
            if (hibernateConfFile.isEmpty()) {
                this.errorMessageId = "UserInputPanel.file.notfile.message";
                return DataValidator.Status.ERROR;
            }
            try {
                if (Files.notExists(Paths.get(hibernateConfFile, new String[0]), new LinkOption[0])) {
                    this.errorMessageId = "UserInputPanel.file.notfile.message";
                    return DataValidator.Status.ERROR;
                }
            }
            catch (Exception e) {
                this.errorMessageId = "UserInputPanel.file.notfile.message";
                return DataValidator.Status.ERROR;
            }
            try {
                DataValidator.Status status = c.readHibernateFile(idata, hibernateConfFile);
                if (status != DataValidator.Status.OK) {
                    this.errorMessageId = c.getErrorMessageId();
                    return status;
                }
            }
            catch (Exception e) {
                idata.setVariable("readHibernateError", e.toString());
                this.errorMessageId = "hibernate.read.error";
                return DataValidator.Status.ERROR;
            }
            idata.setVariable("hibernateConfFileDefault", hibernateConfFile);
        } else if ("withoutHibernateFile".equals(method)) {
            String databaseDbms = idata.getVariable("databaseDbms");
            if ("h2".equals(databaseDbms)) {
                idata.setVariable("databaseDbms", "mysql");
                idata.setVariable("databaseCreateTables", "byInstaller");
                idata.setVariable("databaseHost", "");
                idata.setVariable("databasePort", "");
                idata.setVariable("databaseUser", "");
                idata.setVariable("databasePassword", "");
                idata.setVariable("hibernateDialect", "");
                idata.setVariable("databaseSchema", "");
                idata.setVariable("jdbcConnectionUrl", "");
                idata.setVariable("jdbcConnectionDriver", "");
            }
            if (!Arrays.asList("mysql", "oracle", "mssql", "pgsql").contains(databaseDbms)) {
                return DataValidator.Status.ERROR;
            }
        } else {
            c.setH2(idata);
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

