/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;

public class JavaOptionsValidator
implements DataValidator {
    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "java.options.validation.error";
    }

    @Override
    public String getWarningMessageId() {
        return "java.options.validation.error";
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        String[] javaOptionsParts;
        String javaOptions = idata.getVariable("javaOptions");
        if ("install".equals(idata.getVariable("installMode"))) {
            javaOptions = idata.getVariable("jsJavaOptions");
        }
        idata.setVariable("javaOptionsValidationError", "");
        if (javaOptions == null || javaOptions.trim().isEmpty()) {
            return DataValidator.Status.OK;
        }
        javaOptions = javaOptions.replaceAll("\"[^\"]*\"", "");
        for (String javaOption : javaOptionsParts = javaOptions.trim().split(" ")) {
            if ((javaOption = javaOption.trim()).isEmpty() || javaOption.startsWith("-X") || javaOption.startsWith("-D")) continue;
            idata.setVariable("javaOptionsValidationError", javaOption);
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }
}

