/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.util.Install;
import com.sos.izpack.util.XmlInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CopyHibernateConfFile
extends ProcessHelper {
    @Override
    public boolean run(String[] args) throws Exception {
        this.ok = true;
        try {
            Path targetDir = null;
            Path targetFile = null;
            Path targetTmpFile = null;
            String sourceFile = this.idata.getVariable("hibernateConfFile");
            String hibernateBaseName = "hibernate.cfg.xml";
            targetDir = Paths.get(this.idata.getVariable("APPDATA_PATH"), "resources", "joc");
            targetFile = targetDir.resolve(hibernateBaseName);
            targetTmpFile = targetDir.resolve("tmp_" + hibernateBaseName);
            String target = "./resources/joc/" + targetFile.getFileName().toString();
            Files.deleteIfExists(targetTmpFile);
            if (sourceFile == null || sourceFile.isEmpty()) {
                return true;
            }
            this.writeHeader("Copy hibernate configuration file " + sourceFile + " to " + target);
            XmlInfo hibernateDom = new XmlInfo(sourceFile);
            boolean nothingToDo = this.addHikari(hibernateDom);
            if (nothingToDo && Files.exists(targetFile, new LinkOption[0]) && Files.isSameFile(Paths.get(sourceFile, new String[0]), targetFile)) {
                this.log("... nothing to do", new Object[0]);
            } else {
                this.writeXML(targetFile.toFile(), hibernateDom.getDom());
                this.log("... done", new Object[0]);
            }
        }
        catch (Exception e) {
            Install.setDbConnectionError(e.toString());
            this.log("... error occurred:", new Object[0]);
            this.log(e);
        }
        return this.ok;
    }
}

