/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.userinput.UserInputPanelAutomationHelper;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.console.ConsoleFieldFactory;
import com.izforge.izpack.panels.userinput.field.ElementReader;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.FieldHelper;
import com.izforge.izpack.panels.userinput.field.UserInputPanelSpec;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserInputConsolePanel
extends AbstractConsolePanel {
    private static final String DISPLAY_HIDDEN = "displayHidden";
    private static final String DISPLAY_HIDDEN_CONDITION = "displayHiddenCondition";
    private static final String READONLY = "readonly";
    private static final String READONLY_CONDITION = "readonlyCondition";
    private final Resources resources;
    private final ObjectFactory factory;
    private final RulesEngine rules;
    private final PlatformModelMatcher matcher;
    private final Console console;
    private final Prompt prompt;
    private final Panel panel;
    private static final Logger logger = Logger.getLogger(UserInputConsolePanel.class.getName());
    private List<ConsoleField> fields = new ArrayList<ConsoleField>();
    private final InstallData installData;

    public UserInputConsolePanel(Resources resources, ObjectFactory factory, RulesEngine rules, PlatformModelMatcher matcher, Console console, Prompt prompt, PanelView<ConsolePanel> panelView, InstallData installData) {
        super(panelView);
        ElementReader reader;
        Condition globalConstraint;
        this.installData = installData;
        this.resources = resources;
        this.factory = factory;
        this.rules = rules;
        this.matcher = matcher;
        this.console = console;
        this.prompt = prompt;
        UserInputPanelSpec model = new UserInputPanelSpec(resources, installData, factory, matcher);
        this.panel = this.getPanel();
        IXMLElement spec = model.getPanelSpec(this.panel);
        boolean isDisplayingHidden = false;
        try {
            isDisplayingHidden = Boolean.parseBoolean(spec.getAttribute(DISPLAY_HIDDEN));
        }
        catch (Exception ignore) {
            isDisplayingHidden = false;
        }
        this.panel.setDisplayHidden(isDisplayingHidden);
        String condition = spec.getAttribute(DISPLAY_HIDDEN_CONDITION);
        if (condition != null && !condition.isEmpty()) {
            this.panel.setDisplayHiddenCondition(condition);
        }
        if ((globalConstraint = (reader = new ElementReader(model.getConfig())).getComplexPanelCondition(spec, matcher, installData, rules)) != null) {
            rules.addPanelCondition(this.panel, globalConstraint);
        }
        boolean readonly = false;
        try {
            readonly = Boolean.parseBoolean(spec.getAttribute(READONLY));
        }
        catch (Exception ignore) {
            readonly = false;
        }
        this.panel.setReadonly(readonly);
        condition = spec.getAttribute(READONLY_CONDITION);
        if (condition != null && !condition.isEmpty()) {
            this.panel.setReadonlyCondition(condition);
        }
        this.collectInputs(installData);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        for (ConsoleField field : this.fields) {
            String value;
            String name = field.getVariable();
            if (name == null || (value = properties.getProperty(name)) == null) continue;
            installData.setVariable(name, value);
        }
        return true;
    }

    @Override
    public boolean generateOptions(InstallData installData, Options options) {
        boolean commented = false;
        for (ConsoleField field : this.fields) {
            String name = field.getVariable();
            if (name == null) continue;
            options.put(name, installData.getVariable(name));
            if (commented) continue;
            options.addEmptyLine(name);
            options.putComment(name, Arrays.asList(this.panel.getPanelId()));
            commented = true;
        }
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unblocked variables on panel '" + this.panel.getPanelId() + "': " + this.createListAsString(installData.getVariables().getBlockedVariableNames(this.panel)));
        }
        installData.getVariables().unregisterBlockedVariableNames(installData.getVariables().getBlockedVariableNames(this.panel), this.panel);
        this.printHeadLine(installData, console);
        boolean result = true;
        if (this.fields != null && !this.fields.isEmpty()) {
            boolean rerun = false;
            HashSet<String> variables = new HashSet<String>();
            for (ConsoleField field : this.fields) {
                Field fieldDefinition = field.getField();
                boolean readonly = false;
                boolean addToPanel = false;
                boolean required = FieldHelper.isRequired(fieldDefinition, installData, this.matcher);
                if (required && fieldDefinition.isConditionTrue()) {
                    readonly = fieldDefinition.isEffectiveReadonly(this.panel.isReadonly() || this.panel.getReadonlyCondition() != null && this.rules.isConditionTrue(this.panel.getReadonlyCondition()), this.rules);
                    addToPanel = true;
                    field.setDisplayed(true);
                } else if (required && fieldDefinition.isEffectiveDisplayHidden(this.panel.isDisplayHidden() || this.panel.getDisplayHiddenCondition() != null && this.rules.isConditionTrue(this.panel.getDisplayHiddenCondition()), this.rules)) {
                    readonly = true;
                    addToPanel = true;
                    field.setDisplayed(false);
                } else {
                    readonly = true;
                    addToPanel = false;
                }
                if (!addToPanel) continue;
                field.setReadonly(readonly);
                if (!field.display()) {
                    rerun = true;
                    break;
                }
                String var = fieldDefinition.getVariable();
                if (var == null) continue;
                variables.add(var);
            }
            this.panel.setAffectedVariableNames(variables);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Blocked variables on panel '" + this.panel.getPanelId() + "': " + this.createListAsString(variables));
            }
            installData.getVariables().registerBlockedVariableNames(variables, this.panel);
            result = rerun ? this.promptRerunPanel(installData, console) : this.promptEndPanel(installData, console);
        }
        return result;
    }

    private void collectInputs(InstallData installData) {
        UserInputPanelSpec model = new UserInputPanelSpec(this.resources, installData, this.factory, this.matcher);
        Panel panel = this.getPanel();
        IXMLElement spec = model.getPanelSpec(panel);
        this.fields.clear();
        ConsoleFieldFactory factory = new ConsoleFieldFactory(this.console, this.prompt);
        for (Field fieldDefinition : model.createFields(spec)) {
            ConsoleField consoleField = factory.create(fieldDefinition, model, spec);
            this.fields.add(consoleField);
        }
    }

    @Override
    public void createInstallationRecord(IXMLElement rootElement) {
        new UserInputPanelAutomationHelper(this.fields).createInstallationRecord(this.installData, rootElement);
    }

    @Override
    public boolean handlePanelValidationResult(boolean valid) {
        if (!valid) {
            return this.promptRerunPanel(this.installData, this.console);
        }
        return true;
    }

    private String createListAsString(Set<String> list) {
        StringBuffer msg = new StringBuffer("{");
        if (list != null) {
            Iterator<String> it = list.iterator();
            while (it.hasNext()) {
                if (!logger.isLoggable(Level.FINE)) continue;
                msg.append(it.next());
                if (!it.hasNext()) continue;
                msg.append(", ");
            }
        }
        msg.append("}");
        return msg.toString();
    }
}

