/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSFile;
import com.sos.izpack.process.SOSShell;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class ChangeOwner
extends ProcessHelper {
    @Override
    public boolean run(String[] args) throws Exception {
        this.ok = true;
        Path home = Paths.get(this.idata.getVariable("USER_HOME"), new String[0]);
        String user = this.idata.getVariable("USER_NAME");
        String system_user = System.getProperty("user.name");
        Path appDataPath = Paths.get(this.idata.getVariable("APPDATA_PATH"), new String[0]);
        Path installPath = Paths.get(this.idata.getInstallPath(), new String[0]);
        Path varLogDir = Paths.get(this.idata.getVariable("LOGDIR_PATH"), new String[0]);
        if (!"yes".equals(this.idata.getVariable("withRootPermissions")) && system_user.equals(user)) {
            this.log("", new Object[0]);
            this.log(60, "+" + this.repeat('-', 120), new Object[0]);
            this.log("|   Add read/execute permissions in %1$s to the group", appDataPath.toString());
            this.log(60, "+" + this.repeat('-', 120), new Object[0]);
            try {
                int exitValue = 0;
                if ("joc".equals(this.idata.getVariable("installMode")) && "yes".equals(this.idata.getVariable("withJettyInstall"))) {
                    Path tempDir;
                    SOSCommandResult pr = new SOSCommandResult();
                    pr = SOSShell.executeCommand(120L, "chmod", "-R", "g+rx", appDataPath.toAbsolutePath().toString());
                    exitValue = pr.getExitCode();
                    if (exitValue == 0) {
                        pr = SOSShell.executeCommand(120L, "chmod", "g+w", appDataPath.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                    if (Files.exists(varLogDir, new LinkOption[0]) && exitValue == 0) {
                        pr = SOSShell.executeCommand(120L, "chmod", "-R", "g+rwx", varLogDir.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                    if (exitValue == 0 && Files.exists(tempDir = appDataPath.resolve("temp"), new LinkOption[0])) {
                        pr = SOSShell.executeCommand(120L, "chmod", "-R", "g+w", tempDir.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                    if (exitValue != 0) {
                        throw new Exception(pr.getStdErr());
                    }
                    for (Path appDataParent = appDataPath.getParent(); appDataParent != null; appDataParent = appDataParent.getParent()) {
                        this.setGroupExecutePermission(appDataParent);
                    }
                    for (Path startscript = installPath.resolve("jetty/bin/jetty.sh"); startscript != null; startscript = startscript.getParent()) {
                        this.setGroupExecutePermission(startscript);
                    }
                    this.log("... done", new Object[0]);
                }
            }
            catch (Throwable e) {
                this.log("... error occurred:", new Object[0]);
                this.log(e);
            }
        } else if (!user.equals("root")) {
            this.log("", new Object[0]);
            this.log(60, "+" + this.repeat('-', 120), new Object[0]);
            this.log("|   Change owner in %1$s to %2$s", appDataPath.toString(), user);
            this.log(60, "+" + this.repeat('-', 120), new Object[0]);
            try {
                SOSCommandResult pr = new SOSCommandResult();
                String group = null;
                try {
                    pr = SOSShell.executeCommand("groups", user);
                    if (pr.getExitCode() != 0 || pr.getStdOut().trim().length() <= 0) {
                        throw new Exception(pr.getStdErr());
                    }
                    group = pr.getStdOut().trim().replaceFirst("^" + user + "\\s*:\\s*([^ ]+).*$", "$1");
                    this.log("... the user group of \"%1$s\" is \"%2$s\".", user, group);
                    user = user + ":" + group;
                }
                catch (Throwable e) {
                    this.log("... the primary user group of \"%1$s\" couldn't find out.", user);
                    this.log(e);
                }
                try {
                    if (group != null) {
                        Path installParent;
                        final GroupPrincipal groupPrincipal = FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByGroupName(group);
                        Files.walkFileTree(installPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                            @Override
                            public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attr) throws IOException {
                                try {
                                    Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(groupPrincipal);
                                }
                                catch (Exception e) {
                                    ChangeOwner.this.log(e);
                                    return FileVisitResult.SKIP_SUBTREE;
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path path, BasicFileAttributes attr) throws IOException {
                                try {
                                    Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(groupPrincipal);
                                }
                                catch (Exception e) {
                                    ChangeOwner.this.log(e);
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path path, IOException e) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }
                        });
                        if (installPath.startsWith(home)) {
                            for (installParent = installPath.getParent(); installParent != null; installParent = installParent.getParent()) {
                                this.setGroupExecutePermission(installParent);
                            }
                        } else {
                            while (installParent != null) {
                                this.setOthersReadExecutePermission(installParent);
                                installParent = installParent.getParent();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.log("... the user group \"%1$s\" isn't successfully set in \"%2$s\"", group, installPath);
                    this.log(e);
                }
                for (Path startscript = installPath.resolve("jetty/bin/jetty.sh"); startscript != null; startscript = startscript.getParent()) {
                    this.setGroupExecutePermission(startscript);
                }
                int exitValue = 0;
                if ("joc".equals(this.idata.getVariable("installMode")) && "yes".equals(this.idata.getVariable("withJettyInstall"))) {
                    Object tempDir;
                    pr = SOSShell.executeCommand(120L, "chown", "-R", user, appDataPath.toAbsolutePath().toString());
                    exitValue = pr.getExitCode();
                    if (exitValue == 0) {
                        pr = SOSShell.executeCommand(120L, "chmod", "-R", "ug+rx", appDataPath.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                    if (exitValue == 0) {
                        pr = SOSShell.executeCommand(120L, "chmod", "ug+w", appDataPath.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                    if (Files.exists(varLogDir, new LinkOption[0]) && exitValue == 0 && (exitValue = (pr = SOSShell.executeCommand(120L, "chown", "-R", user, varLogDir.toAbsolutePath().toString())).getExitCode().intValue()) == 0) {
                        pr = SOSShell.executeCommand(120L, "chmod", "-R", "ug+rwx", appDataPath.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                    if (exitValue == 0 && Files.exists((Path)(tempDir = appDataPath.resolve("temp")), new LinkOption[0])) {
                        pr = SOSShell.executeCommand(120L, "chmod", "-R", "ug+w", tempDir.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                } else {
                    for (Path subDir : SOSFile.getSubDirsStream(appDataPath)) {
                        if (exitValue != 0) continue;
                        pr = SOSShell.executeCommand(120L, "chown", "-R", user, subDir.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                }
                if (appDataPath.startsWith(home)) {
                    Path firstExistParentOfAppDataPath;
                    if (pr.getExitCode() == 0) {
                        pr = SOSShell.executeCommand("chown", user, appDataPath.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                    if ((firstExistParentOfAppDataPath = (Path)this.idata.getAttribute("firstExistParentOfAppDataPath")) == null) {
                        firstExistParentOfAppDataPath = home;
                    }
                    Path appDataPathParent = appDataPath.getParent();
                    while (pr.getExitCode() == 0 && !appDataPathParent.equals(firstExistParentOfAppDataPath) && appDataPathParent.startsWith(firstExistParentOfAppDataPath)) {
                        pr = SOSShell.executeCommand("chown", user, appDataPathParent.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                        appDataPathParent = appDataPathParent.getParent();
                    }
                }
                if (installPath.startsWith(home)) {
                    Path firstExistParentOfInstallPath;
                    if (pr.getExitCode() == 0) {
                        pr = SOSShell.executeCommand(120L, "chown", "-R", user, installPath.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                    }
                    if ((firstExistParentOfInstallPath = (Path)this.idata.getAttribute("firstExistParentOfInstallPath")) == null) {
                        firstExistParentOfInstallPath = home;
                    }
                    Path installPathParent = installPath.getParent();
                    while (pr.getExitCode() == 0 && !installPathParent.equals(firstExistParentOfInstallPath) && installPathParent.startsWith(firstExistParentOfInstallPath)) {
                        pr = SOSShell.executeCommand("chown", user, installPathParent.toAbsolutePath().toString());
                        exitValue = pr.getExitCode();
                        installPathParent = installPathParent.getParent();
                    }
                }
                if (pr.getExitCode() != 0) {
                    throw new Exception("chown command returns exit code " + exitValue + ": " + pr.getStdErr());
                }
                this.log("... done", new Object[0]);
            }
            catch (Throwable e) {
                this.log("... error occurred:", new Object[0]);
                this.log(e);
            }
        } else {
            this.log("... nothing to do", new Object[0]);
        }
        return this.ok;
    }

    private void setOthersReadExecutePermission(Path path) throws IOException {
        Set<PosixFilePermission> perms = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).permissions();
        boolean hasExecutePermission = perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
        boolean hasReadPermission = perms.contains((Object)PosixFilePermission.OTHERS_READ);
        if (!hasExecutePermission) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if (!hasReadPermission) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if (!hasReadPermission || !hasExecutePermission) {
            Files.setPosixFilePermissions(path, perms);
        }
    }

    private void setGroupExecutePermission(Path path) throws IOException {
        Set<PosixFilePermission> perms = Files.readAttributes(path, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).permissions();
        boolean hasExecutePermission = perms.contains((Object)PosixFilePermission.GROUP_EXECUTE);
        if (!hasExecutePermission) {
            try {
                perms.add(PosixFilePermission.GROUP_EXECUTE);
                Files.setPosixFilePermissions(path, perms);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

