/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSFile;
import com.sos.izpack.util.Install;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CopyJDBCConnector
extends ProcessHelper {
    private static final Map<String, String> CURRENT_INTERNAL_DRIVERS = Collections.unmodifiableMap(new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("maria", "mariadb-java-client-3.5.0.jar");
            this.put("oracle", "ojdbc8-19.25.0.0.jar");
            this.put("pgsql", "postgresql-42.7.7.jar");
        }
    });
    private static final Map<String, String> DRIVER_CLASSES = Collections.unmodifiableMap(new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("org.mariadb.jdbc.Driver", "maria");
            this.put("com.mysql.cj.jdbc.Driver", "mysql");
            this.put("com.mysql.jdbc.Driver", "mysql");
            this.put("oracle.jdbc.OracleDriver", "oracle");
            this.put("oracle.jdbc.driver.OracleDriver", "oracle");
            this.put("org.postgresql.Driver", "pgsql");
            this.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", "mssql");
            this.put("org.h2.Driver", "h2");
        }
    });
    private static final List<String> OLD_INTERNAL_DRIVERS = Arrays.asList("mariadb-java-client-2.2.6.jar", "mariadb-java-client-2.7.2.jar", "ojdbc8-21.8.0.0.jar", "ojdbc8-19.19.0.0.jar", "ojdbc8-18.3.0.0.jar", "ojdbc6-11.1.0.7.0-Production.jar", "postgresql-9.4.1209.jar", "postgresql-42.2.19.jar", "postgresql-42.2.25.jar", "postgresql-42.3.3.jar", "postgresql-42.4.1.jar", "postgresql-42.4.3.jar", "postgresql-42.4.4.jar", "postgresql-42.7.4.jar");
    private static final String OLD_H2_INTERNAL_DRIVER = "h2-1.4.200.jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(String[] args) throws Exception {
        Path libDir = Paths.get(this.idata.getInstallPath(), "lib");
        Path targetDir = Paths.get(this.idata.getVariable("APPDATA_PATH"), "lib", "ext", "joc");
        for (String driver : OLD_INTERNAL_DRIVERS) {
            Path driverFile = targetDir.resolve(driver);
            try {
                Files.deleteIfExists(driverFile);
            }
            catch (Exception exception) {}
        }
        if (!"h2".equals(this.idata.getVariable("databaseDbms"))) {
            Path driverFile = targetDir.resolve(OLD_H2_INTERNAL_DRIVER);
            try {
                Files.deleteIfExists(driverFile);
            }
            catch (Exception driver) {
                // empty catch block
            }
        }
        HashMap<String, Set<Path>> existingJDBCs = new HashMap<String, Set<Path>>();
        Stream<Path> jarFiles = SOSFile.getFilesStream(targetDir, "\\.jar$", 0);
        jarFiles.filter(p -> !p.getFileName().toString().equals("js7-license.jar")).forEach(p -> {
            JarFile jar = null;
            try {
                jar = new JarFile(p.toFile());
                for (Map.Entry<String, String> driverClass : DRIVER_CLASSES.entrySet()) {
                    if (jar.getJarEntry(driverClass.getKey().replace('.', '/') + ".class") == null) continue;
                    existingJDBCs.putIfAbsent(driverClass.getValue(), new HashSet());
                    ((Set)existingJDBCs.get(driverClass.getValue())).add(p);
                    break;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
        String connector = this.idata.getVariable("connector");
        if (connector != null && !connector.isEmpty()) {
            Path connectorFile = Paths.get(connector, new String[0]);
            String connectorDriverClassDbms = "";
            JarFile jar = null;
            try {
                jar = new JarFile(connectorFile.toFile());
                for (Map.Entry<String, String> driverClass : DRIVER_CLASSES.entrySet()) {
                    if (jar.getJarEntry(driverClass.getKey().replace('.', '/') + ".class") == null) continue;
                    connectorDriverClassDbms = driverClass.getValue();
                    break;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.moveExternalJDBC(connectorFile, targetDir, connectorDriverClassDbms, existingJDBCs);
            Path userLibDir = libDir.resolve("user_lib");
            SOSFile.deleteFolder(userLibDir, true);
        }
        this.moveInternalJDBCs(libDir, targetDir, existingJDBCs);
        return true;
    }

    private void moveInternalJDBCs(Path libDir, Path targetDir, Map<String, Set<Path>> existingJDBCs) {
        try {
            if (libDir != null) {
                this.writeHeader("Store internal JDBC drivers in " + targetDir.toString());
                for (Map.Entry<String, String> driver : CURRENT_INTERNAL_DRIVERS.entrySet()) {
                    Path targetFile = targetDir.resolve(driver.getValue());
                    Path driverFile = libDir.resolve(driver.getValue());
                    this.log("-> %1$s", targetFile.getFileName().toString());
                    if (Files.exists(targetFile, new LinkOption[0])) {
                        this.log("... already exists", new Object[0]);
                        try {
                            Files.deleteIfExists(driverFile);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!Files.exists(targetDir, new LinkOption[0])) {
                        Files.createDirectories(targetDir, new FileAttribute[0]);
                    }
                    if (!Files.exists(driverFile, new LinkOption[0])) {
                        throw new IOException(String.format("%1$s doesn't exist", driverFile.toString()));
                    }
                    if (Files.isDirectory(driverFile, new LinkOption[0])) {
                        throw new IOException(String.format("%1$s is not a file", driverFile.toString()));
                    }
                    if (!Files.isWritable(targetDir)) {
                        throw new IOException(String.format("%1$s isn't writable", targetDir.toString()));
                    }
                    if (existingJDBCs.containsKey(driver.getKey())) {
                        this.log("... skipped because '%s' already exists with the same driver class", existingJDBCs.get(driver.getKey()).iterator().next().getFileName().toString());
                        continue;
                    }
                    SOSFile.copyFile(driverFile, targetFile);
                    this.log("... done", new Object[0]);
                    try {
                        Files.deleteIfExists(driverFile);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            Install.setDbConnectionError(e.toString());
            this.log("... error occurred:", new Object[0]);
            this.log(e);
        }
    }

    private void moveExternalJDBC(Path driverFile, Path targetDir, String connectorDriverClassDbms, Map<String, Set<Path>> existingJDBCs) {
        try {
            Path targetFile = targetDir.resolve(driverFile.getFileName());
            this.writeHeader("Store external JDBC driver " + driverFile.toString());
            this.log("-> %1$s", targetFile.toString());
            if (Files.exists(targetFile, new LinkOption[0])) {
                this.log("... already exists", new Object[0]);
            } else {
                if (!Files.exists(targetDir, new LinkOption[0])) {
                    Files.createDirectories(targetDir, new FileAttribute[0]);
                }
                if (!Files.exists(driverFile, new LinkOption[0])) {
                    throw new IOException(String.format("%1$s doesn't exist", driverFile.toString()));
                }
                if (Files.isDirectory(driverFile, new LinkOption[0])) {
                    throw new IOException(String.format("%1$s is not a file", driverFile.toString()));
                }
                if (!Files.isWritable(targetDir)) {
                    throw new IOException(String.format("%1$s isn't writable", targetDir.toString()));
                }
                if (existingJDBCs.containsKey(connectorDriverClassDbms)) {
                    this.log("... '%s' already exists with the same driver class", existingJDBCs.get(connectorDriverClassDbms).stream().map(p -> p.getFileName().toString()).collect(Collectors.joining("', '")));
                    for (Path p2 : existingJDBCs.get(connectorDriverClassDbms)) {
                        try {
                            Files.deleteIfExists(p2);
                            this.log("... '%s' deleted", p2.getFileName().toString());
                        }
                        catch (Exception e) {
                            Install.setDbConnectionError(e.toString());
                            this.log("... error occurred:", new Object[0]);
                            this.log(e);
                        }
                    }
                } else {
                    existingJDBCs.put(connectorDriverClassDbms, Collections.singleton(targetFile));
                }
                SOSFile.copyFile(driverFile, targetFile);
                this.log("... done", new Object[0]);
            }
        }
        catch (Exception e) {
            Install.setDbConnectionError(e.toString());
            this.log("... error occurred:", new Object[0]);
            this.log(e);
        }
    }
}

