/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.izforge.izpack.panels.process.ProcessPanelWorker;
import com.sos.izpack.process.ProcessConfigFileHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LogInstallData
extends ProcessConfigFileHelper {
    @Override
    public boolean run(String[] args) throws Exception {
        this.createInstallResult();
        String configFilename = null;
        String configDirname = null;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            if (args[i].equals("-f") && i + 1 < argsLength) {
                configFilename = args[i + 1];
            }
            if (!args[i].equals("-d") || i + 1 >= argsLength) continue;
            configDirname = args[i + 1];
        }
        if (configFilename == null) {
            configFilename = this.getConfigFilename();
        }
        if (configDirname == null) {
            configDirname = this.getConfigDir();
        }
        try {
            Path configDir = Paths.get(configDirname, new String[0]);
            Path configFile = configDir.resolve(configFilename);
            if (ProcessPanelWorker.getLogfile() == null) {
                File processPanelLogFile = (File)this.idata.getAttribute("processPanelLogFile");
                if (processPanelLogFile != null) {
                    throw new Exception("No log file access: " + processPanelLogFile.getAbsolutePath());
                }
                throw new Exception("No log file access");
            }
            this.logOnlyToLogFile("+" + this.repeat('-', 120), new Object[0]);
            this.logOnlyToLogFile("|   Summary of install data", new Object[0]);
            this.logOnlyToLogFile("+" + this.repeat('-', 120), new Object[0]);
            Files.lines(configFile).forEach(line -> this.logOnlyToLogFile((String)line, new Object[0]));
            Files.deleteIfExists(configFile);
        }
        catch (Exception e) {
            this.log(e);
        }
        return true;
    }

    @Override
    protected String getConfigDir() {
        return this.idata.getVariable("LOGDIR_PATH");
    }

    @Override
    public String getConfigFilename() {
        return "install.log";
    }

    @Override
    public String getConfigSubDir() {
        return "";
    }

    @Override
    public void process(File configFile, File configTmpFile) throws Exception {
    }

    @Override
    protected void process(File configTmpFile) throws Exception {
    }
}

