/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.izforge.izpack.panels.process.ProcessPanelWorker;
import com.sos.izpack.util.Install;
import com.sos.izpack.util.XmlInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ProcessHelper {
    public InstallData idata = null;
    protected AbstractUIProcessHandler handler = null;
    protected String newline = System.getProperty("line.separator");
    protected boolean verbose = true;
    protected long timeout = 30L;
    protected long cntProgress = 0L;
    protected boolean ok = true;
    private static final Map<String, String> HIKARIPOOL = new HashMap<String, String>();
    private static final String poolProviderKey = "connection.provider_class";
    private static final String poolProviderHikariValue = "org.hibernate.hikaricp.internal.HikariCPConnectionProvider";

    public boolean run(AbstractUIProcessHandler handler, InstallData idata, String[] args) throws Exception {
        this.idata = idata;
        this.handler = handler;
        return this.run(args);
    }

    public abstract boolean run(String[] var1) throws Exception;

    protected String repeat(char c, int i) {
        String str = "";
        for (int j = 0; j < i; ++j) {
            str = str + c;
        }
        return str;
    }

    protected void log(String msg, Object ... args) {
        this.log(-1, msg, args);
    }

    protected void log(int shorter, String msg, Object ... args) {
        String message = msg;
        if (this.verbose) {
            if (msg != null) {
                try {
                    msg = String.format(msg, args);
                }
                catch (Exception e) {
                    msg = message;
                }
                if (ProcessPanelWorker.getLogfile() != null) {
                    ProcessPanelWorker.getLogfile().println(msg);
                }
                if (this.handler != null) {
                    if (Install.isAutomatedInstallation.booleanValue() && shorter > -1) {
                        msg = msg.substring(0, shorter);
                    }
                    this.handler.logOutput(msg, false);
                }
                if (!Install.isAutomatedInstallation.booleanValue()) {
                    if (shorter > -1) {
                        msg = msg.substring(0, shorter);
                    }
                    System.out.println(msg);
                }
            }
        } else {
            this.logOnlyToLogFile(msg, args);
        }
    }

    protected void logOnlyToLogFile(String msg, Object ... args) {
        String message = msg;
        if (msg != null) {
            try {
                msg = String.format(msg, args);
            }
            catch (Exception e) {
                msg = message;
            }
            if (ProcessPanelWorker.getLogfile() != null) {
                ProcessPanelWorker.getLogfile().println(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(Throwable e) {
        this.updateInstallResult();
        String err = e.getMessage() != null ? e.toString() : "unknown error";
        Install.setInstallError(err);
        if (ProcessPanelWorker.getLogfile() != null) {
            StringWriter sw = null;
            PrintWriter pw = null;
            try {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                ProcessPanelWorker.getLogfile().println(sw.toString());
            }
            catch (Exception e1) {
                ProcessPanelWorker.getLogfile().println(err);
            }
            finally {
                try {
                    if (pw != null) {
                        pw.close();
                    }
                    if (sw != null) {
                        sw.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (this.handler != null) {
            this.handler.logOutput(err, true);
        }
        if (!Install.isAutomatedInstallation.booleanValue()) {
            System.out.println(e.getMessage());
        }
    }

    protected void mkdir(File dir) throws IOException, SecurityException {
        if (dir.exists() && dir.isFile()) {
            throw new IOException(String.format("The target directory %1$s is already a file", dir.getAbsolutePath()));
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new SecurityException(String.format("Permission denied to create the directory %1$s", dir.getAbsolutePath()));
        }
        if (!dir.canWrite() && !dir.setWritable(true)) {
            throw new SecurityException(String.format("Permission denied to set the directory %1$s writable", dir.getAbsolutePath()));
        }
    }

    protected String encodeInstallPath(String def) {
        String encodedInstallPath = def;
        String installPath = this.idata.getInstallPath();
        installPath = installPath.replace('\\', '/');
        try {
            String encoded = URLEncoder.encode(installPath, "UTF-8").replaceAll("%2F", "/").replaceAll("\\+", " ").replaceFirst("^([a-zA-Z])%3A", "$1:");
            if (!encoded.equals(installPath)) {
                encodedInstallPath = encoded;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedInstallPath;
    }

    protected LinkedHashMap<String, String> parseOptions(String str) throws IOException {
        if (str == null) {
            str = "";
        }
        str = str.trim().replaceAll("\\\\(?![\"])", "\\\\\\\\");
        str = str.replaceAll("\\p{Blank}", " ");
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(str));
        tokenizer.resetSyntax();
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.quoteChar(34);
        tokenizer.slashStarComments(false);
        tokenizer.slashSlashComments(false);
        int ttype = 0;
        String key = "";
        String val = "";
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        Pattern p = Pattern.compile("^(-[^=]+)(.*)$");
        Matcher m = null;
        while (ttype != -1) {
            ttype = tokenizer.nextToken();
            String sval = "";
            switch (ttype) {
                case -1: {
                    break;
                }
                case -3: {
                    sval = tokenizer.sval.replaceAll("\\\\\\\\", "\\\\");
                    m = p.matcher(sval);
                    if (!m.find()) break;
                    key = m.group(1);
                    val = m.group(2);
                    if (key.equals("-env") && val.matches("^=[^=]+=.*$")) {
                        key = key + val.replaceFirst("^=([^=]+)=.*$", "$1");
                    }
                    args.put(key, val);
                    if (val.length() == 1) break;
                    key = "";
                    break;
                }
                case -2: {
                    sval = tokenizer.nval + "";
                    m = p.matcher(sval);
                    if (!m.find()) break;
                    key = m.group(1);
                    val = m.group(2);
                    if (key.equals("-env") && val.matches("^=[^=]+=.*$")) {
                        key = key + val.replaceFirst("^=([^=]+)=.*$", "$1");
                    }
                    args.put(key, val);
                    if (val.length() == 1) break;
                    key = "";
                    break;
                }
                case 34: {
                    sval = tokenizer.sval.replaceAll("\"", "\\\\\"");
                    if (key.length() > 0) {
                        if (!key.equals("-exe")) {
                            sval = "=" + sval;
                        }
                        if (key.equals("-env") && sval.matches("^=[^=]+=.*$")) {
                            args.remove(key);
                            key = key + sval.replaceFirst("^=([^=]+)=.*$", "$1");
                        }
                        args.put(key, sval);
                    } else {
                        m = p.matcher(sval);
                        if (m.find()) {
                            key = m.group(1);
                            val = m.group(2);
                            if (key.equals("-env") && val.matches("^=[^=]+=.*$")) {
                                key = key + val.replaceFirst("^=([^=]+)=.*$", "$1");
                            }
                            args.put(key, val);
                        }
                    }
                    key = "";
                }
            }
        }
        return args;
    }

    protected String writeOptions(Map<String, String> options) {
        return this.writeOptions(options, enu4Quoting.NOQUOTES);
    }

    protected String writeOptions(Map<String, String> options, enu4Quoting quot) {
        StringBuilder sb = new StringBuilder();
        String val = "";
        boolean optionHasValue = true;
        for (String key : options.keySet()) {
            if (key == null) continue;
            val = options.get(key);
            if (val == null) {
                val = "";
            }
            boolean bl = optionHasValue = val.length() > 0 && val.startsWith("=");
            if (key.startsWith("-env")) {
                key = "-env";
            }
            if (optionHasValue && quot == enu4Quoting.UNIX) {
                sb.append("\\\"" + key + "=" + val.substring(1) + "\\\" ");
                continue;
            }
            if (optionHasValue && (val.indexOf(32) > -1 || quot == enu4Quoting.WINDOWS)) {
                sb.append(key + "=\"" + val.substring(1) + "\" ");
                continue;
            }
            sb.append(key + val + " ");
        }
        return sb.toString();
    }

    protected void writeHeader(String header) {
        this.log("", new Object[0]);
        this.log(60, "+" + this.repeat('-', 120), new Object[0]);
        this.log("|   " + header, new Object[0]);
        this.log(60, "+" + this.repeat('-', 120), new Object[0]);
    }

    public String getRelativePath(String base, String target, char separatorChar) {
        return this.getRelativePath(base, target).replace(File.separatorChar, separatorChar);
    }

    public String getRelativePath(String base, String target) {
        int commonIndex;
        String normalizeTarget;
        String normalizeBase = base.replace('\\', '/').replaceFirst("/$", "");
        String relative = normalizeTarget = target.replace('\\', '/').replaceFirst("/$", "");
        String[] sBase = normalizeBase.split("/");
        String[] sTarget = normalizeTarget.split("/");
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < sTarget.length && commonIndex < sBase.length && sTarget[commonIndex].equals(sBase[commonIndex]); ++commonIndex) {
            common.append(sTarget[commonIndex] + "/");
        }
        if (commonIndex != 0) {
            StringBuffer sbRelative = new StringBuffer();
            boolean baseIsFile = true;
            File baseResource = new File(normalizeBase);
            if (baseResource.exists()) {
                baseIsFile = baseResource.isFile();
            } else if (base.replace('\\', '/').endsWith("/")) {
                baseIsFile = false;
            }
            if (sBase.length != commonIndex) {
                int numDirsUp = baseIsFile ? sBase.length - commonIndex - 1 : sBase.length - commonIndex;
                for (int i = 0; i < numDirsUp; ++i) {
                    sbRelative.append("../");
                }
            }
            sbRelative.append(relative.substring(common.length()));
            relative = sbRelative.toString();
        }
        relative = relative.replace('/', File.separatorChar);
        return relative;
    }

    public static UserPrincipal getWindowsAccount(String account, String hostname) throws IOException {
        try {
            if (account == null) {
                account = "";
            }
            if ((account = account.trim()).isEmpty() || account.endsWith("\\")) {
                return null;
            }
            UserPrincipalLookupService upls = FileSystems.getDefault().getUserPrincipalLookupService();
            UserPrincipal principal = null;
            if (account.startsWith(".\\") || account.startsWith("\\")) {
                String userDomainName = System.getenv("USERDOMAIN");
                if (userDomainName == null || userDomainName.isEmpty()) {
                    userDomainName = hostname;
                }
                if (userDomainName == null || userDomainName.isEmpty()) {
                    principal = upls.lookupPrincipalByName(account = account.replaceFirst("^\\.?\\\\(.*)$", "$1"));
                    if (principal.getName().endsWith("\\")) {
                        principal = upls.lookupPrincipalByName(principal.getName() + account);
                    }
                } else {
                    account = userDomainName + "\\" + account.replaceFirst("^\\.?\\\\(.*)$", "$1");
                    principal = upls.lookupPrincipalByName(account);
                }
            } else {
                principal = upls.lookupPrincipalByName(account);
            }
            return principal;
        }
        catch (IOException e) {
            throw new IOException(String.format("Invalid account '%1$s'", account));
        }
    }

    public boolean addHikari(XmlInfo hibernateDom) throws XPathExpressionException {
        boolean nothingToDo = true;
        String comment = " Hikari Connection Pool ";
        Element elem = hibernateDom.getHibernateElement(poolProviderKey);
        if (elem != null && !elem.getTextContent().equals(poolProviderHikariValue)) {
            Node parent = elem.getParentNode();
            parent.removeChild(elem);
        }
        for (Map.Entry<String, String> entry : HIKARIPOOL.entrySet()) {
            Boolean b = hibernateDom.addHibernateElement(entry.getKey(), entry.getValue(), comment);
            comment = null;
            if (b == null) continue;
            nothingToDo = false;
            if (b.booleanValue()) {
                this.log("property %1$s = %2$s added", entry.getKey(), entry.getValue());
                continue;
            }
            this.log("property %1$s = %2$s changed", entry.getKey(), entry.getValue());
        }
        hibernateDom.deleteC3p0Elements();
        return nothingToDo;
    }

    public void writeXML(File target, Document domDocument) throws Exception {
        DOMSource source = new DOMSource(domDocument);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setAttribute("indent-number", 4);
        Transformer tformer = tFactory.newTransformer();
        tformer.setOutputProperty("indent", "yes");
        tformer.setOutputProperty("method", "xml");
        tformer.setOutputProperty("encoding", domDocument.getXmlEncoding());
        tformer.transform(source, result);
        writer.close();
        String xml = writer.toString();
        xml = xml.replaceAll("\r?\n", this.newline).replaceAll("[ ]{4}", "\t");
        BufferedWriter out = new BufferedWriter(new FileWriter(target));
        out.write(xml);
        out.close();
    }

    protected void createInstallResult() {
        this.updateInstallResult(0, true);
    }

    protected void updateInstallResult() {
        this.updateInstallResult(1);
    }

    protected void updateInstallResult(int returnCode) {
        this.updateInstallResult(returnCode, false);
    }

    protected void updateInstallResult(int returnCode, boolean force) {
        try {
            Path installResultFile = Paths.get(this.idata.getVariable("LOGDIR_PATH"), "install-result.log");
            if (!force) {
                boolean bl = force = Files.exists(installResultFile, new LinkOption[0]) && returnCode > 0;
            }
            if (!force) {
                boolean bl = force = !Files.exists(installResultFile, new LinkOption[0]);
            }
            if (force) {
                ArrayList<String> installLogLines = new ArrayList<String>();
                installLogLines.add("return_code = " + returnCode);
                File processPanelLogFile = (File)this.idata.getAttribute("processPanelLogFile");
                if (processPanelLogFile != null) {
                    installLogLines.add("install_log = " + processPanelLogFile.getName());
                }
                Files.write(installResultFile, installLogLines, new OpenOption[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        HIKARIPOOL.put(poolProviderKey, poolProviderHikariValue);
        HIKARIPOOL.put("hikari.maximumPoolSize", "10");
    }

    protected static enum enu4Quoting {
        NOQUOTES,
        WINDOWS,
        UNIX;

    }

    protected class ProcessResult {
        public String stdout = "";
        public String stderr = "";
        public int exitValue = 0;

        public ProcessResult() {
        }

        public ProcessResult(String stdout, String stderr, int exitValue) {
            this.stdout = stdout == null ? "" : stdout;
            this.stderr = stderr == null ? "" : stderr;
            this.exitValue = exitValue;
        }

        public String toString() {
            return String.format("exit:[%d]%nstdout:%s%nstderr:%s", this.exitValue, this.stdout, this.stderr);
        }
    }
}

