/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.util.ClearWorkingDir;
import com.sos.izpack.util.DBConnectionCallable;
import com.sos.izpack.util.Install;
import com.sos.izpack.util.XmlInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DbConnectionValidator
implements DataValidator {
    private final String fileExt = OsVersion.IS_WINDOWS ? "cmd" : "sh";
    private final String errmsg = "\nA database connection error occurs:\n %1$s";
    private final String hint = "\nThe setup will omit all database transactions and the Controller will not be started, \nbut the database connection data will be configured. \nYou can create the database later and after this call the script \n./install/joc_install_tables.%1$s to create the tables etc..\n";
    private boolean skipTestConnection = false;
    private String errorMessageId = "dbconnection.validation.error";

    protected String getPortWithColon(String port) {
        String portWithColon = "";
        if (!port.isEmpty()) {
            portWithColon = ":" + port;
        }
        return portWithColon;
    }

    protected String getSchemaWithSlash(String schema) {
        String schemaWithShlash = "";
        if (!schema.isEmpty()) {
            schemaWithShlash = "/" + schema;
        }
        return schemaWithShlash;
    }

    public String getHibernateDialect(String dbms) {
        switch (dbms) {
            case "mysql": {
                return "org.hibernate.dialect.MySQLDialect";
            }
            case "oracle": {
                return "org.hibernate.dialect.OracleDialect";
            }
            case "pgsql": {
                return "org.hibernate.dialect.PostgreSQLDialect";
            }
            case "mssql": {
                return "org.hibernate.dialect.SQLServerDialect";
            }
            case "h2": {
                return "org.hibernate.dialect.H2Dialect";
            }
        }
        return null;
    }

    public void setH2(InstallData idata) {
        String method = idata.getVariable("databaseConfigurationMethod");
        if ("h2".equals(method)) {
            idata.setVariable("databaseDbms", "h2");
            idata.setVariable("databaseCreateTables", "byJoc");
            idata.setVariable("databaseHost", "");
            idata.setVariable("databasePort", "");
            idata.setVariable("databaseUser", "joc");
            idata.setVariable("databasePassword", "");
            idata.setVariable("databaseSchema", "./resources/joc/h2/joc");
            idata.setVariable("jdbcConnectionUrl", "jdbc:h2:./resources/joc/h2/joc");
            idata.setVariable("jdbcConnectionDriver", "org.h2.Driver");
        }
    }

    private String getUrl(String dbms, String host, String port, String schema, String url) {
        String portWithColon = this.getPortWithColon(port);
        String schemaWithShlash = this.getSchemaWithSlash(schema);
        switch (dbms) {
            case "mysql": {
                String str = "jdbc:mysql://" + host + portWithColon + schemaWithShlash;
                String amp = "?";
                if (str.contains("?")) {
                    amp = "&amp;";
                }
                str = str + amp + "serverTimezone=UTC";
                return str;
            }
            case "oracle": {
                if (host.contains("(")) {
                    return "jdbc:oracle:thin:@" + host;
                }
                return "jdbc:oracle:thin:@//" + host + portWithColon + schemaWithShlash;
            }
            case "pgsql": {
                return "jdbc:postgresql://" + host + portWithColon + schemaWithShlash;
            }
            case "mssql": {
                return "jdbc:sqlserver://" + host + portWithColon + ";sendStringParametersAsUnicode=true;selectMethod=cursor;databaseName=" + schema;
            }
            case "h2": {
                String h2Url = "jdbc:h2:" + schema;
                return h2Url;
            }
        }
        return null;
    }

    private String getClassname(String dbms, boolean withInternalClass, String jdbcFile) {
        switch (dbms) {
            case "mysql": {
                if (withInternalClass) {
                    return "org.mariadb.jdbc.Driver";
                }
                if (this.checkJDBC("com.mysql.cj.jdbc.Driver", jdbcFile)) {
                    return "com.mysql.cj.jdbc.Driver";
                }
                return "com.mysql.jdbc.Driver";
            }
            case "oracle": {
                if (withInternalClass) {
                    return "oracle.jdbc.OracleDriver";
                }
                if (this.checkJDBC("oracle.jdbc.OracleDriver", jdbcFile)) {
                    return "oracle.jdbc.OracleDriver";
                }
                return "oracle.jdbc.OracleDriver";
            }
            case "pgsql": {
                return "org.postgresql.Driver";
            }
            case "mssql": {
                return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
            case "h2": {
                return "org.h2.Driver";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkJDBC(String className, String jdbcFile) {
        JarFile jar = null;
        try {
            jar = new JarFile(jdbcFile);
            boolean bl = jar.getJarEntry(className.replace('.', '/') + ".class") != null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean checkJDBC(String dbms, boolean withInternalConnector, String jdbcFile) {
        if (!withInternalConnector && "mysql".equals(dbms)) {
            return this.checkJDBC("org.mariadb.jdbc.Driver", jdbcFile);
        }
        return true;
    }

    public DataValidator.Status readHibernateFile(InstallData idata, String hibernateFile) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        XmlInfo hibernateDom = new XmlInfo(hibernateFile);
        return this.readHibernateFile(idata, hibernateDom);
    }

    public DataValidator.Status readHibernateFile(InstallData idata, File hibernateFile) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        XmlInfo hibernateDom = new XmlInfo(hibernateFile);
        return this.readHibernateFile(idata, hibernateDom);
    }

    public DataValidator.Status readHibernateFile(InstallData idata, XmlInfo hibernateDom) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Element pwdElem;
        Element credentialStoreElem = hibernateDom.getCredentialStoreLocation();
        if (credentialStoreElem != null) {
            return DataValidator.Status.OK;
        }
        Element classNameElem = hibernateDom.getDBDriverClass();
        if (classNameElem == null) {
            this.errorMessageId = "hibernate.property.missing";
            return DataValidator.Status.ERROR;
        }
        Element dialectElem = hibernateDom.getDBDialect();
        Element urlElem = hibernateDom.getDBUrl();
        if (urlElem == null) {
            this.errorMessageId = "hibernate.property.missing";
            return DataValidator.Status.ERROR;
        }
        idata.setVariable("hibernateDialect", dialectElem == null ? "" : dialectElem.getTextContent());
        String dbms = hibernateDom.getDbmsFromHibernateConf();
        if (dbms.isEmpty()) {
            this.errorMessageId = "hibernate.unsupported.dialect";
            return DataValidator.Status.ERROR;
        }
        String classname = classNameElem.getTextContent();
        if (classname.equals("org.h2.Driver")) {
            this.errorMessageId = "hibernate.unsupported.h2";
            return DataValidator.Status.ERROR;
        }
        String url = urlElem.getTextContent();
        String user = "";
        String pwd = "";
        Element userElem = hibernateDom.getDBUser();
        if (userElem != null) {
            user = userElem.getTextContent();
        }
        if ((pwdElem = hibernateDom.getDBPassword()) != null) {
            pwd = pwdElem.getTextContent();
        }
        idata.setVariable("databaseDbms", dbms);
        if (classname.contains("microsoft") || classname.contains("mysql") || classname.contains("h2")) {
            idata.setVariable("internalConnector", "no");
        }
        idata.setVariable("databaseUser", user);
        idata.setVariable("databasePassword", pwd);
        idata.setVariable("jdbcConnectionUrl", url);
        idata.setVariable("jdbcConnectionDriver", classname);
        return DataValidator.Status.OK;
    }

    public boolean hibernateFileHasCredentialStoreEntry(XmlInfo hibernateDom) {
        try {
            Element credentialStoreElem = hibernateDom.getCredentialStoreLocation();
            return credentialStoreElem != null;
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    public boolean hibernateFileHasEncryptedEntries(XmlInfo hibernateDom) {
        try {
            if (this.hibernateFileHasEncryptedEntry(hibernateDom.getDBPassword())) {
                return true;
            }
            if (this.hibernateFileHasEncryptedEntry(hibernateDom.getDBUser())) {
                return true;
            }
            return this.hibernateFileHasEncryptedEntry(hibernateDom.getDBUrl());
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    private boolean hibernateFileHasEncryptedEntry(Element elem) {
        return elem != null && this.hibernateFileHasEncryptedEntry(elem.getTextContent());
    }

    public boolean hibernateFileHasEncryptedEntry(String elemValue) {
        return elemValue != null && elemValue.startsWith("enc://");
    }

    public DataValidator.Status validateData(InstallData idata, boolean skipTestConnection) {
        this.skipTestConnection = skipTestConnection;
        return this.validateData(idata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public DataValidator.Status validateData(InstallData idata) {
        block42: {
            boolean skipCheck;
            String method = idata.getVariable("databaseConfigurationMethod");
            String dbcreate = idata.getVariable("databaseCreateTables");
            String dbms = idata.getVariable("databaseDbms");
            String internalConnector = idata.getVariable("internalConnector");
            if ("mssql".equals(dbms) || "h2".equals(dbms)) {
                idata.setVariable("internalConnector", "no");
            }
            boolean withInternalConnector = "yes".equals(internalConnector);
            boolean bl = skipCheck = dbcreate == null || dbcreate.equals("byJoc") || dbcreate.equals("off");
            if (this.skipTestConnection) {
                skipCheck = true;
            }
            ClearWorkingDir.exec("connector", idata);
            String jdbc = idata.getVariable("connector");
            if (withInternalConnector) {
                jdbc = null;
            } else {
                if (jdbc == null || jdbc.isEmpty()) {
                    this.errorMessageId = "UserInputPanel.file.notfile.message";
                    return DataValidator.Status.ERROR;
                }
                try {
                    if (Files.notExists(Paths.get(jdbc, new String[0]), new LinkOption[0])) {
                        this.errorMessageId = "UserInputPanel.file.notfile.message";
                        return DataValidator.Status.ERROR;
                    }
                }
                catch (Exception e) {
                    this.errorMessageId = "UserInputPanel.file.notfile.message";
                    return DataValidator.Status.ERROR;
                }
                idata.setVariable("connectorDefault", jdbc);
            }
            if ("withHibernateFile".equals(method)) {
                try {
                    DataValidator.Status status;
                    XmlInfo hibernateDom = new XmlInfo(idata.getVariable("hibernateConfFile"));
                    if (this.hibernateFileHasCredentialStoreEntry(hibernateDom)) {
                        return DataValidator.Status.OK;
                    }
                    if (this.hibernateFileHasEncryptedEntries(hibernateDom)) {
                        return DataValidator.Status.OK;
                    }
                    if (Install.isAutomatedInstallation.booleanValue() && (status = this.readHibernateFile(idata, hibernateDom)) != DataValidator.Status.OK) {
                        return status;
                    }
                }
                catch (Exception e) {
                    idata.setVariable("readHibernateError", e.toString());
                    this.errorMessageId = "hibernate.read.error";
                    return DataValidator.Status.ERROR;
                }
            }
            String user = idata.getVariable("databaseUser");
            String pwd = idata.getVariable("databasePassword");
            String host = idata.getVariable("databaseHost");
            String port = idata.getVariable("databasePort").trim();
            String schema = idata.getVariable("databaseSchema").trim();
            String url = idata.getVariable("jdbcConnectionUrl");
            String classname = idata.getVariable("jdbcConnectionDriver");
            if (!"withHibernateFile".equals(method)) {
                boolean withInternalClass = this.checkJDBC(dbms, withInternalConnector, jdbc);
                classname = this.getClassname(dbms, withInternalClass, jdbc);
                url = this.getUrl(dbms, host, port, schema, url);
                try {
                    idata.setVariable("jdbcConnectionUrl", url);
                    idata.setVariable("jdbcConnectionDriver", classname);
                }
                catch (Exception e1) {
                    idata.setVariable("dbConnectionError", e1.toString());
                    Install.setDbConnectionError(e1.toString());
                    return DataValidator.Status.WARNING;
                }
            }
            if (this.hibernateFileHasEncryptedEntry(pwd) || this.hibernateFileHasEncryptedEntry(user) || this.hibernateFileHasEncryptedEntry(url)) {
                return DataValidator.Status.OK;
            }
            if (skipCheck) {
                return DataValidator.Status.OK;
            }
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            try {
                Future<Void> result = executorService.submit(new DBConnectionCallable(classname, url, user, pwd, jdbc));
                result.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() != null) {
                    idata.setVariable("dbConnectionError", e.getCause().getClass().getSimpleName() + ": " + e.getCause().getMessage());
                    Install.setDbConnectionError(e.getCause().getClass().getSimpleName() + ": " + e.getCause().getMessage());
                    System.out.println(String.format("\nA database connection error occurs:\n %1$s", e.getCause().getMessage()));
                    System.out.println(String.format("\nThe setup will omit all database transactions and the Controller will not be started, \nbut the database connection data will be configured. \nYou can create the database later and after this call the script \n./install/joc_install_tables.%1$s to create the tables etc..\n", this.fileExt));
                    DataValidator.Status status = DataValidator.Status.WARNING;
                    return status;
                }
                System.out.println(e.getMessage());
            }
            catch (TimeoutException e) {
                idata.setVariable("dbConnectionError", "Timeout reached! No response after 60s");
                Install.setDbConnectionError("Timeout reached! No response after 60s");
                System.out.println(String.format("\nA database connection error occurs:\n %1$s", e.getMessage()));
                System.out.println(String.format("\nThe setup will omit all database transactions and the Controller will not be started, \nbut the database connection data will be configured. \nYou can create the database later and after this call the script \n./install/joc_install_tables.%1$s to create the tables etc..\n", this.fileExt));
                DataValidator.Status status = DataValidator.Status.WARNING;
                return status;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                break block42;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    executorService.shutdown();
                }
                catch (Exception exception) {}
            }
        }
        idata.setVariable("dbConnectionError", "");
        Install.setDbConnectionError(null);
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

