/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.SOSFile;
import com.sos.izpack.util.SetLogPidFileAndWorkDirectory;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.TimeZone;

public class SetInstallPath
implements PanelAction {
    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        Path userPath;
        boolean controllerMode = false;
        boolean agentMode = false;
        boolean jocMode = false;
        if (idata.getVariable("installMode") != null) {
            controllerMode = idata.getVariable("installMode").equals("controller");
            agentMode = idata.getVariable("installMode").equals("agent");
            jocMode = idata.getVariable("installMode").equals("joc");
        }
        idata.setVariable("timeZone", TimeZone.getDefault().getID());
        if (!"Commercial".equals(idata.getVariable("licenseOption"))) {
            idata.setVariable("licenseFile", "");
        }
        if (OsVersion.IS_UNIX) {
            if ("no".equals(idata.getVariable("withRootPermissions"))) {
                idata.setVariable("installAsDaemon", "no");
            }
        } else if (OsVersion.IS_WINDOWS && idata.getVariable("validServiceAccount") != null) {
            idata.setVariable("serviceAccount", idata.getVariable("validServiceAccount"));
        }
        Path installPath = SOSFile.normalizePath(idata.getInstallPath());
        idata.setInstallPath(installPath.toString());
        idata.setAttribute("originalInstallPath", installPath.toString());
        Path appDataPath = SOSFile.normalizePath((Path)idata.getAttribute("APPDATA_PATH"));
        if (appDataPath != null) {
            idata.setVariable("APPDATA_PATH", appDataPath.toString());
        }
        if ((userPath = SOSFile.normalizePath(idata.getVariable("UserPathPanelVariable"))) != null) {
            idata.setVariable("UserPathPanelVariable", userPath.toString());
        } else {
            userPath = installPath;
        }
        if (controllerMode) {
            Path installP;
            String controllerId = idata.getVariable("controllerId");
            idata.setVariable("controllerIdWithSuffix", controllerId);
            boolean isStandby = "yes".equals(idata.getVariable("isStandby"));
            String extInstallPath = controllerId.toLowerCase();
            if (isStandby) {
                if (idata.getVariable("serviceNameSuffix") == null || idata.getVariable("serviceNameSuffix").isEmpty()) {
                    idata.setVariable("serviceNameSuffix", "backup");
                }
                extInstallPath = extInstallPath + "-backup";
                idata.setVariable("controllerIdWithSuffix", controllerId + " -backup");
            }
            if (appDataPath != null && appDataPath.equals(userPath)) {
                userPath = userPath.getParent();
                idata.setVariable("UserPathPanelVariable", userPath.toString());
            }
            if ((installP = (Path)idata.getAttribute("INSTALL_PATH")) != null) {
                installPath = SOSFile.normalizePath(installP);
            }
            installPath = installPath.resolve(extInstallPath);
            appDataPath = userPath.resolve(extInstallPath);
            idata.setInstallPath(installPath.toString());
            idata.setVariable("APPDATA_PATH", appDataPath.toString());
            new SetLogPidFileAndWorkDirectory().executeAction(idata, ah);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/sos"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/3rd-party"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/jdbc"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/patches"), true);
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("config/patches"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/ext"), true);
        } else if (agentMode) {
            appDataPath = userPath;
            idata.setVariable("APPDATA_PATH", appDataPath.toString());
            new SetLogPidFileAndWorkDirectory().executeAction(idata, ah);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/sos"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/3rd-party"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/jdbc"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/patches"), true);
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("config/patches"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("yade/lib/sos"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("yade/lib/3rd-party"), true);
            this.deleteFolderFromPreviousInstall(installPath.resolve("yade/lib/patches"), true);
        } else if (jocMode) {
            boolean createTablesByJoc;
            if ("no".equals(idata.getVariable("withJettyInstall"))) {
                try {
                    appDataPath = installPath.resolve("jetty_base").toRealPath(new LinkOption[0]);
                }
                catch (Exception e) {
                    appDataPath = installPath;
                }
            } else {
                appDataPath = SOSFile.normalizePath(idata.getVariable("jettyBaseDir"));
            }
            idata.setVariable("APPDATA_PATH", appDataPath.toString());
            idata.setVariable("UserPathPanelVariable", appDataPath.toString());
            if (OsVersion.IS_WINDOWS) {
                idata.setVariable("jettyUser", "");
                idata.setVariable("jettyUserHome", "");
            } else {
                idata.setVariable("jettyUser", idata.getVariable("runningUser"));
                idata.setVariable("jettyUserHome", idata.getVariable("runningUserHome"));
            }
            boolean asApiServer = "yes".equals(idata.getVariable("asApiServer"));
            if (asApiServer) {
                idata.setVariable("jocClusterId", "api");
            } else {
                idata.setVariable("jocClusterId", "joc");
                if (idata.getVariable("jocTitle").trim().isEmpty()) {
                    if ("0".equals(idata.getVariable("ordering"))) {
                        idata.setVariable("jocTitle", "Primary");
                    } else {
                        idata.setVariable("jocTitle", "Secondary");
                    }
                }
            }
            switch (idata.getVariable("securityLevel").toUpperCase()) {
                case "HIGH": {
                    idata.setVariable("dbSecurityLevel", "2");
                    break;
                }
                case "MEDIUM": {
                    idata.setVariable("dbSecurityLevel", "1");
                    break;
                }
                default: {
                    idata.setVariable("dbSecurityLevel", "0");
                }
            }
            if ("on".equals(idata.getVariable("databaseCreateTables"))) {
                idata.setVariable("databaseCreateTables", "byInstaller");
            }
            idata.setVariable("createTablesByJoc", (createTablesByJoc = "byJoc".equals(idata.getVariable("databaseCreateTables"))) ? "true" : "false");
            try {
                Files.deleteIfExists(appDataPath.resolve("webapps/joc.war"));
            }
            catch (IOException extInstallPath) {
                // empty catch block
            }
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("WEB-INF"));
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("webapps/joc"));
            this.deleteFolderFromPreviousInstall(installPath.resolve("db"));
            this.deleteFolderFromPreviousInstall(installPath.resolve("lib/patches"), true);
            this.deleteFilesFromPreviousInstall(installPath.resolve("lib"), "\\.jar$", 0);
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("db"), true);
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("temp"), true);
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("patches"));
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("archive"));
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("reporting/app"));
            this.deleteFolderFromPreviousInstall(appDataPath.resolve("reporting/tmp"));
            if ("yes".equals(idata.getVariable("withJettyInstall"))) {
                Path jettyFolder = installPath.resolve("jetty");
                final Path binFolder = jettyFolder.resolve("bin");
                DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                    @Override
                    public boolean accept(Path file) throws IOException {
                        return Files.isDirectory(file, new LinkOption[0]) && !file.equals(binFolder);
                    }
                };
                try {
                    Files.newDirectoryStream(jettyFolder, (DirectoryStream.Filter<? super Path>)filter).forEach(path -> this.deleteFolderFromPreviousInstall((Path)path));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            Files.createDirectories(installPath, new FileAttribute[0]);
        }
        catch (IOException asApiServer) {
            // empty catch block
        }
        idata.setAttribute("firstExistParentOfInstallPath", this.getFirstExistParentDir(installPath));
        idata.setAttribute("firstExistParentOfAppDataPath", this.getFirstExistParentDir(appDataPath));
        Path logDir = SOSFile.normalizePath(idata.getVariable("logDir"));
        Path logPath = SOSFile.normalizePath(idata.getVariable("logPath"));
        Path objVarLogDir = Paths.get("/var/log/", new String[0]);
        Path objLogDir = appDataPath.resolve("logs");
        if (Files.isSymbolicLink(objLogDir)) {
            try {
                Path pointsTo = Files.readSymbolicLink(objLogDir);
                idata.setVariable("LOGDIR_PATH", pointsTo.toString());
            }
            catch (IOException e) {
                idata.setVariable("LOGDIR_PATH", objLogDir.toString());
            }
        } else {
            idata.setVariable("LOGDIR_PATH", objLogDir.toString());
        }
        if (OsVersion.IS_UNIX && logDir != null && logDir.startsWith("/var/log/") && Files.isDirectory(objVarLogDir, new LinkOption[0]) && System.getProperty("user.name").equals("root")) {
            idata.setVariable("LOGDIR_PATH", logDir.toString());
        }
        if (logPath != null) {
            idata.setVariable("LOGDIR_PATH", logPath.toString());
        }
    }

    private void deleteFolderFromPreviousInstall(Path folder) {
        this.deleteFolderFromPreviousInstall(folder, false);
    }

    private void deleteFolderFromPreviousInstall(Path folder, boolean retainRootFolder) {
        try {
            SOSFile.deleteFolder(folder, retainRootFolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteFilesFromPreviousInstall(Path folder, String regexp, int flag) {
        try {
            SOSFile.deleteFiles(folder, regexp, flag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Path getFirstExistParentDir(Path dir) {
        while (dir != null && !Files.exists(dir, new LinkOption[0])) {
            dir = dir.getParent();
        }
        return dir;
    }

    @Override
    public void initialize(PanelActionConfiguration pac) {
    }
}

