/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSShell;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;

public class UserValidator
implements DataValidator {
    private String warnId = "user.validation.warning";
    private String errorId = "user.validation.error";

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        return this.validateUser(idata);
    }

    public DataValidator.Status validateUser(InstallData idata) {
        if (OsVersion.IS_UNIX) {
            String runningUser;
            if (idata.getVariable("runningUser") == null || idata.getVariable("runningUser").isEmpty()) {
                idata.setVariable("runningUser", idata.getVariable("USER_NAME"));
                idata.setVariable("runningUserHome", idata.getVariable("USER_HOME"));
            }
            if (!(runningUser = idata.getVariable("runningUser")).equals(idata.getVariable("USER_NAME"))) {
                try {
                    String home = null;
                    String[] userAttributes = null;
                    SOSCommandResult pr = SOSShell.executeCommand("getent", "passwd", runningUser);
                    if (pr.getExitCode() > 0) {
                        System.out.println("getent passwd returns " + pr.getExitCode() + ". Try reading /etc/passwd...");
                        Optional<String> userLine = Files.lines(Paths.get("/etc/passwd", new String[0])).filter(line -> line.startsWith(runningUser + ":")).findAny();
                        if (!userLine.isPresent()) {
                            return DataValidator.Status.ERROR;
                        }
                        userAttributes = userLine.get().split(":");
                    } else {
                        userAttributes = pr.getStdOut().split(":");
                    }
                    if (userAttributes != null && userAttributes.length > 5) {
                        home = userAttributes[5];
                    }
                    if (home != null && !home.isEmpty()) {
                        idata.setVariable("runningUserHome", home);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return DataValidator.Status.ERROR;
                }
            }
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorId;
    }

    @Override
    public String getWarningMessageId() {
        return this.warnId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

