/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.coi.tools.os.izpack.Registry;
import com.coi.tools.os.win.MSWinConstants;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.util.DefaultTargetPlatformFactory;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import com.izforge.izpack.util.TargetFactory;
import com.sos.izpack.util.Install;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsRegistry
implements MSWinConstants {
    private final String topLevelErrMsg = "Unknown top level registry key (%1$s).";
    private final String parseKeyErrMsg = "Registry key (%1$s) has wrong syntax.";
    public static final Map<String, Integer> topLevelKey = new HashMap<String, Integer>();

    public WindowsRegistry() throws Exception {
        this.initRegistry();
    }

    private void initRegistry() {
        if (Install.reg == null) {
            ObjectFactory dummy = new ObjectFactory(){

                @Override
                public <T> T create(Class<T> type, Object ... parameters) {
                    return null;
                }

                @Override
                public <T> T create(String className, Class<T> superType, Object ... parameters) {
                    return null;
                }
            };
            Platforms platforms = new Platforms();
            Platform platform = platforms.getCurrentPlatform();
            TargetFactory factory = new TargetFactory(new DefaultTargetPlatformFactory(dummy, platform, platforms));
            Install.reg = new Registry(new Librarian(factory, new Housekeeper()));
        }
    }

    private int getTopLevelKey(String key) throws IllegalArgumentException {
        if (topLevelKey.containsKey(key)) {
            return topLevelKey.get(key);
        }
        throw new IllegalArgumentException(String.format("Unknown top level registry key (%1$s).", key));
    }

    public String readString(String key, String valname) throws Exception {
        return Install.reg.getValue(this.parseKey(key), valname).getStringData();
    }

    public String[] readMultiString(String key, String valname) throws Exception {
        try {
            return Install.reg.getValue(this.parseKey(key), valname).getMultiStringData();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long readDWord(String key, String valname) {
        try {
            return Install.reg.getValue(this.parseKey(key), valname).getDwordData();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object read(String key, String valname) throws Exception {
        return Install.reg.getValueAsObject(this.parseKey(key), valname);
    }

    public boolean keyExist(String key) throws Exception {
        return Install.reg.keyExist(this.parseKey(key));
    }

    public List<String> getSubkeys(String key, Pattern filter) throws Exception {
        String[] allSubkeys;
        ArrayList<String> filteredEntries = new ArrayList<String>();
        for (String subKey : allSubkeys = Install.reg.getSubkeys(key)) {
            if (!filter.matcher(subKey).matches()) continue;
            filteredEntries.add(subKey);
        }
        return filteredEntries;
    }

    public void deleteOldUninstallKeys() throws Exception {
        this.deleteOldUninstallKeys("HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall");
        this.deleteOldUninstallKeys("HKLM\\SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall");
    }

    public void deleteOldUninstallKeys(String uninstKey) throws Exception {
        try {
            String uninstallKey = this.parseKey(uninstKey);
            Pattern filter = Pattern.compile("^(Job Scheduler|SOSDEX|SOSFTP|Jade Background Service).*$", 2);
            List<String> jobSchedulerUninstallKeys = this.getSubkeys(uninstallKey, filter);
            if (jobSchedulerUninstallKeys != null) {
                for (String key : jobSchedulerUninstallKeys) {
                    try {
                        Install.reg.deleteKey(uninstallKey + "\\" + key);
                    }
                    catch (Exception exception) {}
                }
            }
            if ((jobSchedulerUninstallKeys = this.getSubkeys(uninstallKey, filter = Pattern.compile("^(JS7|JobScheduler|Jade|JOC|JOE).*$", 2))) != null) {
                for (String key : jobSchedulerUninstallKeys) {
                    try {
                        String unInstallStr = Install.reg.getValue(uninstallKey + "\\" + key, "UninstallString").getStringData();
                        String unInstallerJar = unInstallStr.replaceFirst("javaw(?:.exe)?\\s+-jar\\s+\"([^\"]+)\"", "$1");
                        if (Files.exists(Paths.get(unInstallerJar, new String[0]), new LinkOption[0])) continue;
                        Install.reg.deleteKey(uninstallKey + "\\" + key);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String parseKey(String key) throws Exception {
        Pattern pattern = Pattern.compile("^([^\\\\]+)\\\\(.*)$");
        Matcher matcher = pattern.matcher(key);
        if (matcher.find()) {
            Install.reg.setRoot(this.getTopLevelKey(matcher.group(1)));
            return matcher.group(2);
        }
        throw new IllegalArgumentException(String.format("Registry key (%1$s) has wrong syntax.", key));
    }

    static {
        topLevelKey.put("HKCR", Integer.MIN_VALUE);
        topLevelKey.put("HKEY_CLASSES_ROOT", Integer.MIN_VALUE);
        topLevelKey.put("HKCU", -2147483647);
        topLevelKey.put("HKEY_CURRENT_USER", -2147483647);
        topLevelKey.put("HKLM", -2147483646);
        topLevelKey.put("HKEY_LOCAL_MACHINE", -2147483646);
        topLevelKey.put("HKUS", -2147483645);
        topLevelKey.put("HKU", -2147483645);
        topLevelKey.put("HKEY_USERS", -2147483645);
        topLevelKey.put("HKPD", -2147483644);
        topLevelKey.put("HKEY_PERFORMANCE_DATA", -2147483644);
        topLevelKey.put("HKCC", -2147483643);
        topLevelKey.put("HKEY_CURRENT_CONFIG", -2147483643);
        topLevelKey.put("HKDD", -2147483642);
        topLevelKey.put("HKEY_DYN_DATA", -2147483642);
    }
}

