/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.license.check;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class LicenseCheckHelper {
    protected static final String SOS_LICENCE_PREFIX = "1.3.6.1.4.1.24723.1.3.7";
    protected static final int SAN_KEY_REGISTEREDID = 8;
    protected static final String INTERMEDIATE_CA_CERT_RESOURCE_PATH = "/sos_intermediate_ca.cer";
    protected static final String CONTROLLER_CONF_DIR_ENV_KEY = "JS7_CONTROLLER_CONFIG_DIR";
    protected static final String AGENT_CONF_DIR_ENV_KEY = "JS7_AGENT_CONFIG_DIR";
    protected static final String LICENCE_FOLDERNAME = "license";
    protected static final String JOC_LICENCE_PATH = "resources/joc/license";

    public static boolean check(Path path) throws CertificateException, IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, CertificateExpiredException, CertificateNotYetValidException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(Files.newInputStream(path, new OpenOption[0]));
        LicenseCheckHelper.checkLicenceIntermediateWithThrow(certificate);
        if (!LicenseCheckHelper.checkLicenceRegisteredId(certificate)) {
            throw new CertificateException("License not a JS7 license.");
        }
        certificate.checkValidity();
        return true;
    }

    protected static void checkLicenceIntermediateWithThrow(X509Certificate cert) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate intermediateCert = (X509Certificate)cf.generateCertificate(LicenseCheckHelper.class.getResourceAsStream(INTERMEDIATE_CA_CERT_RESOURCE_PATH));
        cert.verify(intermediateCert.getPublicKey());
    }

    protected static boolean checkLicenceRegisteredId(X509Certificate cert) {
        String registeredId = LicenseCheckHelper.getRegisteredId(cert);
        if (registeredId != null) {
            return registeredId.startsWith(SOS_LICENCE_PREFIX);
        }
        return false;
    }

    protected static String getRegisteredId(X509Certificate cert) {
        try {
            Collection<List<?>> subjectAlternativeNames = cert.getSubjectAlternativeNames();
            if (subjectAlternativeNames != null) {
                for (List<?> entry : subjectAlternativeNames) {
                    int key = (Integer)entry.get(0);
                    if (key != 8) continue;
                    return (String)entry.get(1);
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return null;
    }

    public static X509Certificate getValidOrLatestCertificate(Set<X509Certificate> certificates) {
        Date validFrom = null;
        X509Certificate cert = null;
        ArrayList<X509Certificate> validLicenses = new ArrayList<X509Certificate>();
        for (X509Certificate license : certificates) {
            if (validFrom != null && license.getNotBefore().getTime() > validFrom.getTime()) {
                validFrom = license.getNotBefore();
                cert = license;
            }
            try {
                license.checkValidity();
                validLicenses.add(license);
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                if (validFrom != null) continue;
                validFrom = license.getNotBefore();
                cert = license;
            }
        }
        if (!validLicenses.isEmpty()) {
            validLicenses.sort(Comparator.comparing(certificate -> certificate.getNotAfter().getTime()));
            validLicenses.sort(Comparator.comparing(X509Certificate::getNotAfter).reversed());
            return (X509Certificate)validLicenses.get(0);
        }
        return cert;
    }

    public static X509Certificate geLatestInvalidCertificate(List<X509Certificate> invalidCertificates) {
        if (invalidCertificates != null && !invalidCertificates.isEmpty()) {
            invalidCertificates.sort(Comparator.comparing(X509Certificate::getNotBefore).thenComparing(X509Certificate::getNotAfter).reversed());
            return invalidCertificates.get(0);
        }
        return null;
    }

    public static X509Certificate geLatestValidCertificate(List<X509Certificate> validCertificates) {
        if (validCertificates != null && !validCertificates.isEmpty()) {
            validCertificates.sort(Comparator.comparing(X509Certificate::getNotAfter).reversed());
            return validCertificates.get(0);
        }
        return null;
    }
}

