/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.JVMHelper;
import com.izforge.izpack.util.ProcessHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SelfModifier {
    private static final String BASE_KEY = "self.mod.base";
    private static final String JAR_KEY = "self.mod.jar";
    private static final String CLASS_KEY = "self.mod.class";
    private static final String METHOD_KEY = "self.mod.method";
    private static final String PHASE_KEY = "self.mod.phase";
    private Method method = null;
    private File logFile = null;
    private File sandbox = null;
    private File jarFile = null;
    private int phase = 0;
    private final SimpleDateFormat isoPoint = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final Date date = new Date();
    private final int debugPort2 = Integer.getInteger("self.mod.debugPort2", -1);
    private final int debugPort3 = Integer.getInteger("self.mod.debugPort3", -1);
    private static final String DEBUG_PORT2_KEY = "self.mod.debugPort2";
    private static final String DEBUG_PORT3_KEY = "self.mod.debugPort3";
    private static final String prefix = "izpack";
    private PrintStream log = null;

    public static void test(String[] args) {
        try {
            File sandbox = new File(System.getProperty(BASE_KEY) + ".d");
            File randFile = new File(sandbox, "RandomAccess.tmp");
            RandomAccessFile rand = new RandomAccessFile(randFile, "rw");
            rand.writeChars("Just a test: The JVM has to close 'cuz I won't!\n");
            System.err.print("Deleting sandbox: ");
            FileUtils.deleteDirectory(sandbox);
            System.err.println(sandbox.exists() ? "FAILED" : "SUCCEEDED");
        }
        catch (Exception x) {
            System.err.println(x.getMessage());
            x.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SelfModifier selfModifier = new SelfModifier();
        if (selfModifier.phase == 2) {
            selfModifier.invoke2(args);
        } else if (selfModifier.phase == 3) {
            selfModifier.invoke3(args);
        }
    }

    private SelfModifier() {
        this.phase = Integer.parseInt(System.getProperty(PHASE_KEY));
        String cName = System.getProperty(CLASS_KEY);
        String tName = System.getProperty(METHOD_KEY);
        this.jarFile = new File(System.getProperty(JAR_KEY));
        this.logFile = new File(System.getProperty(BASE_KEY) + ".log");
        this.sandbox = new File(System.getProperty(BASE_KEY) + ".d");
        try {
            Class<?> clazz = Class.forName(cName);
            Method method = clazz.getMethod(tName, String[].class);
            this.initMethod(method);
        }
        catch (ClassNotFoundException x1) {
            this.log("No class found for " + cName);
        }
        catch (NoSuchMethodException x2) {
            this.log("No method " + tName + " found in " + cName);
        }
    }

    public SelfModifier(Method method) throws IOException {
        this.phase = 1;
        ProcessHelper.tryExecJava();
        this.initMethod(method);
    }

    private void initMethod(Method method) {
        int mod = method.getModifiers();
        if ((mod & 1) == 0 || (mod & 8) == 0) {
            throw new IllegalArgumentException("Method not public and static");
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1 || !params[0].isArray() || !"java.lang.String".equals(params[0].getComponentType().getName())) {
            throw new IllegalArgumentException("Method must accept String array");
        }
        Class<?> clazz = method.getDeclaringClass();
        mod = clazz.getModifiers();
        if ((mod & 1) == 0 || (mod & 0x200) != 0) {
            throw new IllegalArgumentException("Method must be in a public class");
        }
        this.method = method;
    }

    public void invoke(String[] args) throws IOException {
        while (true) {
            this.logFile = File.createTempFile(prefix, ".log");
            System.out.println("The uninstaller has put a log file: " + this.logFile.getAbsolutePath());
            String fileName = this.logFile.toString();
            this.sandbox = new File(fileName.substring(0, fileName.length() - 4) + ".d");
            if (!this.sandbox.exists()) break;
            this.logFile.delete();
        }
        if (!this.sandbox.mkdir()) {
            throw new RuntimeException("Failed to create temp dir: " + this.sandbox);
        }
        this.sandbox = this.sandbox.getCanonicalFile();
        this.logFile = this.logFile.getCanonicalFile();
        try {
            this.jarFile = SelfModifier.findJarFile(this.method.getDeclaringClass()).getCanonicalFile();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("SelfModifier must be in a jar file");
        }
        this.log("JarFile: " + this.jarFile);
        this.extractJarFile();
        if (args == null) {
            args = new String[]{};
        }
        this.spawn(args, 2);
        this.log("Exit");
        System.exit(0);
    }

    private Process spawn(String[] args, int nextPhase) throws IOException {
        String base = this.logFile.getAbsolutePath();
        base = base.substring(0, base.length() - 4);
        String javaCommand = ProcessHelper.getJavaCommand();
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaCommand);
        command.addAll(new JVMHelper().getJVMArguments());
        if (nextPhase == 2) {
            if (this.debugPort2 != -1) {
                command.add(this.getDebug(this.debugPort2));
            }
            if (this.debugPort3 != -1) {
                command.add("-Dself.mod.debugPort3=" + this.debugPort3);
            }
        } else if (nextPhase == 3 && this.debugPort3 != -1) {
            command.add(this.getDebug(this.debugPort3));
        }
        command.add("-classpath");
        command.add(this.sandbox.getAbsolutePath());
        command.add("-Dself.mod.base=" + base);
        command.add("-Dself.mod.jar=" + this.jarFile.getPath() + "");
        command.add("-Dself.mod.class=" + this.method.getDeclaringClass().getName());
        command.add("-Dself.mod.method=" + this.method.getName());
        command.add("-Dself.mod.phase=" + nextPhase);
        command.add(this.getClass().getName());
        Collections.addAll(command, args);
        StringBuilder buffer = new StringBuilder("Spawning phase ");
        buffer.append(nextPhase).append(": ");
        for (String anEntireCmd : command) {
            buffer.append("\n\t").append(anEntireCmd);
        }
        this.log(buffer.toString());
        return ProcessHelper.exec(command);
    }

    public static File findJarFile(Class<?> clazz) {
        String resource = clazz.getName().replace('.', '/') + ".class";
        URL url = ClassLoader.getSystemResource(resource);
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        String path = url.getFile();
        path = path.substring(0, path.lastIndexOf(33));
        File file = new File(URI.create(path));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractJarFile() throws IOException {
        int extracted = 0;
        InputStream in = null;
        String MANIFEST = "META-INF/MANIFEST.MF";
        JarFile jar = new JarFile(this.jarFile, true);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String pathname;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || MANIFEST.equals((pathname = entry.getName()).toUpperCase())) continue;
                in = jar.getInputStream(entry);
                FileUtils.copyToFile(in, new File(this.sandbox, pathname));
                ++extracted;
            }
            this.log("Extracted " + extracted + " file" + (extracted > 1 ? "s" : "") + " into " + this.sandbox.getPath());
        }
        catch (Throwable throwable) {
            try {
                jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        try {
            jar.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtils.closeQuietly(in);
    }

    private void invoke2(String[] args) {
        int retVal = -1;
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Process process = this.spawn(args, 3);
            try {
                retVal = process.waitFor();
            }
            catch (InterruptedException e) {
                this.log(e);
            }
            this.log("deleting sandbox");
            FileUtils.deleteDirectory(this.sandbox);
        }
        catch (Exception e) {
            this.log(e);
        }
        this.log("Phase 3 return value = " + retVal);
    }

    private void invoke3(String[] args) {
        try {
            this.errlog("Invoking method: " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + "(String[] args)");
            this.method.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            this.errlog(t.getMessage());
            t.printStackTrace();
            this.errlog("exiting");
            System.err.flush();
            System.exit(31);
        }
        this.errlog("Method returned, waiting for other threads");
        System.err.flush();
    }

    private void errlog(String msg) {
        this.date.setTime(System.currentTimeMillis());
        System.err.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + msg);
    }

    private PrintStream checkLog() {
        try {
            if (this.log == null) {
                this.log = new PrintStream(new FileOutputStream(this.logFile.toString(), true));
            }
        }
        catch (IOException x) {
            System.err.println("Phase " + this.phase + " log err: " + x.getMessage());
            x.printStackTrace();
        }
        this.date.setTime(System.currentTimeMillis());
        return this.log;
    }

    private void log(Throwable t) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + t.getMessage());
            t.printStackTrace(this.log);
        }
    }

    private void log(String msg) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + msg);
        }
    }

    private String getDebug(int port) {
        return "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + port;
    }
}

